/*
 *  Copyright (c) 2017, Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree. An additional grant
 *  of patent rights can be found in the PATENTS file in the same directory.
 *
 */

/*
 *  THIS FILE IS AUTOGENERATED. DO NOT MODIFY IT; ALL CHANGES WILL BE LOST IN
 *  VAIN.
 *
 *  @generated
 */
#pragma once

#include <memory>
#include <string>
#include <unordered_map>
#include <vector>

#include <mcrouter/lib/CacheClientStats.h>
#include <mcrouter/lib/carbon/connection/ExternalCarbonConnectionImpl.h>
#include <mcrouter/lib/carbon/connection/InternalCarbonConnectionImpl.h>
#include <mcrouter/lib/carbon/connection/PooledCarbonConnectionImpl.h>

#include "mcrouter/lib/carbon/example/gen/HelloGoodbyeMessages.h"
#include "mcrouter/lib/carbon/example/gen/HelloGoodbyeRouterInfo.h"

namespace hellogoodbye {

class HelloGoodbyeConnection {
 public:
  using RouterInfo = HelloGoodbyeRouterInfo;

  virtual ~HelloGoodbyeConnection() = default;

  virtual void sendRequestOne(
      const GoodbyeRequest&,
      carbon::RequestCb<GoodbyeRequest>) = 0;
  virtual void sendRequestOne(
      const HelloRequest&,
      carbon::RequestCb<HelloRequest>) = 0;

  virtual void sendRequestMulti(
      std::vector<std::reference_wrapper<const GoodbyeRequest>>&&,
      carbon::RequestCb<GoodbyeRequest>) = 0;
  virtual void sendRequestMulti(
      std::vector<std::reference_wrapper<const HelloRequest>>&&,
      carbon::RequestCb<HelloRequest>) = 0;

  virtual facebook::memcache::CacheClientCounters getStatCounters() const
      noexcept = 0;
  virtual std::unordered_map<std::string, std::string> getConfigOptions() = 0;
  virtual bool healthCheck() = 0;
  virtual std::unique_ptr<HelloGoodbyeConnection> recreate() = 0;
};

template <class Impl>
class HelloGoodbyeConnectionImpl : public HelloGoodbyeConnection {
 public:
  template <class... Args>
  explicit HelloGoodbyeConnectionImpl(Args&&... args)
      : impl_(std::forward<Args>(args)...) {}

  ~HelloGoodbyeConnectionImpl() = default;

  facebook::memcache::CacheClientCounters getStatCounters() const noexcept {
    return impl_.getStatCounters();
  }

  std::unordered_map<std::string, std::string> getConfigOptions() {
    return impl_.getConfigOptions();
  }

  bool healthCheck() {
    return impl_.healthCheck();
  }

  std::unique_ptr<HelloGoodbyeConnection> recreate() {
    return impl_.template recreate<HelloGoodbyeConnectionImpl<Impl>>();
  }

  void sendRequestOne(
      const GoodbyeRequest& req,
      carbon::RequestCb<GoodbyeRequest> cb) {
    return impl_.sendRequestOne(req, std::move(cb));
  }
  void sendRequestOne(
      const HelloRequest& req,
      carbon::RequestCb<HelloRequest> cb) {
    return impl_.sendRequestOne(req, std::move(cb));
  }

  void sendRequestMulti(
      std::vector<std::reference_wrapper<const GoodbyeRequest>>&& reqs,
      carbon::RequestCb<GoodbyeRequest> cb) {
    return impl_.sendRequestMulti(std::move(reqs), std::move(cb));
  }
  void sendRequestMulti(
      std::vector<std::reference_wrapper<const HelloRequest>>&& reqs,
      carbon::RequestCb<HelloRequest> cb) {
    return impl_.sendRequestMulti(std::move(reqs), std::move(cb));
  }

 private:
  Impl impl_;
};

using HelloGoodbyePooledConnection = HelloGoodbyeConnectionImpl<
    carbon::PooledCarbonConnectionImpl<HelloGoodbyeConnection>>;
using HelloGoodbyeInternalConnection = HelloGoodbyeConnectionImpl<
    carbon::InternalCarbonConnectionImpl<HelloGoodbyeConnection>>;
using HelloGoodbyeExternalConnection =
    HelloGoodbyeConnectionImpl<carbon::ExternalCarbonConnectionImpl>;

} // hellogoodbye
