
// w20_2a_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  10.000000
 // --table_div  1.000000
 // --table_op  0.020000

struct tablew20_2a { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablew20_2a_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablew20_2a&() const { return *(tablew20_2a*)this; }
};

 static tablew20_2a_imp<2048> w20_2a_table __rt_data = {
	0,-0.186024,4.094,2048, {
	0.000000000000,-0.072331728515,-0.138143979450,-0.168307280988,-0.180067238815,
	-0.186686541813,-0.191136422906,-0.194414538831,-0.196965536775,-0.199024012289,
	-0.200728225826,-0.202166277845,-0.203397655660,-0.204464366349,-0.205397146833,
	-0.206219147887,-0.206948229720,-0.207598451955,-0.208181074482,-0.208705249696,
	-0.209178513522,-0.209607141460,-0.209996411807,-0.210350803628,-0.210674147941,
	-0.210969744795,-0.211240455052,-0.211488773175,-0.211716879827,-0.211926712411,
	-0.212119967725,-0.212298157988,-0.212462630842,-0.212614591243,-0.212755119838,
	-0.212885188497,-0.213005673507,-0.213117366851,-0.213220985869,-0.213317181607,
	-0.213406546032,-0.213489618316,-0.213566890319,-0.213638811404,-0.213705792655,
	-0.213768210621,-0.213826410613,-0.213880709637,-0.213931399010,-0.213978746686,
	-0.214022999345,-0.214064384263,-0.214103110993,-0.214139372881,-0.214173348433,
	-0.214205202553,-0.214235087665,-0.214263144725,-0.214289504152,-0.214314286665,
	-0.214337604054,-0.214359559877,-0.214380250101,-0.214399763690,-0.214418183140,
	-0.214435584972,-0.214452040182,-0.214467614659,-0.214482369564,-0.214496361683,
	-0.214509643751,-0.214522264748,-0.214534270177,-0.214545702317,-0.214556600454,
	-0.214567001103,-0.214576938207,-0.214586443319,-0.214595545775,-0.214604272855,
	-0.214612649928,-0.214620700587,-0.214628446775,-0.214635908907,-0.214643105972,
	-0.214650055636,-0.214656774336,-0.214663277366,-0.214669578957,-0.214675692353,
	-0.214681629878,-0.214687403002,-0.214693022401,-0.214698498010,-0.214703839080,
	-0.214709054218,-0.214714151440,-0.214719138205,-0.214724021460,-0.214728807671,
	-0.214733502858,-0.214738112626,-0.214742642196,-0.214747096427,-0.214751479845,
	-0.214755796664,-0.214760050807,-0.214764245931,-0.214768385439,-0.214772472502,
	-0.214776510071,-0.214780500898,-0.214784447544,-0.214788352396,-0.214792217677,
	-0.214796045458,-0.214799837669,-0.214803596108,-0.214807322450,-0.214811018256,
	-0.214814684982,-0.214818323982,-0.214821936520,-0.214825523775,-0.214829086844,
	-0.214832626751,-0.214836144450,-0.214839640832,-0.214843116725,-0.214846572903,
	-0.214850010089,-0.214853428956,-0.214856830132,-0.214860214203,-0.214863581717,
	-0.214866933184,-0.214870269079,-0.214873589850,-0.214876895911,-0.214880187650,
	-0.214883465430,-0.214886729590,-0.214889980446,-0.214893218295,-0.214896443414,
	-0.214899656061,-0.214902856479,-0.214906044895,-0.214909221520,-0.214912386554,
	-0.214915540184,-0.214918682583,-0.214921813915,-0.214924934335,-0.214928043985,
	-0.214931143002,-0.214934231512,-0.214937309634,-0.214940377482,-0.214943435160,
	-0.214946482769,-0.214949520401,-0.214952548145,-0.214955566084,-0.214958574297,
	-0.214961572858,-0.214964561836,-0.214967541299,-0.214970511310,-0.214973471926,
	-0.214976423206,-0.214979365202,-0.214982297965,-0.214985221543,-0.214988135983,
	-0.214991041328,-0.214993937620,-0.214996824898,-0.214999703202,-0.215002572566,
	-0.215005433026,-0.215008284615,-0.215011127366,-0.215013961308,-0.215016786471,
	-0.215019602885,-0.215022410575,-0.215025209568,-0.215027999890,-0.215030781566,
	-0.215033554618,-0.215036319071,-0.215039074946,-0.215041822265,-0.215044561048,
	-0.215047291317,-0.215050013090,-0.215052726388,-0.215055431229,-0.215058127632,
	-0.215060815613,-0.215063495192,-0.215066166384,-0.215068829206,-0.215071483675,
	-0.215074129807,-0.215076767617,-0.215079397122,-0.215082018335,-0.215084631271,
	-0.215087235946,-0.215089832373,-0.215092420567,-0.215095000541,-0.215097572310,
	-0.215100135885,-0.215102691282,-0.215105238511,-0.215107777588,-0.215110308524,
	-0.215112831331,-0.215115346022,-0.215117852609,-0.215120351105,-0.215122841520,
	-0.215125323868,-0.215127798158,-0.215130264404,-0.215132722615,-0.215135172804,
	-0.215137614981,-0.215140049158,-0.215142475344,-0.215144893552,-0.215147303790,
	-0.215149706071,-0.215152100404,-0.215154486800,-0.215156865269,-0.215159235820,
	-0.215161598464,-0.215163953211,-0.215166300070,-0.215168639051,-0.215170970164,
	-0.215173293418,-0.215175608823,-0.215177916388,-0.215180216121,-0.215182508033,
	-0.215184792132,-0.215187068428,-0.215189336928,-0.215191597642,-0.215193850579,
	-0.215196095747,-0.215198333154,-0.215200562810,-0.215202784722,-0.215204998899,
	-0.215207205349,-0.215209404079,-0.215211595099,-0.215213778416,-0.215215954038,
	-0.215218121972,-0.215220282227,-0.215222434810,-0.215224579729,-0.215226716990,
	-0.215228846602,-0.215230968572,-0.215233082907,-0.215235189615,-0.215237288701,
	-0.215239380174,-0.215241464040,-0.215243540307,-0.215245608980,-0.215247670067,
	-0.215249723575,-0.215251769509,-0.215253807877,-0.215255838684,-0.215257861938,
	-0.215259877644,-0.215261885809,-0.215263886438,-0.215265879538,-0.215267865115,
	-0.215269843175,-0.215271813723,-0.215273776765,-0.215275732308,-0.215277680355,
	-0.215279620914,-0.215281553989,-0.215283479586,-0.215285397710,-0.215287308366,
	-0.215289211560,-0.215291107297,-0.215292995581,-0.215294876418,-0.215296749812,
	-0.215298615768,-0.215300474291,-0.215302325386,-0.215304169056,-0.215306005308,
	-0.215307834144,-0.215309655569,-0.215311469589,-0.215313276205,-0.215315075424,
	-0.215316867249,-0.215318651683,-0.215320428732,-0.215322198397,-0.215323960684,
	-0.215325715596,-0.215327463137,-0.215329203309,-0.215330936117,-0.215332661564,
	-0.215334379653,-0.215336090387,-0.215337793770,-0.215339489804,-0.215341178492,
	-0.215342859838,-0.215344533844,-0.215346200512,-0.215347859846,-0.215349511848,
	-0.215351156521,-0.215352793866,-0.215354423887,-0.215356046586,-0.215357661964,
	-0.215359270024,-0.215360870767,-0.215362464197,-0.215364050314,-0.215365629120,
	-0.215367200617,-0.215368764807,-0.215370321691,-0.215371871271,-0.215373413547,
	-0.215374948522,-0.215376476196,-0.215377996570,-0.215379509646,-0.215381015425,
	-0.215382513906,-0.215384005091,-0.215385488981,-0.215386965576,-0.215388434877,
	-0.215389896884,-0.215391351597,-0.215392799016,-0.215394239142,-0.215395671975,
	-0.215397097514,-0.215398515760,-0.215399926712,-0.215401330370,-0.215402726733,
	-0.215404115801,-0.215405497573,-0.215406872049,-0.215408239227,-0.215409599107,
	-0.215410951687,-0.215412296967,-0.215413634946,-0.215414965621,-0.215416288992,
	-0.215417605057,-0.215418913815,-0.215420215263,-0.215421509400,-0.215422796223,
	-0.215424075732,-0.215425347923,-0.215426612794,-0.215427870344,-0.215429120568,
	-0.215430363466,-0.215431599034,-0.215432827269,-0.215434048168,-0.215435261729,
	-0.215436467947,-0.215437666821,-0.215438858346,-0.215440042518,-0.215441219335,
	-0.215442388792,-0.215443550886,-0.215444705612,-0.215445852967,-0.215446992945,
	-0.215448125544,-0.215449250757,-0.215450368581,-0.215451479010,-0.215452582040,
	-0.215453677666,-0.215454765882,-0.215455846683,-0.215456920064,-0.215457986019,
	-0.215459044542,-0.215460095627,-0.215461139269,-0.215462175461,-0.215463204197,
	-0.215464225470,-0.215465239274,-0.215466245601,-0.215467244446,-0.215468235801,
	-0.215469219658,-0.215470196010,-0.215471164850,-0.215472126171,-0.215473079963,
	-0.215474026219,-0.215474964931,-0.215475896091,-0.215476819689,-0.215477735717,
	-0.215478644167,-0.215479545029,-0.215480438293,-0.215481323952,-0.215482201993,
	-0.215483072409,-0.215483935189,-0.215484790323,-0.215485637801,-0.215486477611,
	-0.215487309743,-0.215488134187,-0.215488950931,-0.215425985134,-0.215258184835,
	-0.215046135325,-0.214807165399,-0.214550581285,-0.214282394781,-0.214006850560,
	-0.213727104208,-0.213445578556,-0.213164172632,-0.212884394066,-0.212607448054,
	-0.212334299955,-0.212065721063,-0.211802323163,-0.211544585346,-0.211292875316,
	-0.211047466670,-0.210808553154,-0.210576260599,-0.210350657047,-0.210131761409,
	-0.209919550952,-0.209713967791,-0.209514924561,-0.209322309379,-0.209135990192,
	-0.208955818599,-0.208781633195,-0.208613262509,-0.208450527563,-0.208293244113,
	-0.208141224581,-0.207994279737,-0.207852220136,-0.207714857344,-0.207582004981,
	-0.207453479592,-0.207329101366,-0.207208694726,-0.207092080287,-0.206979110013,
	-0.206869614138,-0.206763437779,-0.206660431732,-0.206560452548,-0.206463362550,
	-0.206369029818,-0.206277328123,-0.206188136846,-0.206101340860,-0.206016830401,
	-0.205934500915,-0.205854252898,-0.205775991728,-0.205699627483,-0.205625074761,
	-0.205552252496,-0.205481083775,-0.205411495655,-0.205343418977,-0.205276788192,
	-0.205211541186,-0.205147619111,-0.205084966217,-0.205023529695,-0.204963259526,
	-0.204904108328,-0.204846031218,-0.204788985676,-0.204732931416,-0.204677830260,
	-0.204623646024,-0.204570344403,-0.204517892869,-0.204466260566,-0.204415418216,
	-0.204365338033,-0.204315993631,-0.204267359949,-0.204219413173,-0.204172130662,
	-0.204125490887,-0.204079473359,-0.204034058576,-0.203989227963,-0.203944963821,
	-0.203901249274,-0.203858068225,-0.203815405313,-0.203773245866,-0.203731575869,
	-0.203690381922,-0.203649651210,-0.203609371465,-0.203569530942,-0.203530118389,
	-0.203491123015,-0.203452534472,-0.203414342829,-0.203376538546,-0.203339112460,
	-0.203302055761,-0.203265359973,-0.203229016939,-0.203193018807,-0.203157358008,
	-0.203122027247,-0.203087019490,-0.203052327945,-0.203017946060,-0.202983867501,
	-0.202950086149,-0.202916596089,-0.202883391596,-0.202850467132,-0.202817817332,
	-0.202785437002,-0.202753321108,-0.202721464767,-0.202689863246,-0.202658511951,
	-0.202627406423,-0.202596542331,-0.202565915468,-0.202535521748,-0.202505357195,
	-0.202475417944,-0.202445700236,-0.202416200411,-0.202386914907,-0.202357840256,
	-0.202328973077,-0.202300310078,-0.202271848051,-0.202243583865,-0.202215514470,
	-0.202187636887,-0.202159948213,-0.202132445611,-0.202105126314,-0.202077987617,
	-0.202051026882,-0.202024241526,-0.201997629030,-0.201971186929,-0.201944912813,
	-0.201918804326,-0.201892859164,-0.201867075072,-0.201841449843,-0.201815981319,
	-0.201790667385,-0.201765505972,-0.201740495054,-0.201715632646,-0.201690916803,
	-0.201666345621,-0.201641917231,-0.201617629806,-0.201593481549,-0.201569470704,
	-0.201545595545,-0.201521854383,-0.201498245556,-0.201474767436,-0.201451418425,
	-0.201428196972,-0.201405101519,-0.201382130564,-0.201359282624,-0.201336556243,
	-0.201313949995,-0.201291462475,-0.201269092305,-0.201246838130,-0.201224698620,
	-0.201202672469,-0.201180758391,-0.201158955124,-0.201137261427,-0.201115676080,
	-0.201094197883,-0.201072825658,-0.201051558245,-0.201030394503,-0.201009333310,
	-0.200988373563,-0.200967514177,-0.200946754082,-0.200926092229,-0.200905527583,
	-0.200885059125,-0.200864685855,-0.200844406786,-0.200824220948,-0.200804127383,
	-0.200784125152,-0.200764213328,-0.200744390998,-0.200724657263,-0.200705011238,
	-0.200685452050,-0.200665978841,-0.200646590764,-0.200627286985,-0.200608066683,
	-0.200588929047,-0.200569873280,-0.200550898595,-0.200532004215,-0.200513189378,
	-0.200494453330,-0.200475795327,-0.200457214637,-0.200438710538,-0.200420282318,
	-0.200401929274,-0.200383650713,-0.200365445952,-0.200347314318,-0.200329255144,
	-0.200311267776,-0.200293351566,-0.200275505875,-0.200257730074,-0.200240023540,
	-0.200222385660,-0.200204815828,-0.200187313448,-0.200169877928,-0.200152508686,
	-0.200135205148,-0.200117966745,-0.200100792918,-0.200083683114,-0.200066636785,
	-0.200049653393,-0.200032732405,-0.200015873294,-0.199999075541,-0.199982338633,
	-0.199965662063,-0.199949045329,-0.199932487939,-0.199915989401,-0.199899549235,
	-0.199883166962,-0.199866842112,-0.199850574218,-0.199834362821,-0.199818207465,
	-0.199802107701,-0.199786063084,-0.199770073176,-0.199754137543,-0.199738255755,
	-0.199722427388,-0.199706652023,-0.199690929246,-0.199675258647,-0.199659639820,
	-0.199644072364,-0.199628555885,-0.199613089989,-0.199597674290,-0.199582308403,
	-0.199566991952,-0.199551724560,-0.199536505857,-0.199521335476,-0.199506213054,
	-0.199491138234,-0.199476110659,-0.199461129979,-0.199446195846,-0.199431307917,
	-0.199416465851,-0.199401669312,-0.199386917968,-0.199372211487,-0.199357549546,
	-0.199342931819,-0.199328357990,-0.199313827740,-0.199299340758,-0.199284896734,
	-0.199270495361,-0.199256136336,-0.199241819358,-0.199227544131,-0.199213310359,
	-0.199199117752,-0.199184966021,-0.199170854879,-0.199156784046,-0.199142753239,
	-0.199128762182,-0.199114810601,-0.199100898223,-0.199087024779,-0.199073190002,
	-0.199059393628,-0.199045635396,-0.199031915046,-0.199018232321,-0.199004586968,
	-0.198990978734,-0.198977407370,-0.198963872629,-0.198950374266,-0.198936912038,
	-0.198923485705,-0.198910095029,-0.198896739774,-0.198883419706,-0.198870134594,
	-0.198856884208,-0.198843668320,-0.198830486706,-0.198817339141,-0.198804225405,
	-0.198791145278,-0.198778098543,-0.198765084984,-0.198752104388,-0.198739156542,
	-0.198726241238,-0.198713358267,-0.198700507422,-0.198687688501,-0.198674901299,
	-0.198662145616,-0.198649421253,-0.198636728012,-0.198624065698,-0.198611434117,
	-0.198598833075,-0.198586262383,-0.198573721852,-0.198561211292,-0.198548730520,
	-0.198536279349,-0.198523857597,-0.198511465083,-0.198499101627,-0.198486767049,
	-0.198474461174,-0.198462183826,-0.198449934830,-0.198437714014,-0.198425521207,
	-0.198413356239,-0.198401218940,-0.198389109145,-0.198377026686,-0.198364971400,
	-0.198352943123,-0.198340941694,-0.198328966951,-0.198317018736,-0.198305096889,
	-0.198293201255,-0.198281331678,-0.198269488002,-0.198257670075,-0.198245877745,
	-0.198234110860,-0.198222369271,-0.198210652830,-0.198198961388,-0.198187294799,
	-0.198175652919,-0.198164035602,-0.198152442706,-0.198140874089,-0.198129329609,
	-0.198117809127,-0.198106312504,-0.198094839602,-0.198083390284,-0.198071964415,
	-0.198060561858,-0.198049182482,-0.198037826152,-0.198026492737,-0.198015182105,
	-0.198003894128,-0.197992628675,-0.197981385618,-0.197970164830,-0.197958966186,
	-0.197947789558,-0.197936634824,-0.197925501858,-0.197914390539,-0.197903300744,
	-0.197892232352,-0.197881185243,-0.197870159297,-0.197859154396,-0.197848170423,
	-0.197837207259,-0.197826264789,-0.197815342897,-0.197804441469,-0.197793560391,
	-0.197782699550,-0.197771858833,-0.197761038129,-0.197750237328,-0.197739456318,
	-0.197728694992,-0.197717953239,-0.197707230953,-0.197696528026,-0.197685844351,
	-0.197675179824,-0.197664534337,-0.197653907789,-0.197643300074,-0.197632711089,
	-0.197622140732,-0.197611588902,-0.197601055497,-0.197590540417,-0.197580043562,
	-0.197569564833,-0.197559104131,-0.197548661358,-0.197538236418,-0.197527829213,
	-0.197517439647,-0.197507067625,-0.197496713052,-0.197486375833,-0.197476055875,
	-0.197465753085,-0.197455467370,-0.197445198637,-0.197434946797,-0.197424711757,
	-0.197414493427,-0.197404291718,-0.197394106540,-0.197383937804,-0.197373785422,
	-0.197363649307,-0.197353529372,-0.197343425529,-0.197333337692,-0.197323265777,
	-0.197313209697,-0.197303169368,-0.197293144706,-0.197283135628,-0.197273142050,
	-0.197263163889,-0.197253201063,-0.197243253491,-0.197233321091,-0.197223403782,
	-0.197213501484,-0.197203614117,-0.197193741602,-0.197183883860,-0.197174040811,
	-0.197164212378,-0.197154398484,-0.197144599050,-0.197134814001,-0.197125043259,
	-0.197115286748,-0.197105544394,-0.197095816120,-0.197086101853,-0.197076401517,
	-0.197066715039,-0.197057042345,-0.197047383362,-0.197037738018,-0.197028106239,
	-0.197018487954,-0.197008883092,-0.196999291580,-0.196989713348,-0.196980148326,
	-0.196970596444,-0.196961057631,-0.196951531818,-0.196942018937,-0.196932518918,
	-0.196923031694,-0.196913557195,-0.196904095355,-0.196894646107,-0.196885209382,
	-0.196875785116,-0.196866373240,-0.196856973690,-0.196847586400,-0.196838211305,
	-0.196828848338,-0.196819497437,-0.196810158536,-0.196800831572,-0.196791516481,
	-0.196782213199,-0.196772921663,-0.196763641811,-0.196754373579,-0.196745116907,
	-0.196735871732,-0.196726637992,-0.196717415626,-0.196708204573,-0.196699004773,
	-0.196689816164,-0.196680638688,-0.196671472283,-0.196662316890,-0.196653172451,
	-0.196644038906,-0.196634916196,-0.196625804263,-0.196616703048,-0.196607612494,
	-0.196598532542,-0.196589463137,-0.196580404219,-0.196571355733,-0.196562317621,
	-0.196553289828,-0.196544272297,-0.196535264972,-0.196526267797,-0.196517280718,
	-0.196508303679,-0.196499336624,-0.196490379500,-0.196481432252,-0.196472494826,
	-0.196463567167,-0.196454649222,-0.196445740937,-0.196436842259,-0.196427953135,
	-0.196419073513,-0.196410203338,-0.196401342560,-0.196392491126,-0.196383648984,
	-0.196374816082,-0.196365992368,-0.196357177792,-0.196348372301,-0.196339575846,
	-0.196330788376,-0.196322009839,-0.196313240186,-0.196304479367,-0.196295727332,
	-0.196286984030,-0.196278249413,-0.196269523431,-0.196260806035,-0.196252097177,
	-0.196243396807,-0.196234704876,-0.196226021338,-0.196217346142,-0.196208679242,
	-0.196200020590,-0.196191370138,-0.196182727838,-0.196174093644,-0.196165467508,
	-0.196156849383,-0.196148239223,-0.196139636981,-0.196131042610,-0.196122456065,
	-0.196113877300,-0.196105306268,-0.196096742924,-0.196088187222,-0.196079639118,
	-0.196071098565,-0.196062565519,-0.196054039935,-0.196045521768,-0.196037010974,
	-0.196028507507,-0.196020011325,-0.196011522383,-0.196003040636,-0.195994566042,
	-0.195986098556,-0.195977638135,-0.195969184735,-0.195960738314,-0.195952298829,
	-0.195943866236,-0.195935440492,-0.195927021556,-0.195918609385,-0.195910203936,
	-0.195901805166,-0.195893413036,-0.195885027501,-0.195876648520,-0.195868276053,
	-0.195859910056,-0.195851550490,-0.195843197312,-0.195834850482,-0.195826509958,
	-0.195818175700,-0.195809847667,-0.195801525818,-0.195793210113,-0.195784900512,
	-0.195776596974,-0.195768299460,-0.195760007928,-0.195751722340,-0.195743442656,
	-0.195735168836,-0.195726900841,-0.195718638630,-0.195710382166,-0.195702131409,
	-0.195693886319,-0.195685646858,-0.195677412988,-0.195669184669,-0.195660961862,
	-0.195652744531,-0.195644532635,-0.195636326137,-0.195628124998,-0.195619929182,
	-0.195611738649,-0.195603553361,-0.195595373282,-0.195587198374,-0.195579028599,
	-0.195570863919,-0.195562704298,-0.195554549698,-0.195546400082,-0.195538255413,
	-0.195530115655,-0.195521980769,-0.195513850721,-0.195505725472,-0.195497604987,
	-0.195489489230,-0.195481378163,-0.195473271750,-0.195465169957,-0.195457072745,
	-0.195448980080,-0.195440891926,-0.195432808246,-0.195424729005,-0.195416654169,
	-0.195408583700,-0.195400517563,-0.195392455724,-0.195384398147,-0.195376344797,
	-0.195368295638,-0.195360250637,-0.195352209757,-0.195344172964,-0.195336140223,
	-0.195328111500,-0.195320086760,-0.195312065969,-0.195304049091,-0.195296036094,
	-0.195288026941,-0.195280021600,-0.195272020036,-0.195264022215,-0.195256028103,
	-0.195248037667,-0.195240050871,-0.195232067684,-0.195224088070,-0.195216111997,
	-0.195208139430,-0.195200170337,-0.195192204683,-0.195184242437,-0.195176283563,
	-0.195168328030,-0.195160375805,-0.195152426853,-0.195144481142,-0.195136538639,
	-0.195128599312,-0.195120663127,-0.195112730052,-0.195104800054,-0.195096873101,
	-0.195088949160,-0.195081028198,-0.195073110184,-0.195065195084,-0.195057282867,
	-0.195049373501,-0.195041466952,-0.195033563190,-0.195025662182,-0.195017763896,
	-0.195009868301,-0.195001975363,-0.194994085052,-0.194986197336,-0.194978312184,
	-0.194970429562,-0.194962549441,-0.194954671788,-0.194946796572,-0.194938923761,
	-0.194931053325,-0.194923185232,-0.194915319450,-0.194907455948,-0.194899594696,
	-0.194891735662,-0.194883878815,-0.194876024125,-0.194868171559,-0.194860321088,
	-0.194852472680,-0.194844626305,-0.194836781932,-0.194828939530,-0.194821099069,
	-0.194813260518,-0.194805423846,-0.194797589023,-0.194789756018,-0.194781924801,
	-0.194774095342,-0.194766267611,-0.194758441576,-0.194750617208,-0.194742794477,
	-0.194734973352,-0.194727153804,-0.194719335801,-0.194711519315,-0.194703704315,
	-0.194695890772,-0.194688078655,-0.194680267934,-0.194672458581,-0.194664650564,
	-0.194656843854,-0.194649038422,-0.194641234237,-0.194633431271,-0.194625629493,
	-0.194617828875,-0.194610029386,-0.194602230997,-0.194594433678,-0.194586637401,
	-0.194578842136,-0.194571047854,-0.194563254524,-0.194555462119,-0.194547670608,
	-0.194539879963,-0.194532090154,-0.194524301152,-0.194516512929,-0.194508725455,
	-0.194500938701,-0.194493152638,-0.194485367237,-0.194477582469,-0.194469798306,
	-0.194462014718,-0.194454231677,-0.194446449154,-0.194438667119,-0.194430885545,
	-0.194423104403,-0.194415323663,-0.194407543298,-0.194399763279,-0.194391983576,
	-0.194384204162,-0.194376425008,-0.194368646085,-0.194360867365,-0.194353088819,
	-0.194345310420,-0.194337532138,-0.194329753945,-0.194321975814,-0.194314197715,
	-0.194306419620,-0.194298641501,-0.194290863329,-0.194283085078,-0.194275306717,
	-0.194267528220,-0.194259749558,-0.194251970702,-0.194244191625,-0.194236412299,
	-0.194228632696,-0.194220852787,-0.194213072544,-0.194205291940,-0.194197510947,
	-0.194189729536,-0.194181947680,-0.194174165350,-0.194166382520,-0.194158599160,
	-0.194150815244,-0.194143030743,-0.194135245629,-0.194127459876,-0.194119673454,
	-0.194111886337,-0.194104098496,-0.194096309904,-0.194088520533,-0.194080730355,
	-0.194072939344,-0.194065147470,-0.194057354707,-0.194049561027,-0.194041766403,
	-0.194033970806,-0.194026174210,-0.194018376586,-0.194010577908,-0.194002778147,
	-0.193994977276,-0.193987175269,-0.193979372096,-0.193971567732,-0.193963762148,
	-0.193955955317,-0.193948147212,-0.193940337806,-0.193932527070,-0.193924714978,
	-0.193916901503,-0.193909086616,-0.193901270291,-0.193893452501,-0.193885633217,
	-0.193877812414,-0.193869990063,-0.193862166138,-0.193854340611,-0.193846513455,
	-0.193838684643,-0.193830854148,-0.193823021942,-0.193815187998,-0.193807352290,
	-0.193799514790,-0.193791675470,-0.193783834305,-0.193775991266,-0.193768146327,
	-0.193760299461,-0.193752450640,-0.193744599838,-0.193736747027,-0.193728892180,
	-0.193721035271,-0.193713176272,-0.193705315157,-0.193697451898,-0.193689586469,
	-0.193681718842,-0.193673848990,-0.193665976888,-0.193658102506,-0.193650225820,
	-0.193642346801,-0.193634465423,-0.193626581659,-0.193618695482,-0.193610806866,
	-0.193602915782,-0.193595022205,-0.193587126108,-0.193579227463,-0.193571326244,
	-0.193563422424,-0.193555515977,-0.193547606875,-0.193539695091,-0.193531780599,
	-0.193523863372,-0.193515943383,-0.193508020606,-0.193500095013,-0.193492166578,
	-0.193484235274,-0.193476301075,-0.193468363953,-0.193460423882,-0.193452480835,
	-0.193444534785,-0.193436585706,-0.193428633570,-0.193420678352,-0.193412720024,
	-0.193404758561,-0.193396793934,-0.193388826117,-0.193380855085,-0.193372880809,
	-0.193364903263,-0.193356922422,-0.193348938257,-0.193340950743,-0.193332959852,
	-0.193324965558,-0.193316967835,-0.193308966655,-0.193300961993,-0.193292953821,
	-0.193284942113,-0.193276926842,-0.193268907982,-0.193260885506,-0.193252859387,
	-0.193244829599,-0.193236796115,-0.193228758909,-0.193220717954,-0.193212673223,
	-0.193204624690,-0.193196572329,-0.193188516112,-0.193180456013,-0.193172392006,
	-0.193164324064,-0.193156252160,-0.193148176268,-0.193140096361,-0.193132012413,
	-0.193123924398,-0.193115832288,-0.193107736057,-0.193099635679,-0.193091531127,
	-0.193083422374,-0.193075309395,-0.193067192162,-0.193059070649,-0.193050944829,
	-0.193042814677,-0.193034680165,-0.193026541266,-0.193018397956,-0.193010250206,
	-0.193002097990,-0.192993941283,-0.192985780057,-0.192977614286,-0.192969443943,
	-0.192961269003,-0.192953089438,-0.192944905222,-0.192936716328,-0.192928522731,
	-0.192920324403,-0.192912121319,-0.192903913451,-0.192895700773,-0.192887483259,
	-0.192879260883,-0.192871033617,-0.192862801436,-0.192854564313,-0.192846322221,
	-0.192838075135,-0.192829823027,-0.192821565871,-0.192813303641,-0.192805036311,
	-0.192796763853,-0.192788486242,-0.192780203451,-0.192771915454,-0.192763622224,
	-0.192755323735,-0.192747019960,-0.192738710873,-0.192730396448,-0.192722076658,
	-0.192713751477,-0.192705420879,-0.192697084836,-0.192688743324,-0.192680396314,
	-0.192672043781,-0.192663685699,-0.192655322041,-0.192646952781,-0.192638577892,
	-0.192630197349,-0.192621811124,-0.192613419191,-0.192605021524,-0.192596618097,
	-0.192588208883,-0.192579793856,-0.192571372989,-0.192562946257,-0.192554513633,
	-0.192546075090,-0.192537630603,-0.192529180144,-0.192520723688,-0.192512261208,
	-0.192503792679,-0.192495318073,-0.192486837364,-0.192478350526,-0.192469857533,
	-0.192461358359,-0.192452852977,-0.192444341360,-0.192435823483,-0.192427299320,
	-0.192418768844,-0.192410232028,-0.192401688847,-0.192393139275,-0.192384583284,
	-0.192376020849,-0.192367451944,-0.192358876542,-0.192350294617,-0.192341706143,
	-0.192333111094,-0.192324509443,-0.192315901164,-0.192307286232,-0.192298664619,
	-0.192290036299,-0.192281401248,-0.192272759437,-0.192264110842,-0.192255455435,
	-0.192246793191,-0.192238124084,-0.192229448087,-0.192220765175,-0.192212075321,
	-0.192203378498,-0.192194674682,-0.192185963845,-0.192177245962,-0.192168521007,
	-0.192159788953,-0.192151049775,-0.192142303446,-0.192133549940,-0.192124789231,
	-0.192116021293,-0.192107246101,-0.192098463627,-0.192089673846,-0.192080876732,
	-0.192072072260,-0.192063260402,-0.192054441133,-0.192045614427,-0.192036780258,
	-0.192027938600,-0.192019089426,-0.192010232712,-0.192001368431,-0.191992496557,
	-0.191983617064,-0.191974729927,-0.191965835119,-0.191956932614,-0.191948022387,
	-0.191939104412,-0.191930178663,-0.191921245113,-0.191912303738,-0.191903354511,
	-0.191894397406,-0.191885432398,-0.191876459461,-0.191867478569,-0.191858489696,
	-0.191849492817,-0.191840487905,-0.191831474936,-0.191822453882,-0.191813424720,
	-0.191804387422,-0.191795341963,-0.191786288317,-0.191777226459,-0.191768156364,
	-0.191759078005,-0.191749991356,-0.191740896393,-0.191731793089,-0.191722681420,
	-0.191713561359,-0.191704432880,-0.191695295959,-0.191686150570,-0.191676996687,
	-0.191667834285,-0.191658663338,-0.191649483821,-0.191640295708,-0.191631098974,
	-0.191621893593,-0.191612679541,-0.191603456791,-0.191594225318,-0.191584985098,
	-0.191575736103,-0.191566478310,-0.191557211693,-0.191547936227,-0.191538651886,
	-0.191529358645,-0.191520056479,-0.191510745362,-0.191501425270,-0.191492096177,
	-0.191482758058,-0.191473410888,-0.191464054642,-0.191454689294,-0.191445314820,
	-0.191435931195,-0.191426538392,-0.191417136389,-0.191407725159,-0.191398304677,
	-0.191388874918,-0.191379435858,-0.191369987472,-0.191360529734,-0.191351062620,
	-0.191341586105,-0.191332100164,-0.191322604772,-0.191313099904,-0.191303585537,
	-0.191294061644,-0.191284528201,-0.191274985184,-0.191265432568,-0.191255870327,
	-0.191246298439,-0.191236716877,-0.191227125617,-0.191217524636,-0.191207913907,
	-0.191198293407,-0.191188663112,-0.191179022996,-0.191169373035,-0.191159713206,
	-0.191150043483,-0.191140363842,-0.191130674259,-0.191120974710,-0.191111265170,
	-0.191101545615,-0.191091816020,-0.191082076363,-0.191072326618,-0.191062566761,
	-0.191052796769,-0.191043016617,-0.191033226280,-0.191023425737,-0.191013614961,
	-0.191003793929,-0.190993962618,-0.190984121003,-0.190974269061,-0.190964406767,
	-0.190954534098,-0.190944651030,-0.190934757540,-0.190924853603,-0.190914939197,
	-0.190905014296,-0.190895078879,-0.190885132921,-0.190875176398,-0.190865209288,
	-0.190855231566,-0.190845243210,-0.190835244195,-0.190825234499,-0.190815214098,
	-0.190805182969,-0.190795141089,-0.190785088433,-0.190775024981,-0.190764950707,
	-0.190754865589,-0.190744769604,-0.190734662729,-0.190724544941,-0.190714416216,
	-0.190704276533,-0.190694125867,-0.190683964197,-0.190673791500,-0.190663607752,
	-0.190653412930,-0.190643207013,-0.190632989978,-0.190622761802,-0.190612522462,
	-0.190602271936,-0.190592010201,-0.190581737236,-0.190571453017,-0.190561157522,
	-0.190550850729,-0.190540532615,-0.190530203159,-0.190519862339,-0.190509510131,
	-0.190499146515,-0.190488771467,-0.190478384966,-0.190467986991,-0.190457577518,
	-0.190447156527,-0.190436723995,-0.190426279900,-0.190415824222,-0.190405356937,
	-0.190394878025,-0.190384387465,-0.190373885233,-0.190363371310,-0.190352845673,
	-0.190342308301,-0.190331759173,-0.190321198267,-0.190310625563,-0.190300041038,
	-0.190289444673,-0.190278836445,-0.190268216334,-0.190257584319,-0.190246940378,
	-0.190236284492,-0.190225616638,-0.190214936797,-0.190204244947,-0.190193541069,
	-0.190182825140,-0.190172097142,-0.190161357052,-0.190150604851,-0.190139840519,
	-0.190129064034,-0.190118275378,-0.190107474528,-0.190096661466,-0.190085836171,
	-0.190074998623,-0.190064148802,-0.190053286689,-0.190042412262,-0.190031525503,
	-0.190020626391,-0.190009714907,-0.189998791032,-0.189987854745,-0.189976906027,
	-0.189965944858,-0.189954971220,-0.189943985093,-0.189932986457,-0.189921975293,
	-0.189910951582,-0.189899915306,-0.189888866444,-0.189877804978,-0.189866730889,
	-0.189855644158,-0.189844544766,-0.189833432695,-0.189822307926,-0.189811170440,
	-0.189800020219,-0.189788857244,-0.189777681497,-0.189766492960,-0.189755291613,
	-0.189744077440,-0.189732850422,-0.189721610540,-0.189710357777,-0.189699092115,
	-0.189687813536,-0.189676522022,-0.189665217556,-0.189653900119,-0.189642569694,
	-0.189631226264,-0.189619869811,-0.189608500318,-0.189597117768,-0.189585722142,
	-0.189574313425,-0.189562891598,-0.189551456645,-0.189540008550,-0.189528547294,
	-0.189517072861,-0.189505585235,-0.189494084399,-0.189482570336,-0.189471043030,
	-0.189459502464,-0.189447948622,-0.189436381488,-0.189424801045,-0.189413207277,
	-0.189401600168,-0.189389979703,-0.189378345865,-0.189366698638,-0.189355038007,
	-0.189343363956,-0.189331676470,-0.189319975532,-0.189308261128,-0.189296533242,
	-0.189284791859,-0.189273036964,-0.189261268541,-0.189249486575,-0.189237691052,
	-0.189225881957,-0.189214059274,-0.189202222990,-0.189190373089,-0.189178509557,
	-0.189166632379,-0.189154741542,-0.189142837030,-0.189130918829,-0.189118986927,
	-0.189107041307,-0.189095081957,-0.189083108863,-0.189071122010,-0.189059121385,
	-0.189047106975,-0.189035078765,-0.189023036743,-0.189010980895,-0.188998911207,
	-0.188986827667,-0.188974730262,-0.188962618978,-0.188950493802,-0.188938354723,
	-0.188926201726,-0.188914034799,-0.188901853930,-0.188889659107,-0.188877450316,
	-0.188865227545,-0.188852990783,-0.188840740017,-0.188828475236,-0.188816196426,
	-0.188803903577,-0.188791596676,-0.188779275713,-0.188766940674,-0.188754591550,
	-0.188742228328,-0.188729850998,-0.188717459547,-0.188705053966,-0.188692634242,
	-0.188680200365,-0.188667752325,-0.188655290110,-0.188642813710,-0.188630323114,
	-0.188617818312,-0.188605299294,-0.188592766048,-0.188580218566,-0.188567656838,
	-0.188555080852,-0.188542490599,-0.188529886070,-0.188517267255,-0.188504634144,
	-0.188491986728,-0.188479324998,-0.188466648943,-0.188453958556,-0.188441253827,
	-0.188428534746,-0.188415801306,-0.188403053497,-0.188390291311,-0.188377514739,
	-0.188364723773,-0.188351918404,-0.188339098624,-0.188326264424,-0.188313415798,
	-0.188300552737,-0.188287675232,-0.188274783277,-0.188261876863,-0.188248955983,
	-0.188236020630,-0.188223070797,-0.188210106475,-0.188197127658,-0.188184134339,
	-0.188171126511,-0.188158104167,-0.188145067300,-0.188132015905,-0.188118949973,
	-0.188105869500,-0.188092774478,-0.188079664901,-0.188066540764,-0.188053402060,
	-0.188040248784,-0.188027080929,-0.188013898490,-0.188000701462,-0.187987489839,
	-0.187974263615,-0.187961022787,-0.187947767347,-0.187934497292,-0.187921212616,
	-0.187907913315,-0.187894599384,-0.187881270819,-0.187867927614,-0.187854569766,
	-0.187841197270,-0.187827810122,-0.187814408319,-0.187800991856,-0.187787560729,
	-0.187774114934,-0.187760654469,-0.187747179330,-0.187733689512,-0.187720185014,
	-0.187706665832,-0.187693131962,-0.187679583402,-0.187666020149,-0.187652442201,
	-0.187638849554,-0.187625242206,-0.187611620156,-0.187597983400,-0.187584331936,
	-0.187570665763,-0.187556984878,-0.187543289280,-0.187529578967,-0.187515853937,
	-0.187502114189,-0.187488359722,-0.187474590534,-0.187460806624,-0.187447007991,
	-0.187433194634,-0.187419366553,-0.187405523746,-0.187391666214,-0.187377793955,
	-0.187363906969,-0.187350005257,-0.187336088818,-0.187322157651,-0.187308211758,
	-0.187294251138,-0.187280275791,-0.187266285719,-0.187252280921,-0.187238261399,
	-0.187224227153,-0.187210178183,-0.187196114492,-0.187182036080,-0.187167942949,
	-0.187153835099,-0.187139712532,-0.187125575251,-0.187111423256,-0.187097256549,
	-0.187083075133,-0.187068879009,-0.187054668179,-0.187040442647,-0.187026202414,
	-0.187011947482,-0.186997677855,-0.186983393535,-0.186969094525,-0.186954780828,
	-0.186940452447,-0.186926109386,-0.186911751646,-0.186897379233,-0.186882992150,
	-0.186868590399,-0.186854173986,-0.186839742914,-0.186825297186,-0.186810836808,
	-0.186796361783,-0.186781872115,-0.186767367810,-0.186752848871,-0.186738315303,
	-0.186723767112,-0.186709204302,-0.186694626878,-0.186680034845,-0.186665428209,
	-0.186650806975,-0.186636171149,-0.186621520736,-0.186606855741,-0.186592176171,
	-0.186577482032,-0.186562773330,-0.186548050070,-0.186533312260,-0.186518559905,
	-0.186503793013,-0.186489011589,-0.186474215641,-0.186459405176,-0.186444580200,
	-0.186429740720,-0.186414886745,-0.186400018280,-0.186385135334,-0.186370237914,
	-0.186355326028,-0.186340399684,-0.186325458889,-0.186310503652,-0.186295533980,
	-0.186280549882,-0.186265551366,-0.186250538442,-0.186235511116,-0.186220469398,
	-0.186205413298,-0.186190342822,-0.186175257982,-0.186160158785,-0.186145045242,
	-0.186129917361,-0.186114775152,-0.186099618625,-0.186084447788,-0.186069262653,
	-0.186054063229,-0.186038849526,-0.186023621554
	}
};

double always_inline w20_2aclip(double x) {
    double f = fabs(x);
    f = f * w20_2a_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = w20_2a_table.data[0];
    } else if (i >= w20_2a_table.size-1) {
        f = w20_2a_table.data[w20_2a_table.size-1];
    } else {
    f -= i;
    f = w20_2a_table.data[i]*(1-f) + w20_2a_table.data[i+1]*f;
    }
    return copysign(f, x);
}

