/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import org.gradle.api.internal.artifacts.version.LatestVersionSemanticComparator;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

class LatestModuleConflictResolver implements ModuleConflictResolver {
    public ModuleRevisionResolveState select(Collection<? extends ModuleRevisionResolveState> candidates, ModuleRevisionResolveState root) {
        return Collections.max(candidates, new VersionComparator());
    }

    private class VersionComparator implements Comparator<ModuleRevisionResolveState> {

        LatestVersionSemanticComparator delegate = new LatestVersionSemanticComparator();

        public int compare(ModuleRevisionResolveState left, ModuleRevisionResolveState right) {
            return delegate.compare(left.getRevision(), right.getRevision());
        }
    }
}
