package accesscontrol

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the client for the AccessControl methods of the Accesscontrol service.
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient(endpoint string) Client {
	return Client{New(endpoint)}
}

// CreateRoleAssignment create role assignment.
// Parameters:
// createRoleAssignmentOptions - details of role id and object id.
func (client Client) CreateRoleAssignment(ctx context.Context, createRoleAssignmentOptions RoleAssignmentOptions) (result RoleAssignmentDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.CreateRoleAssignment")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: createRoleAssignmentOptions,
			Constraints: []validation.Constraint{{Target: "createRoleAssignmentOptions.RoleID", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "createRoleAssignmentOptions.PrincipalID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.Client", "CreateRoleAssignment", err.Error())
	}

	req, err := client.CreateRoleAssignmentPreparer(ctx, createRoleAssignmentOptions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "CreateRoleAssignment", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateRoleAssignmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "CreateRoleAssignment", resp, "Failure sending request")
		return
	}

	result, err = client.CreateRoleAssignmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "CreateRoleAssignment", resp, "Failure responding to request")
	}

	return
}

// CreateRoleAssignmentPreparer prepares the CreateRoleAssignment request.
func (client Client) CreateRoleAssignmentPreparer(ctx context.Context, createRoleAssignmentOptions RoleAssignmentOptions) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/rbac/roleAssignments"),
		autorest.WithJSON(createRoleAssignmentOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateRoleAssignmentSender sends the CreateRoleAssignment request. The method will close the
// http.Response Body if it receives an error.
func (client Client) CreateRoleAssignmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateRoleAssignmentResponder handles the response to the CreateRoleAssignment request. The method always
// closes the http.Response Body.
func (client Client) CreateRoleAssignmentResponder(resp *http.Response) (result RoleAssignmentDetails, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteRoleAssignmentByID delete role assignment by role assignment Id.
// Parameters:
// roleAssignmentID - the ID of the role assignment.
func (client Client) DeleteRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.DeleteRoleAssignmentByID")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: roleAssignmentID,
			Constraints: []validation.Constraint{{Target: "roleAssignmentID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.Client", "DeleteRoleAssignmentByID", err.Error())
	}

	req, err := client.DeleteRoleAssignmentByIDPreparer(ctx, roleAssignmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "DeleteRoleAssignmentByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteRoleAssignmentByIDSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "DeleteRoleAssignmentByID", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteRoleAssignmentByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "DeleteRoleAssignmentByID", resp, "Failure responding to request")
	}

	return
}

// DeleteRoleAssignmentByIDPreparer prepares the DeleteRoleAssignmentByID request.
func (client Client) DeleteRoleAssignmentByIDPreparer(ctx context.Context, roleAssignmentID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleAssignmentId": autorest.Encode("path", roleAssignmentID),
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/rbac/roleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteRoleAssignmentByIDSender sends the DeleteRoleAssignmentByID request. The method will close the
// http.Response Body if it receives an error.
func (client Client) DeleteRoleAssignmentByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteRoleAssignmentByIDResponder handles the response to the DeleteRoleAssignmentByID request. The method always
// closes the http.Response Body.
func (client Client) DeleteRoleAssignmentByIDResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetCallerRoleAssignments list role assignments of the caller.
func (client Client) GetCallerRoleAssignments(ctx context.Context) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetCallerRoleAssignments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetCallerRoleAssignmentsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetCallerRoleAssignments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetCallerRoleAssignmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetCallerRoleAssignments", resp, "Failure sending request")
		return
	}

	result, err = client.GetCallerRoleAssignmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetCallerRoleAssignments", resp, "Failure responding to request")
	}

	return
}

// GetCallerRoleAssignmentsPreparer prepares the GetCallerRoleAssignments request.
func (client Client) GetCallerRoleAssignmentsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/rbac/getMyAssignedRoles"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetCallerRoleAssignmentsSender sends the GetCallerRoleAssignments request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetCallerRoleAssignmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetCallerRoleAssignmentsResponder handles the response to the GetCallerRoleAssignments request. The method always
// closes the http.Response Body.
func (client Client) GetCallerRoleAssignmentsResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoleAssignmentByID get role assignment by role assignment Id.
// Parameters:
// roleAssignmentID - the ID of the role assignment.
func (client Client) GetRoleAssignmentByID(ctx context.Context, roleAssignmentID string) (result RoleAssignmentDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRoleAssignmentByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: roleAssignmentID,
			Constraints: []validation.Constraint{{Target: "roleAssignmentID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("accesscontrol.Client", "GetRoleAssignmentByID", err.Error())
	}

	req, err := client.GetRoleAssignmentByIDPreparer(ctx, roleAssignmentID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignmentByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleAssignmentByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignmentByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoleAssignmentByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignmentByID", resp, "Failure responding to request")
	}

	return
}

// GetRoleAssignmentByIDPreparer prepares the GetRoleAssignmentByID request.
func (client Client) GetRoleAssignmentByIDPreparer(ctx context.Context, roleAssignmentID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleAssignmentId": autorest.Encode("path", roleAssignmentID),
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/rbac/roleAssignments/{roleAssignmentId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleAssignmentByIDSender sends the GetRoleAssignmentByID request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetRoleAssignmentByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleAssignmentByIDResponder handles the response to the GetRoleAssignmentByID request. The method always
// closes the http.Response Body.
func (client Client) GetRoleAssignmentByIDResponder(resp *http.Response) (result RoleAssignmentDetails, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoleAssignments list role assignments.
// Parameters:
// roleID - synapse Built-In Role Id.
// principalID - object ID of the AAD principal or security-group.
// continuationToken - continuation token.
func (client Client) GetRoleAssignments(ctx context.Context, roleID string, principalID string, continuationToken string) (result ListRoleAssignmentDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRoleAssignments")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRoleAssignmentsPreparer(ctx, roleID, principalID, continuationToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignments", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleAssignmentsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignments", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoleAssignmentsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleAssignments", resp, "Failure responding to request")
	}

	return
}

// GetRoleAssignmentsPreparer prepares the GetRoleAssignments request.
func (client Client) GetRoleAssignmentsPreparer(ctx context.Context, roleID string, principalID string, continuationToken string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(roleID) > 0 {
		queryParameters["roleId"] = autorest.Encode("query", roleID)
	}
	if len(principalID) > 0 {
		queryParameters["principalId"] = autorest.Encode("query", principalID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/rbac/roleAssignments"),
		autorest.WithQueryParameters(queryParameters))
	if len(continuationToken) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-continuation", autorest.String(continuationToken)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleAssignmentsSender sends the GetRoleAssignments request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetRoleAssignmentsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleAssignmentsResponder handles the response to the GetRoleAssignments request. The method always
// closes the http.Response Body.
func (client Client) GetRoleAssignmentsResponder(resp *http.Response) (result ListRoleAssignmentDetails, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoleDefinitionByID get role by role Id.
// Parameters:
// roleID - synapse Built-In Role Id.
func (client Client) GetRoleDefinitionByID(ctx context.Context, roleID string) (result SynapseRole, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRoleDefinitionByID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetRoleDefinitionByIDPreparer(ctx, roleID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitionByID", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleDefinitionByIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitionByID", resp, "Failure sending request")
		return
	}

	result, err = client.GetRoleDefinitionByIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitionByID", resp, "Failure responding to request")
	}

	return
}

// GetRoleDefinitionByIDPreparer prepares the GetRoleDefinitionByID request.
func (client Client) GetRoleDefinitionByIDPreparer(ctx context.Context, roleID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"roleId": autorest.Encode("path", roleID),
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPathParameters("/rbac/roles/{roleId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleDefinitionByIDSender sends the GetRoleDefinitionByID request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetRoleDefinitionByIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleDefinitionByIDResponder handles the response to the GetRoleDefinitionByID request. The method always
// closes the http.Response Body.
func (client Client) GetRoleDefinitionByIDResponder(resp *http.Response) (result SynapseRole, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetRoleDefinitions list roles.
func (client Client) GetRoleDefinitions(ctx context.Context) (result RolesListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRoleDefinitions")
		defer func() {
			sc := -1
			if result.rlr.Response.Response != nil {
				sc = result.rlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getRoleDefinitionsNextResults
	req, err := client.GetRoleDefinitionsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitions", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetRoleDefinitionsSender(req)
	if err != nil {
		result.rlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitions", resp, "Failure sending request")
		return
	}

	result.rlr, err = client.GetRoleDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "GetRoleDefinitions", resp, "Failure responding to request")
	}

	return
}

// GetRoleDefinitionsPreparer prepares the GetRoleDefinitions request.
func (client Client) GetRoleDefinitionsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	const APIVersion = "2020-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}", urlParameters),
		autorest.WithPath("/rbac/roles"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetRoleDefinitionsSender sends the GetRoleDefinitions request. The method will close the
// http.Response Body if it receives an error.
func (client Client) GetRoleDefinitionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetRoleDefinitionsResponder handles the response to the GetRoleDefinitions request. The method always
// closes the http.Response Body.
func (client Client) GetRoleDefinitionsResponder(resp *http.Response) (result RolesListResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getRoleDefinitionsNextResults retrieves the next set of results, if any.
func (client Client) getRoleDefinitionsNextResults(ctx context.Context, lastResults RolesListResponse) (result RolesListResponse, err error) {
	req, err := lastResults.rolesListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "accesscontrol.Client", "getRoleDefinitionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetRoleDefinitionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "accesscontrol.Client", "getRoleDefinitionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetRoleDefinitionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "accesscontrol.Client", "getRoleDefinitionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetRoleDefinitionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client Client) GetRoleDefinitionsComplete(ctx context.Context) (result RolesListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.GetRoleDefinitions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetRoleDefinitions(ctx)
	return
}
