/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef _GNOME_SCAN_DIALOG_H_
#define _GNOME_SCAN_DIALOG_H_

#include <glib-object.h>
#include <gtk/gtk.h>
#include "gnome-scan-job.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_DIALOG             (gnome_scan_dialog_get_type ())
#define GNOME_SCAN_DIALOG(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialog))
#define GNOME_SCAN_DIALOG_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialogClass))
#define GNOME_IS_SCAN_DIALOG(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_DIALOG))
#define GNOME_IS_SCAN_DIALOG_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_DIALOG))
#define GNOME_SCAN_DIALOG_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_DIALOG, GnomeScanDialogClass))

typedef struct _GnomeScanDialogClass GnomeScanDialogClass;
typedef struct _GnomeScanDialog GnomeScanDialog;

struct _GnomeScanDialogClass
{
	GtkDialogClass parent_class;
};

/**
 * GnomeScanDialog:
 *
 * The #GnomeScanDialog is an autofilled #GtkDialog that present a
 * graphical interface consistent with #GtkPrintUnixDialog available
 * Gtk+ since 2.10, but intirely adapted to scanning. You should not
 * touch #GtkDialog vbox, however, if you want to add a About button
 * or similar, use #GtkDialog action_area.
 **/
struct _GnomeScanDialog
{
	/*< private >*/
	GtkDialog parent_instance;
};

GType gnome_scan_dialog_get_type (void) G_GNUC_CONST;
GtkWidget* gnome_scan_dialog_new (GtkWindow *parent,
								  GnomeScanJob *job);
void gnome_scan_dialog_run (GnomeScanDialog *dialog);

G_END_DECLS

#endif /* _GNOME_SCAN_DIALOG_H_ */
