---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
This documentation is auto generated by a script.
Please do not edit this file directly. Run `make gen-docs` instead.
-->

# `glab token revoke`

Revoke user, group or project access tokens

## Synopsis

Revoke an user, group or project access token. If multiple tokens with the same name exist, you can specify
the ID of the token.

The output format can be either "JSON" or "text". The JSON output will show the meta information of the
revoked token. The normal text output is a description of the revoked token name and ID.

Administrators can revoke personal access tokens belonging to other users.

```plaintext
glab token revoke <token-name|token-id> [flags]
```

## Aliases

```plaintext
revoke
rm
```

## Examples

```plaintext
# Revoke a project access token of current project
glab token revoke my-project-token

# Revoke a project access token of a specific project
glab token revoke --repo user/my-repo my-project-token

# Revoke a group access token
glab token revoke --group group/sub-group my-group-token

# Revoke my personal access token
glab token revoke --user @me my-personal-token

# Revoke a personal access token of another user (administrator only)
glab token revoke --user johndoe johns-personal-token


```

## Options

```plaintext
  -g, --group string      Revoke group access token. Ignored if a user or repository argument is set.
  -F, --output string     Format output as: text, json. 'text' provides the name and ID of the revoked token; 'json' outputs the token with metadata. (default "text")
  -R, --repo OWNER/REPO   Select another repository. Can use either OWNER/REPO or `GROUP/NAMESPACE/REPO` format. Also accepts full URL or Git URL.
  -U, --user string       Revoke personal access token. Use @me for the current user.
```

## Options inherited from parent commands

```plaintext
      --help   Show help for this command.
```
