"""
 * Copyright (C) 2008 Varun Hiremath.
 * Copyright (C) 2008 A Venkattraman.
 * Copyright (C) 2008 C Shyam Sundar.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * Authors: Varun Hiremath, Venkattraman A, Shyam Sundar C

"""

from gastables.NormalShock import NormalShock
from scipy import arange

def get_allValues_from_Mx(Mx,gamma) :
    ns = NormalShock(gamma)
    VALUES = {}
    VALUES["Mx"] = Mx
    try:
        VALUES["My"] = ns.get_My_from_Mx(Mx)
        VALUES["Py/Px"] = ns.get_Py_by_Px_from_Mx(Mx)
        VALUES["Poy/Px"] = ns.get_Poy_by_Px_from_Mx(Mx)
        VALUES["Poy/Pox"] = ns.get_Poy_by_Pox_from_Mx(Mx)
        VALUES["ry/rx"] = ns.get_rhoy_by_rhox_from_Mx(Mx)
        VALUES["Ty/Tx"] = ns.get_Ty_by_Tx_from_Mx(Mx)
        return VALUES
    except Exception, e:
        raise Exception(e)

def get_allValues_from_My(My,gamma):
    ns = NormalShock(gamma)
    try:
        return get_allValues_from_Mx(ns.get_Mx_from_My(My), gamma)
    except Exception, e:
        raise Exception(e)

def get_allValues_from_Py_by_Px(Py_by_Px,gamma):
    ns = NormalShock(gamma)
    try:
        return get_allValues_from_Mx(ns.get_Mx_from_Py_by_Px(Py_by_Px), gamma)
    except Exception, e:
        raise Exception(e)

def get_allValues_from_Poy_by_Px(Poy_by_Px,gamma):
    ns = NormalShock(gamma)
    try:
        return get_allValues_from_Mx(ns.get_Mx_from_Poy_by_Px(Poy_by_Px) ,gamma)
    except Exception, e:
        raise Exception(e)
    
def get_allValues_from_Poy_by_Pox(Poy_by_Pox,gamma):
    ns = NormalShock(gamma)
    try:
        Mx = ns.get_Mx_from_Poy_by_Pox(Poy_by_Pox)
        return get_allValues_from_Mx(Mx, gamma)
    except Exception, e:
        raise Exception(e)

def get_allValues_from_rhoy_by_rhox(rhoy_by_rhox,gamma):
    ns = NormalShock(gamma)
    try:
        return get_allValues_from_Mx(ns.get_Mx_from_rhoy_by_rhox(rhoy_by_rhox), gamma)
    except Exception, e:
        raise Exception(e)

def get_allValues_from_Ty_by_Tx(Ty_by_Tx,gamma):
    ns = NormalShock(gamma)
    try:
        return get_allValues_from_Mx(ns.get_Mx_from_Ty_by_Tx(Ty_by_Tx), gamma)
    except Exception, e:
        raise Exception(e)

def get_plotData_from_Mx(gamma):
    MxRange = arange(1.01,10.01,0.1)
    VALUES = {"Mx" : MxRange, "My" : [], "Py/Px": [], "Poy/Px" : [], "Poy/Pox" : [], "ry/rx" : [], "Ty/Tx" : [] }
    ns = NormalShock(gamma)
    
    for Mx in MxRange:
        VALUES["My"].append(ns.get_My_from_Mx(Mx))
        VALUES["Py/Px"].append(ns.get_Py_by_Px_from_Mx(Mx))
        VALUES["Poy/Px"].append(ns.get_Poy_by_Px_from_Mx(Mx))
        VALUES["Poy/Pox"].append(ns.get_Poy_by_Pox_from_Mx(Mx))
        VALUES["ry/rx"].append(ns.get_rhoy_by_rhox_from_Mx(Mx))
        VALUES["Ty/Tx"].append(ns.get_Ty_by_Tx_from_Mx(Mx))

    return VALUES
