#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Save current configuration to file"

    def run(self):
        self.present_text("Saving current configuration...")

        try:
            # Force reload and save of current configuration
            self.reload_config()

            # Write the configuration file
            with open(self.settings_file, "w") as configfile:
                self.config.write(configfile)

            self.present_text("Configuration saved successfully")
            self.play_sound("Accept")

        except Exception as e:
            self.present_text(f"Failed to save configuration: {str(e)}")
            self.play_sound("Error")
