/*
 * $Id: sig_dio48.c,v 1.15 2012-07-05 21:09:30 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

#include "sig_dio48.h"

struct sig_dio48 *
sig_dio48_create(const char *name)
{
	struct sig_dio48 *sig;
	char n[1000];
	unsigned int i;

	sig = shm_alloc(sizeof(*sig));
	assert(sig);

	for (i = 0; i < 48; i++) {
		sprintf(n, "%s-sig%02d", name, i);
		sig->sig[i] = sig_std_logic_create(n);
	}

	return sig;
}

void
sig_dio48_destroy(struct sig_dio48 *sig)
{
	unsigned int i;

	assert(sig);
	/* assert(sig->type == SIG_GEN_DIO48); */

	for (i = 0; i < 48; i++) {
		sig_std_logic_destroy(sig->sig[i]);
	}

	shm_free(sig);
}

void
sig_dio48_suspend(struct sig_dio48 *b, FILE *fSig)
{
	int i;
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
	
	for (i = 0; i < 48; i++) {
		sig_std_logic_suspend(b->sig[i], fSig);
	}
}

void
sig_dio48_resume(struct sig_dio48 *b, FILE *fSig)
{
	int i;
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
	
	for (i = 0; i < 48; i++) {
		sig_std_logic_resume(b->sig[i], fSig);
	}
}
