.TH "alistat" 1 "Oct 2002" "SQUID 1.9g" "SQUID Manual"

.SH NAME
.TP 
alistat - show statistics for a multiple alignment file

.SH SYNOPSIS
.B alistat
.I [options]
.I alignfile

.SH DESCRIPTION

.B alistat
reads a multiple sequence alignment from the file
.I alignfile
in any supported format (including SELEX, GCG MSF, and
CLUSTAL), and shows a number of simple statistics about it.
These statistics include the name of the format,
the number of sequences, the total number of residues,
the average and range of the sequence lengths, the
alignment length (e.g. including gap characters).

.PP
Also shown are some percent identities. A percent
pairwise alignment identity is defined as
.I (idents / MIN(len1, len2))
where 
.I idents
is the number of exact identities
and 
.I len1, len2
are the unaligned lengths of the two
sequences. The "average percent identity",
"most related pair", and "most unrelated pair"
of the alignment are the average, maximum, and
minimum of all 
(N)(N-1)/2 pairs, respectively.
The "most distant seq" is calculated by finding
the maximum pairwise identity (best relative) for all N sequences,
then finding the minimum of these N numbers (hence, 
the most outlying sequence).

.SH OPTIONS

.TP
.B -a 
Show additional verbose information: a table with one line per
sequence showing name, length, and its highest and lowest pairwise
identity. These lines are prefixed with a * character to enable
easily 
.BR grep' ing
them out and sorting them. For example,
.I alistat -a foo.slx | grep "*" | sort -n +3 
gives a ranked list of the most distant sequences
in the alignment. 
Incompatible with the
.B -f
option.

.TP 
.B -f 
Fast; use a sampling method to estimate the average %id.
When this option is chosen, 
.B alistat 
doesn't show the other three pairwise identity numbers.
This option is useful for very large alignments, for
which the full (N)(N-1) calculation of all pairs would
be prohibitive (e.g. Pfam's GP120 alignment, with over
10,000 sequences). Incompatible with the 
.B -a 
option.

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -q
be quiet - suppress the verbose header (program name, release number
and date, the parameters and options in effect).

.TP
.B -B
(Babelfish). Autodetect and read a sequence file format other than the
default (FASTA). Almost any common sequence file format is recognized
(including Genbank, EMBL, SWISS-PROT, PIR, and GCG unaligned sequence
formats, and Stockholm, GCG MSF, and Clustal alignment formats). See
the printed documentation for a complete list of supported formats.

.SH EXPERT OPTIONS

.TP
.BI --informat " <s>"
Specify that the sequence file is in format 
.I <s>,
rather than the default FASTA format.
Common examples include Genbank, EMBL, GCG, 
PIR, Stockholm, Clustal, MSF, or PHYLIP; 
see the printed documentation for a complete list
of accepted format names.
This option overrides the default format (FASTA)
and the 
.I -B
Babelfish autodetection option.



.SH SEE ALSO

.PP
http://www.genetics.wustl.edu/eddy/software/#squid

.SH AUTHOR

SQUID and its documentation are Copyright (C) 1992-2002 HHMI/Washington University School of Medicine
Freely distributed under the GNU General Public License (GPL)
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


