



contdata =
{
{"ExtendGraphics`CheckPlot3D`", "extendgr\\checkp3d.m"},

{"ExtendGraphics`ComponentPlot`", "extendgr\\componp.m"},

{"ExtendGraphics`ConstrainedContour`", "extendgr\\conscont.m"},

{"ExtendGraphics`CorrelationPlot`", "extendgr\\corrplot.m"},

{"ExtendGraphics`SimpleHull`", "extendgr\\simphull.m"},

{"ExtendGraphics`Delaunay`", "extendgr\\delaunay.m"},

{"ExtendGraphics`FieldLines`", "extendgr\\fieldlns.m"},

{"ExtendGraphics`Geometry`", "extendgr\\geometry.m"},

{"ExtendGraphics`Geometry3D`", "extendgr\\geomet3d.m"},

{"ExtendGraphics`LabelContour`", "extendgr\\lablcont.m"},

{"ExtendGraphics`Mandelbrot`", "extendgr\\mandbrot.m"},

{"ExtendGraphics`NonConvexTriangulate`", "extendgr\\ncontri.m"},

{"ExtendGraphics`PointSubstitute3D`", "extendgr\\pntsubs.m"},

{"ExtendGraphics`SmoothGraphics`", "extendgr\\smtgraph.m"},

{"ExtendGraphics`Ticks`", "extendgr\\ticks.m"},

{"ExtendGraphics`Transform`", "extendgr\\transfom.m"},

{"ExtendGraphics`TriangularInterpolate`", "extendgr\\triinte.m"},

{"ExtendGraphics`View3D`", "extendgr\\view3d.m"}
}



filedata =
Join[ contdata,
{
{"ExtendGraphics`SurfaceGraphics3D`", "extendgr\\srfgraph.m"},

{"ExtendGraphics`Plot`", "extendgr\\plot.m"},

{"ExtendGraphics`Label`", "extendgr\\label.m"},

{"ExtendGraphics`delaunay`", "extendgr\\delaunay.tm"},

{"ExtendGraphics`contour`", "extendgr\\contour.tm"},

{"ExtendGraphics`mandelbrot`", "extendgr\\mandbrot.tm"},

{"ExtendGraphics`Contour`", "extendgr\\contour.m"},

{"ExtendGraphics`EAEdata`", "extendgr\\eaedata.m"},

{"ExtendGraphics`Ionization`", "extendgr\\ionize.m"},

{"ExtendGraphics`Streakdata`", "extendgr\\strkdata.m"},

{"ExtendGraphics`SuperConductor1`", "extendgr\\supcond1.m"},

{"ExtendGraphics`SuperConductor2`", "extendgr\\supcond2.m"},

{"ExtendGraphics`USVotingData`", "extendgr\\usvoting.m"}
}]

binaries =
{"delaunay", "contour", "mandelbrot"}

notebooks =
{{"Contour.ma", "contour.ma"}, 
 {"Delaunay.ma", "delaunay.ma"},
 {"Geometry3D.ma", "geom3d.ma"},
 {"Mandbrot.ma", "mandbrot.ma"},
 {"Surface.ma", "surface.ma"}};



Unprotect[ ContextToFilename]

ContextToFilename[ "ExtendGraphics`delaunay`"] = 
			"ExtendGraphics/delaunay.tm"

ContextToFilename[ "ExtendGraphics`contour`"] = 
			"ExtendGraphics/contour.tm"

ContextToFilename[ "ExtendGraphics`mandelbrot`"] = 
			"ExtendGraphics/mandelbrot.tm"


preamble =
"
(*\n
\n
	This file sets up ContextToFilename conversions for\n
	the ExtendGraphics packages that accompany the book\n
	Mathematica Graphics: Techniques and Applications.\n
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.\n
\n
*)\n\n\n\n"


masterpre =
"
(*\n
\n
	This is the Master.m file that sets up the appropriate\n
	DeclarePackage statements for the ExtendGraphics packages that\n
	accompany the book\n
	Mathematica Graphics: Techniques and Applications.\n
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.\n
\n
*)\n\n
BeginPackage[ \"ExtendGraphics`Master`\"]\n\n
EndPackage[]\n\n\n\n"


GetSymbols[ {"ExtendGraphics`SimpleHull`", _}] :=
	"\"ExtendGraphics`SimpleHull`\", {\"SimpleConvexHull\"}"


GetSymbols[ {cont_, _}] :=
	Block[{},
		Needs[ cont] ;
		StringJoin[
			"\"", ToString[ cont], "\",\n",
			ToString[ Names[ cont <> "*"], FormatType -> InputForm]]
		]

BuildMaster[ target_ /; FileType[ target] === Directory, ops_] :=
	Block[{dir = Directory[], stm, files, name},
		name = If[ ops === "DOS", "master.m", "Master.m"] ;
		stm = OpenWrite[ target <> "/" <> name] ;
		SetDirectory[ ".."] ;

		files = Map[ GetSymbols, contdata] ;
		Write[ stm, OutputForm[ masterpre]] ;
		Do[
			WriteString[ stm, 
				"DeclarePackage[ ", Part[ files,i], " ]\n\n"],
				{i,Length[contdata]}] ;

		WriteString[ stm, "\nNull\n\n\n"] ;
		Close[ stm] ;
		SetDirectory[ dir]
		]


BuildDisc[ target_ /; FileType[ target] === Directory] :=
	Block[{files, newfiles},
		files = Map[ FixFile[ ContextToFilename[ First[#]],"/"]&, filedata] ;
		(*files = Join[ files, binaries] ;*)
		Map[ CopyFile[ #, target <> "/" <> #] &, files] ;
		CopyFile[ "README.TXT", FixFileEnd[target,"/"] <> "README.TXT"] ;
		Map[ 
		  CopyFile[ First[#], 
		            StringJoin[ FixFileEnd[target,"/"], 
                    "Notebooks/", First[#]]]&,
		  notebooks];
		BuildMaster[ target, False] ;
		]


SplitDOSFile[ fname_String] :=
	Block[{pos},
		pos = Part[ StringPosition[ fname, "\\"],1,1] ;
		StringJoin[
			StringTake[ fname, pos-1], ":", StringDrop[ fname, pos]]
		]


SplitMacFile[ fname_String] :=
	Block[{pos, name,dir},
		pos = Part[ StringPosition[ fname, "`"],1,1] ;
		name = StringDrop[ fname, pos] ;
		name = StringDrop[ name, -1] <> ".m" ;
		dir = StringTake[ fname, pos-1] ;
		{ dir, name}
		]

renameP =
"
(*\n
\n
	This file will convert filenames from DOS files to\n
	Macintosh file names for the ExtendGraphics packages\n
	that accompany the book\n
	Mathematica Graphics: Techniques and Applications.\n
	Tom Wickham-Jones, TELOS/Springer-Verlag 1994.\n
\n\n\n
	If the TWJPACKS directory has been copied on Macintosh HD\n
	then enter into a Mathematica session.\n
\n
		Get[\"Macintosh HD:TWJPACKS:MACFILES.M\"]\n
\n
	when it asks you where to build the output enter\n
\n
		Macintosh HD\n
\n		
	and hit return.  It will then build the proper filenames for\n
	the Macintosh in a folder TWJ_Packages.  After this the\n
	TWJPACKS folder can be removed.\n
\n
*)\n\n\n\n"


renamePreamble =
"\n\n\n\n
FixFiles[] :=\n
(\n
newplace = \n
  InputString[ \"Folder where the TWJ_Packages will be placed?\n(e.g. Macintosh HD)\"] ;\n
If[ newplace === \"\" || StringTake[ newplace, -1] =!= \":\",\n
  newplace = newplace <> \":\"] ;\n
If[ FileType[ newplace] =!= Directory,\n
  Print[ \"TWJ_Packages must go into a folder.   Try again.\"];\n
  Abort[]] ;\n
If[ FileNames[\"TWJ_Packages\", newplace] =!= {},\n
  Print[ \"TWJ_Packages in this location already exists.\"];\n
  Print[ \"Remove it and try again.\"];\n
  Abort[]] ;\n
If[ FileType[ newplace <> \"TWJPACKS\"] === Directory,\n
  Print[ \"TWJPACKS found in \", newplace] ;\n
  oldplace = newplace,		\n
  oldplace = InputString[ \"Folder containing the TWJPACKS?\"]] ;\n
If[ oldplace === \"\" || StringTake[ oldplace, -1] =!= \":\",\n
  oldplace = oldplace <> \":\"] ;\n
If[ FileType[ oldplace] =!= Directory ||\n
  FileNames[ \"TWJPACKS\", oldplace] === {},\n
  Print[ \"I can't find the TWJPACKS.   Try again.\"];\n
  Abort[]] ;\n
CreateDirectory[ newplace <> \"TWJ_Packages\"] ;\n
CreateDirectory[ newplace <> \"TWJ_Packages:ExtendGraphics\"] ;\n
CreateDirectory[ newplace <> \"TWJ_Packages:Notebooks\"] ;\n
oldplace = oldplace <> \"TWJPACKS:\" ;\n
newplace = newplace <> \"TWJ_PACKAGES:\" ;\n
myCopyFile[ oldplace, newplace, { \"README.TXT\", \"\", \"README.TXT\"}] ;\n
Map[ myCopyFile[ oldplace, newplace, #]&, filedata];\n
Print[\"Files successfully copied.  The old versions can now be deleted.\"];\n
)\n\n\n
myCopyFile[ olddir_, newdir_, {oldname_, subdir_, name_}] :=\n
  Block[{dir},\n
    dir = Directory[] ;\n
	SetDirectory[ newdir <> subdir ] ;\n
	CopyFile[ olddir <> oldname, name] ;
	SetDirectory[ dir] ;
	]
\n\n\n
FixFiles[]
\n\n\n\n"
	
notedata =
{{"ntebooks:contour.ma", "Notebooks", "Contour.ma"}, 
 {"ntebooks:delaunay.ma", "Notebooks", "Delaunay.ma"},
 {"ntebooks:geom3d.ma", "Notebooks", "Geometry3D.ma"},
 {"ntebooks:mandbrot.ma", "Notebooks", "Mandbrot.ma"},
 {"ntebooks:surface.ma", "Notebooks", "Surface.ma"},
 {"extendgr:master.m", "ExtendGraphics", "Master.m"}};

FixTM[ {dos_, dir_, mac_}] :=
	{dos, dir,
		If[ ToLowerCase[ StringTake[ dos, -3]] === ".tm",
			StringDrop[ mac, -1] <> "tm", mac]}

BuildRename[ target_] :=
	Block[{stm, files},
		stm = OpenWrite[ FixFileEnd[target,"/"] <> "macfiles.m"] ;
		Write[ stm, OutputForm[renameP]] ;
		files = 
		  Map[ Flatten[{SplitDOSFile[#[[2]]], SplitMacFile[#[[1]]]}]&, 
		       filedata] ;
		files = Join[ files, notedata] ;
		files = Map[ FixTM, files] ;
		files = 
			Map[ToString[ OutputForm[#]]&,
			files, {2}] ;
		files = Map[ {ToUpperCase[#[[1]]], #[[2]], #[[3]]}&, files] ;
		WriteString[ stm, "filedata = \n"] ;
		Write[ stm, files] ;
		Write[ stm, OutputForm[renamePreamble]] ;
		Close[ stm] ;
		]

		
FixDOSFile[ fname_String] :=
	StringDrop[ fname, Part[ StringPosition[ fname, "\\"],1,1]]
	
FixFile[ fname_String, sep_String] :=
	StringDrop[ fname, Part[ StringPosition[ fname, sep],1,1]]
	
FixFileEnd[ fname_String, sep_String] :=
	StringTake[ fname, Part[ StringPosition[ fname, sep],-1,1]]
	

	
DOSBuildDisc[ target_ /; FileType[ target] === Directory] :=
	Block[{files, newfiles, stm},
		files = Map[ ContextToFilename[ First[#]]&, filedata] ;
		Map[ CopyFile[ FixFile[ContextToFilename[ First[#]], "/"], 
				target <> "/" <> FixFile[Last[#], "\\"]] &, filedata] ;
		Map[ 
		  CopyFile[ First[#], 
		            StringJoin[FixFileEnd[target,"/"], "ntebooks/", Last[#]]]&,
		  notebooks];
		CopyFile[ "README.TXT", FixFileEnd[target,"/"] <> "readme.txt"] ;

		stm = OpenWrite[ target <> "/../" <> "dosgraph.m"] ;
		newfiles = Append[ filedata, 
					{"ExtendGraphics`Master`", "extendgr\\master.m"}] ;
		Write[ stm, OutputForm[ preamble]] ;
		WriteString[ stm, "Unprotect[ ContextToFilename]\n\n"] ;
		Do[
			WriteString[ stm, 
				"ContextToFilename[ \"", 
				Part[ newfiles,i,1],"\" ] = \n",
				"       \"", StringReplace[ Part[ newfiles,i,2],
									"\\" -> "\\\\"], "\"\n\n"],
				{i,Length[newfiles]}] ;

		WriteString[ stm, "Null \n\n"];

		Close[ stm] ;
		BuildRename[ target] ;
		BuildMaster[ target, "DOS"] ;
		]		


(*


<<BuildDisc.m

BuildDisc[ "../DiscOut/TWJ_Packages/ExtendGraphics"]

DOSBuildDisc[ "../DOSDisc/twjpacks/extendgr"]

*)











