{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdVector: TMFVec3f;
    { X3D field "vector". } { }
    public property FdVector: TMFVec3f read FFdVector;
    { Set X3D field "vector". } { }
    procedure SetVector(const Value: array of TVector3);
    { Set X3D field "vector". } { }
    procedure SetVector(const Value: TVector3List);

{$endif read_interface}

{$ifdef read_implementation}

{ TTangentNode ----------------------------------------------- }

procedure TTangentNode.SetVector(const Value: array of TVector3);
begin
  FdVector.Send(Value);
end;

procedure TTangentNode.SetVector(const Value: TVector3List);
begin
  FdVector.Send(Value);
end;

class function TTangentNode.ClassX3DType: String;
begin
  Result := 'Tangent';
end;

procedure TTangentNode.CreateNode;
begin
  inherited;

  FFdVector := TMFVec3f.Create(Self, True, 'vector', []);
   FdVector.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVector);
  { X3D specification comment: [-1,1] }

  DefaultContainerField := 'tangent';
end;

{$endif read_implementation}
