{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetEnabled: Boolean;
    procedure SetEnabled(const Value: Boolean);
    function GetVisibilityRange: Single;
    procedure SetVisibilityRange(const Value: Single);
    function GetVolumetric: Boolean;
    procedure SetVolumetric(const Value: Boolean);
    function GetVolumetricDirection: TVector3;
    procedure SetVolumetricDirection(const Value: TVector3);
    function GetVolumetricVisibilityStart: Single;
    procedure SetVolumetricVisibilityStart(const Value: Single);
  public
    { X3D field "color". } { }
    property Color: TCastleColorRGB read GetColor write SetColor;
    { X3D field "enabled". } { }
    property Enabled: Boolean read GetEnabled write SetEnabled;
    { X3D field "visibilityRange". } { }
    property VisibilityRange: Single read GetVisibilityRange write SetVisibilityRange;
    { X3D field "volumetric". } { }
    property Volumetric: Boolean read GetVolumetric write SetVolumetric;
    { X3D field "volumetricDirection". } { }
    property VolumetricDirection: TVector3 read GetVolumetricDirection write SetVolumetricDirection;
    { X3D field "volumetricVisibilityStart". } { }
    property VolumetricVisibilityStart: Single read GetVolumetricVisibilityStart write SetVolumetricVisibilityStart;

{$endif read_interface}

{$ifdef read_implementation}

{ TLocalFogNode ----------------------------------------------- }

function TLocalFogNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TLocalFogNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TLocalFogNode.GetEnabled: Boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TLocalFogNode.SetEnabled(const Value: Boolean);
begin
  FdEnabled.Send(Value);
end;

function TLocalFogNode.GetVisibilityRange: Single;
begin
  Result := FdVisibilityRange.Value;
end;

procedure TLocalFogNode.SetVisibilityRange(const Value: Single);
begin
  FdVisibilityRange.Send(Value);
end;

function TLocalFogNode.GetVolumetric: Boolean;
begin
  Result := FdVolumetric.Value;
end;

procedure TLocalFogNode.SetVolumetric(const Value: Boolean);
begin
  FdVolumetric.Send(Value);
end;

function TLocalFogNode.GetVolumetricDirection: TVector3;
begin
  Result := FdVolumetricDirection.Value;
end;

procedure TLocalFogNode.SetVolumetricDirection(const Value: TVector3);
begin
  FdVolumetricDirection.Send(Value);
end;

function TLocalFogNode.GetVolumetricVisibilityStart: Single;
begin
  Result := FdVolumetricVisibilityStart.Value;
end;

procedure TLocalFogNode.SetVolumetricVisibilityStart(const Value: Single);
begin
  FdVolumetricVisibilityStart.Send(Value);
end;

{$endif read_implementation}
