;;; bitmap16.el --- a font file generator for 8x16 bitmap patterns
;; Copyright (C) 2001 Katsumi Yamaoka

;; Author: Katsumi Yamaoka <yamaoka@jpl.org>
;; Keywords: bitmap, bdf, font

;; This file is part of BITMAP-MULE.

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; All files generated by this program can be distributed under the
;; GNU General Public License.  See the beginning of those files.

;;; Code:

(defun generate-bitmap-bdf-font ()
  "Generate a bdf font file in the current directory for 8x16 bitmap
patterns.  The name of the file will be \"bitmap16.bdf\"."
  (let ((buffer (get-buffer-create "bitmap16.bdf")))
    (save-excursion
      (set-buffer buffer)
      (erase-buffer)
      (setq buffer-file-name (expand-file-name (buffer-name)))
      (insert "STARTFONT 2.1
COMMENT This font was automatically generated by BITMAP-MULE.
COMMENT Font for BITMAP 8x16.
COMMENT   Whole bitmap patterns of 8x16 can be displayed by
COMMENT   overwriting 16 characters of this font (one char per one row).
")
      (insert "COMMENT
COMMENT Copyright (C) 2001 Katsumi Yamaoka
COMMENT
COMMENT This font is free data; you can redistribute it and/or modify
COMMENT it under the terms of the GNU General Public License as published by
COMMENT the Free Software Foundation; either version 2, or (at your option)
COMMENT any later version.
COMMENT
COMMENT This font is distributed in the hope that it will be useful,
COMMENT but WITHOUT ANY WARRANTY; without even the implied warranty of
COMMENT MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
COMMENT GNU General Public License for more details.
COMMENT
COMMENT You should have received a copy of the GNU General Public License
COMMENT along with this font; see the file COPYING.  If not, write to the
COMMENT Free Software Foundation, Inc., 59 Temple Place - Suite 330,
COMMENT Boston, MA 02111-1307, USA.
")
      (insert "COMMENT
FONT -Misc-Fixed-Medium-R-Normal--16-120-100-100-M-80-BITMAP.8x16-0
SIZE 16 100 100
FONTBOUNDINGBOX 8 16 0 -2
STARTPROPERTIES 21
FOUNDRY \"Misc\"
FAMILY_NAME \"Fixed\"
WEIGHT_NAME \"Medium\"
SLANT \"R\"
SETWIDTH_NAME \"Normal\"
ADD_STYLE_NAME \"\"
PIXEL_SIZE 16
POINT_SIZE 120
RESOLUTION_X 100
RESOLUTION_Y 100
SPACING \"M\"
AVERAGE_WIDTH 80
CHARSET_REGISTRY \"BITMAP.8x16\"
CHARSET_ENCODING \"0\"
STRIKEOUT_ASCENT 14
STRIKEOUT_DESCENT 2
X_HEIGHT 16
DEFAULT_CHAR 8224
FONT_DESCENT 2
FONT_ASCENT 14
FACE_NAME \"8x16 BITMAP\"
ENDPROPERTIES
CHARS 4082
")
      ;; Space (all bits cleared) character
      (insert "STARTCHAR C000
ENCODING 8224
SWIDTH 480 0
DWIDTH 8 0
BBX 0 0 0 0
BITMAP
ENDCHAR
")
      ;; Block (all bits set) character
      (insert "STARTCHAR CFFFFF
ENCODING 8225
SWIDTH 480 0
DWIDTH 8 0
BBX 8 16 0 -2
BITMAP
FF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF\nFF
ENDCHAR
")
      (let ((index 0)
	    (row 0)
	    column)
	(while (< row 16)
	  (setq column 0)
	  (while (< column 255)
	    (setq column (1+ column))
	    (insert (format "STARTCHAR C%x%02x\n" row column)
		    (format "ENCODING %d\n" (+ 8448
					       (* (/ index 96) 256)
					       (% index 96) 32))
		    "SWIDTH 480 0\n"
		    "DWIDTH 8 0\n"
		    (format "BBX 8 1 0 %d\n" (- 13 row))
		    "BITMAP\n"
		    (format "%02x\n" column)
		    "ENDCHAR\n")
	    (setq index (1+ index)))
	  (setq row (1+ row))))
      (insert "ENDFONT\n")
      ;; Force the line-break codes to be LF.
      (let ((file-coding-system '*noconv*)
	    (buffer-file-coding-system 'binary))
	(save-buffer)))))

;; bitmap16.el ends here
