// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __stack_h__
#define __stack_h__

#include "Puma/Array.h"

namespace Puma {

template <class Item>
class Stack : private Array<Item> {
public:
  Stack (long is = 8192, long incr = 8192) :
    Array<Item> (is, incr) {}
  void push (Item f) { Array<Item>::append (f); }
  Item &top () const { long len = Array<Item>::length ()-1; 
                       return Array<Item>::lookup (len >= 0 ? len : 0); }
  void pop () { Array<Item>::remove (Array<Item>::length () - 1); }
  long length () const { return Array<Item>::length (); }
  void reset () { Array<Item>::reset (); }
};

} // namespace Puma

#endif /* __stack_h__ */
