/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.annotation.Annotation;
import org.cojen.classfile.TypeDesc;
import org.cojen.util.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationDescPrinter
extends AnnotationVisitor<Object, Object> {
    static final char TAG_BOOLEAN = 'Z';
    static final char TAG_BYTE = 'B';
    static final char TAG_SHORT = 'S';
    static final char TAG_CHAR = 'C';
    static final char TAG_INT = 'I';
    static final char TAG_LONG = 'J';
    static final char TAG_FLOAT = 'F';
    static final char TAG_DOUBLE = 'D';
    static final char TAG_VOID = 'V';
    static final char TAG_OBJECT = 'L';
    static final char TAG_ARRAY = '[';
    static final char TAG_STRING = 's';
    static final char TAG_CLASS = 'c';
    static final char TAG_ENUM = 'e';
    static final char TAG_ANNOTATION = '@';
    private final StringBuilder mBuilder;

    public static String makePlainDescriptor(Class<? extends Annotation> annotationType) {
        return "@" + TypeDesc.forClass(annotationType).getDescriptor();
    }

    public static String makePlainDescriptor(String annotationType) {
        return "@L" + annotationType.replace('.', '/') + ';';
    }

    public AnnotationDescPrinter(boolean sort, StringBuilder b) {
        super(sort);
        this.mBuilder = b;
    }

    public Object visit(Annotation value) {
        return this.visit(value, null);
    }

    @Override
    public Object visit(String name, int pos, Annotation value, Object param) {
        if (this.appendName(name, pos, '@')) {
            this.mBuilder.append(TypeDesc.forClass(value.annotationType()).getDescriptor());
        }
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, int value, Object param) {
        this.appendName(name, pos, 'I');
        this.mBuilder.append(value);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, long value, Object param) {
        this.appendName(name, pos, 'J');
        this.mBuilder.append(value);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, float value, Object param) {
        this.appendName(name, pos, 'F');
        this.mBuilder.append(Float.toString(value));
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, double value, Object param) {
        this.appendName(name, pos, 'D');
        this.mBuilder.append(Double.toString(value));
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, boolean value, Object param) {
        this.appendName(name, pos, 'Z');
        this.mBuilder.append(value ? (char)'1' : '0');
        return null;
    }

    @Override
    public Object visit(String name, int pos, byte value, Object param) {
        this.appendName(name, pos, 'B');
        this.mBuilder.append(value);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, short value, Object param) {
        this.appendName(name, pos, 'S');
        this.mBuilder.append(value);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, char value, Object param) {
        this.appendName(name, pos, 'C');
        this.mBuilder.append(value);
        return null;
    }

    @Override
    public Object visit(String name, int pos, String value, Object param) {
        this.appendName(name, pos, 's');
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\\' || c == ';') {
                this.mBuilder.append('\\');
            }
            this.mBuilder.append(c);
        }
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Class value, Object param) {
        this.appendName(name, pos, 'c');
        if (value == String.class) {
            this.mBuilder.append('s');
        } else if (value == Class.class) {
            this.mBuilder.append('c');
        } else {
            this.mBuilder.append(TypeDesc.forClass(value).getDescriptor());
        }
        return null;
    }

    @Override
    public Object visit(String name, int pos, Enum value, Object param) {
        if (this.appendName(name, pos, 'e')) {
            this.mBuilder.append(value.getDeclaringClass().getName());
            this.mBuilder.append('.');
        }
        this.mBuilder.append(value.name());
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Annotation[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, int[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, long[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, float[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, double[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, boolean[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, byte[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, short[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, char[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, String[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Class[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    @Override
    public Object visit(String name, int pos, Enum[] value, Object param) {
        this.appendName(name, pos, '[');
        super.visit(name, pos, value, param);
        this.mBuilder.append(';');
        return null;
    }

    private boolean appendName(String name, int pos, char tag) {
        if (name != null) {
            this.mBuilder.append(name);
            this.mBuilder.append('=');
        }
        if (name != null || pos == 0) {
            this.mBuilder.append(tag);
            return true;
        }
        return false;
    }
}

