/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuffer;
import org.cojen.classfile.ConstantInfo;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.Descriptor;
import org.cojen.classfile.ExceptionHandler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.CodeAttr;
import org.cojen.classfile.constant.ConstantClassInfo;
import org.cojen.classfile.constant.ConstantDoubleInfo;
import org.cojen.classfile.constant.ConstantFieldInfo;
import org.cojen.classfile.constant.ConstantFloatInfo;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantInterfaceMethodInfo;
import org.cojen.classfile.constant.ConstantLongInfo;
import org.cojen.classfile.constant.ConstantMethodInfo;
import org.cojen.classfile.constant.ConstantNameAndTypeInfo;
import org.cojen.classfile.constant.ConstantStringInfo;
import org.cojen.util.IntHashMap;

public class CodeDisassembler {
    private final MethodInfo mMethod;
    private final String mEnclosingClassName;
    private final String mSuperClassName;
    private final CodeAttr mCode;
    private final ConstantPool mCp;
    private final byte[] mByteCodes;
    private final ExceptionHandler[] mExceptionHandlers;
    private CodeAssembler mAssembler;
    private Vector<Object> mLocals;
    private boolean mHasThis;
    private Location mReturnLocation;
    private IntHashMap<Object> mLabels;
    private IntHashMap<List<ExceptionHandler>> mCatchLocations;
    private int mAddress;

    public CodeDisassembler(MethodInfo method) throws IllegalArgumentException {
        this.mMethod = method;
        this.mEnclosingClassName = method.getClassFile().getClassName();
        this.mSuperClassName = method.getClassFile().getSuperClassName();
        this.mCode = method.getCodeAttr();
        if (this.mCode == null) {
            throw new IllegalArgumentException("Method defines no code");
        }
        this.mCp = this.mCode.getConstantPool();
        CodeBuffer buffer = this.mCode.getCodeBuffer();
        this.mByteCodes = buffer.getByteCodes();
        this.mExceptionHandlers = buffer.getExceptionHandlers();
    }

    public void disassemble(CodeAssembler assembler) {
        this.disassemble(assembler, null, null);
    }

    public synchronized void disassemble(CodeAssembler assembler, LocalVariable[] params, Location returnLocation) {
        int i;
        this.mAssembler = assembler;
        this.mLocals = new Vector();
        this.mHasThis = !this.mMethod.getModifiers().isStatic();
        if (this.mHasThis) {
            this.mLocals.add(null);
        }
        this.gatherLabels();
        TypeDesc[] paramTypes = this.mMethod.getMethodDescriptor().getParameterTypes();
        if (params == null) {
            params = new LocalVariable[assembler.getParameterCount()];
            i = params.length;
            while (--i >= 0) {
                params[i] = assembler.getParameter(i);
            }
        }
        if (paramTypes.length != params.length) {
            throw new IllegalArgumentException("Method parameter count doesn't match given parameter count: " + paramTypes.length + " != " + params.length);
        }
        for (i = 0; i < paramTypes.length; ++i) {
            LocalVariable paramVar = params[i];
            if (!this.compatibleType(paramTypes[i], paramVar.getType())) {
                throw new IllegalArgumentException("Method parameter type is not compatible with given type: " + paramTypes[i] + " != " + paramVar.getType());
            }
            this.mLocals.add(paramVar);
            if (!paramVar.getType().isDoubleWord()) continue;
            this.mLocals.add(null);
        }
        this.mReturnLocation = returnLocation;
        Location currentLoc = new Location(){

            public int getLocation() {
                return CodeDisassembler.this.mAddress;
            }

            public int compareTo(Location other) {
                int locb;
                if (this == other) {
                    return 0;
                }
                int loca = this.getLocation();
                if (loca < (locb = other.getLocation())) {
                    return -1;
                }
                if (loca > locb) {
                    return 1;
                }
                return 0;
            }
        };
        int currentLine = -1;
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            int nextLine = this.mCode.getLineNumber(currentLoc);
            if (nextLine != currentLine && (currentLine = nextLine) >= 0) {
                this.mAssembler.mapLineNumber(currentLine);
            }
            this.locateLabel();
            byte opcode = this.mByteCodes[this.mAddress];
            block10 : switch (opcode) {
                default: {
                    this.error(opcode, "Unknown opcode: " + (opcode & 0xFF));
                    break;
                }
                case 0: {
                    assembler.nop();
                    break;
                }
                case -54: {
                    assembler.breakpoint();
                    break;
                }
                case 1: {
                    assembler.loadNull();
                    break;
                }
                case 2: {
                    assembler.loadConstant(-1);
                    break;
                }
                case 3: {
                    assembler.loadConstant(0);
                    break;
                }
                case 4: {
                    assembler.loadConstant(1);
                    break;
                }
                case 5: {
                    assembler.loadConstant(2);
                    break;
                }
                case 6: {
                    assembler.loadConstant(3);
                    break;
                }
                case 7: {
                    assembler.loadConstant(4);
                    break;
                }
                case 8: {
                    assembler.loadConstant(5);
                    break;
                }
                case 9: {
                    assembler.loadConstant(0L);
                    break;
                }
                case 10: {
                    assembler.loadConstant(1L);
                    break;
                }
                case 11: {
                    assembler.loadConstant(0.0f);
                    break;
                }
                case 12: {
                    assembler.loadConstant(1.0f);
                    break;
                }
                case 13: {
                    assembler.loadConstant(2.0f);
                    break;
                }
                case 14: {
                    assembler.loadConstant(0.0);
                    break;
                }
                case 15: {
                    assembler.loadConstant(1.0);
                    break;
                }
                case 87: {
                    assembler.pop();
                    break;
                }
                case 88: {
                    assembler.pop2();
                    break;
                }
                case 89: {
                    assembler.dup();
                    break;
                }
                case 90: {
                    assembler.dupX1();
                    break;
                }
                case 91: {
                    assembler.dupX2();
                    break;
                }
                case 92: {
                    assembler.dup2();
                    break;
                }
                case 93: {
                    assembler.dup2X2();
                    break;
                }
                case 94: {
                    assembler.dup2X2();
                    break;
                }
                case 95: {
                    assembler.swap();
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    assembler.math(opcode);
                    break;
                }
                case -123: {
                    assembler.convert(TypeDesc.INT, TypeDesc.LONG);
                    break;
                }
                case -122: {
                    assembler.convert(TypeDesc.INT, TypeDesc.FLOAT);
                    break;
                }
                case -121: {
                    assembler.convert(TypeDesc.INT, TypeDesc.DOUBLE);
                    break;
                }
                case -120: {
                    assembler.convert(TypeDesc.LONG, TypeDesc.INT);
                    break;
                }
                case -119: {
                    assembler.convert(TypeDesc.LONG, TypeDesc.FLOAT);
                    break;
                }
                case -118: {
                    assembler.convert(TypeDesc.LONG, TypeDesc.DOUBLE);
                    break;
                }
                case -117: {
                    assembler.convert(TypeDesc.FLOAT, TypeDesc.INT);
                    break;
                }
                case -116: {
                    assembler.convert(TypeDesc.FLOAT, TypeDesc.LONG);
                    break;
                }
                case -115: {
                    assembler.convert(TypeDesc.FLOAT, TypeDesc.DOUBLE);
                    break;
                }
                case -114: {
                    assembler.convert(TypeDesc.DOUBLE, TypeDesc.INT);
                    break;
                }
                case -113: {
                    assembler.convert(TypeDesc.DOUBLE, TypeDesc.LONG);
                    break;
                }
                case -112: {
                    assembler.convert(TypeDesc.DOUBLE, TypeDesc.FLOAT);
                    break;
                }
                case -111: {
                    assembler.convert(TypeDesc.INT, TypeDesc.BYTE);
                    break;
                }
                case -110: {
                    assembler.convert(TypeDesc.INT, TypeDesc.CHAR);
                    break;
                }
                case -109: {
                    assembler.convert(TypeDesc.INT, TypeDesc.SHORT);
                    break;
                }
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: {
                    if (this.mReturnLocation != null) {
                        assembler.branch(this.mReturnLocation);
                        break;
                    }
                    switch (opcode) {
                        case -84: {
                            assembler.returnValue(TypeDesc.INT);
                            break;
                        }
                        case -83: {
                            assembler.returnValue(TypeDesc.LONG);
                            break;
                        }
                        case -82: {
                            assembler.returnValue(TypeDesc.FLOAT);
                            break;
                        }
                        case -81: {
                            assembler.returnValue(TypeDesc.DOUBLE);
                            break;
                        }
                        case -80: {
                            assembler.returnValue(TypeDesc.OBJECT);
                            break;
                        }
                        case -79: {
                            assembler.returnVoid();
                        }
                    }
                    break;
                }
                case 46: {
                    assembler.loadFromArray(TypeDesc.INT);
                    break;
                }
                case 47: {
                    assembler.loadFromArray(TypeDesc.LONG);
                    break;
                }
                case 48: {
                    assembler.loadFromArray(TypeDesc.FLOAT);
                    break;
                }
                case 49: {
                    assembler.loadFromArray(TypeDesc.DOUBLE);
                    break;
                }
                case 50: {
                    assembler.loadFromArray(TypeDesc.OBJECT);
                    break;
                }
                case 51: {
                    assembler.loadFromArray(TypeDesc.BYTE);
                    break;
                }
                case 52: {
                    assembler.loadFromArray(TypeDesc.CHAR);
                    break;
                }
                case 53: {
                    assembler.loadFromArray(TypeDesc.SHORT);
                    break;
                }
                case 79: {
                    assembler.storeToArray(TypeDesc.INT);
                    break;
                }
                case 80: {
                    assembler.storeToArray(TypeDesc.LONG);
                    break;
                }
                case 81: {
                    assembler.storeToArray(TypeDesc.FLOAT);
                    break;
                }
                case 82: {
                    assembler.storeToArray(TypeDesc.DOUBLE);
                    break;
                }
                case 83: {
                    assembler.storeToArray(TypeDesc.OBJECT);
                    break;
                }
                case 84: {
                    assembler.storeToArray(TypeDesc.BYTE);
                    break;
                }
                case 85: {
                    assembler.storeToArray(TypeDesc.CHAR);
                    break;
                }
                case 86: {
                    assembler.storeToArray(TypeDesc.SHORT);
                    break;
                }
                case -66: {
                    assembler.arrayLength();
                    break;
                }
                case -65: {
                    assembler.throwObject();
                    break;
                }
                case -62: {
                    assembler.monitorEnter();
                    break;
                }
                case -61: {
                    assembler.monitorExit();
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    ConstantInfo ci;
                    int index;
                    switch (opcode) {
                        case 18: {
                            index = this.readUnsignedByte();
                            break;
                        }
                        case 19: 
                        case 20: {
                            index = this.readUnsignedShort();
                            break;
                        }
                        default: {
                            index = 0;
                        }
                    }
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (ci instanceof ConstantStringInfo) {
                        assembler.loadConstant(((ConstantStringInfo)ci).getValue());
                        break;
                    }
                    if (ci instanceof ConstantIntegerInfo) {
                        assembler.loadConstant(((ConstantIntegerInfo)ci).getValue());
                        break;
                    }
                    if (ci instanceof ConstantLongInfo) {
                        assembler.loadConstant(((ConstantLongInfo)ci).getValue());
                        break;
                    }
                    if (ci instanceof ConstantFloatInfo) {
                        assembler.loadConstant(((ConstantFloatInfo)ci).getValue());
                        break;
                    }
                    if (ci instanceof ConstantDoubleInfo) {
                        assembler.loadConstant(((ConstantDoubleInfo)ci).getValue());
                        break;
                    }
                    if (ci instanceof ConstantClassInfo) {
                        assembler.loadConstant(((ConstantClassInfo)ci).getType());
                        break;
                    }
                    this.error(opcode, "Invalid constant type for load: " + ci);
                    break;
                }
                case -69: {
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (ci instanceof ConstantClassInfo) {
                        assembler.newObject(((ConstantClassInfo)ci).getType());
                        break;
                    }
                    this.error(opcode, "Invalid constant type for new: " + ci);
                    break;
                }
                case -67: {
                    TypeDesc type;
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (ci instanceof ConstantClassInfo) {
                        type = ((ConstantClassInfo)ci).getType().toArrayType();
                        assembler.newObject(type);
                        break;
                    }
                    this.error(opcode, "Invalid constant type for new: " + ci);
                    break;
                }
                case -59: {
                    TypeDesc type;
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    int dims = this.readUnsignedByte();
                    if (ci instanceof ConstantClassInfo) {
                        type = ((ConstantClassInfo)ci).getType();
                        assembler.newObject(type, dims);
                        break;
                    }
                    this.error(opcode, "Invalid constant type for new: " + ci);
                    break;
                }
                case -64: {
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (ci instanceof ConstantClassInfo) {
                        assembler.checkCast(((ConstantClassInfo)ci).getType());
                        break;
                    }
                    this.error(opcode, "Invalid constant type for checkcast: " + ci);
                    break;
                }
                case -63: {
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (ci instanceof ConstantClassInfo) {
                        assembler.instanceOf(((ConstantClassInfo)ci).getType());
                        break;
                    }
                    this.error(opcode, "Invalid constant type for instanceof: " + ci);
                    break;
                }
                case -78: 
                case -77: 
                case -76: 
                case -75: {
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (!(ci instanceof ConstantFieldInfo)) {
                        this.error(opcode, "Invalid constant type for field access: " + ci);
                        break;
                    }
                    ConstantFieldInfo field = (ConstantFieldInfo)ci;
                    String className = field.getParentClass().getType().getFullName();
                    if (this.mEnclosingClassName.equals(className)) {
                        className = null;
                    }
                    String fieldName = field.getNameAndType().getName();
                    Descriptor desc = field.getNameAndType().getType();
                    if (!(desc instanceof TypeDesc)) {
                        this.error(opcode, "Invalid descriptor for field access: " + desc);
                        break;
                    }
                    TypeDesc type = (TypeDesc)desc;
                    switch (opcode) {
                        case -78: {
                            if (className == null) {
                                assembler.loadStaticField(fieldName, type);
                                break;
                            }
                            assembler.loadStaticField(className, fieldName, type);
                            break;
                        }
                        case -77: {
                            if (className == null) {
                                assembler.storeStaticField(fieldName, type);
                                break;
                            }
                            assembler.storeStaticField(className, fieldName, type);
                            break;
                        }
                        case -76: {
                            if (className == null) {
                                assembler.loadField(fieldName, type);
                                break;
                            }
                            assembler.loadField(className, fieldName, type);
                            break;
                        }
                        case -75: {
                            if (className == null) {
                                assembler.storeField(fieldName, type);
                                break;
                            }
                            assembler.storeField(className, fieldName, type);
                        }
                    }
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    TypeDesc[] paramTypes2;
                    ConstantNameAndTypeInfo nameAndType;
                    ConstantInfo method;
                    String className;
                    ConstantInfo ci;
                    int index = this.readUnsignedShort();
                    try {
                        ci = this.mCp.getConstant(index);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.error(opcode, "Undefined constant at index: " + index);
                        break;
                    }
                    if (opcode == -71) {
                        this.readShort();
                        if (!(ci instanceof ConstantInterfaceMethodInfo)) {
                            this.error(opcode, "Invalid constant type for method invocation: " + ci);
                            break;
                        }
                        method = (ConstantInterfaceMethodInfo)ci;
                        className = ((ConstantInterfaceMethodInfo)method).getParentClass().getType().getFullName();
                        nameAndType = ((ConstantInterfaceMethodInfo)method).getNameAndType();
                    } else if (opcode == -70) {
                        this.readShort();
                        method = (ConstantInterfaceMethodInfo)ci;
                        className = ((ConstantInterfaceMethodInfo)method).getParentClass().getType().getFullName();
                        nameAndType = ((ConstantInterfaceMethodInfo)method).getNameAndType();
                    } else {
                        if (!(ci instanceof ConstantMethodInfo)) {
                            this.error(opcode, "Invalid constant type for method invocation: " + ci);
                            break;
                        }
                        method = (ConstantMethodInfo)ci;
                        className = ((ConstantMethodInfo)method).getParentClass().getType().getFullName();
                        if (this.mEnclosingClassName.equals(className)) {
                            className = null;
                        }
                        nameAndType = ((ConstantMethodInfo)method).getNameAndType();
                    }
                    String methodName = nameAndType.getName();
                    Descriptor desc = nameAndType.getType();
                    if (!(desc instanceof MethodDesc)) {
                        this.error(opcode, "Invalid descriptor for method invocation: " + desc);
                        break;
                    }
                    TypeDesc ret = ((MethodDesc)desc).getReturnType();
                    if (ret == TypeDesc.VOID) {
                        ret = null;
                    }
                    if ((paramTypes2 = ((MethodDesc)desc).getParameterTypes()).length == 0) {
                        paramTypes2 = null;
                    }
                    switch (opcode) {
                        case -74: {
                            if (className == null) {
                                assembler.invokeVirtual(methodName, ret, paramTypes2);
                                break;
                            }
                            assembler.invokeVirtual(className, methodName, ret, paramTypes2);
                            break;
                        }
                        case -73: {
                            if ("<init>".equals(methodName)) {
                                if (className == null) {
                                    assembler.invokeConstructor(paramTypes2);
                                    break;
                                }
                                if ("<init>".equals(this.mMethod.getName()) && className.equals(this.mSuperClassName)) {
                                    assembler.invokeSuperConstructor(paramTypes2);
                                    break;
                                }
                                assembler.invokeConstructor(className, paramTypes2);
                                break;
                            }
                            if (className == null) {
                                assembler.invokePrivate(methodName, ret, paramTypes2);
                                break;
                            }
                            assembler.invokeSuper(className, methodName, ret, paramTypes2);
                            break;
                        }
                        case -72: {
                            if (className == null) {
                                assembler.invokeStatic(methodName, ret, paramTypes2);
                                break;
                            }
                            assembler.invokeStatic(className, methodName, ret, paramTypes2);
                            break;
                        }
                        case -71: {
                            assembler.invokeInterface(className, methodName, ret, paramTypes2);
                        }
                    }
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    TypeDesc type;
                    int index;
                    switch (opcode) {
                        case 21: 
                        case 54: {
                            index = this.readUnsignedByte();
                            type = TypeDesc.INT;
                            break;
                        }
                        case 22: 
                        case 55: {
                            index = this.readUnsignedByte();
                            type = TypeDesc.LONG;
                            break;
                        }
                        case 23: 
                        case 56: {
                            index = this.readUnsignedByte();
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 24: 
                        case 57: {
                            index = this.readUnsignedByte();
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 25: 
                        case 58: {
                            index = this.readUnsignedByte();
                            type = TypeDesc.OBJECT;
                            break;
                        }
                        case 26: 
                        case 59: {
                            index = 0;
                            type = TypeDesc.INT;
                            break;
                        }
                        case 27: 
                        case 60: {
                            index = 1;
                            type = TypeDesc.INT;
                            break;
                        }
                        case 28: 
                        case 61: {
                            index = 2;
                            type = TypeDesc.INT;
                            break;
                        }
                        case 29: 
                        case 62: {
                            index = 3;
                            type = TypeDesc.INT;
                            break;
                        }
                        case 30: 
                        case 63: {
                            index = 0;
                            type = TypeDesc.LONG;
                            break;
                        }
                        case 31: 
                        case 64: {
                            index = 1;
                            type = TypeDesc.LONG;
                            break;
                        }
                        case 32: 
                        case 65: {
                            index = 2;
                            type = TypeDesc.LONG;
                            break;
                        }
                        case 33: 
                        case 66: {
                            index = 3;
                            type = TypeDesc.LONG;
                            break;
                        }
                        case 34: 
                        case 67: {
                            index = 0;
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 35: 
                        case 68: {
                            index = 1;
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 36: 
                        case 69: {
                            index = 2;
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 37: 
                        case 70: {
                            index = 3;
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 38: 
                        case 71: {
                            index = 0;
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 39: 
                        case 72: {
                            index = 1;
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 40: 
                        case 73: {
                            index = 2;
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 41: 
                        case 74: {
                            index = 3;
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 42: 
                        case 75: {
                            index = 0;
                            type = TypeDesc.OBJECT;
                            break;
                        }
                        case 43: 
                        case 76: {
                            index = 1;
                            type = TypeDesc.OBJECT;
                            break;
                        }
                        case 44: 
                        case 77: {
                            index = 2;
                            type = TypeDesc.OBJECT;
                            break;
                        }
                        case 45: 
                        case 78: {
                            index = 3;
                            type = TypeDesc.OBJECT;
                            break;
                        }
                        default: {
                            index = 0;
                            type = null;
                        }
                    }
                    switch (opcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: {
                            if (index == 0 && this.mHasThis) {
                                assembler.loadThis();
                                break;
                            }
                            assembler.loadLocal(this.getLocalVariable(index, type));
                            break;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: {
                            if (index == 0 && this.mHasThis) {
                                this.mHasThis = false;
                            }
                            assembler.storeLocal(this.getLocalVariable(index, type));
                        }
                    }
                    break;
                }
                case -87: {
                    LocalVariable local = this.getLocalVariable(this.readUnsignedByte(), TypeDesc.OBJECT);
                    assembler.ret(local);
                    break;
                }
                case -124: {
                    LocalVariable local = this.getLocalVariable(this.readUnsignedByte(), TypeDesc.INT);
                    assembler.integerIncrement(local, this.readByte());
                    break;
                }
                case -89: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.branch(loc);
                    break;
                }
                case -88: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.jsr(loc);
                    break;
                }
                case -56: {
                    Label loc = this.getLabel(this.mAddress + this.readInt());
                    assembler.branch(loc);
                    break;
                }
                case -55: {
                    Label loc = this.getLabel(this.mAddress + this.readInt());
                    assembler.jsr(loc);
                    break;
                }
                case -58: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.ifNullBranch(loc, true);
                    break;
                }
                case -57: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.ifNullBranch(loc, false);
                    break;
                }
                case -91: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.ifEqualBranch(loc, true);
                    break;
                }
                case -90: {
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    assembler.ifEqualBranch(loc, false);
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: {
                    String choice;
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    switch (opcode) {
                        case -103: {
                            choice = "==";
                            break;
                        }
                        case -102: {
                            choice = "!=";
                            break;
                        }
                        case -101: {
                            choice = "<";
                            break;
                        }
                        case -100: {
                            choice = ">=";
                            break;
                        }
                        case -99: {
                            choice = ">";
                            break;
                        }
                        case -98: {
                            choice = "<=";
                            break;
                        }
                        default: {
                            choice = null;
                        }
                    }
                    assembler.ifZeroComparisonBranch(loc, choice);
                    break;
                }
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: {
                    String choice;
                    Label loc = this.getLabel(this.mAddress + this.readShort());
                    switch (opcode) {
                        case -97: {
                            choice = "==";
                            break;
                        }
                        case -96: {
                            choice = "!=";
                            break;
                        }
                        case -95: {
                            choice = "<";
                            break;
                        }
                        case -94: {
                            choice = ">=";
                            break;
                        }
                        case -93: {
                            choice = ">";
                            break;
                        }
                        case -92: {
                            choice = "<=";
                            break;
                        }
                        default: {
                            choice = null;
                        }
                    }
                    assembler.ifComparisonBranch(loc, choice);
                    break;
                }
                case 16: {
                    assembler.loadConstant(this.readByte());
                    break;
                }
                case 17: {
                    assembler.loadConstant(this.readShort());
                    break;
                }
                case -68: {
                    int atype = this.readByte();
                    TypeDesc type = null;
                    switch (atype) {
                        case 4: {
                            type = TypeDesc.BOOLEAN;
                            break;
                        }
                        case 5: {
                            type = TypeDesc.CHAR;
                            break;
                        }
                        case 6: {
                            type = TypeDesc.FLOAT;
                            break;
                        }
                        case 7: {
                            type = TypeDesc.DOUBLE;
                            break;
                        }
                        case 8: {
                            type = TypeDesc.BYTE;
                            break;
                        }
                        case 9: {
                            type = TypeDesc.SHORT;
                            break;
                        }
                        case 10: {
                            type = TypeDesc.INT;
                            break;
                        }
                        case 11: {
                            type = TypeDesc.LONG;
                        }
                    }
                    if (type == null) {
                        this.error(opcode, "Unknown primitive type for new array: " + atype);
                        break;
                    }
                    assembler.newObject(type.toArrayType());
                    break;
                }
                case -86: 
                case -85: {
                    Location[] locations;
                    int[] cases;
                    int opcodeAddress = this.mAddress;
                    while ((this.mAddress + 1 & 3) != 0) {
                        ++this.mAddress;
                    }
                    Label defaultLocation = this.getLabel(opcodeAddress + this.readInt());
                    if (opcode == -86) {
                        int lowValue = this.readInt();
                        int highValue = this.readInt();
                        int caseCount = highValue - lowValue + 1;
                        try {
                            cases = new int[caseCount];
                        }
                        catch (NegativeArraySizeException e) {
                            this.error(opcode, "Negative case count for switch: " + caseCount);
                            break;
                        }
                        locations = new Location[caseCount];
                        for (int i2 = 0; i2 < caseCount; ++i2) {
                            cases[i2] = lowValue + i2;
                            locations[i2] = this.getLabel(opcodeAddress + this.readInt());
                        }
                    } else {
                        int caseCount = this.readInt();
                        try {
                            cases = new int[caseCount];
                        }
                        catch (NegativeArraySizeException e) {
                            this.error(opcode, "Negative case count for switch: " + caseCount);
                            break;
                        }
                        locations = new Location[caseCount];
                        for (int i3 = 0; i3 < caseCount; ++i3) {
                            cases[i3] = this.readInt();
                            locations[i3] = this.getLabel(opcodeAddress + this.readInt());
                        }
                    }
                    assembler.switchBranch(cases, locations, defaultLocation);
                    break;
                }
                case -60: {
                    LocalVariable local;
                    TypeDesc type;
                    int index;
                    opcode = this.mByteCodes[++this.mAddress];
                    switch (opcode) {
                        default: {
                            this.error(opcode, "Unknown wide instruction");
                            break block10;
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            switch (opcode) {
                                case 21: 
                                case 54: {
                                    type = TypeDesc.INT;
                                    break;
                                }
                                case 22: 
                                case 55: {
                                    type = TypeDesc.LONG;
                                    break;
                                }
                                case 23: 
                                case 56: {
                                    type = TypeDesc.FLOAT;
                                    break;
                                }
                                case 24: 
                                case 57: {
                                    type = TypeDesc.DOUBLE;
                                    break;
                                }
                                case 25: 
                                case 58: {
                                    type = TypeDesc.OBJECT;
                                    break;
                                }
                                default: {
                                    type = null;
                                }
                            }
                            index = this.readUnsignedShort();
                            switch (opcode) {
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: 
                                case 25: {
                                    if (index == 0 && this.mHasThis) {
                                        assembler.loadThis();
                                        break;
                                    }
                                    assembler.loadLocal(this.getLocalVariable(index, type));
                                    break;
                                }
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 58: {
                                    if (index == 0 && this.mHasThis) {
                                        this.mHasThis = false;
                                    }
                                    assembler.storeLocal(this.getLocalVariable(index, type));
                                }
                            }
                            break block10;
                        }
                        case -87: {
                            local = this.getLocalVariable(this.readUnsignedShort(), TypeDesc.OBJECT);
                            assembler.ret(local);
                            break block10;
                        }
                        case -124: 
                    }
                    local = this.getLocalVariable(this.readUnsignedShort(), TypeDesc.INT);
                    assembler.integerIncrement(local, this.readShort());
                }
            }
            ++this.mAddress;
        }
    }

    protected void error(byte opcode, String message) {
    }

    private void gatherLabels() {
        int labelKey;
        this.mLabels = new IntHashMap();
        this.mCatchLocations = new IntHashMap(this.mExceptionHandlers.length * 2 + 1);
        for (int i = this.mExceptionHandlers.length - 1; i >= 0; --i) {
            ExceptionHandler handler = this.mExceptionHandlers[i];
            labelKey = handler.getStartLocation().getLocation();
            this.mLabels.put(labelKey, (Object)labelKey);
            labelKey = handler.getEndLocation().getLocation();
            this.mLabels.put(labelKey, (Object)labelKey);
            labelKey = handler.getCatchLocation().getLocation();
            List<ExceptionHandler> list = this.mCatchLocations.get(labelKey);
            if (list == null) {
                list = new ArrayList<ExceptionHandler>(2);
                this.mCatchLocations.put(labelKey, list);
            }
            list.add(handler);
        }
        this.mAddress = 0;
        while (this.mAddress < this.mByteCodes.length) {
            byte opcode = this.mByteCodes[this.mAddress];
            switch (opcode) {
                default: {
                    this.error(opcode, "Unknown opcode: " + (opcode & 0xFF));
                    break;
                }
                case -103: 
                case -102: 
                case -101: 
                case -100: 
                case -99: 
                case -98: 
                case -97: 
                case -96: 
                case -95: 
                case -94: 
                case -93: 
                case -92: 
                case -91: 
                case -90: 
                case -89: 
                case -88: 
                case -58: 
                case -57: {
                    labelKey = this.mAddress + this.readShort();
                    this.mLabels.put(labelKey, (Object)labelKey);
                    break;
                }
                case -56: 
                case -55: {
                    labelKey = this.mAddress + this.readInt();
                    this.mLabels.put(labelKey, (Object)labelKey);
                    break;
                }
                case -86: 
                case -85: {
                    int opcodeAddress = this.mAddress;
                    while ((this.mAddress + 1 & 3) != 0) {
                        ++this.mAddress;
                    }
                    labelKey = opcodeAddress + this.readInt();
                    this.mLabels.put(labelKey, (Object)labelKey);
                    if (opcode == -86) {
                        int lowValue = this.readInt();
                        int highValue = this.readInt();
                        int caseCount = highValue - lowValue + 1;
                        for (int i = 0; i < caseCount; ++i) {
                            labelKey = opcodeAddress + this.readInt();
                            this.mLabels.put(labelKey, (Object)labelKey);
                        }
                    } else {
                        int caseCount = this.readInt();
                        for (int i = 0; i < caseCount; ++i) {
                            this.mAddress += 4;
                            labelKey = opcodeAddress + this.readInt();
                            this.mLabels.put(labelKey, (Object)labelKey);
                        }
                    }
                    break;
                }
                case -128: 
                case -127: 
                case -126: 
                case -125: 
                case -123: 
                case -122: 
                case -121: 
                case -120: 
                case -119: 
                case -118: 
                case -117: 
                case -116: 
                case -115: 
                case -114: 
                case -113: 
                case -112: 
                case -111: 
                case -110: 
                case -109: 
                case -108: 
                case -107: 
                case -106: 
                case -105: 
                case -104: 
                case -84: 
                case -83: 
                case -82: 
                case -81: 
                case -80: 
                case -79: 
                case -66: 
                case -65: 
                case -62: 
                case -61: 
                case -54: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case -87: 
                case -68: 
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++this.mAddress;
                    break;
                }
                case -124: 
                case -78: 
                case -77: 
                case -76: 
                case -75: 
                case -74: 
                case -73: 
                case -72: 
                case -69: 
                case -67: 
                case -64: 
                case -63: 
                case 17: 
                case 19: 
                case 20: {
                    this.mAddress += 2;
                    break;
                }
                case -59: {
                    this.mAddress += 3;
                    break;
                }
                case -71: 
                case -70: {
                    this.mAddress += 4;
                    break;
                }
                case -60: {
                    opcode = this.mByteCodes[++this.mAddress];
                    this.mAddress += 2;
                    if (opcode != -124) break;
                    this.mAddress += 2;
                }
            }
            ++this.mAddress;
        }
    }

    private int readByte() {
        return this.mByteCodes[++this.mAddress];
    }

    private int readUnsignedByte() {
        return this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readShort() {
        return this.mByteCodes[++this.mAddress] << 8 | this.mByteCodes[++this.mAddress] & 0xFF;
    }

    private int readUnsignedShort() {
        return (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private int readInt() {
        return this.mByteCodes[++this.mAddress] << 24 | (this.mByteCodes[++this.mAddress] & 0xFF) << 16 | (this.mByteCodes[++this.mAddress] & 0xFF) << 8 | (this.mByteCodes[++this.mAddress] & 0xFF) << 0;
    }

    private LocalVariable getLocalVariable(int index, TypeDesc type) {
        LocalVariable local;
        if (index >= this.mLocals.size()) {
            this.mLocals.setSize(index + 1);
            LocalVariable local2 = this.mAssembler.createLocalVariable(null, type);
            this.mLocals.set(index, local2);
            return local2;
        }
        Object obj = this.mLocals.get(index);
        if (obj == null) {
            LocalVariable local3 = this.mAssembler.createLocalVariable(null, type);
            this.mLocals.set(index, local3);
            return local3;
        }
        if (obj instanceof LocalVariable) {
            LocalVariable local4 = (LocalVariable)obj;
            if (this.compatibleType(type, local4.getType())) {
                return local4;
            }
            ArrayList<LocalVariable> locals = new ArrayList<LocalVariable>(4);
            locals.add(local4);
            local4 = this.mAssembler.createLocalVariable(null, type);
            locals.add(local4);
            this.mLocals.set(index, locals);
            return local4;
        }
        List locals = (List)obj;
        int i = locals.size();
        while (--i >= 0) {
            local = (LocalVariable)locals.get(i);
            if (!this.compatibleType(type, local.getType())) continue;
            return local;
        }
        local = this.mAssembler.createLocalVariable(null, type);
        locals.add(local);
        return local;
    }

    private boolean compatibleType(TypeDesc a, TypeDesc b) {
        if (a == b || !a.isPrimitive() && !b.isPrimitive()) {
            return true;
        }
        return this.isIntType(a) && this.isIntType(b);
    }

    private boolean isIntType(TypeDesc type) {
        switch (type.getTypeCode()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private void locateLabel() {
        List<ExceptionHandler> handlers;
        int labelKey = this.mAddress;
        Object labelValue = this.mLabels.get(labelKey);
        if (labelValue != null) {
            if (labelValue instanceof Label) {
                ((Label)labelValue).setLocation();
            } else {
                labelValue = this.mAssembler.createLabel().setLocation();
                this.mLabels.put(labelKey, labelValue);
            }
        }
        if ((handlers = this.mCatchLocations.get(labelKey)) != null) {
            for (int i = 0; i < handlers.size(); ++i) {
                ExceptionHandler handler = handlers.get(i);
                Label start = this.getLabel(handler.getStartLocation().getLocation());
                Label end = this.getLabel(handler.getEndLocation().getLocation());
                String catchClassName = handler.getCatchType() == null ? null : handler.getCatchType().getType().getFullName();
                this.mAssembler.exceptionHandler(start, end, catchClassName);
            }
        }
    }

    private Label getLabel(int address) {
        int labelKey = address;
        Object labelValue = this.mLabels.get(labelKey);
        if (!(labelValue instanceof Label)) {
            labelValue = this.mAssembler.createLabel();
            this.mLabels.put(labelKey, labelValue);
        }
        return (Label)labelValue;
    }
}

