
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001-2003 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *     The "insertBefore(newChild,refChild)" method inserts the
 *     node "newChild" before the node "refChild". 
 *     
 *     Insert a newly created Element node before the second
 *     sup element in the document and check the "newChild"
 *     and "refChild" after insertion for correct placement.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=246">http://www.w3.org/Bugs/Public/show_bug.cgi?id=246</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=247">http://www.w3.org/Bugs/Public/show_bug.cgi?id=247</a>
* @see <a href="http://www.w3.org/Bugs/Public/show_bug.cgi?id=261">http://www.w3.org/Bugs/Public/show_bug.cgi?id=261</a>
*/
public final class hc_nodeinsertbefore extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public hc_nodeinsertbefore(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elementList;
      Node employeeNode;
      NodeList childList;
      Node refChild;
      Node newChild;
      Node child;
      String childName;
      Node insertedNode;
      java.util.List actual = new java.util.ArrayList();
      
      java.util.List expected = new java.util.ArrayList();
      expected.add("em");
      expected.add("strong");
      expected.add("code");
      expected.add("br");
      expected.add("sup");
      expected.add("var");
      expected.add("acronym");
      
      int nodeType;
      doc = (Document) load("hc_staff", true);
      elementList = doc.getElementsByTagName("sup");
      refChild = elementList.item(2);
      employeeNode = refChild.getParentNode();
      childList = employeeNode.getChildNodes();
      newChild = doc.createElement("br");
      insertedNode = employeeNode.insertBefore(newChild, refChild);
      for (int indexN10091 = 0; indexN10091 < childList.getLength(); indexN10091++) {
          child = (Node) childList.item(indexN10091);
    nodeType = (int) child.getNodeType();
      
      if (equals(1, nodeType)) {
          childName = child.getNodeName();
      actual.add(childName);
      }
      }
      assertEqualsAutoCase("element", "nodeNames", expected, actual);
        }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/hc_nodeinsertbefore";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(hc_nodeinsertbefore.class, args);
   }
}

