/* Copyright 2014 Adobe Systems Incorporated (http://www.adobe.com/). All Rights Reserved.
   This software is licensed as OpenSource, under the Apache License, Version 2.0.
   This license is available at: http://opensource.org/licenses/Apache-2.0. */

/* Mac OS Hebrew aggregate Unicode initializer.

   Element values are UVs. UV_UNDEF is 0xFFFF. Index by code, get UV.
   Source: ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/APPLE/HEBREW.TXT
   as of 9/9/99.

   2 entries are mapped to Corporate Use Area Unicode values that Apple has
   deprecated. The full transcoding hint sequence is shown in parentheses for
   such mappings. */

UV_UNDEF,   /* 00 */
UV_UNDEF,   /* 01 */
UV_UNDEF,   /* 02 */
UV_UNDEF,   /* 03 */
UV_UNDEF,   /* 04 */
UV_UNDEF,   /* 05 */
UV_UNDEF,   /* 06 */
UV_UNDEF,   /* 07 */
UV_UNDEF,   /* 08 */
UV_UNDEF,   /* 09 */
UV_UNDEF,   /* 0A */
UV_UNDEF,   /* 0B */
UV_UNDEF,   /* 0C */
UV_UNDEF,   /* 0D */
UV_UNDEF,   /* 0E */
UV_UNDEF,   /* 0F */
UV_UNDEF,   /* 10 */
UV_UNDEF,   /* 11 */
UV_UNDEF,   /* 12 */
UV_UNDEF,   /* 13 */
UV_UNDEF,   /* 14 */
UV_UNDEF,   /* 15 */
UV_UNDEF,   /* 16 */
UV_UNDEF,   /* 17 */
UV_UNDEF,   /* 18 */
UV_UNDEF,   /* 19 */
UV_UNDEF,   /* 1A */
UV_UNDEF,   /* 1B */
UV_UNDEF,   /* 1C */
UV_UNDEF,   /* 1D */
UV_UNDEF,   /* 1E */
UV_UNDEF,   /* 1F */
0x0020,     /* 20  SPACE, left-right */
0x0021,     /* 21  EXCLAMATION MARK, left-right */
0x0022,     /* 22  QUOTATION MARK, left-right */
0x0023,     /* 23  NUMBER SIGN, left-right */
0x0024,     /* 24  DOLLAR SIGN, left-right */
0x0025,     /* 25  PERCENT SIGN, left-right */
0x0026,     /* 26  AMPERSAND */
0x0027,     /* 27  APOSTROPHE, left-right */
0x0028,     /* 28  LEFT PARENTHESIS, left-right */
0x0029,     /* 29  RIGHT PARENTHESIS, left-right */
0x002A,     /* 2A  ASTERISK, left-right */
0x002B,     /* 2B  PLUS SIGN, left-right */
0x002C,     /* 2C  COMMA, left-right */
0x002D,     /* 2D  HYPHEN-MINUS, left-right */
0x002E,     /* 2E  FULL STOP, left-right */
0x002F,     /* 2F  SOLIDUS, left-right */
0x0030,     /* 30  DIGIT ZERO, left-right */
0x0031,     /* 31  DIGIT ONE, left-right */
0x0032,     /* 32  DIGIT TWO, left-right */
0x0033,     /* 33  DIGIT THREE, left-right */
0x0034,     /* 34  DIGIT FOUR, left-right */
0x0035,     /* 35  DIGIT FIVE, left-right */
0x0036,     /* 36  DIGIT SIX, left-right */
0x0037,     /* 37  DIGIT SEVEN, left-right */
0x0038,     /* 38  DIGIT EIGHT, left-right */
0x0039,     /* 39  DIGIT NINE, left-right */
0x003A,     /* 3A  COLON, left-right */
0x003B,     /* 3B  SEMICOLON, left-right */
0x003C,     /* 3C  LESS-THAN SIGN, left-right */
0x003D,     /* 3D  EQUALS SIGN, left-right */
0x003E,     /* 3E  GREATER-THAN SIGN, left-right */
0x003F,     /* 3F  QUESTION MARK, left-right */
0x0040,     /* 40  COMMERCIAL AT */
0x0041,     /* 41  LATIN CAPITAL LETTER A */
0x0042,     /* 42  LATIN CAPITAL LETTER B */
0x0043,     /* 43  LATIN CAPITAL LETTER C */
0x0044,     /* 44  LATIN CAPITAL LETTER D */
0x0045,     /* 45  LATIN CAPITAL LETTER E */
0x0046,     /* 46  LATIN CAPITAL LETTER F */
0x0047,     /* 47  LATIN CAPITAL LETTER G */
0x0048,     /* 48  LATIN CAPITAL LETTER H */
0x0049,     /* 49  LATIN CAPITAL LETTER I */
0x004A,     /* 4A  LATIN CAPITAL LETTER J */
0x004B,     /* 4B  LATIN CAPITAL LETTER K */
0x004C,     /* 4C  LATIN CAPITAL LETTER L */
0x004D,     /* 4D  LATIN CAPITAL LETTER M */
0x004E,     /* 4E  LATIN CAPITAL LETTER N */
0x004F,     /* 4F  LATIN CAPITAL LETTER O */
0x0050,     /* 50  LATIN CAPITAL LETTER P */
0x0051,     /* 51  LATIN CAPITAL LETTER Q */
0x0052,     /* 52  LATIN CAPITAL LETTER R */
0x0053,     /* 53  LATIN CAPITAL LETTER S */
0x0054,     /* 54  LATIN CAPITAL LETTER T */
0x0055,     /* 55  LATIN CAPITAL LETTER U */
0x0056,     /* 56  LATIN CAPITAL LETTER V */
0x0057,     /* 57  LATIN CAPITAL LETTER W */
0x0058,     /* 58  LATIN CAPITAL LETTER X */
0x0059,     /* 59  LATIN CAPITAL LETTER Y */
0x005A,     /* 5A  LATIN CAPITAL LETTER Z */
0x005B,     /* 5B  LEFT SQUARE BRACKET, left-right */
0x005C,     /* 5C  REVERSE SOLIDUS */
0x005D,     /* 5D  RIGHT SQUARE BRACKET, left-right */
0x005E,     /* 5E  CIRCUMFLEX ACCENT */
0x005F,     /* 5F  LOW LINE */
0x0060,     /* 60  GRAVE ACCENT */
0x0061,     /* 61  LATIN SMALL LETTER A */
0x0062,     /* 62  LATIN SMALL LETTER B */
0x0063,     /* 63  LATIN SMALL LETTER C */
0x0064,     /* 64  LATIN SMALL LETTER D */
0x0065,     /* 65  LATIN SMALL LETTER E */
0x0066,     /* 66  LATIN SMALL LETTER F */
0x0067,     /* 67  LATIN SMALL LETTER G */
0x0068,     /* 68  LATIN SMALL LETTER H */
0x0069,     /* 69  LATIN SMALL LETTER I */
0x006A,     /* 6A  LATIN SMALL LETTER J */
0x006B,     /* 6B  LATIN SMALL LETTER K */
0x006C,     /* 6C  LATIN SMALL LETTER L */
0x006D,     /* 6D  LATIN SMALL LETTER M */
0x006E,     /* 6E  LATIN SMALL LETTER N */
0x006F,     /* 6F  LATIN SMALL LETTER O */
0x0070,     /* 70  LATIN SMALL LETTER P */
0x0071,     /* 71  LATIN SMALL LETTER Q */
0x0072,     /* 72  LATIN SMALL LETTER R */
0x0073,     /* 73  LATIN SMALL LETTER S */
0x0074,     /* 74  LATIN SMALL LETTER T */
0x0075,     /* 75  LATIN SMALL LETTER U */
0x0076,     /* 76  LATIN SMALL LETTER V */
0x0077,     /* 77  LATIN SMALL LETTER W */
0x0078,     /* 78  LATIN SMALL LETTER X */
0x0079,     /* 79  LATIN SMALL LETTER Y */
0x007A,     /* 7A  LATIN SMALL LETTER Z */
0x007B,     /* 7B  LEFT CURLY BRACKET, left-right */
0x007C,     /* 7C  VERTICAL LINE, left-right */
0x007D,     /* 7D  RIGHT CURLY BRACKET, left-right */
0x007E,     /* 7E  TILDE */
UV_UNDEF,   /* 7F */
0x00C4,     /* 80  LATIN CAPITAL LETTER A WITH DIAERESIS */
0xFB1F,     /* 81  HEBREW LIGATURE YIDDISH YOD YOD PATAH */
0x00C7,     /* 82  LATIN CAPITAL LETTER C WITH CEDILLA */
0x00C9,     /* 83  LATIN CAPITAL LETTER E WITH ACUTE */
0x00D1,     /* 84  LATIN CAPITAL LETTER N WITH TILDE */
0x00D6,     /* 85  LATIN CAPITAL LETTER O WITH DIAERESIS */
0x00DC,     /* 86  LATIN CAPITAL LETTER U WITH DIAERESIS */
0x00E1,     /* 87  LATIN SMALL LETTER A WITH ACUTE */
0x00E0,     /* 88  LATIN SMALL LETTER A WITH GRAVE */
0x00E2,     /* 89  LATIN SMALL LETTER A WITH CIRCUMFLEX */
0x00E4,     /* 8A  LATIN SMALL LETTER A WITH DIAERESIS */
0x00E3,     /* 8B  LATIN SMALL LETTER A WITH TILDE */
0x00E5,     /* 8C  LATIN SMALL LETTER A WITH RING ABOVE */
0x00E7,     /* 8D  LATIN SMALL LETTER C WITH CEDILLA */
0x00E9,     /* 8E  LATIN SMALL LETTER E WITH ACUTE */
0x00E8,     /* 8F  LATIN SMALL LETTER E WITH GRAVE */
0x00EA,     /* 90  LATIN SMALL LETTER E WITH CIRCUMFLEX */
0x00EB,     /* 91  LATIN SMALL LETTER E WITH DIAERESIS */
0x00ED,     /* 92  LATIN SMALL LETTER I WITH ACUTE */
0x00EC,     /* 93  LATIN SMALL LETTER I WITH GRAVE */
0x00EE,     /* 94  LATIN SMALL LETTER I WITH CIRCUMFLEX */
0x00EF,     /* 95  LATIN SMALL LETTER I WITH DIAERESIS */
0x00F1,     /* 96  LATIN SMALL LETTER N WITH TILDE */
0x00F3,     /* 97  LATIN SMALL LETTER O WITH ACUTE */
0x00F2,     /* 98  LATIN SMALL LETTER O WITH GRAVE */
0x00F4,     /* 99  LATIN SMALL LETTER O WITH CIRCUMFLEX */
0x00F6,     /* 9A  LATIN SMALL LETTER O WITH DIAERESIS */
0x00F5,     /* 9B  LATIN SMALL LETTER O WITH TILDE */
0x00FA,     /* 9C  LATIN SMALL LETTER U WITH ACUTE */
0x00F9,     /* 9D  LATIN SMALL LETTER U WITH GRAVE */
0x00FB,     /* 9E  LATIN SMALL LETTER U WITH CIRCUMFLEX */
0x00FC,     /* 9F  LATIN SMALL LETTER U WITH DIAERESIS */
0x0020,     /* A0  SPACE, right-left */
0x0021,     /* A1  EXCLAMATION MARK, right-left */
0x0022,     /* A2  QUOTATION MARK, right-left */
0x0023,     /* A3  NUMBER SIGN, right-left */
0x0024,     /* A4  DOLLAR SIGN, right-left */
0x0025,     /* A5  PERCENT SIGN, right-left */
0x20AA,     /* A6  NEW SHEQEL SIGN */
0x0027,     /* A7  APOSTROPHE, right-left */
0x0028,     /* A8  LEFT PARENTHESIS, right-left */
0x0029,     /* A9  RIGHT PARENTHESIS, right-left */
0x002A,     /* AA  ASTERISK, right-left */
0x002B,     /* AB  PLUS SIGN, right-left */
0x002C,     /* AC  COMMA, right-left */
0x002D,     /* AD  HYPHEN-MINUS, right-left */
0x002E,     /* AE  FULL STOP, right-left */
0x002F,     /* AF  SOLIDUS, right-left */
0x0030,     /* B0  DIGIT ZERO, right-left */
0x0031,     /* B1  DIGIT ONE, right-left */
0x0032,     /* B2  DIGIT TWO, right-left */
0x0033,     /* B3  DIGIT THREE, right-left */
0x0034,     /* B4  DIGIT FOUR, right-left */
0x0035,     /* B5  DIGIT FIVE, right-left */
0x0036,     /* B6  DIGIT SIX, right-left */
0x0037,     /* B7  DIGIT SEVEN, right-left */
0x0038,     /* B8  DIGIT EIGHT, right-left */
0x0039,     /* B9  DIGIT NINE, right-left */
0x003A,     /* BA  COLON, right-left */
0x003B,     /* BB  SEMICOLON, right-left */
0x003C,     /* BC  LESS-THAN SIGN, right-left */
0x003D,     /* BD  EQUALS SIGN, right-left */
0x003E,     /* BE  GREATER-THAN SIGN, right-left */
0x003F,     /* BF  QUESTION MARK, right-left */
0xF89A,     /* C0  Hebrew ligature lamed holam (0xF86A+0x05DC+0x05B9) */
0x201E,     /* C1  DOUBLE LOW-9 QUOTATION MARK, right-left */
0xF89B,     /* C2  Hebrew canoral 1 */
0xF89C,     /* C3  Hebrew canoral 2 */
0xF89D,     /* C4  Hebrew canoral 3 */
0xF89E,     /* C5  Hebrew canoral 4 */
0x05BC,     /* C6  HEBREW POINT DAGESH OR MAPIQ */
0xFB4B,     /* C7  HEBREW LETTER VAV WITH HOLAM */
0xFB35,     /* C8  HEBREW LETTER VAV WITH DAGESH */
0x2026,     /* C9  HORIZONTAL ELLIPSIS, right-left */
0x00A0,     /* CA  NO-BREAK SPACE, right-left */
0x05B8,     /* CB  HEBREW POINT QAMATS */
0x05B7,     /* CC  HEBREW POINT PATAH */
0x05B5,     /* CD  HEBREW POINT TSERE */
0x05B6,     /* CE  HEBREW POINT SEGOL */
0x05B4,     /* CF  HEBREW POINT HIRIQ */
0x2013,     /* D0  EN DASH, right-left */
0x2014,     /* D1  EM DASH, right-left */
0x201C,     /* D2  LEFT DOUBLE QUOTATION MARK, right-left */
0x201D,     /* D3  RIGHT DOUBLE QUOTATION MARK, right-left */
0x2018,     /* D4  LEFT SINGLE QUOTATION MARK, right-left */
0x2019,     /* D5  RIGHT SINGLE QUOTATION MARK, right-left */
0xFB2A,     /* D6  HEBREW LETTER SHIN WITH SHIN DOT */
0xFB2B,     /* D7  HEBREW LETTER SHIN WITH SIN DOT */
0x05BF,     /* D8  HEBREW POINT RAFE */
0x05B0,     /* D9  HEBREW POINT SHEVA */
0x05B2,     /* DA  HEBREW POINT HATAF PATAH */
0x05B1,     /* DB  HEBREW POINT HATAF SEGOL */
0x05BB,     /* DC  HEBREW POINT QUBUTS */
0x05B9,     /* DD  HEBREW POINT HOLAM */
0xF89F,     /* DE  HEBREW POINT QAMATS, alternate form "qamats qatan" (0x05B8+0xF87F) */
0x05B3,     /* DF  HEBREW POINT HATAF QAMATS */
0x05D0,     /* E0  HEBREW LETTER ALEF */
0x05D1,     /* E1  HEBREW LETTER BET */
0x05D2,     /* E2  HEBREW LETTER GIMEL */
0x05D3,     /* E3  HEBREW LETTER DALET */
0x05D4,     /* E4  HEBREW LETTER HE */
0x05D5,     /* E5  HEBREW LETTER VAV */
0x05D6,     /* E6  HEBREW LETTER ZAYIN */
0x05D7,     /* E7  HEBREW LETTER HET */
0x05D8,     /* E8  HEBREW LETTER TET */
0x05D9,     /* E9  HEBREW LETTER YOD */
0x05DA,     /* EA  HEBREW LETTER FINAL KAF */
0x05DB,     /* EB  HEBREW LETTER KAF */
0x05DC,     /* EC  HEBREW LETTER LAMED */
0x05DD,     /* ED  HEBREW LETTER FINAL MEM */
0x05DE,     /* EE  HEBREW LETTER MEM */
0x05DF,     /* EF  HEBREW LETTER FINAL NUN */
0x05E0,     /* F0  HEBREW LETTER NUN */
0x05E1,     /* F1  HEBREW LETTER SAMEKH */
0x05E2,     /* F2  HEBREW LETTER AYIN */
0x05E3,     /* F3  HEBREW LETTER FINAL PE */
0x05E4,     /* F4  HEBREW LETTER PE */
0x05E5,     /* F5  HEBREW LETTER FINAL TSADI */
0x05E6,     /* F6  HEBREW LETTER TSADI */
0x05E7,     /* F7  HEBREW LETTER QOF */
0x05E8,     /* F8  HEBREW LETTER RESH */
0x05E9,     /* F9  HEBREW LETTER SHIN */
0x05EA,     /* FA  HEBREW LETTER TAV */
0x007D,     /* FB  RIGHT CURLY BRACKET, right-left */
0x005D,     /* FC  RIGHT SQUARE BRACKET, right-left */
0x007B,     /* FD  LEFT CURLY BRACKET, right-left */
0x005B,     /* FE  LEFT SQUARE BRACKET, right-left */
0x007C,     /* FF  VERTICAL LINE, right-left */
