/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_GATEWAYACCESS_H_
#define OPENDRIM_GATEWAYACCESS_H_

#include "IP_Common.h"

#include "OpenDRIM_Gateway.h"

int IP_OpenDRIM_Gateway_load(const CMPIBroker* broker, string& errorMessage);

int IP_OpenDRIM_Gateway_unload(string& errorMessage);

int IP_OpenDRIM_Gateway_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Gateway>& instances, const char** properties, string& errorMessage, const string& discriminant);

int IP_OpenDRIM_Gateway_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Gateway& instance, const char** properties, string& errorMessage);

int IP_OpenDRIM_Gateway_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& newInstance, const OpenDRIM_Gateway& oldInstance, const char** properties, string& errorMessage);

int IP_OpenDRIM_Gateway_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, string& errorMessage);

int IP_OpenDRIM_Gateway_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, string& errorMessage);

int IP_OpenDRIM_Gateway_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Gateway& instance, unsigned int& returnValue, const OpenDRIM_Gateway_RequestStateChange_In& in, OpenDRIM_Gateway_RequestStateChange_Out& out, string& errorMessage);

int IP_OpenDRIM_Gateway_populate(OpenDRIM_Gateway& instance, string& errorMessage);

#endif /*OPENDRIM_GATEWAYACCESS_H_*/
