      BLOCK DATA GPTABD
CGPTABD
C     BLOCK DATA PROGRAM FOR ALL MODULES HAVING ANYTHING TO DO WITH THE
C     NASTRAN STRUCTURAL ELEMENTS.
C
C     NOTE. ALL MODULES SHOULD BE WRITTEN TO TAKE ADVANTAGE OF THE
C     FLEXIBLE NATURE OF THIS DATA.
C
C     THE ELEMENTS OF NASTRAN ARE ALL REPRESENTED BELOW.  THEY ARE
C     ARRANGED BY ELEMENT TYPE NUMBER.  EACH ELEMENT ENTRY BELOW
C     CONTAINS -INCR- NUMBER OF VALUES.  -INCR- AT SOME FUTURE DATE MAY
C     GROW LARGER THUS MODULE WRITERS SHOULD ALWAYS INCLUDE -INCR- WHEN
C     COMPUTING INDEXES INTO THIS DATA.
C
C     -NELEM- IS SIMPLY THE CURRENT NUMBER OF ELEMENTS IN NASTRAN.
C
C     -LAST- IS SIMPLY THE NUMBER OF THE FIRST WORD OF THE LAST ELEMENT
C     ENTRY SUCH THAT DO LOOPS MAY HAVE THE FOLLOWING FORM.
C
C              DO 100 I = 1,LAST,INCR
C                     . . .
C                     . . .
C                     . . .
C          100 CONTINUE
C
C     THUS IN THE ABOVE LOOP E(I) POINTS TO THE FIRST WORD OF OF AN
C     ELEMENT ENTRY.
C
C     TERMS OF EACH ELEMENT ENTRY.
C     ============================
C      1. AND 2.  = ELEMENT NAME STORED 2A4
C      3. ELEMENT TYPE NUMBER
C      4. AND 5. ELEMENT-CONNECTION-TABLE RECORD ID AND BIT NUMBER
C      6. NUMBER OF ELEMENT CONNECTION TABLE WORDS FOR THIS ELEMENT
C      7. 8. AND 9. SAME AS 4. 5. AND 6. BUT FOR ELEMENT PROPERTY TABLE
C     10. NUMBER OF GRID POINTS FOR THIS ELEMENT
C     11. SCALAR
C     12. NUMBER OF WORDS IN THE ELEMENT-SUMMARY-TABLE FOR THIS ELEMENT
C     13. POSITION IN ECT OF FIRST GRID POINT
C     14. AND 15. TEMPERATURE TYPE AND COUNT AS USED BY THE SSG MODULE
C     16. TWO LETTER SYMBOL FOR PLOTTING.  ELEMENT WILL BE PLOTTED IF
C         WORD 10 IS 2 TO 42 AND WORD 11 IS ZERO AND WORD 16 .NE. 2HXX
C     17. NUMBER OF ESTA WORDS SDR2 WILL PICK UP FROM PHASE-1 ELEMENT
C         ROUTINES AND PASS TO THE PHASE-2 ELEMENT ROUTINES
C     18. AND 19. THE REAL STRESS WORD AND FORCE WORD COUNTS FOR OUT-
C         PUTS FROM THE SDR2 PHASE-2 ROUTINES TO AN OUTPUT FILE FOR OFP
C     20. AND 21. COMPLEX STRESS AND FORCE POINTERS FOR ORDERING OF
C         COMPLEX STRESS AND FORCE OUTPUTS TO A FILE FOR OFP PROCESSING
C     22. 23. AND 24. SMA1, SMA2, AND DS1 ELEMENT OVERLAY TREE POSITION
C     25. MAXIMUM DEGREES OF FREEDOM DEFINED FOR ELEMENT
C
C
      INTEGER E(2150),
     1        E 1(25),E 2(25),E 3(25),E 4(25),E 5(25),E 6(25),E 7(25),
     2        E 8(25),E 9(25),E10(25),E11(25),E12(25),E13(25),E14(25),
     3        E15(25),E16(25),E17(25),E18(25),E19(25),E20(25),E21(25),
     4        E22(25),E23(25),E24(25),E25(25),E26(25),E27(25),E28(25),
     5        E29(25),E30(25),E31(25),E32(25),E33(25),E34(25),E35(25),
     6        E36(25),E37(25),E38(25),E39(25),E40(25),E41(25),E42(25),
     7        E43(25),E44(25),E45(25),E46(25),E47(25),E48(25),E49(25),
     8        E50(25),E51(25),E52(25),E53(25),E54(25),E55(25),E56(25),
     9        E57(25),E58(25),E59(25),E60(25),E61(25),E62(25),E63(25),
     O        E64(25),E65(25),E66(25),E67(25),E68(25),E69(25),E70(25),
     1        E71(25),E72(25),E73(25),E74(25),E75(25),E76(25),E77(25),
     2        E78(25),E79(25),E80(25),E81(25),E82(25),E83(25),E84(25),
     3        E85(25),E86(25)
C
      INTEGER COMPLX(530),
     1        COMP1(100),COMP2(100),COMP3(100),COMP4(100),COMP5(100),
     2        COMP6( 30)
C
      COMMON /GPTA1 / NELEM,LAST,INCR,E
      COMMON /CLSTRS/ COMPLX
C
      EQUIVALENCE (E 1(1),E(   1)), (E 2(1),E(  26)), (E 3(1),E(  51)),
     1            (E 4(1),E(  76)), (E 5(1),E( 101)), (E 6(1),E( 126)),
     2            (E 7(1),E( 151)), (E 8(1),E( 176)), (E 9(1),E( 201)),
     3            (E10(1),E( 226)), (E11(1),E( 251)), (E12(1),E( 276)),
     4            (E13(1),E( 301)), (E14(1),E( 326)), (E15(1),E( 351)),
     5            (E16(1),E( 376)), (E17(1),E( 401)), (E18(1),E( 426)),
     6            (E19(1),E( 451)), (E20(1),E( 476)), (E21(1),E( 501)),
     7            (E22(1),E( 526)), (E23(1),E( 551)), (E24(1),E( 576)),
     8            (E25(1),E( 601)), (E26(1),E( 626)), (E27(1),E( 651)),
CRPKR THE FOLLOWING TWO LINES WERE REPLACED
CRPKR EQUIVALENCE STATEMENT TOO LONG
CRPKR9            (E28(1),E( 676)), (E29(1),E( 701)), (E30(1),E( 726)),
CRPKRO            (E31(1),E( 751)), (E32(1),E( 776)), (E33(1),E( 801)),
     9            (E28(1),E( 676)), (E29(1),E( 701)), (E30(1),E( 726))
      EQUIVALENCE (E31(1),E( 751)), (E32(1),E( 776)), (E33(1),E( 801)),
     1            (E34(1),E( 826)), (E35(1),E( 851)), (E36(1),E( 876)),
     2            (E37(1),E( 901)), (E38(1),E( 926)), (E39(1),E( 951)),
     3            (E40(1),E( 976)), (E41(1),E(1001)), (E42(1),E(1026)),
     4            (E43(1),E(1051)), (E44(1),E(1076)), (E45(1),E(1101)),
     5            (E46(1),E(1126)), (E47(1),E(1151)), (E48(1),E(1176)),
     6            (E49(1),E(1201)), (E50(1),E(1226)), (E51(1),E(1251)),
     7            (E52(1),E(1276)), (E53(1),E(1301)), (E54(1),E(1326)),
     8            (E55(1),E(1351)), (E56(1),E(1376)), (E57(1),E(1401)),
     9            (E58(1),E(1426)), (E59(1),E(1451)), (E60(1),E(1476))
      EQUIVALENCE (E61(1),E(1501)), (E62(1),E(1526)), (E63(1),E(1551)),
     1            (E64(1),E(1576)), (E65(1),E(1601)), (E66(1),E(1626)),
     2            (E67(1),E(1651)), (E68(1),E(1676)), (E69(1),E(1701)),
     3            (E70(1),E(1726)), (E71(1),E(1751)), (E72(1),E(1776)),
     4            (E73(1),E(1801)), (E74(1),E(1826)), (E75(1),E(1851)),
     5            (E76(1),E(1876)), (E77(1),E(1901)), (E78(1),E(1926)),
     6            (E79(1),E(1951)), (E80(1),E(1976)), (E81(1),E(2001)),
     7            (E82(1),E(2026)), (E83(1),E(2051)), (E84(1),E(2076)),
     8            (E85(1),E(2101)), (E86(1),E(2126))
C
      EQUIVALENCE (COMPLX(  1),COMP1(1)), (COMPLX(101),COMP2(1)),
     1            (COMPLX(201),COMP3(1)), (COMPLX(301),COMP4(1)),
     2            (COMPLX(401),COMP5(1)), (COMPLX(501),COMP6(1))
C
      DATA  NELEM /86/ ,LAST /2150/ ,INCR/25/
C
C     CURRENTLY ECTBIT USES 1 THRU 96, EXCEPT
C        76-77, 82, 88-90, 94-96
C     (50 IS USED BY CONGRUENT ELEMENT, CNGRNT, WITH ECT-ID 5008)
C
C     CURRENTLY EPTBIT USES 1 THRU 96, EXCEPT
C        26-48, 50, 52, 54-55, 57, 59-60, 71-81, 83, 86-94 AND 96
C
C                ------,------,------,------,------,------,------,
C     DATA  Exx/ NAME1 ,NAME2 ,ELTYPE,ECT-ID,ECTBIT,ECTWDS,EPT-ID,
C                EPTBIT,EPTWDS,GRDPTS,SCALAR,ESTWDS,GRID1 ,TEMTYP,
C                TEMCT ,SYMBOL,ESTAWD,STRESS,FORCE ,STRSPT,FORCPT,
C                SMA1OV,SMA2OV,DS1OV ,MAXDOF/
C                ------,------,------,------,------,------,------,
      DATA  E 1/ 4HROD ,4H    ,     1,  3001,    30,     4,   902,
     1                9,     6,     2,     0,    17,     3,     1,
     2                2,2HRD  ,    23,     5,     3,    41,    13,
     3                1,     1,     1,     6/
C
C     NOTE FROM G.CHAN/UNISYS  9/91
C     THE NEXT ELEMENT IS NOT AVAILABLE IN COSMIC/NASTRAN. BUT ELEMENT
C     TYPE 2 IS USED LOCALLY IN DS1 SUBROUTINE. CHECK WITH DS1 FIRST IF
C     BEAM ELEMENT IS TO BE USED. MAKE SURE THERE IS NO CONFLICT ABOUT
C     ELEMENT TYPE 2
C
      DATA  E 2/ 4HBEAM,4H    ,     2,   101,     1,    20,   102,
     1                1,    20,     2,     0,    47,     3,     0,
     2                0,2HBM  ,    88,    14,     9,     0,     0,
     3                1,     1,     1,     6/
      DATA  E 3/ 4HTUBE,4H    ,     3,  3701,    37,     4,  1602,
     1               16,     5,     2,     0,    16,     3,     1,
     2                2,2HTU  ,    23,     5,     3,    41,    13,
     3                1,     1,     1,     6/
      DATA  E 4/ 4HSHEA,4HR   ,     4,  3101,    31,     6,  1002,
     1               10,     4,     4,     0,    25,     3,     2,
     2                7,2HSH  ,    33,     4,    17,    47,   156,
     3                1,     1,     1,     6/
      DATA  E 5/ 4HTWIS,4HT   ,     5,  3801,    38,     6,  1702,
     1               17,     4,     4,     0,    25,     3,     2,
     2                7,2HTW  ,    25,     4,     3,    47,    13,
     3                1,     1,     0,     6/
      DATA  E 6/ 4HTRIA,4H1   ,     6,  3301,    33,     6,  1202,
     1               12,    10,     3,     0,    27,     3,     2,
     2                7,2HT1  ,   137,    17,     6,    73,     1,
     3                1,     1,     2,     6/
      DATA  E 7/ 4HTRBS,4HC   ,     7,  3201,    32,     6,  1102,
     1               11,     8,     3,     0,    25,     3,     2,
     2                7,2HTB  ,   101,    17,     6,    73,     1,
     3                1,     1,     0,     6/
      DATA  E 8/ 4HTRPL,4HT   ,     8,  3601,    36,     6,  1502,
     1               15,     8,     3,     0,    25,     3,     2,
     2                7,2HTP  ,   101,    17,     6,    73,     1,
     3                1,     1,     0,     6/
      DATA  E 9/ 4HTRME,4HM   ,     9,  3501,    35,     6,  1402,
     1               14,     4,     3,     0,    21,     3,     2,
     2                2,2HTM  ,    36,     8,     0,    89,     0,
     3                1,     1,     2,     6/
      DATA  E10/ 4HCONR,4HOD  ,    10,  1601,    16,     8,     0,
     1                0,     0,     2,     0,    17,     2,     1,
     2                2,2HCR  ,    23,     5,     3,    41,    13,
     3                1,     1,     1,     6/
      DATA  E11/ 4HELAS,4H1   ,    11,   601,     6,     6,   302,
     1                3,     4,     2,     1,     8,     3,     0,
     2                0,2H    ,     5,     2,     2,    19,    19,
     3                1,     1,     0,     1/
      DATA  E12/ 4HELAS,4H2   ,    12,   701,     7,     8,     0,
     1                0,     0,     2,     1,     8,     3,     0,
     2                0,2H    ,     5,     2,     2,    19,    19,
     3                1,     1,     0,     1/
      DATA  E13/ 4HELAS,4H3   ,    13,   801,     8,     4,   302,
     1                3,     4,     2,    -1,     6,     3,     0,
     2                0,2H    ,     5,     2,     2,    19,    19,
     3                1,     1,     0,     1/
      DATA  E14/ 4HELAS,4H4   ,    14,   901,     9,     4,     0,
     1                0,     0,     2,    -1,     4,     3,     0,
     2                0,2H    ,     5,     0,     2,    19,    19,
     3                1,     1,     0,     1/
      DATA  E15/ 4HQDPL,4HT   ,    15,  2701,    27,     7,   602,
     1                6,     8,     4,     0,    30,     3,     2,
     2                7,2HQP  ,   131,    17,     6,    73,     1,
     3                1,     1,     0,     6/
      DATA  E16/ 4HQDME,4HM   ,    16,  2601,    26,     7,   502,
     1                5,     4,     4,     0,    26,     3,     2,
     2                2,2HQM  ,    45,     8,     0,    89,     0,
     3                1,     1,     2,     6/
      DATA  E17/ 4HTRIA,4H2   ,    17,  3401,    34,     6,  1302,
     1               13,     4,     3,     0,    21,     3,     2,
     2                7,2HT2  ,   137,    17,     6,    73,     1,
     3                1,     1,     2,     6/
      DATA  E18/ 4HQUAD,4H2   ,    18,  2901,    29,     7,   802,
     1                8,     4,     4,     0,    26,     3,     2,
     2                7,2HQ2  ,   176,    17,     6,    73,     1,
     3                1,     1,     2,     6/
      DATA  E19/ 4HQUAD,4H1   ,    19,  2801,    28,     7,   702,
     1                7,    10,     4,     0,    32,     3,     2,
     2                7,2HQ1  ,   176,    17,     6,    73,     1,
     3                1,     1,     2,     6/
      DATA  E20/ 4HDAMP,4H1   ,    20,   201,     2,     6,   202,
     1                2,     2,     2,     1,     6,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E21/ 4HDAMP,4H2   ,    21,   301,     3,     6,     0,
     1                0,     0,     2,     1,     6,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E22/ 4HDAMP,4H3   ,    22,   401,     4,     4,   202,
     1                2,     2,     2,    -1,     4,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E23/ 4HDAMP,4H4   ,    23,   501,     5,     4,     0,
     1                0,     0,     2,    -1,     4,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E24/ 4HVISC,4H    ,    24,  3901,    39,     4,  1802,
     1               18,     3,     2,     0,    14,     3,     0,
     2                0,2HVS  ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E25/ 4HMASS,4H1   ,    25,  1001,    10,     6,   402,
     1                4,     2,     2,     1,     6,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E26/ 4HMASS,4H2   ,    26,  1101,    11,     6,     0,
     1                0,     0,     2,     1,     6,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E27/ 4HMASS,4H3   ,    27,  1201,    12,     4,   402,
     1                4,     2,     2,    -1,     4,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E28/ 4HMASS,4H4   ,    28,  1301,    13,     4,     0,
     1                0,     0,     2,    -1,     4,     3,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E29/ 4HCONM,4H1   ,    29,  1401,    14,    24,     0,
     1                0,     0,     1,     0,    29,     2,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E30/ 4HCONM,4H2   ,    30,  1501,    15,    13,     0,
     1                0,     0,     1,     0,    18,     2,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E31/ 4HPLOT,4HEL  ,    31,  5201,    52,     3,     0,
     1                0,     0,     2,     0,    12,     2,     0,
     2                0,2HPL  ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E32/ 4HREAC,4HT   ,    32,  5251,    60,    19,     0,
     1                0,     0,     1,     0,    24,     2,     0,
     2                0,2H    ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E33/ 4HQUAD,4H3   ,    33,  2958,    40,     7,   852,
     1               49,    62,     4,     0,    24,     3,     0,
     2                0,2HQ3  ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     6/
      DATA  E34/ 4HBAR ,4H    ,    34,  2408,    24,    16,    52,
     1               20,    19,     2,     0,    42,     3,     1,
     2               15,2HBR  ,   124,    16,     9,    53,    23,
     3                1,     1,     1,     6/
      DATA  E35/ 4HCONE,4HAX  ,    35,  8515,    85,     4,   152,
     1               19,    24,     2,     0,    35,     3,     3,
     2                4,2HCN  ,   118,    18,     7,     0,     0,
     3                2,     2,     2,     6/
      DATA  E36/ 4HTRIA,4HRG  ,    36,  1708,    17,     6,     0,
     1                0,     0,     3,     0,    19,     2,     3,
     2                5,2HTI  ,   126,     5,    10,     0,     0,
     3                2,     2,     0,     6/
      DATA  E37/ 4HTRAP,4HRG  ,    37,  1808,    18,     7,     0,
     1                0,     0,     4,     0,    24,     2,     3,
     2                6,2HTA  ,   394,    21,    13,     0,     0,
     3                2,     2,     0,     6/
      DATA  E38/ 4HTORD,4HRG  ,    38,  1908,    19,     7,  2102,
     1               21,     4,     2,     0,    18,     3,     3,
     2                4,2HTR  ,   358,    16,    13,     0,     0,
     3                2,     2,     0,     6/
      DATA  E39/ 4HTETR,4HA   ,    39,  5508,    55,     6,     0,
     1                0,     0,     4,     0,    23,     3,     3,
     2                6,2HTE  ,    88,     9,     0,    97,     0,
     3                3,     1,     0,     6/
      DATA  E40/ 4HWEDG,4HE   ,    40,  5608,    56,     8,     0,
     1                0,     0,     6,     0,    33,     3,     3,
     2                8,2HWG  ,   128,     9,     0,    97,     0,
     3                3,     1,     0,     6/
      DATA  E41/ 4HHEXA,4H1   ,    41,  5708,    57,    10,     0,
     1                0,     0,     8,     0,    43,     3,     3,
     2               10,2HH1  ,   168,     9,     0,    97,     0,
     3                3,     1,     0,     6/
      DATA  E42/ 4HHEXA,4H2   ,    42,  5808,    58,    10,     0,
     1                0,     0,     8,     0,    43,     3,     3,
     2               10,2HH2  ,   168,     9,     0,    97,     0,
     3                3,     1,     0,     6/
      DATA  E43/ 4HFLUI,4HD2  ,    43,  7815,    78,     6,     0,
     1                0,     0,     2,     0,    15,     2,     0,
     2                0,2HF2  ,     0,     0,     0,     0,     0,
     3                3,     1,     0,     6/
      DATA  E44/ 4HFLUI,4HD3  ,    44,  7915,    79,     7,     0,
     1                0,     0,     3,     0,    20,     2,     0,
     2                0,2HF3  ,     0,     0,     0,     0,     0,
     3                3,     1,     0,     1/
      DATA  E45/ 4HFLUI,4HD4  ,    45,  8015,    80,     8,     0,
     1                0,     0,     4,     0,    25,     2,     0,
     2                0,2HF4  ,     0,     0,     0,     0,     0,
     3                3,     1,     0,     1/
      DATA  E46/ 4HFLMA,4HSS  ,    46,  2508,    25,     5,     0,
     1                0,     0,     2,     0,    14,     2,     0,
     2                0,2HFM  ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E47/ 4HAXIF,4H2   ,    47,  2108,    21,     6,     0,
     1                0,     0,     2,     0,    15,     2,     0,
     2                0,2HA2  ,    13,     5,     0,   111,     0,
     3                1,     1,     0,     1/
      DATA  E48/ 4HAXIF,4H3   ,    48,  2208,    22,     7,     0,
     1                0,     0,     3,     0,    20,     2,     0,
     2                0,2HA3  ,    32,    10,     0,   122,     0,
     3                1,     1,     0,     1/
      DATA  E49/ 4HAXIF,4H4   ,    49,  2308,    23,     8,     0,
     1                0,     0,     4,     0,    25,     2,     0,
     2                0,2HA4  ,    49,    12,     0,   122,     0,
     3                1,     1,     0,     1/
      DATA  E50/ 4HSLOT,4H3   ,    50,  4408,    44,     8,     0,
     1                0,     0,     3,     0,    21,     2,     0,
     2                0,2HS3  ,    20,     6,     0,     1,     0,
     3                1,     1,     0,     1/
      DATA  E51/ 4HSLOT,4H4   ,    51,  4508,    45,     9,     0,
     1                0,     0,     4,     0,    26,     2,     0,
     2                0,2HS4  ,    29,     7,     0,   142,     0,
     3                1,     1,     0,     1/
      DATA  E52/ 4HHBDY,4H    ,    52,  4208,    42,    15,  2502,
     1               25,     7,     8,     0,    53,     4,     3,
     2               10,2HHB  ,     0,     0,     0,     0,     0,
     3                1,     1,     0,     1/
      DATA  E53/ 4HDUM1,4H    ,    53,  6108,    61,     0,  6102,
     1               61,     0,     0,     0,     0,     3,     3,
     2                0,2HD1  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E54/ 4HDUM2,4H    ,    54,  6208,    62,     0,  6202,
     1               62,     0,     0,     0,     0,     3,     3,
     2                0,2HD2  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E55/ 4HDUM3,4H    ,    55,  6308,    63,     0,  6302,
     1               63,     0,     0,     0,     0,     3,     3,
     2                0,2HD3  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E56/ 4HDUM4,4H    ,    56,  6408,    64,     0,  6402,
     1               64,     0,     0,     0,     0,     3,     3,
     2                0,2HD4  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E57/ 4HDUM5,4H    ,    57,  6508,    65,     0,  6502,
     1               65,     0,     0,     0,     0,     3,     3,
     2                0,2HD5  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E58/ 4HDUM6,4H    ,    58,  6608,    66,     0,  6602,
     1               66,     0,     0,     0,     0,     3,     3,
     2                0,2HD6  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E59/ 4HDUM7,4H    ,    59,  6708,    67,     0,  6702,
     1               67,     0,     0,     0,     0,     3,     3,
     2                0,2HD7  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E60/ 4HDUM8,4H    ,    60,  6808,    68,     0,  6802,
     1               68,     0,     0,     0,     0,     3,     3,
     2                0,2HD8  ,   100,    10,    10,     3,     3,
     3                4,     2,     3,     6/
      DATA  E61/ 4HDUM9,4H    ,    61,  6908,    69,     0,  6902,
     1               69,     0,     0,     0,     0,     3,     3,
     2                0,2HD9  ,   100,    10,    10,     3,     3,
     3                4,     1,     3,     6/
      DATA  E62/ 4HQDME,4HM1  ,    62,  2008,    20,     7,  2202,
     1               22,     4,     4,     0,    26,     3,     2,
     2                2,2HM1  ,    45,     8,     0,    89,     0,
     3                5,     1,     0,     6/
      DATA  E63/ 4HQDME,4HM2  ,    63,  5308,    53,     7,  5302,
     1               53,     4,     4,     0,    26,     3,     2,
     2                5,2HM2  ,   250,     8,    17,    89,   156,
     3                5,     1,     0,     6/
      DATA  E64/ 4HQUAD,4H4   ,    64,  5408,    54,    13,  5802,
     1               58,    17,     4,     0,    45,     3,     2,
     2                7,2HQ4  ,  2395,    17,     9,    73,    23,
     3                1,     1,     2,     6/
      DATA  E65/ 4HIHEX,4H1   ,    65,  7108,    71,    10,  7002,
     1               70,     7,     8,     0,    55,     3,     4,
     2                9,2HXL  ,   649,    22,     0,   191,     0,
     3                6,     1,     4,     6/
      DATA  E66/ 4HIHEX,4H2   ,    66,  7208,    72,    22,  7002,
     1               70,     7,    20,     0,   127,     3,     4,
     2               21,2HXQ  ,   649,    22,     0,   191,     0,
     3                6,     1,     4,     6/
      DATA  E67/ 4HIHEX,4H3   ,    67,  7308,    73,    34,  7002,
     1               70,     7,    32,     0,   199,     3,     4,
     2               33,2HXC  ,   649,    23,     0,   206,     0,
     3                6,     1,     4,     6/
      DATA  E68/ 4HQUAD,4HTS  ,    68,  4108,    41,    23,  2402,
     1               24,     8,     8,     0,    62,     3,     3,
     2               10,2HQS  ,  4276,    41,    49,     0,     0,
     3                2,     2,     0,     6/
      DATA  E69/ 4HTRIA,4HTS  ,    69,  5908,    59,    21,  2302,
     1               23,     8,     6,     0,    52,     3,     3,
     2                8,2HTS  ,  2490,    33,    37,     0,     0,
     3                2,     2,     0,     6/
      DATA  E70/ 4HTRIA,4HAX  ,    70,  7012,    70,     6,  7032,
     1               85,    17,     3,     0,    34,     3,     3,
     2                5,2HTX  ,   250,    11,    14,   231,   252,
     3                2,     2,     0,     6/
      DATA  E71/ 4HTRAP,4HAX  ,    71,  7042,    74,     7,  7052,
     1               95,    17,     4,     0,    39,     3,     3,
     2                6,2HT4  ,   954,    47,    18,   279,   372,
     3                2,     2,     0,     6/
      DATA  E72/ 4HAERO,4H1   ,    72,  3002,    46,     6,     0,
     1                0,     0,     5,     0,     0,     2,     0,
     2                0,2HAE  ,     0,     0,     0,     0,     0,
     3                0,     0,     0,     6/
      DATA  E73/ 4HTRIM,4H6   ,    73,  6101,    81,     9,  6201,
     1               82,     6,     6,     0,    43,     3,     4,
     2                7,2HT6  ,   233,    29,     0,    73,     0,
     3                1,     1,     0,     6/
      DATA  E74/ 4HTRPL,4HT1  ,    74,  6301,    83,     9,  6401,
     1               84,    16,     6,     0,    48,     3,     2,
     2                7,2HP6  ,   990,    65,    16,    73,     0,
     3                1,     1,     0,     6/
      DATA  E75/ 4HTRSH,4HL   ,    75,  7501,    75,     9,  7601,
     1               76,    20,     6,     0,    52,     3,     2,
     2                7,  2HSL,  1200,    65,    16,    73,     0,
     3                1,     1,     2,     6/
      DATA  E76/ 4HFHEX,4H1   ,    76,  9210,    92,    10,     0,
     1                0,     0,     8,     0,    43,     3,     0,
     2                0,2HFA  ,     0,     0,     0,     0,     0,
     3                0,     0,     0,     1/
      DATA  E77/ 4HFHEX,4H2   ,    77,  9310,    93,    10,     0,
     1                0,     0,     8,     0,    43,     3,     0,
     2                0,2HFB  ,     0,     0,     0,     0,     0,
     3                0,     0,     0,     1/
      DATA  E78/ 4HFTET,4HRA  ,    78,  8610,    86,     6,     0,
     1                0,     0,     4,     0,    23,     3,     0,
     2                0,2HFT  ,     0,     0,     0,     0,     0,
     3                0,     0,     0,     1/
      DATA  E79/ 4HFWED,4HGE  ,    79,  8710,    87,     8,     0,
     1                0,     0,     6,     0,    33,     3,     0,
     2                0,2HFW  ,     0,     0,     0,     0,     0,
     3                0,     0,     0,     1/
      DATA  E80/ 4HIS2D,4H8   ,    80,  2001,    47,    12,  2002,
     1               56,     3,     8,     0,    46,     3,     3,
     2               10,2HD8  ,   215,    43,     0,   411,     0,
     3                7,     7,     6,     6/
      DATA  E81/ 4HELBO,4HW   ,    81,  5101,    51,     8,  5102,
     1               51,    24,     2,     0,    39,     3,     1,
     2               15,2HEB  ,   126,    17,    12,   505,   481,
     3                1,     1,     1,     6/
      DATA  E82/ 4HFTUB,4HE   ,    73,  8408,    84,     4,  8402,
     1               84,     5,     2,     0,    16,     3,     1,
     2                2,2HFT  ,     5,     0,     2,     0,     0,
     3                1,     1,     0,     1/
      DATA  E83/ 4HTRIA,4H3   ,    83,  9108,    91,    11,  5802,
     1               58,    17,     3,     0,    39,     3,     2,
     2                7,2HT3  ,   713,    17,     9,    73,    23,
     3                1,     1,     2,     6/
      DATA  E84/ 4HPSE2,4H    ,    84,  4302,    77,     4,  4303,
     1               43,     5,     2,     0,    16,     3,     0,
     2                0,2HP1  ,     0,     0,     0,     0,     0,
     3                1,     1,     1,     6/
      DATA  E85/ 4HPSE3,4H    ,    85,  4802,    48,     5,  4303,
     1               43,     5,     3,     0,    21,     3,     0,
     2                0,2HP2  ,     0,     0,     0,     0,     0,
     3                1,     1,     1,     6/
      DATA  E86/ 4HPSE4,4H    ,    86,  4902,    94,     6,  4303,
     1               43,     5,     4,     0,    26,     3,     0,
     2                0,2HP3  ,     0,     0,     0,     0,     0,
     3                1,     1,     1,     6/
C
C
C     COMPLX DESCRIBES THE MANNER IN WHICH THE TWO PARTS OF COMPLEX
C     STRESSES AND FORCES ARE RELATED TO EACH OTHER.  ANY ELEMENT WHICH
C     HAS COMPLEX STRESS OR FORCE OUTPUT POINTS TO  A STRING WITH WORDS
C     20 AND 21 OF ITS ELEMENT ENTRY.  THE COMPLX TABLE IS USED IN SDR2
C     AND DDRMM, WHICH ARE IN LINKS 13 AND 12 RESPECTIVELY
C
C     EACH STRING IS DEFINDED AS FOLLOWS
C      0  TERMINATES THE FORMAT STRING
C     -N  PUT INTO PRINT BUFFER THE REAL PART OF PAIR
C     +N  (AND  N.LE.I)  PUT BOTH REAL AND IMAGINARY PARTS INTO BUFFER
C     +N  (AND  N.GT.I)  PUT IMAGINARY PART ONLY INTO PRINT BUFFER
C         WHERE    I  =  THE LENGTH OF STRING IN WORD 18 (REAL-STRESS)
C                        OR 19 (REAL-FORCE) PLUS 1
C
      DATA COMP1/  1,  -2,  -3,  -4,  -5,  -6,   8,   9,  10,  11
     1         ,  12,   0,   1,  -2,   5,  -3,   6,   0,   1,  -2
     2         ,   4,   0,   1,  -2,  -3,  -4,  -5,  -6,  -7,  -8
     3         ,  -9,  11,  12,  13,  14,  15,  16,  17,  18,   0
     4         ,   1,  -2,   7,  -4,   9,   0,   1,  -2,  -3,   6
     5         ,   7,   0,   1,  -2,  -3,  -4,  -5,  -6,  18,  19
     6         ,  20,  21,  22, -10, -11, -12, -13,  26,  27,  28
     7         ,  29,   0,   1,   2,  -3,  20,  -4,  21,  -5,  22
     8         ,  10, -11,  28, -12,  29, -13,  30,   0,   1,  -2
     9         ,  -3,  -4,  10,  11,  12,   0,   1,  -2,  -3,  -4  /
      DATA COMP2/ -5,  -6,  -7,  11,  12,  13,  14,  15,  16,   0
     1         ,   1,  -2,  -3,  -4,  -5,   7,   8,   9,  10,   0
     2         ,   0,   1,  -2,  -3,  -4,  -5,  -6,  -7,  -8,  -9
     3         , -10,  12,  13,  14,  15,  16,  17,  18,  19,  20
     4         ,   0,   1,  -2,  -3,  -4,  -5,  -6,  -7,   9,  10
     5         ,  11,  12,  13,  14,   0,   1,  -2,  -3,  -4,  -5
     6         ,  -6,  -7,  -8,  -9,  19,  20,  21,  22,  23,  24
     7         ,  25,  26, -10, -11, -12, -13, -14, -15, -16, -17
     8         ,  27,  28,  29,  30,  31,  32,  33,  34,   0,   0
     9         ,   1,   2,  -3, -11, -17,  -4, -12, -18,  25,  33  /
      DATA COMP3/ 39,  26,  34,  40,   0,   1,   2,  -3, -12, -18
     1         ,  -4, -13, -19,  11,  26,  35,  41,  27,  36,  42
     2         ,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0
     3         ,   1,   2,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -10
     4         , -11,  14,  15,  16,  17,  18,  19,  20,  21,  22
     5         ,   0,   1,   2,  -3,  -4,  -5,  -6,  17,  18,  19
     6         ,  20,  -7,  -8,  -9, -10,  21,  22,  23,  24, -11
     7         , -12, -13, -14,  25,  26,  27,  28,   0,   1,   2
     8         ,  -3,  -4,  -5,  -6,  -7,  -8,  -9, -10, -11,  50
     9         ,  51,  52,  53,  54,  55,  56,  57,  58, -12, -13  /
      DATA COMP4/-14, -15, -16, -17, -18, -19, -20,  59,  60,  61
     1         ,  62,  63,  64,  65,  66,  67, -21, -22, -23, -24
     2         , -25, -26, -27, -28, -29,  68,  69,  70,  71,  72
     3         ,  73,  74,  75,  76, -30, -31, -32, -33, -34, -35
     4         , -36, -37, -38,  77,  78,  79,  80,  81,  82,  83
     5         ,  84,  85, -39, -40, -41, -42, -43, -44, -45, -46
     6         , -47,  86,  87,  88,  89,  90,  91,  92,  93,  94
     7         ,   0,   1,   2,  -3,  -4,  -5,  -6,  21,  22,  23
     8         ,  24,  -7,  -8,  -9, -10,  25,  26,  27,  28, -11
     9         , -12, -13, -14,  29,  30,  31,  32, -15, -16, -17  /
      DATA COMP5/-18,  33,  34,  35,  36,   0,   0,   0,   0,   0
     1         ,   1,   2,   3,   4,   5,  -6,  49,  -7,  50,  -8
     2         ,  51,   9,  10, -11,  54, -12,  55, -13,  56,  14
     3         ,  15, -16,  59, -17,  60, -18,  61,  19,  20, -21
     4         ,  64, -22,  65, -23,  66,  24,  25, -26,  69, -27
     5         ,  70, -28,  71,  29,  30, -31,  74, -32,  75, -33
     6         ,  76,  34,  35, -36,  79, -37,  80, -38,  81,  39
     7         ,  40, -41,  84, -42,  85, -43,  86,   0,   0,   0
     8         ,   1,  -2,  -3,  -4,  -5,  -6,  -7,  14,  15,  16
     9         ,  17,  18,  19,  -8,  -9, -10, -11, -12,  20,  21  /
      DATA COMP6/ 22,  23,  24,   0,   1,  -2,  -3,  -4,  -5,  -6
     1         ,  19,  20,  21,  22,  23, -10, -11, -12, -13, -14
     2         ,  27,  28,  29,  30,  31,   0,   0,   0,   0,   0  /
      END
