/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ResolutionBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CaptureResolutionBox
extends JP2Box {
    public CaptureResolutionBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ResolutionBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        ResolutionBox resolutionBox = (ResolutionBox)this._parentBox;
        int n = this._module.readUnsignedShort(this._dstrm);
        int n2 = this._module.readUnsignedShort(this._dstrm);
        int n3 = this._module.readUnsignedShort(this._dstrm);
        int n4 = this._module.readUnsignedShort(this._dstrm);
        int n5 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        int n6 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        Rational rational = new Rational((int)((double)n * Math.pow(10.0, n5)), n2 * 100);
        Rational rational2 = new Rational((int)((double)n3 * Math.pow(10.0, n6)), n4 * 100);
        NisoImageMetadata nisoImageMetadata = this._module.getCurrentNiso();
        nisoImageMetadata.setYSamplingFrequency(rational);
        nisoImageMetadata.setXSamplingFrequency(rational2);
        nisoImageMetadata.setSamplingFrequencyUnit(3);
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Capture Resolution Box";
    }
}

