(** Extract Images - Incomplete and unsupported. *)
(* FIXME: Also CMYK etc... *)
type pixel_layout =
  | BPP1 (* Black and white *)
  | BPP8 (* Greyscale *)
  | BPP24 (* Colour *)
  | BPP48 (* 48 bit colour *)

type image =
  | JPEG of Utility.bytestream * float list option
  | JPEG2000 of Utility.bytestream * float list option
  | JBIG2 of Utility.bytestream * float list option
  | Raw of int * int * pixel_layout * Utility.bytestream

(** Given a pdf document, resources dictionary and a stream representing an
image, return a triple : width, height, and a stream of (width * height * 3)
bytes RGBRGB etc. In all instances, if JPEG or JPEG2000 or JBIG2 is the compression
 method, data is returned still encoded. *)
val get_image_24bpp :
  Pdf.pdfdoc -> Pdf.pdfobject -> Pdf.pdfobject -> image

(** Similarly, but if it's to be Raw, use the smallest pixel layout required to
represent the data. Not implemented yet. *)
val get_image :
  Pdf.pdfdoc -> Pdf.pdfobject -> Pdf.pdfobject -> image

(** Get the uncompressed image contents in 24bpp, decoding JPEG, JPEG2000 and JBIG2 as
required. Not implemented yet. *)
val get_image_raw_24bpp :
  Pdf.pdfdoc -> Pdf.pdfobject -> Pdf.pdfobject -> image

(** Get the uncompressed image contents, decoding JPEG, JPEG2000 and JBIG2 as
required. Not implemented yet. *)
val get_image_raw :
  Pdf.pdfdoc -> Pdf.pdfobject -> Pdf.pdfobject -> image


