/* VideoMetadata.c generated by valac 0.40.4, the Vala compiler
 * generated from VideoMetadata.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;
typedef struct _MediaMetadataPrivate MediaMetadataPrivate;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
typedef struct _VideoMetadataPrivate VideoMetadataPrivate;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_QUICK_TIME_METADATA_LOADER (quick_time_metadata_loader_get_type ())
#define QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader))
#define QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))
#define IS_QUICK_TIME_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_METADATA_LOADER))
#define IS_QUICK_TIME_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_METADATA_LOADER))
#define QUICK_TIME_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderClass))

typedef struct _QuickTimeMetadataLoader QuickTimeMetadataLoader;
typedef struct _QuickTimeMetadataLoaderClass QuickTimeMetadataLoaderClass;
#define _quick_time_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_metadata_loader_unref (var), NULL)))

#define TYPE_AVI_METADATA_LOADER (avi_metadata_loader_get_type ())
#define AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoader))
#define AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))
#define IS_AVI_METADATA_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_METADATA_LOADER))
#define IS_AVI_METADATA_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_METADATA_LOADER))
#define AVI_METADATA_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderClass))

typedef struct _AVIMetadataLoader AVIMetadataLoader;
typedef struct _AVIMetadataLoaderClass AVIMetadataLoaderClass;
#define _avi_metadata_loader_unref0(var) ((var == NULL) ? NULL : (var = (avi_metadata_loader_unref (var), NULL)))
typedef struct _QuickTimeMetadataLoaderPrivate QuickTimeMetadataLoaderPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_QUICK_TIME_ATOM (quick_time_atom_get_type ())
#define QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtom))
#define QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))
#define IS_QUICK_TIME_ATOM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_QUICK_TIME_ATOM))
#define IS_QUICK_TIME_ATOM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_QUICK_TIME_ATOM))
#define QUICK_TIME_ATOM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_QUICK_TIME_ATOM, QuickTimeAtomClass))

typedef struct _QuickTimeAtom QuickTimeAtom;
typedef struct _QuickTimeAtomClass QuickTimeAtomClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _quick_time_atom_unref0(var) ((var == NULL) ? NULL : (var = (quick_time_atom_unref (var), NULL)))
typedef struct _ParamSpecQuickTimeMetadataLoader ParamSpecQuickTimeMetadataLoader;
typedef struct _QuickTimeAtomPrivate QuickTimeAtomPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecQuickTimeAtom ParamSpecQuickTimeAtom;
typedef struct _AVIMetadataLoaderPrivate AVIMetadataLoaderPrivate;

#define TYPE_AVI_CHUNK (avi_chunk_get_type ())
#define AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVI_CHUNK, AVIChunk))
#define AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVI_CHUNK, AVIChunkClass))
#define IS_AVI_CHUNK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVI_CHUNK))
#define IS_AVI_CHUNK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVI_CHUNK))
#define AVI_CHUNK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVI_CHUNK, AVIChunkClass))

typedef struct _AVIChunk AVIChunk;
typedef struct _AVIChunkClass AVIChunkClass;
#define _avi_chunk_unref0(var) ((var == NULL) ? NULL : (var = (avi_chunk_unref (var), NULL)))
typedef struct _ParamSpecAVIMetadataLoader ParamSpecAVIMetadataLoader;
typedef struct _AVIChunkPrivate AVIChunkPrivate;
typedef struct _ParamSpecAVIChunk ParamSpecAVIChunk;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MediaMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MediaMetadataPrivate * priv;
};

struct _MediaMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (MediaMetadata *self);
	void (*read_from_file) (MediaMetadata* self, GFile* file, GError** error);
	MetadataDateTime* (*get_creation_date_time) (MediaMetadata* self);
	gchar* (*get_title) (MediaMetadata* self);
	gchar* (*get_comment) (MediaMetadata* self);
};

struct _VideoMetadata {
	MediaMetadata parent_instance;
	VideoMetadataPrivate * priv;
};

struct _VideoMetadataClass {
	MediaMetadataClass parent_class;
};

struct _VideoMetadataPrivate {
	MetadataDateTime* timestamp;
	gchar* title;
	gchar* comment;
};

struct _QuickTimeMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeMetadataLoaderPrivate * priv;
};

struct _QuickTimeMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeMetadataLoader *self);
};

struct _QuickTimeMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecQuickTimeMetadataLoader {
	GParamSpec parent_instance;
};

struct _QuickTimeAtom {
	GTypeInstance parent_instance;
	volatile int ref_count;
	QuickTimeAtomPrivate * priv;
};

struct _QuickTimeAtomClass {
	GTypeClass parent_class;
	void (*finalize) (QuickTimeAtom *self);
};

struct _QuickTimeAtomPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	QuickTimeAtom* parent;
};

struct _ParamSpecQuickTimeAtom {
	GParamSpec parent_instance;
};

struct _AVIMetadataLoader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIMetadataLoaderPrivate * priv;
};

struct _AVIMetadataLoaderClass {
	GTypeClass parent_class;
	void (*finalize) (AVIMetadataLoader *self);
};

struct _AVIMetadataLoaderPrivate {
	GFile* file;
};

struct _ParamSpecAVIMetadataLoader {
	GParamSpec parent_instance;
};

struct _AVIChunk {
	GTypeInstance parent_instance;
	volatile int ref_count;
	AVIChunkPrivate * priv;
};

struct _AVIChunkClass {
	GTypeClass parent_class;
	void (*finalize) (AVIChunk *self);
};

struct _AVIChunkPrivate {
	GFile* file;
	gchar* section_name;
	guint64 section_size;
	guint64 section_offset;
	GDataInputStream* input;
	AVIChunk* parent;
};

struct _ParamSpecAVIChunk {
	GParamSpec parent_instance;
};


static gpointer video_metadata_parent_class = NULL;
static gpointer quick_time_metadata_loader_parent_class = NULL;
static gpointer quick_time_atom_parent_class = NULL;
static gpointer avi_metadata_loader_parent_class = NULL;
static gpointer avi_chunk_parent_class = NULL;

gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_media_metadata (GValue* value,
                               gpointer v_object);
void value_take_media_metadata (GValue* value,
                                gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void value_set_metadata_date_time (GValue* value,
                                   gpointer v_object);
void value_take_metadata_date_time (GValue* value,
                                    gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
GType video_metadata_get_type (void) G_GNUC_CONST;
#define VIDEO_METADATA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_METADATA, VideoMetadataPrivate))
VideoMetadata* video_metadata_new (void);
VideoMetadata* video_metadata_construct (GType object_type);
MediaMetadata* media_metadata_construct (GType object_type);
static void video_metadata_real_read_from_file (MediaMetadata* base,
                                         GFile* file,
                                         GError** error);
gpointer quick_time_metadata_loader_ref (gpointer instance);
void quick_time_metadata_loader_unref (gpointer instance);
GParamSpec* param_spec_quick_time_metadata_loader (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
void value_set_quick_time_metadata_loader (GValue* value,
                                           gpointer v_object);
void value_take_quick_time_metadata_loader (GValue* value,
                                            gpointer v_object);
gpointer value_get_quick_time_metadata_loader (const GValue* value);
GType quick_time_metadata_loader_get_type (void) G_GNUC_CONST;
QuickTimeMetadataLoader* quick_time_metadata_loader_new (GFile* file);
QuickTimeMetadataLoader* quick_time_metadata_loader_construct (GType object_type,
                                                               GFile* file);
gboolean quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self);
MetadataDateTime* quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self);
gchar* quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self);
gpointer avi_metadata_loader_ref (gpointer instance);
void avi_metadata_loader_unref (gpointer instance);
GParamSpec* param_spec_avi_metadata_loader (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
void value_set_avi_metadata_loader (GValue* value,
                                    gpointer v_object);
void value_take_avi_metadata_loader (GValue* value,
                                     gpointer v_object);
gpointer value_get_avi_metadata_loader (const GValue* value);
GType avi_metadata_loader_get_type (void) G_GNUC_CONST;
AVIMetadataLoader* avi_metadata_loader_new (GFile* file);
AVIMetadataLoader* avi_metadata_loader_construct (GType object_type,
                                                  GFile* file);
gboolean avi_metadata_loader_is_supported (AVIMetadataLoader* self);
MetadataDateTime* avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self);
gchar* avi_metadata_loader_get_title (AVIMetadataLoader* self);
static MetadataDateTime* video_metadata_real_get_creation_date_time (MediaMetadata* base);
static gchar* video_metadata_real_get_title (MediaMetadata* base);
static gchar* video_metadata_real_get_comment (MediaMetadata* base);
static void video_metadata_finalize (MediaMetadata * obj);
#define QUICK_TIME_METADATA_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoaderPrivate))
#define QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT ((time_t) 2082844800)
static gulong quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self);
MetadataDateTime* metadata_date_time_new (time_t timestamp);
MetadataDateTime* metadata_date_time_construct (GType object_type,
                                                time_t timestamp);
gpointer quick_time_atom_ref (gpointer instance);
void quick_time_atom_unref (gpointer instance);
GParamSpec* param_spec_quick_time_atom (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_quick_time_atom (GValue* value,
                                gpointer v_object);
void value_take_quick_time_atom (GValue* value,
                                 gpointer v_object);
gpointer value_get_quick_time_atom (const GValue* value);
GType quick_time_atom_get_type (void) G_GNUC_CONST;
QuickTimeAtom* quick_time_atom_new (GFile* file);
QuickTimeAtom* quick_time_atom_construct (GType object_type,
                                          GFile* file);
void quick_time_atom_open_file (QuickTimeAtom* self,
                                GError** error);
void quick_time_atom_read_atom (QuickTimeAtom* self,
                                GError** error);
gchar* quick_time_atom_get_current_atom_name (QuickTimeAtom* self);
void quick_time_atom_next_atom (QuickTimeAtom* self,
                                GError** error);
gboolean quick_time_atom_is_last_atom (QuickTimeAtom* self);
void quick_time_atom_close_file (QuickTimeAtom* self,
                                 GError** error);
QuickTimeAtom* quick_time_atom_get_first_child_atom (QuickTimeAtom* self);
guint64 quick_time_atom_section_size_remaining (QuickTimeAtom* self);
guint32 quick_time_atom_read_uint32 (QuickTimeAtom* self,
                                     GError** error);
static void quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj);
#define QUICK_TIME_ATOM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_QUICK_TIME_ATOM, QuickTimeAtomPrivate))
static QuickTimeAtom* quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                                      QuickTimeAtom* parent);
static QuickTimeAtom* quick_time_atom_construct_with_input_stream (GType object_type,
                                                            GDataInputStream* input,
                                                            QuickTimeAtom* parent);
static void quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                             guint64 amount);
guchar quick_time_atom_read_byte (QuickTimeAtom* self,
                                  GError** error);
guint64 quick_time_atom_read_uint64 (QuickTimeAtom* self,
                                     GError** error);
static void quick_time_atom_skip (QuickTimeAtom* self,
                           guint64 skip_amount,
                           GError** error);
void skip_uint64 (GInputStream* input,
                  guint64 skip_amount,
                  GError** error);
static void quick_time_atom_finalize (QuickTimeAtom * obj);
#define AVI_METADATA_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVI_METADATA_LOADER, AVIMetadataLoaderPrivate))
#define AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH 19
#define AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER ((guint16) 0x13)
#define AVI_METADATA_LOADER_MAX_STRD_LENGTH 100
static gulong avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self);
gpointer avi_chunk_ref (gpointer instance);
void avi_chunk_unref (gpointer instance);
GParamSpec* param_spec_avi_chunk (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_avi_chunk (GValue* value,
                          gpointer v_object);
void value_take_avi_chunk (GValue* value,
                           gpointer v_object);
gpointer value_get_avi_chunk (const GValue* value);
GType avi_chunk_get_type (void) G_GNUC_CONST;
AVIChunk* avi_chunk_new (GFile* file);
AVIChunk* avi_chunk_construct (GType object_type,
                               GFile* file);
void avi_chunk_open_file (AVIChunk* self,
                          GError** error);
void avi_chunk_read_chunk (AVIChunk* self,
                           GError** error);
gchar* avi_chunk_get_current_chunk_name (AVIChunk* self);
gchar* avi_chunk_read_name (AVIChunk* self,
                            GError** error);
void avi_chunk_close_file (AVIChunk* self,
                           GError** error);
static gchar* avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                                AVIChunk* chunk,
                                                GError** error);
guint64 avi_chunk_section_size_remaining (AVIChunk* self);
guint16 avi_chunk_read_uint16 (AVIChunk* self,
                               GError** error);
void avi_chunk_skip (AVIChunk* self,
                     guint64 skip_amount,
                     GError** error);
guchar avi_chunk_read_byte (AVIChunk* self,
                            GError** error);
static gchar* avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                               AVIChunk* chunk,
                                               GError** error);
static gchar* avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error);
gchar* avi_chunk_section_to_string (AVIChunk* self,
                                    GError** error);
AVIChunk* avi_chunk_get_first_child_chunk (AVIChunk* self);
gboolean avi_chunk_is_last_chunk (AVIChunk* self);
void avi_chunk_next_chunk (AVIChunk* self,
                           GError** error);
static gulong avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                       const gchar* sdate);
static GDateMonth avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                                  const gchar* s);
void avi_chunk_nonsection_skip (AVIChunk* self,
                                guint64 skip_amount,
                                GError** error);
static void avi_metadata_loader_finalize (AVIMetadataLoader * obj);
#define AVI_CHUNK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVI_CHUNK, AVIChunkPrivate))
#define AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH 1024
static AVIChunk* avi_chunk_new_with_input_stream (GDataInputStream* input,
                                           AVIChunk* parent);
static AVIChunk* avi_chunk_construct_with_input_stream (GType object_type,
                                                 GDataInputStream* input,
                                                 AVIChunk* parent);
static void avi_chunk_advance_section_offset (AVIChunk* self,
                                       guint64 amount);
static void avi_chunk_finalize (AVIChunk * obj);


VideoMetadata*
video_metadata_construct (GType object_type)
{
	VideoMetadata* self = NULL;
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (VideoMetadata*) media_metadata_construct (object_type);
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 451 "VideoMetadata.c"
}


VideoMetadata*
video_metadata_new (void)
{
#line 13 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return video_metadata_construct (TYPE_VIDEO_METADATA);
#line 460 "VideoMetadata.c"
}


static void
video_metadata_real_read_from_file (MediaMetadata* base,
                                    GFile* file,
                                    GError** error)
{
	VideoMetadata * self;
	QuickTimeMetadataLoader* quicktime = NULL;
	QuickTimeMetadataLoader* _tmp0_;
	QuickTimeMetadataLoader* _tmp1_;
	AVIMetadataLoader* avi = NULL;
	AVIMetadataLoader* _tmp6_;
	AVIMetadataLoader* _tmp7_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError * _inner_error_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 19 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 20 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = quick_time_metadata_loader_new (file);
#line 20 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quicktime = _tmp0_;
#line 21 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quicktime;
#line 21 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (quick_time_metadata_loader_is_supported (_tmp1_)) {
#line 493 "VideoMetadata.c"
		QuickTimeMetadataLoader* _tmp2_;
		MetadataDateTime* _tmp3_;
		QuickTimeMetadataLoader* _tmp4_;
		gchar* _tmp5_;
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = quicktime;
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = quick_time_metadata_loader_get_creation_date_time (_tmp2_);
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_metadata_date_time_unref0 (self->priv->timestamp);
#line 22 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->timestamp = _tmp3_;
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = quicktime;
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = quick_time_metadata_loader_get_title (_tmp4_);
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->title);
#line 23 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->title = _tmp5_;
#line 25 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->comment);
#line 25 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->comment = NULL;
#line 26 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_metadata_loader_unref0 (quicktime);
#line 26 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 522 "VideoMetadata.c"
	}
#line 28 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = avi_metadata_loader_new (file);
#line 28 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi = _tmp6_;
#line 29 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = avi;
#line 29 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (avi_metadata_loader_is_supported (_tmp7_)) {
#line 532 "VideoMetadata.c"
		AVIMetadataLoader* _tmp8_;
		MetadataDateTime* _tmp9_;
		AVIMetadataLoader* _tmp10_;
		gchar* _tmp11_;
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = avi;
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = avi_metadata_loader_get_creation_date_time (_tmp8_);
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_metadata_date_time_unref0 (self->priv->timestamp);
#line 30 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->timestamp = _tmp9_;
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = avi;
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = avi_metadata_loader_get_title (_tmp10_);
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->title);
#line 31 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->title = _tmp11_;
#line 32 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (self->priv->comment);
#line 32 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->comment = NULL;
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_metadata_loader_unref0 (avi);
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_metadata_loader_unref0 (quicktime);
#line 33 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 563 "VideoMetadata.c"
	}
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = g_file_get_path (file);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = _tmp12_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "File %s is not a supported video format", _tmp13_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = _tmp14_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (_tmp13_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_inner_error_ = _tmp15_;
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_propagate_error (error, _inner_error_);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_metadata_loader_unref0 (avi);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_metadata_loader_unref0 (quicktime);
#line 36 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return;
#line 585 "VideoMetadata.c"
}


static gpointer
_metadata_date_time_ref0 (gpointer self)
{
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? metadata_date_time_ref (self) : NULL;
#line 594 "VideoMetadata.c"
}


static MetadataDateTime*
video_metadata_real_get_creation_date_time (MediaMetadata* base)
{
	VideoMetadata * self;
	MetadataDateTime* result = NULL;
	MetadataDateTime* _tmp0_;
	MetadataDateTime* _tmp1_;
#line 39 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->timestamp;
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _metadata_date_time_ref0 (_tmp0_);
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 615 "VideoMetadata.c"
}


static gchar*
video_metadata_real_get_title (MediaMetadata* base)
{
	VideoMetadata * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 43 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->title;
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 636 "VideoMetadata.c"
}


static gchar*
video_metadata_real_get_comment (MediaMetadata* base)
{
	VideoMetadata * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 47 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_METADATA, VideoMetadata);
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->comment;
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 48 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 657 "VideoMetadata.c"
}


static void
video_metadata_class_init (VideoMetadataClass * klass)
{
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	video_metadata_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->finalize = video_metadata_finalize;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (VideoMetadataPrivate));
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->read_from_file = (void (*) (MediaMetadata *, GFile*, GError**)) video_metadata_real_read_from_file;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_creation_date_time = (MetadataDateTime* (*) (MediaMetadata *)) video_metadata_real_get_creation_date_time;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_title = (gchar* (*) (MediaMetadata *)) video_metadata_real_get_title;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((MediaMetadataClass *) klass)->get_comment = (gchar* (*) (MediaMetadata *)) video_metadata_real_get_comment;
#line 678 "VideoMetadata.c"
}


static void
video_metadata_instance_init (VideoMetadata * self)
{
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = VIDEO_METADATA_GET_PRIVATE (self);
#line 9 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->timestamp = NULL;
#line 10 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->title = NULL;
#line 11 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->comment = NULL;
#line 693 "VideoMetadata.c"
}


static void
video_metadata_finalize (MediaMetadata * obj)
{
	VideoMetadata * self;
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_METADATA, VideoMetadata);
#line 9 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_metadata_date_time_unref0 (self->priv->timestamp);
#line 10 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->title);
#line 11 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->comment);
#line 7 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	MEDIA_METADATA_CLASS (video_metadata_parent_class)->finalize (obj);
#line 711 "VideoMetadata.c"
}


GType
video_metadata_get_type (void)
{
	static volatile gsize video_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&video_metadata_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMetadata), 0, (GInstanceInitFunc) video_metadata_instance_init, NULL };
		GType video_metadata_type_id;
		video_metadata_type_id = g_type_register_static (TYPE_MEDIA_METADATA, "VideoMetadata", &g_define_type_info, 0);
		g_once_init_leave (&video_metadata_type_id__volatile, video_metadata_type_id);
	}
	return video_metadata_type_id__volatile;
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? g_object_ref (self) : NULL;
#line 734 "VideoMetadata.c"
}


QuickTimeMetadataLoader*
quick_time_metadata_loader_construct (GType object_type,
                                      GFile* file)
{
	QuickTimeMetadataLoader* self = NULL;
	GFile* _tmp0_;
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeMetadataLoader*) g_type_create_instance (object_type);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 62 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp0_;
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 756 "VideoMetadata.c"
}


QuickTimeMetadataLoader*
quick_time_metadata_loader_new (GFile* file)
{
#line 61 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_metadata_loader_construct (TYPE_QUICK_TIME_METADATA_LOADER, file);
#line 765 "VideoMetadata.c"
}


MetadataDateTime*
quick_time_metadata_loader_get_creation_date_time (QuickTimeMetadataLoader* self)
{
	MetadataDateTime* result = NULL;
	MetadataDateTime* _tmp0_;
#line 65 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), NULL);
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = metadata_date_time_new ((time_t) quick_time_metadata_loader_get_creation_date_time_for_quicktime (self));
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 66 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 782 "VideoMetadata.c"
}


gchar*
quick_time_metadata_loader_get_title (QuickTimeMetadataLoader* self)
{
	gchar* result = NULL;
#line 69 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), NULL);
#line 71 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 71 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 796 "VideoMetadata.c"
}


gboolean
quick_time_metadata_loader_is_supported (QuickTimeMetadataLoader* self)
{
	gboolean result = FALSE;
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), FALSE);
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new (_tmp0_);
#line 76 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	test = _tmp1_;
#line 78 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	ret = FALSE;
#line 819 "VideoMetadata.c"
	{
		QuickTimeAtom* _tmp2_;
		QuickTimeAtom* _tmp3_;
		QuickTimeAtom* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = test;
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_open_file (_tmp2_, &_inner_error_);
#line 80 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 833 "VideoMetadata.c"
			goto __catch586_g_error;
		}
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = test;
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_read_atom (_tmp3_, &_inner_error_);
#line 81 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 842 "VideoMetadata.c"
			goto __catch586_g_error;
		}
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = test;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = quick_time_atom_get_current_atom_name (_tmp4_);
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = _tmp5_;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = g_strcmp0 ("ftyp", _tmp6_) == 0;
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp6_);
#line 84 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp7_) {
#line 85 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			ret = TRUE;
#line 859 "VideoMetadata.c"
		} else {
#line 90 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			while (TRUE) {
#line 863 "VideoMetadata.c"
				QuickTimeAtom* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				QuickTimeAtom* _tmp12_;
				QuickTimeAtom* _tmp13_;
				QuickTimeAtom* _tmp14_;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp8_ = test;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp9_ = quick_time_atom_get_current_atom_name (_tmp8_);
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp10_ = _tmp9_;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = g_strcmp0 ("moov", _tmp10_) == 0;
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (_tmp10_);
#line 91 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (_tmp11_) {
#line 92 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					ret = TRUE;
#line 93 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 887 "VideoMetadata.c"
				}
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp12_ = test;
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				quick_time_atom_next_atom (_tmp12_, &_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 895 "VideoMetadata.c"
					goto __catch586_g_error;
				}
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp13_ = test;
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				quick_time_atom_read_atom (_tmp13_, &_inner_error_);
#line 96 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 904 "VideoMetadata.c"
					goto __catch586_g_error;
				}
#line 97 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp14_ = test;
#line 97 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (quick_time_atom_is_last_atom (_tmp14_)) {
#line 98 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 913 "VideoMetadata.c"
				}
			}
		}
	}
	goto __finally586;
	__catch586_g_error:
	{
		GError* e = NULL;
		GFile* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = self->priv->file;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = g_file_get_path (_tmp15_);
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = _tmp16_;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = e;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = _tmp18_->message;
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:103: Error while testing for QuickTime file for %s:" \
" %s", _tmp17_, _tmp19_);
#line 103 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp17_);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 947 "VideoMetadata.c"
	}
	__finally586:
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 952 "VideoMetadata.c"
		gboolean _tmp20_ = FALSE;
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp20_;
#line 962 "VideoMetadata.c"
	}
	{
		QuickTimeAtom* _tmp21_;
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp21_ = test;
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_close_file (_tmp21_, &_inner_error_);
#line 107 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 972 "VideoMetadata.c"
			goto __catch587_g_error;
		}
	}
	goto __finally587;
	__catch587_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp22_ = e;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp23_ = _tmp22_->message;
#line 109 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:109: Error while closing Quicktime file: %s", _tmp23_);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 994 "VideoMetadata.c"
	}
	__finally587:
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 999 "VideoMetadata.c"
		gboolean _tmp24_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 106 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp24_;
#line 1009 "VideoMetadata.c"
	}
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ret;
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (test);
#line 111 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1017 "VideoMetadata.c"
}


static gulong
quick_time_metadata_loader_get_creation_date_time_for_quicktime (QuickTimeMetadataLoader* self)
{
	gulong result = 0UL;
	QuickTimeAtom* test = NULL;
	GFile* _tmp0_;
	QuickTimeAtom* _tmp1_;
	time_t timestamp = 0;
	time_t _tmp33_;
	time_t _tmp35_;
	GError * _inner_error_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_METADATA_LOADER (self), 0UL);
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new (_tmp0_);
#line 115 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	test = _tmp1_;
#line 116 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	timestamp = (time_t) 0;
#line 1042 "VideoMetadata.c"
	{
		QuickTimeAtom* _tmp2_;
		gboolean done = FALSE;
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = test;
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_open_file (_tmp2_, &_inner_error_);
#line 119 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1052 "VideoMetadata.c"
			goto __catch588_g_error;
		}
#line 120 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		done = FALSE;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		while (TRUE) {
#line 1059 "VideoMetadata.c"
			gboolean _tmp3_;
			QuickTimeAtom* _tmp4_;
			QuickTimeAtom* _tmp5_;
			QuickTimeAtom* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gboolean _tmp9_;
			QuickTimeAtom* _tmp25_;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = done;
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (!(!_tmp3_)) {
#line 121 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				break;
#line 1074 "VideoMetadata.c"
			}
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = test;
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			quick_time_atom_read_atom (_tmp4_, &_inner_error_);
#line 123 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1082 "VideoMetadata.c"
				goto __catch588_g_error;
			}
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp5_ = test;
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (quick_time_atom_is_last_atom (_tmp5_)) {
#line 124 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				break;
#line 1091 "VideoMetadata.c"
			}
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp6_ = test;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = quick_time_atom_get_current_atom_name (_tmp6_);
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = _tmp7_;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = g_strcmp0 ("moov", _tmp8_) == 0;
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp8_);
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (_tmp9_) {
#line 1105 "VideoMetadata.c"
				QuickTimeAtom* child = NULL;
				QuickTimeAtom* _tmp10_;
				QuickTimeAtom* _tmp11_;
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp10_ = test;
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp11_ = quick_time_atom_get_first_child_atom (_tmp10_);
#line 126 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				child = _tmp11_;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				while (TRUE) {
#line 1117 "VideoMetadata.c"
					gboolean _tmp12_;
					QuickTimeAtom* _tmp13_;
					gboolean _tmp14_ = FALSE;
					QuickTimeAtom* _tmp15_;
					QuickTimeAtom* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					gboolean _tmp20_;
					QuickTimeAtom* _tmp24_;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp12_ = done;
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!(!_tmp12_)) {
#line 127 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1133 "VideoMetadata.c"
					}
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp13_ = child;
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					quick_time_atom_read_atom (_tmp13_, &_inner_error_);
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 129 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_quick_time_atom_unref0 (child);
#line 1143 "VideoMetadata.c"
						goto __catch588_g_error;
					}
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp15_ = child;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (quick_time_atom_is_last_atom (_tmp15_)) {
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp14_ = TRUE;
#line 1152 "VideoMetadata.c"
					} else {
						QuickTimeAtom* _tmp16_;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp16_ = child;
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp14_ = ((guint64) 0) == quick_time_atom_section_size_remaining (_tmp16_);
#line 1159 "VideoMetadata.c"
					}
#line 130 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (_tmp14_) {
#line 131 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						done = TRUE;
#line 132 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1167 "VideoMetadata.c"
					}
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp17_ = child;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp18_ = quick_time_atom_get_current_atom_name (_tmp17_);
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp19_ = _tmp18_;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp20_ = g_strcmp0 ("mvhd", _tmp19_) == 0;
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp19_);
#line 135 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (_tmp20_) {
#line 1181 "VideoMetadata.c"
						QuickTimeAtom* _tmp21_;
						guint32 _tmp22_ = 0U;
						QuickTimeAtom* _tmp23_;
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp21_ = child;
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						quick_time_atom_read_uint32 (_tmp21_, &_inner_error_);
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 137 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
							_quick_time_atom_unref0 (child);
#line 1193 "VideoMetadata.c"
							goto __catch588_g_error;
						}
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp23_ = child;
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp22_ = quick_time_atom_read_uint32 (_tmp23_, &_inner_error_);
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
							_quick_time_atom_unref0 (child);
#line 1204 "VideoMetadata.c"
							goto __catch588_g_error;
						}
#line 139 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						timestamp = _tmp22_ - QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
#line 140 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						done = TRUE;
#line 141 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 1213 "VideoMetadata.c"
					}
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp24_ = child;
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					quick_time_atom_next_atom (_tmp24_, &_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 143 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_quick_time_atom_unref0 (child);
#line 1223 "VideoMetadata.c"
						goto __catch588_g_error;
					}
				}
#line 125 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_quick_time_atom_unref0 (child);
#line 1229 "VideoMetadata.c"
			}
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp25_ = test;
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			quick_time_atom_next_atom (_tmp25_, &_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1237 "VideoMetadata.c"
				goto __catch588_g_error;
			}
		}
	}
	goto __finally588;
	__catch588_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp26_ = e;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp27_ = _tmp26_->message;
#line 149 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:149: Error while testing for QuickTime file: %s", _tmp27_);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 1260 "VideoMetadata.c"
	}
	__finally588:
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1265 "VideoMetadata.c"
		gulong _tmp28_ = 0UL;
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 118 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp28_;
#line 1275 "VideoMetadata.c"
	}
	{
		QuickTimeAtom* _tmp29_;
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp29_ = test;
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_close_file (_tmp29_, &_inner_error_);
#line 153 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "VideoMetadata.c"
			goto __catch589_g_error;
		}
	}
	goto __finally589;
	__catch589_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp30_ = e;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp31_ = _tmp30_->message;
#line 155 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:155: Error while closing Quicktime file: %s", _tmp31_);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 1307 "VideoMetadata.c"
	}
	__finally589:
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1312 "VideoMetadata.c"
		gulong _tmp32_ = 0UL;
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_quick_time_atom_unref0 (test);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 152 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp32_;
#line 1322 "VideoMetadata.c"
	}
#line 166 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp33_ = timestamp;
#line 166 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp33_ < ((time_t) 0)) {
#line 1328 "VideoMetadata.c"
		time_t _tmp34_;
#line 167 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp34_ = timestamp;
#line 167 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		timestamp = _tmp34_ + QUICK_TIME_METADATA_LOADER_QUICKTIME_EPOCH_ADJUSTMENT;
#line 1334 "VideoMetadata.c"
	}
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp35_ = timestamp;
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (gulong) _tmp35_;
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (test);
#line 169 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1344 "VideoMetadata.c"
}


static void
value_quick_time_metadata_loader_init (GValue* value)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 1353 "VideoMetadata.c"
}


static void
value_quick_time_metadata_loader_free_value (GValue* value)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (value->data[0].v_pointer);
#line 1364 "VideoMetadata.c"
	}
}


static void
value_quick_time_metadata_loader_copy_value (const GValue* src_value,
                                             GValue* dest_value)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = quick_time_metadata_loader_ref (src_value->data[0].v_pointer);
#line 1377 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1381 "VideoMetadata.c"
	}
}


static gpointer
value_quick_time_metadata_loader_peek_pointer (const GValue* value)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 1391 "VideoMetadata.c"
}


static gchar*
value_quick_time_metadata_loader_collect_value (GValue* value,
                                                guint n_collect_values,
                                                GTypeCValue* collect_values,
                                                guint collect_flags)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 1403 "VideoMetadata.c"
		QuickTimeMetadataLoader * object;
		object = collect_values[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1410 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1414 "VideoMetadata.c"
		}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = quick_time_metadata_loader_ref (object);
#line 1418 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1422 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 1426 "VideoMetadata.c"
}


static gchar*
value_quick_time_metadata_loader_lcopy_value (const GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	QuickTimeMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1442 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 1448 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 1452 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = quick_time_metadata_loader_ref (value->data[0].v_pointer);
#line 1456 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 1460 "VideoMetadata.c"
}


GParamSpec*
param_spec_quick_time_metadata_loader (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags)
{
	ParamSpecQuickTimeMetadataLoader* spec;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 1480 "VideoMetadata.c"
}


gpointer
value_get_quick_time_metadata_loader (const GValue* value)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER), NULL);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 1491 "VideoMetadata.c"
}


void
value_set_quick_time_metadata_loader (GValue* value,
                                      gpointer v_object)
{
	QuickTimeMetadataLoader * old;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_ref (value->data[0].v_pointer);
#line 1514 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1518 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (old);
#line 1524 "VideoMetadata.c"
	}
}


void
value_take_quick_time_metadata_loader (GValue* value,
                                       gpointer v_object)
{
	QuickTimeMetadataLoader * old;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_METADATA_LOADER));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 1546 "VideoMetadata.c"
	} else {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 1550 "VideoMetadata.c"
	}
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_metadata_loader_unref (old);
#line 1556 "VideoMetadata.c"
	}
}


static void
quick_time_metadata_loader_class_init (QuickTimeMetadataLoaderClass * klass)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_metadata_loader_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((QuickTimeMetadataLoaderClass *) klass)->finalize = quick_time_metadata_loader_finalize;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (QuickTimeMetadataLoaderPrivate));
#line 1570 "VideoMetadata.c"
}


static void
quick_time_metadata_loader_instance_init (QuickTimeMetadataLoader * self)
{
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = QUICK_TIME_METADATA_LOADER_GET_PRIVATE (self);
#line 59 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 1583 "VideoMetadata.c"
}


static void
quick_time_metadata_loader_finalize (QuickTimeMetadataLoader * obj)
{
	QuickTimeMetadataLoader * self;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_METADATA_LOADER, QuickTimeMetadataLoader);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 59 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 1597 "VideoMetadata.c"
}


GType
quick_time_metadata_loader_get_type (void)
{
	static volatile gsize quick_time_metadata_loader_type_id__volatile = 0;
	if (g_once_init_enter (&quick_time_metadata_loader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_quick_time_metadata_loader_init, value_quick_time_metadata_loader_free_value, value_quick_time_metadata_loader_copy_value, value_quick_time_metadata_loader_peek_pointer, "p", value_quick_time_metadata_loader_collect_value, "p", value_quick_time_metadata_loader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (QuickTimeMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeMetadataLoader), 0, (GInstanceInitFunc) quick_time_metadata_loader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType quick_time_metadata_loader_type_id;
		quick_time_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&quick_time_metadata_loader_type_id__volatile, quick_time_metadata_loader_type_id);
	}
	return quick_time_metadata_loader_type_id__volatile;
}


gpointer
quick_time_metadata_loader_ref (gpointer instance)
{
	QuickTimeMetadataLoader * self;
	self = instance;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 1626 "VideoMetadata.c"
}


void
quick_time_metadata_loader_unref (gpointer instance)
{
	QuickTimeMetadataLoader * self;
	self = instance;
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		QUICK_TIME_METADATA_LOADER_GET_CLASS (self)->finalize (self);
#line 53 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1641 "VideoMetadata.c"
	}
}


QuickTimeAtom*
quick_time_atom_construct (GType object_type,
                           GFile* file)
{
	QuickTimeAtom* self = NULL;
	GFile* _tmp0_;
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 182 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp0_;
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 1664 "VideoMetadata.c"
}


QuickTimeAtom*
quick_time_atom_new (GFile* file)
{
#line 181 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_atom_construct (TYPE_QUICK_TIME_ATOM, file);
#line 1673 "VideoMetadata.c"
}


static gpointer
_quick_time_atom_ref0 (gpointer self)
{
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? quick_time_atom_ref (self) : NULL;
#line 1682 "VideoMetadata.c"
}


static QuickTimeAtom*
quick_time_atom_construct_with_input_stream (GType object_type,
                                             GDataInputStream* input,
                                             QuickTimeAtom* parent)
{
	QuickTimeAtom* self = NULL;
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_DATA_INPUT_STREAM (input), NULL);
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (parent), NULL);
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (QuickTimeAtom*) g_type_create_instance (object_type);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (input);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 186 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _quick_time_atom_ref0 (parent);
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (self->priv->parent);
#line 187 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 1714 "VideoMetadata.c"
}


static QuickTimeAtom*
quick_time_atom_new_with_input_stream (GDataInputStream* input,
                                       QuickTimeAtom* parent)
{
#line 185 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return quick_time_atom_construct_with_input_stream (TYPE_QUICK_TIME_ATOM, input, parent);
#line 1724 "VideoMetadata.c"
}


void
quick_time_atom_open_file (QuickTimeAtom* self,
                           GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_close_file (self, &_inner_error_);
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 191 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1749 "VideoMetadata.c"
	}
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->file;
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 1763 "VideoMetadata.c"
	}
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 192 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp3_;
#line 193 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = self->priv->input;
#line 193 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
#line 194 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 195 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = g_strdup ("");
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 196 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp5_;
#line 190 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 1787 "VideoMetadata.c"
}


void
quick_time_atom_close_file (QuickTimeAtom* self,
                            GError** error)
{
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 200 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 200 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp0_) {
#line 1803 "VideoMetadata.c"
		GDataInputStream* _tmp1_;
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->input;
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 201 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 1815 "VideoMetadata.c"
		}
#line 202 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_object_unref0 (self->priv->input);
#line 202 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->input = NULL;
#line 1821 "VideoMetadata.c"
	}
}


static void
quick_time_atom_advance_section_offset (QuickTimeAtom* self,
                                        guint64 amount)
{
	guint64 _tmp0_;
	QuickTimeAtom* _tmp1_;
#line 206 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 207 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_offset;
#line 207 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = _tmp0_ + amount;
#line 208 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->parent;
#line 208 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp1_) {
#line 1842 "VideoMetadata.c"
		QuickTimeAtom* _tmp2_;
#line 209 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = self->priv->parent;
#line 209 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_advance_section_offset (_tmp2_, amount);
#line 1848 "VideoMetadata.c"
	}
}


QuickTimeAtom*
quick_time_atom_get_first_child_atom (QuickTimeAtom* self)
{
	QuickTimeAtom* result = NULL;
	GDataInputStream* _tmp0_;
	QuickTimeAtom* _tmp1_;
#line 213 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = quick_time_atom_new_with_input_stream (_tmp0_, self);
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 219 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1869 "VideoMetadata.c"
}


guchar
quick_time_atom_read_byte (QuickTimeAtom* self,
                           GError** error)
{
	guchar result = '\0';
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), '\0');
#line 223 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 1);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error_);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1891 "VideoMetadata.c"
		guchar _tmp2_ = '\0';
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp2_;
#line 1897 "VideoMetadata.c"
	}
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (guchar) _tmp0_;
#line 224 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1903 "VideoMetadata.c"
}


guint32
quick_time_atom_read_uint32 (QuickTimeAtom* self,
                             GError** error)
{
	guint32 result = 0U;
	guint32 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
#line 227 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0U);
#line 228 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 4);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_data_input_stream_read_uint32 (_tmp1_, NULL, &_inner_error_);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1925 "VideoMetadata.c"
		guint32 _tmp2_ = 0U;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp2_;
#line 1931 "VideoMetadata.c"
	}
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 229 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1937 "VideoMetadata.c"
}


guint64
quick_time_atom_read_uint64 (QuickTimeAtom* self,
                             GError** error)
{
	guint64 result = 0ULL;
	guint64 _tmp0_ = 0ULL;
	GDataInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
#line 232 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
#line 233 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_advance_section_offset (self, (guint64) 8);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_data_input_stream_read_uint64 (_tmp1_, NULL, &_inner_error_);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1959 "VideoMetadata.c"
		guint64 _tmp2_ = 0ULL;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp2_;
#line 1965 "VideoMetadata.c"
	}
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 234 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 1971 "VideoMetadata.c"
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
#line 1124 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 1125 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1989 "VideoMetadata.c"
}


void
quick_time_atom_read_atom (QuickTimeAtom* self,
                           GError** error)
{
	guint32 _tmp0_ = 0U;
	GString* sb = NULL;
	GString* _tmp1_;
	guchar _tmp2_ = '\0';
	GString* _tmp3_;
	guchar _tmp4_ = '\0';
	GString* _tmp5_;
	guchar _tmp6_ = '\0';
	GString* _tmp7_;
	guchar _tmp8_ = '\0';
	GString* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	guint64 _tmp34_;
	GError * _inner_error_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = quick_time_atom_read_uint32 (self, &_inner_error_);
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2026 "VideoMetadata.c"
	}
#line 239 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) _tmp0_;
#line 242 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_string_new ("");
#line 242 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp1_;
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2044 "VideoMetadata.c"
	}
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = sb;
#line 243 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp3_, (gchar) _tmp2_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2060 "VideoMetadata.c"
	}
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = sb;
#line 244 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp5_, (gchar) _tmp4_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2076 "VideoMetadata.c"
	}
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = sb;
#line 245 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp7_, (gchar) _tmp6_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = quick_time_atom_read_byte (self, &_inner_error_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2092 "VideoMetadata.c"
	}
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = sb;
#line 246 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp9_, (gchar) _tmp8_);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = sb;
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = _tmp10_->str;
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 247 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp12_;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = self->priv->section_name;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = strlen (_tmp13_);
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = _tmp14_;
#line 250 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp15_ != 4) {
#line 2116 "VideoMetadata.c"
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GError* _tmp19_;
		GError* _tmp20_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = self->priv->file;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = g_file_get_path (_tmp16_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp18_ = _tmp17_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "QuickTime atom name length is invalid for %s", _tmp18_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp20_ = _tmp19_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp18_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = _tmp20_;
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 251 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2142 "VideoMetadata.c"
	}
	{
		gint i = 0;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		i = 0;
#line 2148 "VideoMetadata.c"
		{
			gboolean _tmp21_ = FALSE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp21_ = TRUE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			while (TRUE) {
#line 2155 "VideoMetadata.c"
				gint _tmp23_;
				const gchar* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!_tmp21_) {
#line 2164 "VideoMetadata.c"
					gint _tmp22_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp22_ = i;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					i = _tmp22_ + 1;
#line 2170 "VideoMetadata.c"
				}
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp21_ = FALSE;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp23_ = i;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp24_ = self->priv->section_name;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp25_ = strlen (_tmp24_);
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp26_ = _tmp25_;
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!(_tmp23_ < _tmp26_)) {
#line 254 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					break;
#line 2186 "VideoMetadata.c"
				}
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp27_ = self->priv->section_name;
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp28_ = i;
#line 255 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (!g_ascii_isprint (string_get (_tmp27_, (glong) _tmp28_))) {
#line 2194 "VideoMetadata.c"
					GFile* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					GError* _tmp32_;
					GError* _tmp33_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp29_ = self->priv->file;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp30_ = g_file_get_path (_tmp29_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp31_ = _tmp30_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp32_ = g_error_new (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, "Bad QuickTime atom in file %s", _tmp31_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp33_ = _tmp32_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp31_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_inner_error_ = _tmp33_;
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_propagate_error (error, _inner_error_);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_string_free0 (sb);
#line 256 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return;
#line 2220 "VideoMetadata.c"
				}
			}
		}
	}
#line 260 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp34_ = self->priv->section_size;
#line 260 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (((guint64) 1) == _tmp34_) {
#line 2229 "VideoMetadata.c"
		guint64 _tmp35_ = 0ULL;
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp35_ = quick_time_atom_read_uint64 (self, &_inner_error_);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 2241 "VideoMetadata.c"
		}
#line 263 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->section_size = _tmp35_;
#line 2245 "VideoMetadata.c"
	}
#line 237 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 2249 "VideoMetadata.c"
}


static void
quick_time_atom_skip (QuickTimeAtom* self,
                      guint64 skip_amount,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 267 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error_);
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 268 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2272 "VideoMetadata.c"
	}
}


guint64
quick_time_atom_section_size_remaining (QuickTimeAtom* self)
{
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
#line 271 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), 0ULL);
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->section_offset;
#line 272 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "section_size >= section_offset");
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->section_size;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = self->priv->section_offset;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp2_ - _tmp3_;
#line 273 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2301 "VideoMetadata.c"
}


void
quick_time_atom_next_atom (QuickTimeAtom* self,
                           GError** error)
{
	GError * _inner_error_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_QUICK_TIME_ATOM (self));
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_skip (self, quick_time_atom_section_size_remaining (self), &_inner_error_);
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 277 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 2320 "VideoMetadata.c"
	}
#line 278 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 279 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 2326 "VideoMetadata.c"
}


gchar*
quick_time_atom_get_current_atom_name (QuickTimeAtom* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 282 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), NULL);
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_name;
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 283 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2346 "VideoMetadata.c"
}


gboolean
quick_time_atom_is_last_atom (QuickTimeAtom* self)
{
	gboolean result = FALSE;
	guint64 _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_QUICK_TIME_ATOM (self), FALSE);
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ((guint64) 0) == _tmp0_;
#line 287 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2363 "VideoMetadata.c"
}


static void
value_quick_time_atom_init (GValue* value)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 2372 "VideoMetadata.c"
}


static void
value_quick_time_atom_free_value (GValue* value)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (value->data[0].v_pointer);
#line 2383 "VideoMetadata.c"
	}
}


static void
value_quick_time_atom_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = quick_time_atom_ref (src_value->data[0].v_pointer);
#line 2396 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2400 "VideoMetadata.c"
	}
}


static gpointer
value_quick_time_atom_peek_pointer (const GValue* value)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 2410 "VideoMetadata.c"
}


static gchar*
value_quick_time_atom_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 2422 "VideoMetadata.c"
		QuickTimeAtom * object;
		object = collect_values[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2429 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2433 "VideoMetadata.c"
		}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = quick_time_atom_ref (object);
#line 2437 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2441 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 2445 "VideoMetadata.c"
}


static gchar*
value_quick_time_atom_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	QuickTimeAtom ** object_p;
	object_p = collect_values[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2461 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 2467 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 2471 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = quick_time_atom_ref (value->data[0].v_pointer);
#line 2475 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 2479 "VideoMetadata.c"
}


GParamSpec*
param_spec_quick_time_atom (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecQuickTimeAtom* spec;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_QUICK_TIME_ATOM), NULL);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 2499 "VideoMetadata.c"
}


gpointer
value_get_quick_time_atom (const GValue* value)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM), NULL);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 2510 "VideoMetadata.c"
}


void
value_set_quick_time_atom (GValue* value,
                           gpointer v_object)
{
	QuickTimeAtom * old;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_ref (value->data[0].v_pointer);
#line 2533 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2537 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (old);
#line 2543 "VideoMetadata.c"
	}
}


void
value_take_quick_time_atom (GValue* value,
                            gpointer v_object)
{
	QuickTimeAtom * old;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_QUICK_TIME_ATOM));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 2565 "VideoMetadata.c"
	} else {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 2569 "VideoMetadata.c"
	}
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		quick_time_atom_unref (old);
#line 2575 "VideoMetadata.c"
	}
}


static void
quick_time_atom_class_init (QuickTimeAtomClass * klass)
{
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	quick_time_atom_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((QuickTimeAtomClass *) klass)->finalize = quick_time_atom_finalize;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (QuickTimeAtomPrivate));
#line 2589 "VideoMetadata.c"
}


static void
quick_time_atom_instance_init (QuickTimeAtom * self)
{
	gchar* _tmp0_;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = QUICK_TIME_ATOM_GET_PRIVATE (self);
#line 174 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_strdup ("");
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp0_;
#line 176 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 177 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 178 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = NULL;
#line 179 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = NULL;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 2615 "VideoMetadata.c"
}


static void
quick_time_atom_finalize (QuickTimeAtom * obj)
{
	QuickTimeAtom * self;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_QUICK_TIME_ATOM, QuickTimeAtom);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 174 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 175 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 178 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 179 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_quick_time_atom_unref0 (self->priv->parent);
#line 2635 "VideoMetadata.c"
}


GType
quick_time_atom_get_type (void)
{
	static volatile gsize quick_time_atom_type_id__volatile = 0;
	if (g_once_init_enter (&quick_time_atom_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_quick_time_atom_init, value_quick_time_atom_free_value, value_quick_time_atom_copy_value, value_quick_time_atom_peek_pointer, "p", value_quick_time_atom_collect_value, "p", value_quick_time_atom_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (QuickTimeAtomClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) quick_time_atom_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (QuickTimeAtom), 0, (GInstanceInitFunc) quick_time_atom_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType quick_time_atom_type_id;
		quick_time_atom_type_id = g_type_register_fundamental (g_type_fundamental_next (), "QuickTimeAtom", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&quick_time_atom_type_id__volatile, quick_time_atom_type_id);
	}
	return quick_time_atom_type_id__volatile;
}


gpointer
quick_time_atom_ref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 2664 "VideoMetadata.c"
}


void
quick_time_atom_unref (gpointer instance)
{
	QuickTimeAtom * self;
	self = instance;
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		QUICK_TIME_ATOM_GET_CLASS (self)->finalize (self);
#line 173 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2679 "VideoMetadata.c"
	}
}


AVIMetadataLoader*
avi_metadata_loader_construct (GType object_type,
                               GFile* file)
{
	AVIMetadataLoader* self = NULL;
	GFile* _tmp0_;
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIMetadataLoader*) g_type_create_instance (object_type);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 306 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp0_;
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 2702 "VideoMetadata.c"
}


AVIMetadataLoader*
avi_metadata_loader_new (GFile* file)
{
#line 305 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_metadata_loader_construct (TYPE_AVI_METADATA_LOADER, file);
#line 2711 "VideoMetadata.c"
}


MetadataDateTime*
avi_metadata_loader_get_creation_date_time (AVIMetadataLoader* self)
{
	MetadataDateTime* result = NULL;
	MetadataDateTime* _tmp0_;
#line 309 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = metadata_date_time_new ((time_t) avi_metadata_loader_get_creation_date_time_for_avi (self));
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 310 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2728 "VideoMetadata.c"
}


gchar*
avi_metadata_loader_get_title (AVIMetadataLoader* self)
{
	gchar* result = NULL;
#line 313 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 315 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 315 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2742 "VideoMetadata.c"
}


gboolean
avi_metadata_loader_is_supported (AVIMetadataLoader* self)
{
	gboolean result = FALSE;
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), FALSE);
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new (_tmp0_);
#line 320 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	chunk = _tmp1_;
#line 321 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	ret = FALSE;
#line 2765 "VideoMetadata.c"
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gboolean _tmp4_ = FALSE;
		AVIChunk* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = chunk;
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_open_file (_tmp2_, &_inner_error_);
#line 323 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2780 "VideoMetadata.c"
			goto __catch590_g_error;
		}
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = chunk;
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_read_chunk (_tmp3_, &_inner_error_);
#line 324 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2789 "VideoMetadata.c"
			goto __catch590_g_error;
		}
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = chunk;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = avi_chunk_get_current_chunk_name (_tmp5_);
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = _tmp6_;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = g_strcmp0 ("RIFF", _tmp7_) == 0;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp7_);
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp8_) {
#line 2804 "VideoMetadata.c"
			gchar* _tmp9_ = NULL;
			AVIChunk* _tmp10_;
			gchar* _tmp11_;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = chunk;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp11_ = avi_chunk_read_name (_tmp10_, &_inner_error_);
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp11_;
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2816 "VideoMetadata.c"
				goto __catch590_g_error;
			}
#line 327 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = g_strcmp0 ("AVI ", _tmp9_) == 0;
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp9_);
#line 2823 "VideoMetadata.c"
		} else {
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = FALSE;
#line 2827 "VideoMetadata.c"
		}
#line 326 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp4_) {
#line 328 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			ret = TRUE;
#line 2833 "VideoMetadata.c"
		}
	}
	goto __finally590;
	__catch590_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = e;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = _tmp12_->message;
#line 331 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:331: Error while testing for AVI file: %s", _tmp13_);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 2854 "VideoMetadata.c"
	}
	__finally590:
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2859 "VideoMetadata.c"
		gboolean _tmp14_ = FALSE;
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 322 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp14_;
#line 2869 "VideoMetadata.c"
	}
	{
		AVIChunk* _tmp15_;
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = chunk;
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_close_file (_tmp15_, &_inner_error_);
#line 335 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2879 "VideoMetadata.c"
			goto __catch591_g_error;
		}
	}
	goto __finally591;
	__catch591_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = e;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp17_ = _tmp16_->message;
#line 337 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:337: Error while closing AVI file: %s", _tmp17_);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 2901 "VideoMetadata.c"
	}
	__finally591:
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2906 "VideoMetadata.c"
		gboolean _tmp18_ = FALSE;
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 334 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp18_;
#line 2916 "VideoMetadata.c"
	}
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = ret;
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (chunk);
#line 339 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 2924 "VideoMetadata.c"
}


static gchar*
avi_metadata_loader_read_nikon_nctg_tag (AVIMetadataLoader* self,
                                         AVIChunk* chunk,
                                         GError** error)
{
	gchar* result = NULL;
	gboolean found_date = FALSE;
	gboolean _tmp2_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
#line 343 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 343 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 344 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	found_date = FALSE;
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 2946 "VideoMetadata.c"
		guint16 tag = 0U;
		guint16 size = 0U;
		guint16 _tmp0_;
		guint16 _tmp1_;
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!(avi_chunk_section_size_remaining (chunk) > ((guint64) (sizeof (guint16) * 2)))) {
#line 345 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 2955 "VideoMetadata.c"
		}
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		tag = avi_chunk_read_uint16 (chunk, &_inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2965 "VideoMetadata.c"
		}
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		size = avi_chunk_read_uint16 (chunk, &_inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 347 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2975 "VideoMetadata.c"
		}
#line 348 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp0_ = tag;
#line 348 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (AVI_METADATA_LOADER_NIKON_NCTG_TIMESTAMP_MARKER == _tmp0_) {
#line 349 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			found_date = TRUE;
#line 350 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 2985 "VideoMetadata.c"
		}
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = size;
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_skip (chunk, (guint64) _tmp1_, &_inner_error_);
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 352 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 2997 "VideoMetadata.c"
		}
	}
#line 355 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = found_date;
#line 355 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp2_) {
#line 3004 "VideoMetadata.c"
		GString* sb = NULL;
		GString* _tmp3_;
		GString* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
#line 357 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = g_string_new ("");
#line 357 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sb = _tmp3_;
#line 3014 "VideoMetadata.c"
		{
			gint i = 0;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			i = 0;
#line 3019 "VideoMetadata.c"
			{
				gboolean _tmp4_ = FALSE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp4_ = TRUE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				while (TRUE) {
#line 3026 "VideoMetadata.c"
					gint _tmp6_;
					guchar _tmp7_ = '\0';
					GString* _tmp8_;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!_tmp4_) {
#line 3032 "VideoMetadata.c"
						gint _tmp5_;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_tmp5_ = i;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						i = _tmp5_ + 1;
#line 3038 "VideoMetadata.c"
					}
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp4_ = FALSE;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp6_ = i;
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (!(_tmp6_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH)) {
#line 358 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						break;
#line 3048 "VideoMetadata.c"
					}
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp7_ = avi_chunk_read_byte (chunk, &_inner_error_);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						g_propagate_error (error, _inner_error_);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_g_string_free0 (sb);
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						return NULL;
#line 3060 "VideoMetadata.c"
					}
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp8_ = sb;
#line 359 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_string_append_c (_tmp8_, (gchar) _tmp7_);
#line 3066 "VideoMetadata.c"
				}
			}
		}
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = sb;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = _tmp9_->str;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = _tmp11_;
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 361 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3082 "VideoMetadata.c"
	}
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = g_strdup ("");
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp12_;
#line 363 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3090 "VideoMetadata.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 3114 "VideoMetadata.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 3123 "VideoMetadata.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 3144 "VideoMetadata.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 3148 "VideoMetadata.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 3154 "VideoMetadata.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 3164 "VideoMetadata.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 3168 "VideoMetadata.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 3176 "VideoMetadata.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 3183 "VideoMetadata.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 3187 "VideoMetadata.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 3193 "VideoMetadata.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 3205 "VideoMetadata.c"
}


static gchar*
avi_metadata_loader_read_fuji_strd_tag (AVIMetadataLoader* self,
                                        AVIChunk* chunk,
                                        GError** error)
{
	gchar* result = NULL;
	gint colons = 0;
	gint post_colons = 0;
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GString* _tmp20_;
	const gchar* _tmp21_;
	GString* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gchar* _tmp26_;
	GError * _inner_error_ = NULL;
#line 368 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 368 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (chunk, (guint64) 98, &_inner_error_);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 369 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 3243 "VideoMetadata.c"
	}
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (chunk, (guint64) 8, &_inner_error_);
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 370 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 3253 "VideoMetadata.c"
	}
#line 372 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	colons = 0;
#line 373 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	post_colons = 0;
#line 374 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 374 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 3265 "VideoMetadata.c"
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		guchar _tmp4_ = '\0';
		gchar c = '\0';
		gint _tmp5_;
		gchar _tmp7_;
		gchar _tmp9_;
		GString* _tmp12_;
		gssize _tmp13_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = colons;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp2_ <= 4) {
#line 3279 "VideoMetadata.c"
			gint _tmp3_;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = post_colons;
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp1_ = _tmp3_ < 2;
#line 3285 "VideoMetadata.c"
		} else {
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp1_ = FALSE;
#line 3289 "VideoMetadata.c"
		}
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!_tmp1_) {
#line 376 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 3295 "VideoMetadata.c"
		}
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = avi_chunk_read_byte (chunk, &_inner_error_);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3307 "VideoMetadata.c"
		}
#line 377 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		c = (gchar) _tmp4_;
#line 378 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = colons;
#line 378 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (4 == _tmp5_) {
#line 3315 "VideoMetadata.c"
			gint _tmp6_;
#line 379 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp6_ = post_colons;
#line 379 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			post_colons = _tmp6_ + 1;
#line 3321 "VideoMetadata.c"
		}
#line 381 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = c;
#line 381 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (':' == _tmp7_) {
#line 3327 "VideoMetadata.c"
			gint _tmp8_;
#line 382 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = colons;
#line 382 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			colons = _tmp8_ + 1;
#line 3333 "VideoMetadata.c"
		}
#line 384 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = c;
#line 384 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (g_ascii_isprint (_tmp9_)) {
#line 3339 "VideoMetadata.c"
			GString* _tmp10_;
			gchar _tmp11_;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp10_ = sb;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp11_ = c;
#line 385 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_string_append_c (_tmp10_, _tmp11_);
#line 3348 "VideoMetadata.c"
		}
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = sb;
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = _tmp12_->len;
#line 387 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp13_ > ((gssize) AVI_METADATA_LOADER_MAX_STRD_LENGTH)) {
#line 3356 "VideoMetadata.c"
			gchar* _tmp14_;
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp14_ = g_strdup ("");
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp14_;
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 388 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3366 "VideoMetadata.c"
		}
	}
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = sb;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp16_ = _tmp15_->str;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp17_ = strlen (_tmp16_);
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp18_ = _tmp17_;
#line 392 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp18_ < AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH) {
#line 3379 "VideoMetadata.c"
		gchar* _tmp19_;
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp19_ = g_strdup ("");
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = _tmp19_;
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 393 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3389 "VideoMetadata.c"
	}
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = sb;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp21_ = _tmp20_->str;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp22_ = sb;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp23_ = _tmp22_->str;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp24_ = strlen (_tmp23_);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp25_ = _tmp24_;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp26_ = string_substring (_tmp21_, (glong) (_tmp25_ - AVI_METADATA_LOADER_NUMERICAL_DATE_LENGTH), (glong) -1);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp26_;
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 396 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3411 "VideoMetadata.c"
}


static gchar*
avi_metadata_loader_read_section (AVIMetadataLoader* self,
                                  AVIChunk* chunk,
                                  GError** error)
{
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 400 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), NULL);
#line 400 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (chunk), NULL);
#line 401 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 3428 "VideoMetadata.c"
		gchar* name = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp13_;
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_read_chunk (chunk, &_inner_error_);
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 402 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3441 "VideoMetadata.c"
		}
#line 403 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp0_ = avi_chunk_get_current_chunk_name (chunk);
#line 403 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		name = _tmp0_;
#line 404 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = name;
#line 404 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (g_strcmp0 ("IDIT", _tmp1_) == 0) {
#line 3451 "VideoMetadata.c"
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			gchar* _tmp4_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp3_ = avi_chunk_section_to_string (chunk, &_inner_error_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp2_ = _tmp3_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3467 "VideoMetadata.c"
			}
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp4_ = _tmp2_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp2_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp4_;
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp2_);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 405 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3481 "VideoMetadata.c"
		} else {
			const gchar* _tmp5_;
#line 406 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp5_ = name;
#line 406 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (g_strcmp0 ("nctg", _tmp5_) == 0) {
#line 3488 "VideoMetadata.c"
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gchar* _tmp8_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp7_ = avi_metadata_loader_read_nikon_nctg_tag (self, chunk, &_inner_error_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp6_ = _tmp7_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					g_propagate_error (error, _inner_error_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (name);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return NULL;
#line 3504 "VideoMetadata.c"
				}
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp8_ = _tmp6_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp6_ = NULL;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = _tmp8_;
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (_tmp6_);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 407 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3518 "VideoMetadata.c"
			} else {
				const gchar* _tmp9_;
#line 408 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_tmp9_ = name;
#line 408 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				if (g_strcmp0 ("strd", _tmp9_) == 0) {
#line 3525 "VideoMetadata.c"
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_;
					gchar* _tmp12_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp11_ = avi_metadata_loader_read_fuji_strd_tag (self, chunk, &_inner_error_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp10_ = _tmp11_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						g_propagate_error (error, _inner_error_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						_g_free0 (name);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
						return NULL;
#line 3541 "VideoMetadata.c"
					}
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp12_ = _tmp10_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_tmp10_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					result = _tmp12_;
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (_tmp10_);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					_g_free0 (name);
#line 409 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
					return result;
#line 3555 "VideoMetadata.c"
				}
			}
		}
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = name;
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (g_strcmp0 ("LIST", _tmp13_) == 0) {
#line 3563 "VideoMetadata.c"
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _result_ = NULL;
			AVIChunk* _tmp16_;
			AVIChunk* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp14_ = avi_chunk_read_name (chunk, &_inner_error_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp15_ = _tmp14_;
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp15_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 413 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3586 "VideoMetadata.c"
			}
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp16_ = avi_chunk_get_first_child_chunk (chunk);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp17_ = _tmp16_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp18_ = avi_metadata_loader_read_section (self, _tmp17_, &_inner_error_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp19_ = _tmp18_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_avi_chunk_unref0 (_tmp17_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_result_ = _tmp19_;
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				g_propagate_error (error, _inner_error_);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 414 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return NULL;
#line 3608 "VideoMetadata.c"
			}
#line 415 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp20_ = _result_;
#line 415 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			if (NULL != _tmp20_) {
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = _result_;
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				_g_free0 (name);
#line 416 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3620 "VideoMetadata.c"
			}
#line 412 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_result_);
#line 3624 "VideoMetadata.c"
		}
#line 420 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (avi_chunk_is_last_chunk (chunk)) {
#line 421 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 421 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 3632 "VideoMetadata.c"
		}
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_next_chunk (chunk, &_inner_error_);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (name);
#line 423 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 3644 "VideoMetadata.c"
		}
#line 401 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (name);
#line 3648 "VideoMetadata.c"
	}
#line 425 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = NULL;
#line 425 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3654 "VideoMetadata.c"
}


static gulong
avi_metadata_loader_parse_date (AVIMetadataLoader* self,
                                const gchar* sdate)
{
	gulong result = 0UL;
	gint _tmp0_;
	gint _tmp1_;
	GDate date = {0};
	guint seconds = 0U;
	gint year = 0;
	gint month = 0;
	gint day = 0;
	gint hour = 0;
	gint min = 0;
	gint sec = 0;
	gchar weekday[4] = {0};
	gchar monthstr[4] = {0};
	struct tm time = {0};
	struct tm _tmp17_ = {0};
	time_t tm = 0;
	gulong _result_ = 0UL;
	time_t _tmp18_;
	guint _tmp19_;
	gulong _tmp20_;
	time_t _tmp21_;
#line 432 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0UL);
#line 432 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (sdate != NULL, 0UL);
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = strlen (sdate);
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp1_ == 0) {
#line 434 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = (gulong) 0;
#line 434 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3697 "VideoMetadata.c"
	}
#line 437 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	memset (&date, 0, sizeof (GDate));
#line 438 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	seconds = (guint) 0;
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_ascii_isdigit (string_get (sdate, (glong) 0))) {
#line 3705 "VideoMetadata.c"
		gchar* tmp = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gint _result_ = 0;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 447 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = g_strdup (sdate);
#line 447 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		tmp = _tmp2_;
#line 448 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = tmp;
#line 448 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_strcanon (_tmp3_, "0123456789 ", ' ');
#line 449 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sec = 0;
#line 450 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = tmp;
#line 450 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_result_ = sscanf (_tmp4_, "%d %d %d %d %d %d", &year, &month, &day, &hour, &min, &sec);
#line 451 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = _result_;
#line 451 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp5_ < 5) {
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = (gulong) 0;
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (tmp);
#line 452 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3742 "VideoMetadata.c"
		}
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = day;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp7_ = month;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp8_ = year;
#line 454 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_date_set_dmy (&date, (GDateDay) _tmp6_, (gint) ((GDateMonth) _tmp7_), (GDateYear) _tmp8_);
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp9_ = sec;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = min;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = hour;
#line 455 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		seconds = (guint) ((_tmp9_ + (_tmp10_ * 60)) + (_tmp11_ * 3600));
#line 443 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (tmp);
#line 3762 "VideoMetadata.c"
	} else {
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 458 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (7 != sscanf (sdate, "%3s %3s %d %d:%d:%d %d", weekday, monthstr, &day, &hour, &min, &sec, &year)) {
#line 460 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = (gulong) 0;
#line 460 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 3775 "VideoMetadata.c"
		}
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp12_ = day;
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = year;
#line 462 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_date_set_dmy (&date, (GDateDay) _tmp12_, (gint) avi_metadata_loader_month_from_string (self, (const gchar*) monthstr), (GDateYear) _tmp13_);
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = sec;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = min;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp16_ = hour;
#line 463 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		seconds = (guint) ((_tmp14_ + (_tmp15_ * 60)) + (_tmp16_ * 3600));
#line 3791 "VideoMetadata.c"
	}
#line 466 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	memset (&time, 0, sizeof (struct tm));
#line 467 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_date_to_struct_tm (&date, &_tmp17_);
#line 467 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	time = _tmp17_;
#line 470 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	tm = mktime (&time);
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp18_ = tm;
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp19_ = seconds;
#line 471 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_result_ = (gulong) (_tmp18_ + _tmp19_);
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp20_ = _result_;
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp21_ = tm;
#line 472 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp20_ < ((gulong) _tmp21_)) {
#line 3813 "VideoMetadata.c"
		GFile* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp22_ = self->priv->file;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp23_ = g_file_get_path (_tmp22_);
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp24_ = _tmp23_;
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:473: Overflow for timestamp in video file %s", _tmp24_);
#line 473 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (_tmp24_);
#line 475 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		result = (gulong) 0;
#line 475 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return result;
#line 3831 "VideoMetadata.c"
	}
#line 478 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _result_;
#line 478 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 3837 "VideoMetadata.c"
}


static GDateMonth
avi_metadata_loader_month_from_string (AVIMetadataLoader* self,
                                       const gchar* s)
{
	GDateMonth result = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label0 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label1 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label2 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label3 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label4 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label5 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label6 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label7 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label8 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label9 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label10 = 0;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	static GQuark _tmp2_label11 = 0;
#line 481 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0);
#line 481 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (s != NULL, 0);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_utf8_strdown (s, (gssize) -1);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _tmp0_;
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_free (_tmp1_);
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("jan")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3889 "VideoMetadata.c"
			default:
			{
#line 484 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JANUARY;
#line 484 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3896 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("feb")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3902 "VideoMetadata.c"
			default:
			{
#line 486 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_FEBRUARY;
#line 486 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3909 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("mar")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3915 "VideoMetadata.c"
			default:
			{
#line 488 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_MARCH;
#line 488 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3922 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("apr")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3928 "VideoMetadata.c"
			default:
			{
#line 490 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_APRIL;
#line 490 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3935 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("may")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3941 "VideoMetadata.c"
			default:
			{
#line 492 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_MAY;
#line 492 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3948 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("jun")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3954 "VideoMetadata.c"
			default:
			{
#line 494 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JUNE;
#line 494 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3961 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("jul")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3967 "VideoMetadata.c"
			default:
			{
#line 496 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_JULY;
#line 496 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3974 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("aug")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3980 "VideoMetadata.c"
			default:
			{
#line 498 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_AUGUST;
#line 498 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 3987 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label8) ? _tmp2_label8 : (_tmp2_label8 = g_quark_from_static_string ("sep")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 3993 "VideoMetadata.c"
			default:
			{
#line 500 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_SEPTEMBER;
#line 500 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4000 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label9) ? _tmp2_label9 : (_tmp2_label9 = g_quark_from_static_string ("oct")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 4006 "VideoMetadata.c"
			default:
			{
#line 502 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_OCTOBER;
#line 502 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4013 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label10) ? _tmp2_label10 : (_tmp2_label10 = g_quark_from_static_string ("nov")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 4019 "VideoMetadata.c"
			default:
			{
#line 504 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_NOVEMBER;
#line 504 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4026 "VideoMetadata.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label11) ? _tmp2_label11 : (_tmp2_label11 = g_quark_from_static_string ("dec")))) {
#line 482 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		switch (0) {
#line 4032 "VideoMetadata.c"
			default:
			{
#line 506 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				result = G_DATE_DECEMBER;
#line 506 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
				return result;
#line 4039 "VideoMetadata.c"
			}
		}
	}
#line 508 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = G_DATE_BAD_MONTH;
#line 508 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4047 "VideoMetadata.c"
}


static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
#line 1248 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1249 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1250 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _result_;
#line 1251 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 4072 "VideoMetadata.c"
}


static gulong
avi_metadata_loader_get_creation_date_time_for_avi (AVIMetadataLoader* self)
{
	gulong result = 0UL;
	AVIChunk* chunk = NULL;
	GFile* _tmp0_;
	AVIChunk* _tmp1_;
	gulong timestamp = 0UL;
	GError * _inner_error_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_METADATA_LOADER (self), 0UL);
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->file;
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new (_tmp0_);
#line 512 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	chunk = _tmp1_;
#line 513 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	timestamp = (gulong) 0;
#line 4095 "VideoMetadata.c"
	{
		AVIChunk* _tmp2_;
		AVIChunk* _tmp3_;
		gchar* sdate = NULL;
		AVIChunk* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = chunk;
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_open_file (_tmp2_, &_inner_error_);
#line 515 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4109 "VideoMetadata.c"
			goto __catch592_g_error;
		}
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = chunk;
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_nonsection_skip (_tmp3_, (guint64) 12, &_inner_error_);
#line 516 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4118 "VideoMetadata.c"
			goto __catch592_g_error;
		}
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = chunk;
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = avi_metadata_loader_read_section (self, _tmp4_, &_inner_error_);
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		sdate = _tmp5_;
#line 517 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4129 "VideoMetadata.c"
			goto __catch592_g_error;
		}
#line 518 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = sdate;
#line 518 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (NULL != _tmp6_) {
#line 4136 "VideoMetadata.c"
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = sdate;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = string_strip (_tmp7_);
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = _tmp8_;
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			timestamp = avi_metadata_loader_parse_date (self, _tmp9_);
#line 519 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_free0 (_tmp9_);
#line 4150 "VideoMetadata.c"
		}
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_free0 (sdate);
#line 4154 "VideoMetadata.c"
	}
	goto __finally592;
	__catch592_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp10_ = e;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp11_ = _tmp10_->message;
#line 522 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:522: Error while reading AVI file: %s", _tmp11_);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 4174 "VideoMetadata.c"
	}
	__finally592:
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4179 "VideoMetadata.c"
		gulong _tmp12_ = 0UL;
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp12_;
#line 4189 "VideoMetadata.c"
	}
	{
		AVIChunk* _tmp13_;
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp13_ = chunk;
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_close_file (_tmp13_, &_inner_error_);
#line 526 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4199 "VideoMetadata.c"
			goto __catch593_g_error;
		}
	}
	goto __finally593;
	__catch593_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		e = _inner_error_;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_inner_error_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp14_ = e;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp15_ = _tmp14_->message;
#line 528 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_debug ("VideoMetadata.vala:528: Error while closing AVI file: %s", _tmp15_);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_error_free0 (e);
#line 4221 "VideoMetadata.c"
	}
	__finally593:
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4226 "VideoMetadata.c"
		gulong _tmp16_ = 0UL;
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_avi_chunk_unref0 (chunk);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_clear_error (&_inner_error_);
#line 525 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp16_;
#line 4236 "VideoMetadata.c"
	}
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = timestamp;
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (chunk);
#line 530 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4244 "VideoMetadata.c"
}


static void
value_avi_metadata_loader_init (GValue* value)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 4253 "VideoMetadata.c"
}


static void
value_avi_metadata_loader_free_value (GValue* value)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (value->data[0].v_pointer);
#line 4264 "VideoMetadata.c"
	}
}


static void
value_avi_metadata_loader_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = avi_metadata_loader_ref (src_value->data[0].v_pointer);
#line 4277 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4281 "VideoMetadata.c"
	}
}


static gpointer
value_avi_metadata_loader_peek_pointer (const GValue* value)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 4291 "VideoMetadata.c"
}


static gchar*
value_avi_metadata_loader_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 4303 "VideoMetadata.c"
		AVIMetadataLoader * object;
		object = collect_values[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4310 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4314 "VideoMetadata.c"
		}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = avi_metadata_loader_ref (object);
#line 4318 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4322 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 4326 "VideoMetadata.c"
}


static gchar*
value_avi_metadata_loader_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	AVIMetadataLoader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4342 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 4348 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 4352 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = avi_metadata_loader_ref (value->data[0].v_pointer);
#line 4356 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 4360 "VideoMetadata.c"
}


GParamSpec*
param_spec_avi_metadata_loader (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecAVIMetadataLoader* spec;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_METADATA_LOADER), NULL);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 4380 "VideoMetadata.c"
}


gpointer
value_get_avi_metadata_loader (const GValue* value)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER), NULL);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 4391 "VideoMetadata.c"
}


void
value_set_avi_metadata_loader (GValue* value,
                               gpointer v_object)
{
	AVIMetadataLoader * old;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_ref (value->data[0].v_pointer);
#line 4414 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4418 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (old);
#line 4424 "VideoMetadata.c"
	}
}


void
value_take_avi_metadata_loader (GValue* value,
                                gpointer v_object)
{
	AVIMetadataLoader * old;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_METADATA_LOADER));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 4446 "VideoMetadata.c"
	} else {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 4450 "VideoMetadata.c"
	}
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_metadata_loader_unref (old);
#line 4456 "VideoMetadata.c"
	}
}


static void
avi_metadata_loader_class_init (AVIMetadataLoaderClass * klass)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_metadata_loader_parent_class = g_type_class_peek_parent (klass);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((AVIMetadataLoaderClass *) klass)->finalize = avi_metadata_loader_finalize;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (AVIMetadataLoaderPrivate));
#line 4470 "VideoMetadata.c"
}


static void
avi_metadata_loader_instance_init (AVIMetadataLoader * self)
{
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = AVI_METADATA_LOADER_GET_PRIVATE (self);
#line 294 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 4483 "VideoMetadata.c"
}


static void
avi_metadata_loader_finalize (AVIMetadataLoader * obj)
{
	AVIMetadataLoader * self;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_METADATA_LOADER, AVIMetadataLoader);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 294 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 4497 "VideoMetadata.c"
}


GType
avi_metadata_loader_get_type (void)
{
	static volatile gsize avi_metadata_loader_type_id__volatile = 0;
	if (g_once_init_enter (&avi_metadata_loader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_avi_metadata_loader_init, value_avi_metadata_loader_free_value, value_avi_metadata_loader_copy_value, value_avi_metadata_loader_peek_pointer, "p", value_avi_metadata_loader_collect_value, "p", value_avi_metadata_loader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AVIMetadataLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_metadata_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIMetadataLoader), 0, (GInstanceInitFunc) avi_metadata_loader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType avi_metadata_loader_type_id;
		avi_metadata_loader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIMetadataLoader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&avi_metadata_loader_type_id__volatile, avi_metadata_loader_type_id);
	}
	return avi_metadata_loader_type_id__volatile;
}


gpointer
avi_metadata_loader_ref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 4526 "VideoMetadata.c"
}


void
avi_metadata_loader_unref (gpointer instance)
{
	AVIMetadataLoader * self;
	self = instance;
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		AVI_METADATA_LOADER_GET_CLASS (self)->finalize (self);
#line 292 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4541 "VideoMetadata.c"
	}
}


AVIChunk*
avi_chunk_construct (GType object_type,
                     GFile* file)
{
	AVIChunk* self = NULL;
	GFile* _tmp0_;
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIChunk*) g_type_create_instance (object_type);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (file);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 544 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = _tmp0_;
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 4564 "VideoMetadata.c"
}


AVIChunk*
avi_chunk_new (GFile* file)
{
#line 543 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_chunk_construct (TYPE_AVI_CHUNK, file);
#line 4573 "VideoMetadata.c"
}


static gpointer
_avi_chunk_ref0 (gpointer self)
{
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self ? avi_chunk_ref (self) : NULL;
#line 4582 "VideoMetadata.c"
}


static AVIChunk*
avi_chunk_construct_with_input_stream (GType object_type,
                                       GDataInputStream* input,
                                       AVIChunk* parent)
{
	AVIChunk* self = NULL;
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_IS_DATA_INPUT_STREAM (input), NULL);
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (parent), NULL);
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = (AVIChunk*) g_type_create_instance (object_type);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _g_object_ref0 (input);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 548 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp0_;
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = _avi_chunk_ref0 (parent);
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (self->priv->parent);
#line 549 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = _tmp1_;
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return self;
#line 4614 "VideoMetadata.c"
}


static AVIChunk*
avi_chunk_new_with_input_stream (GDataInputStream* input,
                                 AVIChunk* parent)
{
#line 547 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return avi_chunk_construct_with_input_stream (TYPE_AVI_CHUNK, input, parent);
#line 4624 "VideoMetadata.c"
}


void
avi_chunk_open_file (AVIChunk* self,
                     GError** error)
{
	GFileInputStream* _tmp0_ = NULL;
	GFile* _tmp1_;
	GFileInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 552 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_close_file (self, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 553 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4649 "VideoMetadata.c"
	}
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->file;
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = g_file_read (_tmp1_, NULL, &_inner_error_);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = _tmp2_;
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4663 "VideoMetadata.c"
	}
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = g_data_input_stream_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream));
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 554 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = _tmp3_;
#line 555 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = self->priv->input;
#line 555 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_data_input_stream_set_byte_order (_tmp4_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
#line 556 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 557 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = g_strdup ("");
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 558 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp5_;
#line 552 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (_tmp0_);
#line 4687 "VideoMetadata.c"
}


void
avi_chunk_close_file (AVIChunk* self,
                      GError** error)
{
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 561 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 562 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 562 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp0_) {
#line 4703 "VideoMetadata.c"
		GDataInputStream* _tmp1_;
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->input;
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 563 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return;
#line 4715 "VideoMetadata.c"
		}
#line 564 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_object_unref0 (self->priv->input);
#line 564 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		self->priv->input = NULL;
#line 4721 "VideoMetadata.c"
	}
}


void
avi_chunk_nonsection_skip (AVIChunk* self,
                           guint64 skip_amount,
                           GError** error)
{
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 568 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error_);
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 569 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4745 "VideoMetadata.c"
	}
}


void
avi_chunk_skip (AVIChunk* self,
                guint64 skip_amount,
                GError** error)
{
	GDataInputStream* _tmp0_;
	GError * _inner_error_ = NULL;
#line 572 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 573 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, skip_amount);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	skip_uint64 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_input_stream_get_type (), GInputStream), skip_amount, &_inner_error_);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 574 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4771 "VideoMetadata.c"
	}
}


AVIChunk*
avi_chunk_get_first_child_chunk (AVIChunk* self)
{
	AVIChunk* result = NULL;
	GDataInputStream* _tmp0_;
	AVIChunk* _tmp1_;
#line 577 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->input;
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_new_with_input_stream (_tmp0_, self);
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 578 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4792 "VideoMetadata.c"
}


static void
avi_chunk_advance_section_offset (AVIChunk* self,
                                  guint64 amount)
{
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp4_;
	AVIChunk* _tmp5_;
#line 581 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_offset;
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->section_size;
#line 582 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if ((_tmp0_ + amount) > _tmp1_) {
#line 4812 "VideoMetadata.c"
		guint64 _tmp2_;
		guint64 _tmp3_;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = self->priv->section_size;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = self->priv->section_offset;
#line 583 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		amount = _tmp2_ - _tmp3_;
#line 4821 "VideoMetadata.c"
	}
#line 585 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = self->priv->section_offset;
#line 585 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = _tmp4_ + amount;
#line 586 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = self->priv->parent;
#line 586 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (NULL != _tmp5_) {
#line 4831 "VideoMetadata.c"
		AVIChunk* _tmp6_;
#line 587 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = self->priv->parent;
#line 587 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_advance_section_offset (_tmp6_, amount);
#line 4837 "VideoMetadata.c"
	}
}


guchar
avi_chunk_read_byte (AVIChunk* self,
                     GError** error)
{
	guchar result = '\0';
	guint8 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
#line 591 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), '\0');
#line 592 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, (guint64) 1);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4860 "VideoMetadata.c"
		guchar _tmp2_ = '\0';
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp2_;
#line 4866 "VideoMetadata.c"
	}
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = (guchar) _tmp0_;
#line 593 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4872 "VideoMetadata.c"
}


guint16
avi_chunk_read_uint16 (AVIChunk* self,
                       GError** error)
{
	guint16 result = 0U;
	guint16 _tmp0_ = 0U;
	GDataInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
#line 596 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0U);
#line 597 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_advance_section_offset (self, (guint64) 2);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->input;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_data_input_stream_read_uint16 (_tmp1_, NULL, &_inner_error_);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4894 "VideoMetadata.c"
		guint16 _tmp2_ = 0U;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return _tmp2_;
#line 4900 "VideoMetadata.c"
	}
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_;
#line 598 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 4906 "VideoMetadata.c"
}


void
avi_chunk_read_chunk (AVIChunk* self,
                      GError** error)
{
	GString* sb = NULL;
	GString* _tmp0_;
	guint8 _tmp1_ = 0U;
	GDataInputStream* _tmp2_;
	GString* _tmp3_;
	guint8 _tmp4_ = 0U;
	GDataInputStream* _tmp5_;
	GString* _tmp6_;
	guint8 _tmp7_ = 0U;
	GDataInputStream* _tmp8_;
	GString* _tmp9_;
	guint8 _tmp10_ = 0U;
	GDataInputStream* _tmp11_;
	GString* _tmp12_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	guint32 _tmp16_ = 0U;
	GDataInputStream* _tmp17_;
	GError * _inner_error_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 604 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 604 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->input;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4952 "VideoMetadata.c"
	}
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = sb;
#line 605 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp3_, (gchar) _tmp1_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = self->priv->input;
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = g_data_input_stream_read_byte (_tmp5_, NULL, &_inner_error_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4970 "VideoMetadata.c"
	}
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = sb;
#line 606 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp6_, (gchar) _tmp4_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = self->priv->input;
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = g_data_input_stream_read_byte (_tmp8_, NULL, &_inner_error_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 4988 "VideoMetadata.c"
	}
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = sb;
#line 607 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp9_, (gchar) _tmp7_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = self->priv->input;
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = g_data_input_stream_read_byte (_tmp11_, NULL, &_inner_error_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 5006 "VideoMetadata.c"
	}
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = sb;
#line 608 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp12_, (gchar) _tmp10_);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp13_ = sb;
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp14_ = _tmp13_->str;
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 609 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp15_;
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp17_ = self->priv->input;
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp16_ = g_data_input_stream_read_uint32 (_tmp17_, NULL, &_inner_error_);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 5034 "VideoMetadata.c"
	}
#line 610 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) _tmp16_;
#line 611 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 601 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 5042 "VideoMetadata.c"
}


gchar*
avi_chunk_read_name (AVIChunk* self,
                     GError** error)
{
	gchar* result = NULL;
	GString* sb = NULL;
	GString* _tmp0_;
	guchar _tmp1_ = '\0';
	GString* _tmp2_;
	guchar _tmp3_ = '\0';
	GString* _tmp4_;
	guchar _tmp5_ = '\0';
	GString* _tmp6_;
	guchar _tmp7_ = '\0';
	GString* _tmp8_;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError * _inner_error_ = NULL;
#line 614 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 615 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 615 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = avi_chunk_read_byte (self, &_inner_error_);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5081 "VideoMetadata.c"
	}
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = sb;
#line 616 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp2_, (gchar) _tmp1_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = avi_chunk_read_byte (self, &_inner_error_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5097 "VideoMetadata.c"
	}
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp4_ = sb;
#line 617 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp4_, (gchar) _tmp3_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp5_ = avi_chunk_read_byte (self, &_inner_error_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5113 "VideoMetadata.c"
	}
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp6_ = sb;
#line 618 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp6_, (gchar) _tmp5_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp7_ = avi_chunk_read_byte (self, &_inner_error_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_g_string_free0 (sb);
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return NULL;
#line 5129 "VideoMetadata.c"
	}
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp8_ = sb;
#line 619 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_string_append_c (_tmp8_, (gchar) _tmp7_);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp9_ = sb;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = _tmp9_->str;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = g_strdup (_tmp10_);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp11_;
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 620 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5147 "VideoMetadata.c"
}


void
avi_chunk_next_chunk (AVIChunk* self,
                      GError** error)
{
	GError * _inner_error_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (IS_AVI_CHUNK (self));
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_skip (self, avi_chunk_section_size_remaining (self), &_inner_error_);
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_propagate_error (error, _inner_error_);
#line 624 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return;
#line 5166 "VideoMetadata.c"
	}
#line 625 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 626 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 5172 "VideoMetadata.c"
}


gchar*
avi_chunk_get_current_chunk_name (AVIChunk* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 629 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_name;
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp1_;
#line 630 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5192 "VideoMetadata.c"
}


gboolean
avi_chunk_is_last_chunk (AVIChunk* self)
{
	gboolean result = FALSE;
	guint64 _tmp0_;
#line 633 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), FALSE);
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp0_ == ((guint64) 0);
#line 634 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5209 "VideoMetadata.c"
}


guint64
avi_chunk_section_size_remaining (AVIChunk* self)
{
	guint64 result = 0ULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
#line 637 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), 0ULL);
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = self->priv->section_size;
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp1_ = self->priv->section_offset;
#line 638 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_vala_assert (_tmp0_ >= _tmp1_, "section_size >= section_offset");
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp2_ = self->priv->section_size;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp3_ = self->priv->section_offset;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp2_ - _tmp3_;
#line 639 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5237 "VideoMetadata.c"
}


gchar*
avi_chunk_section_to_string (AVIChunk* self,
                             GError** error)
{
	gchar* result = NULL;
	GString* sb = NULL;
	GString* _tmp0_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
#line 643 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (IS_AVI_CHUNK (self), NULL);
#line 644 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_string_new ("");
#line 644 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	sb = _tmp0_;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	while (TRUE) {
#line 5260 "VideoMetadata.c"
		guint64 _tmp1_;
		guint64 _tmp2_;
		guchar _tmp3_ = '\0';
		GString* _tmp4_;
		GString* _tmp5_;
		gssize _tmp6_;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp1_ = self->priv->section_offset;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp2_ = self->priv->section_size;
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (!(_tmp1_ < _tmp2_)) {
#line 645 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			break;
#line 5275 "VideoMetadata.c"
		}
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp3_ = avi_chunk_read_byte (self, &_inner_error_);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			g_propagate_error (error, _inner_error_);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return NULL;
#line 5287 "VideoMetadata.c"
		}
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp4_ = sb;
#line 646 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_string_append_c (_tmp4_, (gchar) _tmp3_);
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp5_ = sb;
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		_tmp6_ = _tmp5_->len;
#line 647 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (_tmp6_ > ((gssize) AVI_CHUNK_MAX_STRING_TO_SECTION_LENGTH)) {
#line 5299 "VideoMetadata.c"
			GString* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp7_ = sb;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp8_ = _tmp7_->str;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			result = _tmp9_;
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			_g_string_free0 (sb);
#line 648 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return result;
#line 5315 "VideoMetadata.c"
		}
	}
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp10_ = sb;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp11_ = _tmp10_->str;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp12_ = g_strdup (_tmp11_);
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	result = _tmp12_;
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_string_free0 (sb);
#line 651 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return result;
#line 5330 "VideoMetadata.c"
}


static void
value_avi_chunk_init (GValue* value)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	value->data[0].v_pointer = NULL;
#line 5339 "VideoMetadata.c"
}


static void
value_avi_chunk_free_value (GValue* value)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (value->data[0].v_pointer);
#line 5350 "VideoMetadata.c"
	}
}


static void
value_avi_chunk_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (src_value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = avi_chunk_ref (src_value->data[0].v_pointer);
#line 5363 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		dest_value->data[0].v_pointer = NULL;
#line 5367 "VideoMetadata.c"
	}
}


static gpointer
value_avi_chunk_peek_pointer (const GValue* value)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 5377 "VideoMetadata.c"
}


static gchar*
value_avi_chunk_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (collect_values[0].v_pointer) {
#line 5389 "VideoMetadata.c"
		AVIChunk * object;
		object = collect_values[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		if (object->parent_instance.g_class == NULL) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5396 "VideoMetadata.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 5400 "VideoMetadata.c"
		}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = avi_chunk_ref (object);
#line 5404 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5408 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 5412 "VideoMetadata.c"
}


static gchar*
value_avi_chunk_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	AVIChunk ** object_p;
	object_p = collect_values[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!object_p) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 5428 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (!value->data[0].v_pointer) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = NULL;
#line 5434 "VideoMetadata.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = value->data[0].v_pointer;
#line 5438 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		*object_p = avi_chunk_ref (value->data[0].v_pointer);
#line 5442 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return NULL;
#line 5446 "VideoMetadata.c"
}


GParamSpec*
param_spec_avi_chunk (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecAVIChunk* spec;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_AVI_CHUNK), NULL);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return G_PARAM_SPEC (spec);
#line 5466 "VideoMetadata.c"
}


gpointer
value_get_avi_chunk (const GValue* value)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK), NULL);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return value->data[0].v_pointer;
#line 5477 "VideoMetadata.c"
}


void
value_set_avi_chunk (GValue* value,
                     gpointer v_object)
{
	AVIChunk * old;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_ref (value->data[0].v_pointer);
#line 5500 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5504 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (old);
#line 5510 "VideoMetadata.c"
	}
}


void
value_take_avi_chunk (GValue* value,
                      gpointer v_object)
{
	AVIChunk * old;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	old = value->data[0].v_pointer;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (v_object) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_AVI_CHUNK));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = v_object;
#line 5532 "VideoMetadata.c"
	} else {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		value->data[0].v_pointer = NULL;
#line 5536 "VideoMetadata.c"
	}
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (old) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		avi_chunk_unref (old);
#line 5542 "VideoMetadata.c"
	}
}


static void
avi_chunk_class_init (AVIChunkClass * klass)
{
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	avi_chunk_parent_class = g_type_class_peek_parent (klass);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	((AVIChunkClass *) klass)->finalize = avi_chunk_finalize;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_type_class_add_private (klass, sizeof (AVIChunkPrivate));
#line 5556 "VideoMetadata.c"
}


static void
avi_chunk_instance_init (AVIChunk * self)
{
	gchar* _tmp0_;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv = AVI_CHUNK_GET_PRIVATE (self);
#line 535 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->file = NULL;
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_tmp0_ = g_strdup ("");
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_name = _tmp0_;
#line 537 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_size = (guint64) 0;
#line 538 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->section_offset = (guint64) 0;
#line 539 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->input = NULL;
#line 540 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->priv->parent = NULL;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self->ref_count = 1;
#line 5582 "VideoMetadata.c"
}


static void
avi_chunk_finalize (AVIChunk * obj)
{
	AVIChunk * self;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVI_CHUNK, AVIChunk);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_signal_handlers_destroy (self);
#line 535 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->file);
#line 536 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_free0 (self->priv->section_name);
#line 539 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_g_object_unref0 (self->priv->input);
#line 540 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	_avi_chunk_unref0 (self->priv->parent);
#line 5602 "VideoMetadata.c"
}


GType
avi_chunk_get_type (void)
{
	static volatile gsize avi_chunk_type_id__volatile = 0;
	if (g_once_init_enter (&avi_chunk_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_avi_chunk_init, value_avi_chunk_free_value, value_avi_chunk_copy_value, value_avi_chunk_peek_pointer, "p", value_avi_chunk_collect_value, "p", value_avi_chunk_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (AVIChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avi_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AVIChunk), 0, (GInstanceInitFunc) avi_chunk_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType avi_chunk_type_id;
		avi_chunk_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AVIChunk", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&avi_chunk_type_id__volatile, avi_chunk_type_id);
	}
	return avi_chunk_type_id__volatile;
}


gpointer
avi_chunk_ref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	g_atomic_int_inc (&self->ref_count);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	return instance;
#line 5631 "VideoMetadata.c"
}


void
avi_chunk_unref (gpointer instance)
{
	AVIChunk * self;
	self = instance;
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		AVI_CHUNK_GET_CLASS (self)->finalize (self);
#line 534 "/home/jens/Source/shotwell/src/VideoMetadata.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 5646 "VideoMetadata.c"
	}
}



