/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8020842
 * @summary SNIHostName does not throw IAE when hostname ends
 *          with a trailing dot
 */

import javax.net.ssl.SNIHostName;

public class IllegalSNIName {

    public static void main(String[] args) throws Exception {
        String[] illegalNames = {
                "example\u3002\u3002com",
                "example..com",
                "com\u3002",
                "com.",
                "."
            };

        for (String name : illegalNames) {
            try {
                SNIHostName hostname = new SNIHostName(name);
                throw new Exception(
                    "Expected to get IllegalArgumentException for " + name);
            } catch (IllegalArgumentException iae) {
                // That's the right behavior.
            }
        }
    }
}
