/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/DocXml/CafCoreTypesXml/AttachmentCollectionXml.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderBatchXml.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderRequestHeaderXml.h"

#include "Doc/CafCoreTypesDoc/CAttachmentCollectionDoc.h"
#include "Doc/ProviderRequestDoc/CProviderBatchDoc.h"
#include "Doc/ProviderRequestDoc/CProviderRequestDoc.h"
#include "Doc/ProviderRequestDoc/CProviderRequestHeaderDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/ProviderRequestXml/ProviderRequestXml.h"

using namespace Caf;

void ProviderRequestXml::add(
	const SmartPtrCProviderRequestDoc providerRequestDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRequestXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(providerRequestDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdVal =
			BasePlatform::UuidToString(providerRequestDoc->getClientId());
		CAF_CM_VALIDATE_STRING(clientIdVal);
		thisXml->addAttribute("clientId", clientIdVal);

		const std::string requestIdVal =
			BasePlatform::UuidToString(providerRequestDoc->getRequestId());
		CAF_CM_VALIDATE_STRING(requestIdVal);
		thisXml->addAttribute("requestId", requestIdVal);

		const std::string pmeIdVal = providerRequestDoc->getPmeId();
		CAF_CM_VALIDATE_STRING(pmeIdVal);
		thisXml->addAttribute("pmeId", pmeIdVal);

		const SmartPtrCProviderRequestHeaderDoc requestHeaderVal =
			providerRequestDoc->getRequestHeader();
		CAF_CM_VALIDATE_SMARTPTR(requestHeaderVal);

		const SmartPtrCXmlElement requestHeaderXml =
			thisXml->createAndAddElement("requestHeader");
		ProviderRequestHeaderXml::add(requestHeaderVal, requestHeaderXml);

		const SmartPtrCProviderBatchDoc batchVal =
			providerRequestDoc->getBatch();
		CAF_CM_VALIDATE_SMARTPTR(batchVal);

		const SmartPtrCXmlElement batchXml =
			thisXml->createAndAddElement("batch");
		ProviderBatchXml::add(batchVal, batchXml);

		const SmartPtrCAttachmentCollectionDoc attachmentCollectionVal =
			providerRequestDoc->getAttachmentCollection();
		if (! attachmentCollectionVal.IsNull()) {
			const SmartPtrCXmlElement attachmentCollectionXml =
				thisXml->createAndAddElement("attachmentCollection");
			AttachmentCollectionXml::add(attachmentCollectionVal, attachmentCollectionXml);
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProviderRequestDoc ProviderRequestXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProviderRequestXml", "parse");

	SmartPtrCProviderRequestDoc providerRequestDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string clientIdStrVal =
			thisXml->findRequiredAttribute("clientId");
		UUID clientIdVal = CAFCOMMON_GUID_NULL;
		if (! clientIdStrVal.empty()) {
			BasePlatform::UuidFromString(clientIdStrVal.c_str(), clientIdVal);
		}

		const std::string requestIdStrVal =
			thisXml->findRequiredAttribute("requestId");
		UUID requestIdVal = CAFCOMMON_GUID_NULL;
		if (! requestIdStrVal.empty()) {
			BasePlatform::UuidFromString(requestIdStrVal.c_str(), requestIdVal);
		}

		const std::string pmeIdVal =
			thisXml->findRequiredAttribute("pmeId");

		const SmartPtrCXmlElement requestHeaderXml =
			thisXml->findRequiredChild("requestHeader");

		SmartPtrCProviderRequestHeaderDoc requestHeaderVal;
		if (! requestHeaderXml.IsNull()) {
			requestHeaderVal = ProviderRequestHeaderXml::parse(requestHeaderXml);
		}

		const SmartPtrCXmlElement batchXml =
			thisXml->findRequiredChild("batch");

		SmartPtrCProviderBatchDoc batchVal;
		if (! batchXml.IsNull()) {
			batchVal = ProviderBatchXml::parse(batchXml);
		}

		const SmartPtrCXmlElement attachmentCollectionXml =
			thisXml->findOptionalChild("attachmentCollection");

		SmartPtrCAttachmentCollectionDoc attachmentCollectionVal;
		if (! attachmentCollectionXml.IsNull()) {
			attachmentCollectionVal = AttachmentCollectionXml::parse(attachmentCollectionXml);
		}

		providerRequestDoc.CreateInstance();
		providerRequestDoc->initialize(
			clientIdVal,
			requestIdVal,
			pmeIdVal,
			requestHeaderVal,
			batchVal,
			attachmentCollectionVal);
	}
	CAF_CM_EXIT;

	return providerRequestDoc;
}

