# Netplan documentation

```{toctree}
---
maxdepth: 2
hidden: true
---
tutorial
howto
reference
explanation
```

**Netplan** is a network configuration abstraction renderer.

It is a **utility for network configuration** on a Linux system. You create a
description of the required interfaces and define what each should do.

Netplan meets the need of **easy, descriptive network configuration** in YAML
across a versatile set of server, desktop, cloud or IoT installations.

It is useful for **administrators of a Linux system** who want to use a common
network configuration, controlling different back ends like NetworkManager or
systemd-networkd.

## In this documentation

::::{grid} 1 1 2 2

:::{grid-item-card} **[Tutorial](/netplan-tutorial)**
:link: /netplan-tutorial
:link-type: doc

**Get started** - hands-on introduction to Netplan for new users
:::
:::{grid-item-card} **[How-to guides](/howto)**
:link: /howto
:link-type: doc

**Step-by-step guides** covering key operations and common tasks
:::
::::

::::{grid} 1 1 2 2
:reverse:

:::{grid-item-card} **[Reference](/reference)**
:link: /reference
:link-type: doc

**Technical information** - specifications, APIs, architecture
:::
:::{grid-item-card} **[Explanation](/explanation)**
:link: /explanation
:link-type: doc

**Discussion and clarification** of key topics
:::
::::

## Project and community

Netplan is a member of the Ubuntu family. It’s an open source project that
warmly welcomes community contributions, suggestions, fixes and constructive
feedback.

* **[Read our code of conduct](https://ubuntu.com/community/ethos/code-of-conduct)**:
As a community we adhere to the Ubuntu code of conduct.

* **[Get support](https://askubuntu.com/questions/tagged/netplan)**:
Ask Ubuntu is a question and answer site for Ubuntu users and developers.

* **[Join our online chat](https://web.libera.chat/gamja/?channels=%23netplan)**:
Meet us in `#netplan` on IRC Libera.Chat.

* **[Report bugs](https://bugs.launchpad.net/netplan/+filebug)**:
We want to know about the problems so we can fix them.

* **[Contribute code](https://github.com/canonical/netplan)**:
The code is open and we are open to accepting changes to it.

Thinking about using Netplan? [Get in touch!](https://netplan.io)
