; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S -data-layout=e-n32 | FileCheck %s --check-prefix=ALL --check-prefix=LE
; RUN: opt < %s -passes=instcombine -S -data-layout=E-n32 | FileCheck %s --check-prefix=ALL --check-prefix=BE

declare i32 @memcmp(ptr, ptr, i64)

; The alignment of this constant does not matter. We constant fold the load.

@charbuf = private unnamed_addr constant [4 x i8] [i8 0, i8 0, i8 0, i8 1], align 1

define i1 @memcmp_4bytes_unaligned_constant_i8(ptr align 4 %x) {
; LE-LABEL: @memcmp_4bytes_unaligned_constant_i8(
; LE-NEXT:    [[LHSV:%.*]] = load i32, ptr [[X:%.*]], align 4
; LE-NEXT:    [[DOTNOT:%.*]] = icmp eq i32 [[LHSV]], 16777216
; LE-NEXT:    ret i1 [[DOTNOT]]
;
; BE-LABEL: @memcmp_4bytes_unaligned_constant_i8(
; BE-NEXT:    [[LHSV:%.*]] = load i32, ptr [[X:%.*]], align 4
; BE-NEXT:    [[DOTNOT:%.*]] = icmp eq i32 [[LHSV]], 1
; BE-NEXT:    ret i1 [[DOTNOT]]
;
  %call = tail call i32 @memcmp(ptr %x, ptr @charbuf, i64 4)
  %cmpeq0 = icmp eq i32 %call, 0
  ret i1 %cmpeq0
}

; We still don't care about alignment of the constant. We are not limited to constant folding only i8 arrays.
; It doesn't matter if the constant operand is the first operand to the memcmp.

@intbuf_unaligned = private unnamed_addr constant [4 x i16] [i16 1, i16 2, i16 3, i16 4], align 1

define i1 @memcmp_4bytes_unaligned_constant_i16(ptr align 4 %x) {
; LE-LABEL: @memcmp_4bytes_unaligned_constant_i16(
; LE-NEXT:    [[RHSV:%.*]] = load i32, ptr [[X:%.*]], align 4
; LE-NEXT:    [[DOTNOT:%.*]] = icmp eq i32 [[RHSV]], 131073
; LE-NEXT:    ret i1 [[DOTNOT]]
;
; BE-LABEL: @memcmp_4bytes_unaligned_constant_i16(
; BE-NEXT:    [[RHSV:%.*]] = load i32, ptr [[X:%.*]], align 4
; BE-NEXT:    [[DOTNOT:%.*]] = icmp eq i32 [[RHSV]], 65538
; BE-NEXT:    ret i1 [[DOTNOT]]
;
  %call = tail call i32 @memcmp(ptr @intbuf_unaligned, ptr %x, i64 4)
  %cmpeq0 = icmp eq i32 %call, 0
  ret i1 %cmpeq0
}

; Verif that a memcmp call where all arguments are constants is constant
; folded even for arrays of other types than i8.

@intbuf = private unnamed_addr constant [2 x i32] [i32 0, i32 1], align 4

define i1 @memcmp_3bytes_aligned_constant_i32(ptr align 4 %x) {
; LE-LABEL: @memcmp_3bytes_aligned_constant_i32(
; LE-NEXT:    ret i1 false
;
; BE-LABEL: @memcmp_3bytes_aligned_constant_i32(
; BE-NEXT:    ret i1 true
;
  %call = tail call i32 @memcmp(ptr getelementptr inbounds ([2 x i32], ptr @intbuf, i64 0, i64 1), ptr @intbuf, i64 3)
  %cmpeq0 = icmp eq i32 %call, 0
  ret i1 %cmpeq0
}

; A sloppy implementation would infinite loop by recreating the unused instructions.

define i1 @memcmp_4bytes_one_unaligned_i8(ptr align 4 %x, ptr align 1 %y) {
; ALL-LABEL: @memcmp_4bytes_one_unaligned_i8(
; ALL-NEXT:    [[CALL:%.*]] = tail call i32 @memcmp(ptr noundef nonnull dereferenceable(4) [[X:%.*]], ptr noundef nonnull dereferenceable(4) [[Y:%.*]], i64 4)
; ALL-NEXT:    [[CMPEQ0:%.*]] = icmp eq i32 [[CALL]], 0
; ALL-NEXT:    ret i1 [[CMPEQ0]]
;
  %lhsv = load i32, ptr %x
  %call = tail call i32 @memcmp(ptr %x, ptr %y, i64 4)
  %cmpeq0 = icmp eq i32 %call, 0
  ret i1 %cmpeq0
}

