;; Pipeline description for Freescale PowerPC e5500 core.
;;   Copyright (C) 2012-2014 Free Software Foundation, Inc.
;;   Contributed by Edmar Wienskoski (edmar@freescale.com)
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.
;;
;; e5500 64-bit SFX(2), CFX, LSU, FPU, BU
;; Max issue 3 insns/clock cycle (includes 1 branch)

(define_automaton "e5500_most,e5500_long")
(define_cpu_unit "e5500_decode_0,e5500_decode_1" "e5500_most")

;; SFX.
(define_cpu_unit "e5500_sfx_0,e5500_sfx_1" "e5500_most")

;; CFX.
(define_cpu_unit "e5500_cfx_stage0,e5500_cfx_stage1" "e5500_most")

;; Non-pipelined division.
(define_cpu_unit "e5500_cfx_div" "e5500_long")

;; LSU.
(define_cpu_unit "e5500_lsu" "e5500_most")

;; FPU.
(define_cpu_unit "e5500_fpu" "e5500_long")

;; BU.
(define_cpu_unit "e5500_bu" "e5500_most")

;; The following units are used to make the automata deterministic.
(define_cpu_unit "present_e5500_decode_0" "e5500_most")
(define_cpu_unit "present_e5500_sfx_0" "e5500_most")
(presence_set "present_e5500_decode_0" "e5500_decode_0")
(presence_set "present_e5500_sfx_0" "e5500_sfx_0")

;; Some useful abbreviations.
(define_reservation "e5500_decode"
    "e5500_decode_0|e5500_decode_1+present_e5500_decode_0")
(define_reservation "e5500_sfx"
   "e5500_sfx_0|e5500_sfx_1+present_e5500_sfx_0")

;; SFX.
(define_insn_reservation "e5500_sfx" 1
  (and (eq_attr "type" "integer,insert_word,insert_dword,delayed_compare,\
	shift,cntlz,exts")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx")

(define_insn_reservation "e5500_sfx2" 2
  (and (eq_attr "type" "cmp,compare,fast_compare,trap")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx")

(define_insn_reservation "e5500_delayed" 2
  (and (eq_attr "type" "var_shift_rotate,var_delayed_compare")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx*2")

(define_insn_reservation "e5500_two" 2
  (and (eq_attr "type" "two")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_decode+e5500_sfx,e5500_sfx")

(define_insn_reservation "e5500_three" 3
  (and (eq_attr "type" "three")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,(e5500_decode+e5500_sfx)*2,e5500_sfx")

;; SFX - Mfcr.
(define_insn_reservation "e5500_mfcr" 4
  (and (eq_attr "type" "mfcr")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx_0*4")

;; SFX - Mtcrf.
(define_insn_reservation "e5500_mtcrf" 1
  (and (eq_attr "type" "mtcr")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx_0")

;; SFX - Mtjmpr.
(define_insn_reservation "e5500_mtjmpr" 1
  (and (eq_attr "type" "mtjmpr,mfjmpr")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_sfx")

;; CFX - Multiply.
(define_insn_reservation "e5500_multiply" 4
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_cfx_stage0,e5500_cfx_stage1")

(define_insn_reservation "e5500_multiply_i" 5
  (and (eq_attr "type" "imul2,imul3,imul_compare")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_cfx_stage0,\
   e5500_cfx_stage0+e5500_cfx_stage1,e5500_cfx_stage1")

;; CFX - Divide.
(define_insn_reservation "e5500_divide" 16
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_cfx_stage0+e5500_cfx_div,\
   e5500_cfx_div*15")

(define_insn_reservation "e5500_divide_d" 26
  (and (eq_attr "type" "ldiv")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_cfx_stage0+e5500_cfx_div,\
   e5500_cfx_div*25")

;; LSU - Loads.
(define_insn_reservation "e5500_load" 3
  (and (eq_attr "type" "load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u,\
			load_l,sync")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_lsu")

(define_insn_reservation "e5500_fpload" 4
  (and (eq_attr "type" "fpload,fpload_ux,fpload_u")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_lsu")

;; LSU - Stores.
(define_insn_reservation "e5500_store" 3
  (and (eq_attr "type" "store,store_ux,store_u,store_c")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_lsu")

(define_insn_reservation "e5500_fpstore" 3
  (and (eq_attr "type" "fpstore,fpstore_ux,fpstore_u")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_lsu")

;; FP.
(define_insn_reservation "e5500_float" 7
  (and (eq_attr "type" "fpsimple,fp,fpcompare,dmul")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_fpu")

(define_insn_reservation "e5500_sdiv" 20
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_fpu*20")

(define_insn_reservation "e5500_ddiv" 35
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_fpu*35")

;; BU.
(define_insn_reservation "e5500_branch" 1
  (and (eq_attr "type" "jmpreg,branch,isync")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_bu")

;; BU - CR logical.
(define_insn_reservation "e5500_cr_logical" 1
  (and (eq_attr "type" "cr_logical,delayed_cr")
       (eq_attr "cpu" "ppce5500"))
  "e5500_decode,e5500_bu")
