# Changelog
All changes to the project will be documented in this file.

## [5.1.225507] - 2021-05-05
[View Complete Diff of Changes](https://www.github.com/dotnet/format/compare/b95e1694941ca2595941f1c9cd0d9727b6c53d43...756d5a1c121be3e57e924788af64aa5607dc24e1)

### Breaking Changes

- Implicit restore when fixing code style or 3rd party analyzers (disable with `--no-restore`)
- Adopt csc style for warnings and errors
- Warnings and errors are now written to the standard error stream

### Merged PRs:
- [Add DiagnosticId to the format report (1133)](https://github.com/dotnet/format/pull/1133)
- [Reenabled .NET Core 2.1 support (1021)](https://github.com/dotnet/format/pull/1021)
- [Update System.CommandLine to 2.0.0-beta1.21216.1 (1118)](https://www.github.com/dotnet/format/pull/1118)
- [Support AdditionalDocument changes (1106)](https://www.github.com/dotnet/format/pull/1106)
- [Fix typo in examples (1082)](https://www.github.com/dotnet/format/pull/1082)
- [Run CodeStyle formatter before removing unnecessary imports (1071)](https://www.github.com/dotnet/format/pull/1071)
- [Allow Solution Filter files to be passed as the workspace path (1059)](https://www.github.com/dotnet/format/pull/1059)
- [Add .pre-commit-hooks.yaml (872)](https://www.github.com/dotnet/format/pull/872)
- [Add implicit restore when running analysis. Adds `--no-restore` option. (1015)](https://www.github.com/dotnet/format/pull/1015)
- [Add separate command for binary log (1044)](https://www.github.com/dotnet/format/pull/1044)
- [Use correct flag for codestyle codefixes (1037)](https://www.github.com/dotnet/format/pull/1037)
- [Enhance whitespace issue logging with a detailed TextChange message (1017)](https://www.github.com/dotnet/format/pull/1017)
- [Log all formatter error messages in a csc-style (1016)](https://www.github.com/dotnet/format/pull/1016)
- [LogDebug each project's applied .editorconfig (1013)](https://www.github.com/dotnet/format/pull/1013)
- [Add option to filter diagnostics by id (1007)](https://www.github.com/dotnet/format/pull/1007)
- [Fix pre-commit directory (1004)](https://www.github.com/dotnet/format/pull/1004)
- [Log warnings and errors to the standard error stream (982)](https://www.github.com/dotnet/format/pull/982)
- [Only report fixable compiler diagnostics. (981)](https://www.github.com/dotnet/format/pull/981)

## [5.0.211103] - 2021-02-11
[View Complete Diff of Changes](https://www.github.com/dotnet/format/compare/82a5527cd93d66bffc885c0bb901499f5981db35...b95e1694941ca2595941f1c9cd0d9727b6c53d43)

### Breaking Changes
- Removed `--dry-run` should use `--check` instead
- Removed `--files` should use `--include` instead
- Removed `--workspace` this option is now implied

### Merged PRs:
- [Isolate each Analyzer assembly into its own LoadContext. (959)](https://www.github.com/dotnet/format/pull/959)
- [Implement GetDocumentDiagnosticsAsync in CodeFix DiagnosticProvider (958)](https://www.github.com/dotnet/format/pull/958)
- [Fix missing ` in README.md (914)](https://www.github.com/dotnet/format/pull/914)
- [Add unit test for 3rd party fixer formatting (896)](https://www.github.com/dotnet/format/pull/896)
- [Add unit test for code style fixer formatting (893)](https://www.github.com/dotnet/format/pull/893)
- [Improve FixAll support by using equivalence key when available (884)](https://www.github.com/dotnet/format/pull/884)
- [Only run analyzers against specified project when workspace is a project (865)](https://www.github.com/dotnet/format/pull/865)
- [When matching all files don't rely on FileMatcher (864)](https://www.github.com/dotnet/format/pull/864)
- [Fix markdown formatting in example table (858)](https://www.github.com/dotnet/format/pull/858)
- [Add ability to read --{in,ex}clude value from stdin (790)](https://www.github.com/dotnet/format/pull/790)
- [Add test to ensure code containing <auto-generated> comment is treated as generated. (857)](https://www.github.com/dotnet/format/pull/857)
- [Fixes #834 : error reportfile without directory specified (842)](https://www.github.com/dotnet/format/pull/842)
- [Log there were warnings loading the workspace if diagnostics are reported (841)](https://www.github.com/dotnet/format/pull/841)
- [Fix CommandLine_AllArguments_Bind test (818)](https://www.github.com/dotnet/format/pull/818)
- [Fix Run argument names (817)](https://www.github.com/dotnet/format/pull/817)
- [Add option for whitespace formatting (774)](https://www.github.com/dotnet/format/pull/774)
- [Load analyzer assemlbies in their own AssemblyLoadContext (746)](https://www.github.com/dotnet/format/pull/746)
- [Check that file exists before considering it for formatting (775)](https://www.github.com/dotnet/format/pull/775)
- [Report formatted files and counts based based on reported issues. (776)](https://www.github.com/dotnet/format/pull/776)
- [Support generated_code editorconfig setting (780)](https://www.github.com/dotnet/format/pull/780)
- [Create integrations.md (777)](https://www.github.com/dotnet/format/pull/777)
- [Fix warnings and apply suggestions. (767)](https://www.github.com/dotnet/format/pull/767)
- [Improve folder workspace performance (763)](https://www.github.com/dotnet/format/pull/763)
- [Improve folder performance (760)](https://www.github.com/dotnet/format/pull/760)
- [Update --include and --exclude documentation (761)](https://www.github.com/dotnet/format/pull/761)
- [Remove aliases for the fix style and fix analyzers options (753)](https://www.github.com/dotnet/format/pull/753)
- [Run analyzers during integration tests (728)](https://www.github.com/dotnet/format/pull/728)
- [Remove unnecessary imports (749)](https://www.github.com/dotnet/format/pull/749)
- [Only include compiler diagnostics if a fixer supports them (750)](https://www.github.com/dotnet/format/pull/750)
- [Added CodeFormatter tests for `--fix-style` (751)](https://www.github.com/dotnet/format/pull/751)
- [Format one solution per repo during integration tests (739)](https://www.github.com/dotnet/format/pull/739)
- [Filter analyzers by project language before running (725)](https://www.github.com/dotnet/format/pull/725)
- [Run all analyzers even when a fixer isn't present (723)](https://www.github.com/dotnet/format/pull/723)
- [Update documentation for analyzers (722)](https://www.github.com/dotnet/format/pull/722)
- [Add devcontainer to better support Codespaces (721)](https://www.github.com/dotnet/format/pull/721)
- [Add validation when specifying --folder and analyzers (715)](https://www.github.com/dotnet/format/pull/715)
- [Merge in Feature/analyzers (713)](https://www.github.com/dotnet/format/pull/713)
- [Remove deprecated options and aliases (710)](https://www.github.com/dotnet/format/pull/710)
- [Added reflection based discovery of analyzers and fixes (698)](https://www.github.com/dotnet/format/pull/698)
- [Only run Imports formatter when is has configuration in the .editorconfig (701)](https://www.github.com/dotnet/format/pull/701)

## [4.1.131201] - 2020-06-15
[View Complete Diff of Changes](https://www.github.com/dotnet/format/compare/f772fc306ff4b70cabebbea76beba9cdfd7ecb80...82a5527cd93d66bffc885c0bb901499f5981db35)
## Merged PRs:
- [Only run Imports formatter when is has configuration in the .editorconfig (701)](https://www.github.com/dotnet/format/pull/701)
- [Remove the 255 argument limit for OneOrMany options such as --include and --exclude (700)](https://www.github.com/dotnet/format/pull/700)

## [4.0.130203] - 2020-06-01
[View Complete Diff of Changes](https://www.github.com/dotnet/format/compare/3f2b20c65d32a59ca6bbc68b788a31ed38576d8e...f772fc306ff4b70cabebbea76beba9cdfd7ecb80)
### Breaking Changes:
- Added an imports formatter for sorting imports.
- Format now runs on the latest installed Runtime.
- `--check` and `--dry-run` have combined into a single option.
- `--include` and `--exclude` use space-separated paths instead of comma-separated.

### Deprecations:
- Added warning to use the default argument instead of `--workspace` option. Use `dotnet format ./format.sln` instead of `dotnet format -w ./format.sln`
- Added warning to use the default argument to specify the folder path when using the `--folder` option. Use `dotnet format ./src -f` instead of `dotnet format -f ./src`
- Added warning to use `--include` instead of `--files` alias.
- Added warning to use `--check` instead of `--dry-run` alias.

### Merged PRs:
- [Add Imports Formatter (693)](https://www.github.com/dotnet/roslyn/pull/693)
- [Always run on the latest Runtime (694)](https://www.github.com/dotnet/roslyn/pull/694)
- [Move to Roslyn's editorconfig support (590)](https://www.github.com/dotnet/roslyn/pull/590)
- [Command line argument for solution/project as positional argument (681)](https://www.github.com/dotnet/roslyn/pull/681)
- [Add option to format generated code files. (673)](https://www.github.com/dotnet/roslyn/pull/673)
- [Produce a binlog when verbosity is set to detailed (605)](https://www.github.com/dotnet/roslyn/pull/605)
- [Fix #581 - Add final newline false positive (633)](https://www.github.com/dotnet/roslyn/pull/633)
- [Combine --check and --dry-run into a single option. (541)](https://github.com/dotnet/format/pull/541)
- [Use space-separated paths instead of comma-separated for --include and --exclude (551)](https://github.com/dotnet/format/pull/551)
- [Support loading commandline options from response files (552)](https://github.com/dotnet/format/pull/552)
- [Support file globbing in --include and --exclude options (555)](https://github.com/dotnet/format/pull/555)

## [3.3.111304] - 2020-02-13
[View Complete Diff of Changes](https://github.com/dotnet/format/compare/3ecea99de4bb82b724bf11134279b5aaf8dd1f2f...7c8f67a570f5fde6a247704733d6742f93c0fa48)
### Merged PRs:
- [Enhance --files option to support folder paths. Add --include alias. (533)](https://github.com/dotnet/format/pull/533)
- [format-500: Add `--exclude` option to ignore given files/folders (529)](https://github.com/dotnet/format/pull/529)
- [format-379: Add `--report` command line argument to export json format report to given directory (495)](https://github.com/dotnet/format/pull/495)
- [Update charset formatter to check for equivalent encodings (508)](https://github.com/dotnet/format/pull/508)

## [3.2.107702] - 2020-01-27
[View Complete Diff of Changes](https://github.com/dotnet/format/compare/256f37159dc60b29f76999749f57f4338324f102...3ecea99de4bb82b724bf11134279b5aaf8dd1f2f)
### Merged PRs:
- [Add FolderWorkspace and -f options to load files by folder (335)](https://github.com/dotnet/format/pull/335)
- [Add formatter for the charset .editorconfig option (330)](https://github.com/dotnet/format/pull/330)

## [3.1.37601] - 2019-07-26
[View Complete Diff of Changes](https://github.com/dotnet/format/compare/211cab024c37fdffa5955c5855f9d62a14703452...256f37159dc60b29f76999749f57f4338324f102)
### Merged PRs:
- [Add end_of_line formatter (169)](https://github.com/dotnet/format/pull/169)
- [Log formatting change details when in dry-run mode (249)](https://github.com/dotnet/format/pull/249)
- [Added final newline formatter (133)](https://github.com/dotnet/format/pull/133)
- [Check that code files excluded by .editorconfig are not formatted (130)](https://github.com/dotnet/format/pull/130)

## [3.0.4] - 2019-04-02
[View Complete Diff of Changes](https://github.com/dotnet/format/compare/658b525df6382ed33b20345ba5b037c8515c9a71...211cab024c37fdffa5955c5855f9d62a14703452)
### Merged PRs:
- [Added --files option (52)](https://github.com/dotnet/format/pull/52)
- [Add new CLI '--check' option (48)](https://github.com/dotnet/format/pull/48)
- [Avoiding exception when redirect stdout(#21) (23)](https://github.com/dotnet/format/pull/23)

## [3.0.2] - 2019-02-28
### Initial Release
- Partial support for core .editorconfig options
- Support for .NET whitespace formatting options
- Support for --dry-run option
