/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.imgfactory.impl.ImageFromBase64Callback;
import com.paterva.maltego.imgfactory.impl.ImageFromBase64Thread;
import com.paterva.maltego.imgfactory.impl.ImageFromFileCallback;
import com.paterva.maltego.imgfactory.impl.ImageFromFileThread;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlCallback;
import com.paterva.maltego.imgfactory.impl.ImageFromUrlThread;
import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.imgfactory.impl.ImageSizerCallback;
import com.paterva.maltego.imgfactory.impl.ImageSizerThread;
import com.paterva.maltego.imgfactory.impl.SwappingImageCache;
import com.paterva.maltego.imgfactoryapi.ImageCache;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.ThreadUtil;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeSettings;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeStrategy;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import sun.awt.shell.ShellFolder;

class CachedImageFactory
extends ImageCache
implements ImageFromUrlCallback,
ImageFromFileCallback,
ImageFromBase64Callback,
ImageSizerCallback {
    private final ConcurrentMap<ImageID, ArrayList<ImageCallback>> _imageRequests;
    private HashMap<String, Image> _extImages;
    private HashMap<Thread, FastURL> _urlThreads;
    private HashMap<Thread, ImageID> _sizerThreads;
    private HashMap<Thread, Object> _fileThreads;
    private HashMap<Thread, String> _base64Threads;
    private SwappingImageCache _cache;
    private RequestProcessor _fetchProcessor;
    private RequestProcessor _resizeProcessor;
    private Set<Object> _deadImageCache = new HashSet<Object>();
    private Set<Object> _failedImageCache;
    private static final int MAX_URL_THREADS = 17;
    private static final int MAX_BASE64_THREADS = 3;
    private static final int CONCURRENT_FETCH_THREADS = 10;
    private static final int CONCURRENT_RESIZE_THREADS = ForkJoinPool.getCommonPoolParallelism();
    private static final boolean DEBUG = false;
    private static Image _defaultFileIcon;

    public CachedImageFactory() {
        this(300000, 600000, 200);
    }

    public CachedImageFactory(int memoryShrinkInterval, int maxMemoryIdleTime, int maxMemoryImages) {
        this._extImages = new HashMap();
        this._failedImageCache = new HashSet<Object>();
        this._fileThreads = new HashMap();
        this._imageRequests = new ConcurrentHashMap<ImageID, ArrayList<ImageCallback>>();
        this._sizerThreads = new HashMap();
        this._urlThreads = new HashMap();
        this._base64Threads = new HashMap();
        this._cache = new SwappingImageCache(memoryShrinkInterval, maxMemoryIdleTime, maxMemoryImages);
        this._fetchProcessor = new RequestProcessor("Image Fetch Processor", 10, true);
        this._resizeProcessor = new RequestProcessor("Resizing Processor", CONCURRENT_RESIZE_THREADS, true);
    }

    private void addToCache(ImageID imageId, Image image) {
        if (image != null) {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width > 1024 || height > 1024) {
                String msg = String.format("Adding large image to cache: (%dx%d) %s", width, height, imageId.Key.toString());
                if (ImageUtils.isPossibleBase64Image((String)imageId.Key.toString())) {
                    msg = String.format("Adding large image to cache: (%dx%d) %s", width, height, ImageUtils.getBase64ImageDisplayString((String)imageId.Key.toString()));
                }
                Logger.getLogger(this.getClass().getName()).warning(msg);
            }
            this._cache.put(imageId, image);
        }
    }

    public synchronized void addImage(Object newImageKey, Image image) {
        ImageID imageId = new ImageID(newImageKey, -1, -1);
        this.addToCache(imageId, image);
    }

    public synchronized Image getImage(GraphID graphID, Object imageKey, ImageCallback cb) {
        return this.getImageInternal(imageKey, -1, -1, cb);
    }

    public synchronized Image getImage(GraphID graphID, Object imageKey, int width, int height, ImageCallback cb) {
        return this.getImageInternal(imageKey, width, height, cb);
    }

    public synchronized Image resizeImage(GraphID graphID, Object newImageKey, Image originalImage, int width, int height, ImageCallback cb) {
        this.addImage(newImageKey, originalImage);
        return this.getImage(newImageKey, width, height, cb);
    }

    public synchronized boolean contains(Object imageKey) {
        ImageID imageIdOriginal = new ImageID(imageKey, -1, -1);
        return this._cache.contains(imageIdOriginal);
    }

    public void remove(Object imageKey) {
        ImageID imageIdOriginal = new ImageID(imageKey, -1, -1);
        this._cache.remove(imageIdOriginal, true);
    }

    private synchronized Image getImageInternal(Object imageKey, int width, int height, ImageCallback cb) {
        Attachments atts;
        if (this._deadImageCache.contains(imageKey)) {
            return null;
        }
        if (imageKey instanceof Attachments && (imageKey = (atts = (Attachments)imageKey).getPrimaryImage()) == null) {
            return null;
        }
        ImageID imageId = new ImageID(imageKey, width, height);
        ImageID imageIdOriginal = new ImageID(imageKey, -1, -1);
        Image image = null;
        boolean found = false;
        if (this._cache.contains(imageId)) {
            image = this._cache.get(imageId);
            found = true;
        } else if (this._cache.contains(imageIdOriginal) && !this.mustResize(imageId, image = this._cache.get(imageIdOriginal))) {
            found = true;
        }
        if (!found) {
            if (PrivacyModeSettings.getInstance().getPrivacyMode() == PrivacyMode.STEALTH && imageKey instanceof FastURL && !PrivacyModeStrategy.mayDownload((FastURL)((FastURL)imageKey))) {
                return null;
            }
            if (cb == null) {
                image = this.getImageNonThreaded(imageKey, width, height);
            } else {
                this.getImageThreaded(imageKey, width, height, cb);
                return null;
            }
        }
        return image;
    }

    private synchronized Image getImageNonThreaded(Object imageKey, int width, int height) {
        Image originalImage;
        ImageID imageId = new ImageID(imageKey, width, height);
        ImageID imageIdOriginal = new ImageID(imageKey, -1, -1);
        if (this._cache.contains(imageIdOriginal)) {
            originalImage = this._cache.get(imageIdOriginal);
        } else if (imageKey instanceof FastURL) {
            try {
                originalImage = ImageFromUrlThread.getImage(((FastURL)imageKey).getURL());
            }
            catch (Exception ex) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from URL (1) {1}", new Object[]{ex.getMessage(), imageKey});
                return null;
            }
            this.addToCache(imageIdOriginal, originalImage);
        } else if (imageKey instanceof File) {
            File file = (File)imageKey;
            try {
                BufferedImage img = ImageFromFileThread.getImage(file);
                originalImage = img != null ? img : this.getShellIcon(file);
            }
            catch (Exception ex) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from file {1}", new Object[]{ex.getMessage(), file.getAbsolutePath()});
                return null;
            }
            this.addToCache(imageIdOriginal, originalImage);
        } else if (imageKey instanceof Attachment) {
            Attachment att = (Attachment)imageKey;
            try {
                File attFile = FileStore.getDefault().get(att.getId());
                BufferedImage img = ImageFromFileThread.getImage(attFile);
                originalImage = img != null ? img : this.getShellIcon(new File(att.getFileName()));
            }
            catch (Exception ex) {
                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from attachment (1) {1}", new Object[]{ex.getMessage(), att});
                return null;
            }
            this.addToCache(imageIdOriginal, originalImage);
        } else if (imageKey instanceof Image) {
            this.addImage(imageKey, (Image)imageKey);
            originalImage = this._cache.get(imageIdOriginal);
        } else if (imageKey instanceof ImageIcon) {
            this.addImage(imageKey, ((ImageIcon)imageKey).getImage());
            originalImage = this._cache.get(imageIdOriginal);
        } else if (imageKey instanceof String) {
            String imageKeyString = (String)imageKey;
            originalImage = null;
            if (ImageUtils.isPossibleBase64Image((String)imageKeyString)) {
                try {
                    originalImage = ImageFromBase64Thread.getImage(imageKeyString);
                }
                catch (Exception ex) {
                    Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from String (1) {1}", new Object[]{ex.getMessage(), imageKeyString});
                    return null;
                }
                this.addToCache(imageIdOriginal, originalImage);
            }
        } else {
            Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "Original image not found. (1)");
            return null;
        }
        if (originalImage == null) {
            return null;
        }
        if (this.mustResize(imageId, originalImage)) {
            Image resizedImage = ImageUtils.resize((Image)originalImage, (int)width, (int)height);
            this.addToCache(imageId, resizedImage);
            return resizedImage;
        }
        return originalImage;
    }

    private synchronized void getImageThreaded(Object imageKey, int width, int height, ImageCallback callback) {
        ImageID imageId = new ImageID(imageKey, width, height);
        ImageID imageIdOriginal = new ImageID(imageKey, -1, -1);
        ArrayList callbackOptions = (ArrayList)this._imageRequests.get(imageId);
        if (callbackOptions != null) {
            ((ArrayList)this._imageRequests.get(imageId)).add(callback);
        } else {
            boolean haveOriginal;
            block32: {
                haveOriginal = false;
                if (this._cache.contains(imageIdOriginal)) {
                    haveOriginal = true;
                } else if (imageKey instanceof Image) {
                    this.addImage(imageKey, (Image)imageKey);
                    haveOriginal = true;
                } else if (imageKey instanceof ImageIcon) {
                    this.addImage(imageKey, ((ImageIcon)imageKey).getImage());
                    haveOriginal = true;
                } else {
                    Thread imgFetcher;
                    ArrayList<ImageCallback> callbacks = new ArrayList<ImageCallback>();
                    callbacks.add(callback);
                    this._imageRequests.put(imageId, callbacks);
                    if (imageKey instanceof FastURL) {
                        try {
                            FastURL fastURL = (FastURL)imageKey;
                            if (this._urlThreads.size() < 17) {
                                if (!this._urlThreads.containsValue(fastURL)) {
                                    imgFetcher = new ImageFromUrlThread(fastURL.getURL(), this);
                                    this._urlThreads.put(imgFetcher, fastURL);
                                    this._fetchProcessor.post((Runnable)imgFetcher);
                                }
                                break block32;
                            }
                            this._imageRequests.remove(imageId);
                            callback.imageFailed((Exception)new IllegalStateException("URL image request dropped due to load."));
                        }
                        catch (Exception ex) {
                            Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from URL (2) {1}", new Object[]{ex.getMessage(), imageKey});
                        }
                    } else if (imageKey instanceof File) {
                        File file = (File)imageKey;
                        if (!this._fileThreads.containsValue(file)) {
                            imgFetcher = new ImageFromFileThread(file, (ImageFromFileCallback)this);
                            this._fileThreads.put(imgFetcher, file);
                            this._fetchProcessor.post((Runnable)imgFetcher);
                        }
                    } else if (imageKey instanceof Attachment) {
                        Attachment att = (Attachment)imageKey;
                        try {
                            if (!this._fileThreads.containsValue(att)) {
                                File attFile = FileStore.getDefault().get(att.getId());
                                ImageFromFileThread imgFetcher2 = new ImageFromFileThread(attFile, (ImageFromFileCallback)this);
                                this._fileThreads.put(imgFetcher2, att);
                                this._fetchProcessor.post((Runnable)imgFetcher2);
                            }
                        }
                        catch (FileNotFoundException ex) {
                            Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from attachment (2) {1}", new Object[]{ex.getMessage(), att});
                        }
                    } else if (imageKey instanceof String) {
                        String imageKeyString = (String)imageKey;
                        if (ImageUtils.isPossibleBase64Image((String)imageKeyString)) {
                            try {
                                if (this._base64Threads.size() < 3) {
                                    if (!this._base64Threads.containsValue(imageKeyString)) {
                                        imgFetcher = new ImageFromBase64Thread(imageKeyString, this);
                                        this._base64Threads.put(imgFetcher, imageKeyString);
                                        this._fetchProcessor.post((Runnable)imgFetcher);
                                    }
                                    break block32;
                                }
                                this._imageRequests.remove(imageId);
                                callback.imageFailed((Exception)new IllegalStateException("Base64 image request dropped due to load."));
                            }
                            catch (Exception ex) {
                                Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "{0}: could not load image from String (2) {1}", new Object[]{ex.getMessage(), imageKeyString});
                            }
                        }
                    } else {
                        Logger.getLogger(CachedImageFactory.class.getName()).log(Level.WARNING, "Original image not found. (2): {0}", imageKey.toString());
                    }
                }
            }
            if (haveOriginal) {
                Image originalImage = this._cache.get(imageIdOriginal);
                if (this.mustResize(imageId, originalImage)) {
                    ArrayList<ImageCallback> callbacks = new ArrayList<ImageCallback>();
                    callbacks.add(callback);
                    this._imageRequests.put(imageId, callbacks);
                    ImageSizerThread imgSizer = new ImageSizerThread(originalImage, width, height, this);
                    this._sizerThreads.put(imgSizer, imageId);
                    this._resizeProcessor.post((Runnable)imgSizer);
                } else {
                    this.doCallback(callback, originalImage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageOriginalReady(Object key, Image image) {
        Image imageOriginal = image;
        ImageID imageIdOriginal = new ImageID(key, -1, -1);
        this.addToCache(imageIdOriginal, imageOriginal);
        ArrayList callbacks = new ArrayList();
        ConcurrentMap<ImageID, ArrayList<ImageCallback>> concurrentMap = this._imageRequests;
        synchronized (concurrentMap) {
            Iterator it = this._imageRequests.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ImageID imageId = (ImageID)entry.getKey();
                if (!imageId.Key.equals(key)) continue;
                if (this.mustResize(imageId, imageOriginal)) {
                    ImageSizerThread imgSizer = new ImageSizerThread(imageOriginal, imageId.Width, imageId.Height, this);
                    this._sizerThreads.put(imgSizer, imageId);
                    this._resizeProcessor.post((Runnable)imgSizer);
                    continue;
                }
                if (!imageId.equals(imageIdOriginal)) {
                    this.addToCache(imageId, imageOriginal);
                }
                callbacks.add(entry.getValue());
                it.remove();
            }
        }
        callbacks.forEach(cb -> this.notifyAllReady((List<ImageCallback>)cb, imageOriginal));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageOriginalFailed(Object key, Exception ex) {
        if (this._failedImageCache.contains(key)) {
            this._failedImageCache.remove(key);
            this._deadImageCache.add(key);
        } else if (!this._deadImageCache.contains(key)) {
            this._failedImageCache.add(key);
        }
        ArrayList callbacks = new ArrayList();
        ConcurrentMap<ImageID, ArrayList<ImageCallback>> concurrentMap = this._imageRequests;
        synchronized (concurrentMap) {
            Iterator it = this._imageRequests.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ImageID imageId = (ImageID)entry.getKey();
                if (!imageId.Key.equals(key)) continue;
                callbacks.add(entry.getValue());
                it.remove();
            }
        }
        callbacks.forEach(cb -> this.notifyAllFailed((List<ImageCallback>)cb, ex));
    }

    @Override
    public synchronized void imageFromUrlReady(ImageFromUrlThread sender, Image image) {
        FastURL fastURL = this._urlThreads.get(sender);
        this.imageOriginalReady(fastURL, image);
        this._urlThreads.remove(sender);
    }

    @Override
    public synchronized void imageFromUrlFailed(ImageFromUrlThread sender, Exception ex) {
        FastURL fastURL = this._urlThreads.get(sender);
        this.imageOriginalFailed(fastURL, ex);
        this._urlThreads.remove(sender);
    }

    @Override
    public synchronized void imageFromFileReady(ImageFromFileThread sender, Image image) {
        Object obj = this._fileThreads.get(sender);
        if (image == null) {
            if (obj instanceof Attachment) {
                Attachment att = (Attachment)obj;
                try {
                    File file = FileStore.getDefault().get(att.getId());
                    image = this.getShellIcon(file);
                }
                catch (FileNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (obj instanceof File) {
                File file = (File)obj;
                image = this.getShellIcon(file);
            }
        }
        this.imageOriginalReady(obj, image);
        this._fileThreads.remove(sender);
    }

    @Override
    public synchronized void imageFromFileFailed(ImageFromFileThread sender, Exception ex) {
        Object obj = this._fileThreads.get(sender);
        this.imageOriginalFailed(obj, ex);
        this._fileThreads.remove(sender);
    }

    @Override
    public void imageFromBase64Ready(ImageFromBase64Thread sender, Image image) {
        String base64 = this._base64Threads.get(sender);
        this.imageOriginalReady(base64, image);
        this._base64Threads.remove(sender);
    }

    @Override
    public void imageFromBase64Failed(ImageFromBase64Thread sender, Exception ex) {
        String base64 = this._base64Threads.get(sender);
        this.imageOriginalFailed(base64, ex);
        this._base64Threads.remove(sender);
    }

    @Override
    public synchronized void imageSizerReady(ImageSizerThread sender, Image image) {
        ImageID imageId = this._sizerThreads.get(sender);
        this.addToCache(imageId, image);
        List callbacks = (List)this._imageRequests.remove(imageId);
        this.notifyAllReady(callbacks, image);
        this._sizerThreads.remove(sender);
    }

    @Override
    public synchronized void imageSizerFailed(ImageSizerThread sender, Exception ex) {
        ImageID imageId = this._sizerThreads.get(sender);
        List callbacks = (List)this._imageRequests.remove(imageId);
        this.notifyAllFailed(callbacks, ex);
        this._sizerThreads.remove(sender);
    }

    private boolean mustResize(ImageID imageId, Image image) {
        int requestedWidth = imageId.Width;
        int requestedHeight = imageId.Height;
        return this.mustResize(image, requestedWidth, requestedHeight);
    }

    public boolean mustResize(Image image, int requestedWidth, int requestedHeight) {
        if (requestedWidth == -1 && requestedHeight == -1) {
            requestedWidth = image.getWidth(null);
            requestedHeight = image.getHeight(null);
        } else if (requestedWidth == -1) {
            requestedWidth = CachedImageFactory.calculateRelativeX(image.getWidth(null), image.getHeight(null), requestedHeight);
        } else if (requestedHeight == -1) {
            requestedHeight = CachedImageFactory.calculateRelativeY(image.getWidth(null), image.getHeight(null), requestedWidth);
        }
        return image.getWidth(null) != requestedWidth || image.getHeight(null) != requestedHeight;
    }

    private static int calculateRelativeY(float x, float y, float newX) {
        float newY = y / x * newX;
        return Math.round(newY);
    }

    private static int calculateRelativeX(float x, float y, float newY) {
        float newX = x / y * newY;
        return Math.round(newX);
    }

    private void notifyAllReady(List<ImageCallback> callbacks, Image image) {
        if (callbacks != null) {
            callbacks.forEach(callback -> this.doCallback((ImageCallback)callback, image));
        }
    }

    private void notifyAllFailed(List<ImageCallback> callbacks, Exception ex) {
        if (callbacks != null) {
            callbacks.forEach(callback -> this.doFail((ImageCallback)callback, ex));
        }
    }

    private void doCallback(ImageCallback cb, Image data) {
        ThreadUtil.safeRun((boolean)cb.needAwtThread(), () -> cb.imageReady(data));
    }

    private void doFail(ImageCallback cb, Exception ex) {
        ThreadUtil.safeRun((boolean)cb.needAwtThread(), () -> cb.imageFailed(ex));
    }

    private Image getShellIcon(File file) {
        String extension = FileUtilities.getFileExtension((File)file);
        Image image = null;
        if (this._extImages.containsKey(extension)) {
            image = this._extImages.get(extension);
        } else {
            try {
                if (!Utilities.isWindows()) {
                    Icon icon;
                    FileView fileView;
                    JFileChooser fc = new JFileChooser();
                    FileChooserUI ui = fc.getUI();
                    if (ui != null && (fileView = ui.getFileView(fc)) != null && (icon = fileView.getIcon(file)) != null) {
                        image = ImageUtilities.icon2Image((Icon)icon);
                    }
                } else {
                    if (!file.exists()) {
                        file = File.createTempFile("maltego_att_icon", "." + extension);
                        file.deleteOnExit();
                    }
                    image = ShellFolder.getShellFolder(file).getIcon(true);
                }
                if (image == null) {
                    if (_defaultFileIcon == null) {
                        _defaultFileIcon = ImageUtilities.loadImage((String)"com/paterva/maltego/imgfactory/impl/File48.png", (boolean)true);
                    }
                    image = _defaultFileIcon;
                }
                if (!extension.toLowerCase().equals("ico")) {
                    this._extImages.put(extension, image);
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return image;
    }

    public void resetFailedImages() {
        this._failedImageCache.clear();
        this._deadImageCache.clear();
    }

    private /* synthetic */ void lambda$new$0(ActionEvent __) {
        System.out.println(new Date().toString());
        System.out.println(this._cache.getStatus());
    }
}

