/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.imex;

import com.maltego.tx3.java.api.discovery.EntityAction;
import com.maltego.tx3.java.api.discovery.EntityDefinition;
import com.maltego.tx3.java.api.discovery.EntityDefinitionProperty;
import com.maltego.tx3.java.api.discovery.EntityProperties;
import com.maltego.tx3.java.api.discovery.V3EntityOverlay;
import com.maltego.tx3.java.api.execution.Property;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityPropTypeMapping;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.SpecActionDescriptor;
import com.paterva.maltego.entity.manager.imex.EntitySpecDiscoveryItems;
import com.paterva.maltego.entity.manager.imex.EntitySpecDiscoveryProvider;
import com.paterva.maltego.entity.registry.converter.RegexEntityConverter;
import com.paterva.maltego.json.discovery.JsonDiscoveryContext;
import com.paterva.maltego.json.discovery.JsonDiscoveryProvider;
import com.paterva.maltego.transform.protocol.v3.api.proxy.V3HttpProxy;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.serializer.EvaluatorFactory;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EntitySpecJsonDiscoveryProvider
extends JsonDiscoveryProvider<EntitySpecDiscoveryItems>
implements DiscoveryProvider<EntitySpecDiscoveryItems> {
    private final TypeRegistry typeRegistry = TypeRegistry.getDefault();
    private final EntityPropTypeMapping entityTypeMapping = EntityPropTypeMapping.getDefault();
    private final EntitySpecDiscoveryProvider delegate = new EntitySpecDiscoveryProvider();
    private static final Logger LOG = Logger.getLogger(EntitySpecJsonDiscoveryProvider.class.getName());
    private static final Set<Property.PropertyType> NO_JSON_NATIVE_PROPERTY_TYPES = EnumSet.of(Property.PropertyType.DATE, new Property.PropertyType[]{Property.PropertyType.DATE_TIME, Property.PropertyType.DATE_RANGE, Property.PropertyType.TIME_SPAN, Property.PropertyType.URL, Property.PropertyType.COLOR});

    public EntitySpecDiscoveryItems fetch(JsonDiscoveryContext dc) {
        V3HttpProxy proxy = new V3HttpProxy(dc.getV3Url());
        List entityDefinitions = proxy.listEntityDefinitions(true);
        List<MaltegoEntitySpec> entitySpec = entityDefinitions.stream().map(ed -> this.readMaltegoSpec((EntityDefinition)ed)).collect(Collectors.toList());
        return new EntitySpecDiscoveryItems(this, entitySpec, (DiscoveryContext)dc);
    }

    public EntitySpecDiscoveryItems getNewAndMerged(EntitySpecDiscoveryItems items) {
        return this.delegate.getNewAndMerged(items);
    }

    public void apply(EntitySpecDiscoveryItems specs) {
        this.delegate.apply(specs);
    }

    private DisplayDescriptor readPropertyField(EntityDefinitionProperty entityProp) {
        Object propertyValue;
        Class toClazz;
        Property.PropertyType propType = entityProp.getType();
        String v2PropType = this.entityTypeMapping.getV2PropTypeName(propType.name(), entityProp.getArray().booleanValue(), true, new Object[]{entityProp.getSampleValue(), entityProp.getDefaultValue()});
        if (entityProp.getArray().booleanValue()) {
            v2PropType = v2PropType + "[]";
        }
        DisplayDescriptor fieldDescriptor = new DisplayDescriptor(this.typeRegistry.getType(v2PropType).getType(), entityProp.getName(), entityProp.getDisplayName());
        TypeDescriptor td = fieldDescriptor.getTypeDescriptor();
        fieldDescriptor.setHidden(entityProp.getHidden().booleanValue());
        fieldDescriptor.setNullable(entityProp.getNullable().booleanValue());
        fieldDescriptor.setReadonly(entityProp.getReadonly().booleanValue());
        fieldDescriptor.setDescription(entityProp.getDescription());
        if (null != entityProp.getSampleValue()) {
            toClazz = fieldDescriptor.getType();
            propertyValue = entityProp.getSampleValue();
            if (toClazz.isArray() && NO_JSON_NATIVE_PROPERTY_TYPES.contains(propType)) {
                propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                propertyValue = Converter.changeArrayType((Object)propertyValue, String.class);
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            } else if (toClazz.isArray()) {
                if (toClazz.getComponentType() == String.class) {
                    propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                }
                propertyValue = Converter.changeArrayType((Object)propertyValue, toClazz.getComponentType());
            } else if (propertyValue != null && !propertyValue.getClass().equals(toClazz)) {
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            }
            fieldDescriptor.setSampleValue(propertyValue);
        }
        if (null != entityProp.getDefaultValue()) {
            toClazz = fieldDescriptor.getType();
            propertyValue = entityProp.getDefaultValue();
            if (toClazz.isArray() && NO_JSON_NATIVE_PROPERTY_TYPES.contains(propType)) {
                propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                propertyValue = Converter.changeArrayType((Object)propertyValue, String.class);
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            } else if (toClazz.isArray()) {
                if (toClazz.getComponentType() == String.class) {
                    propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                }
                propertyValue = Converter.changeArrayType((Object)propertyValue, toClazz.getComponentType());
            } else if (propertyValue != null && !propertyValue.getClass().equals(toClazz)) {
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            }
            fieldDescriptor.setDefaultValue(propertyValue);
        }
        if (null != entityProp.getEvaluator()) {
            Evaluator evaluator = EvaluatorFactory.create((String)entityProp.getEvaluator());
            if (evaluator == null) {
                String defaultValueStr;
                Object defaultValue = fieldDescriptor.getDefaultValue();
                if (defaultValue instanceof String && StringUtils.isNotBlank((CharSequence)(defaultValueStr = (String)defaultValue))) {
                    fieldDescriptor.setEvaluator(EvaluatorFactory.createForDefaultValue((String)defaultValueStr));
                }
            } else {
                fieldDescriptor.setEvaluator(evaluator);
            }
        }
        return fieldDescriptor;
    }

    private MaltegoEntitySpec readEntityDefinition(EntityDefinition definition, DisplayDescriptorList propertiesList) {
        MaltegoEntitySpec spec = new MaltegoEntitySpec(definition.getId(), (DisplayDescriptorCollection)propertiesList, new GroupDefinitions());
        spec.setBaseEntitySpecs(definition.getBaseEntities());
        spec.setLargeIconResource(definition.getIconResource());
        spec.setConversionOrder(definition.getConversionOrder());
        spec.setDisplayName(definition.getDisplayName());
        spec.setDisplayNamePlural(definition.getDisplayNamePlural());
        spec.setDescription(definition.getDescription());
        spec.setVisible(definition.isVisible());
        spec.setToolboxItem(definition.isAllowedRoot());
        String category = definition.getCategory();
        if (!StringUtilities.isNullOrEmpty((String)category)) {
            spec.setDefaultCategory(category);
        } else {
            spec.setDefaultCategory("My Entities");
        }
        return spec;
    }

    private void translateActions(MaltegoEntitySpec spec, EntityDefinition definition) {
        if (null != definition.getActions() && !definition.getActions().isEmpty()) {
            ArrayList<SpecActionDescriptor> actions = new ArrayList<SpecActionDescriptor>();
            for (EntityAction action : definition.getActions()) {
                String displayName = action.getDisplayName().isEmpty() ? action.getName() : action.getDisplayName();
                SpecActionDescriptor descriptor = new SpecActionDescriptor(action.getType(), action.getName(), displayName, action.getConfig());
                actions.add(descriptor);
            }
            spec.setActions(actions);
        }
    }

    private void translateOverlays(MaltegoEntitySpec spec, EntityDefinition definition) {
        if (null != definition.getOverlays() && !definition.getOverlays().isEmpty()) {
            OverlayDescriptorSet overlaySet = new OverlayDescriptorSet();
            for (V3EntityOverlay v3overlay : definition.getOverlays()) {
                OverlayDescriptor overlay = new OverlayDescriptor(v3overlay.getPropertyName(), v3overlay.getPosition().name(), v3overlay.getType().getType());
                overlaySet.add(overlay);
            }
            spec.setOverlaySet(overlaySet);
        }
    }

    private void translateRegexConverter(MaltegoEntitySpec spec, EntityDefinition definition) {
        EntityProperties definitionProperties = definition.getProperties();
        if (null != definition.getRegexConverter() && null != definitionProperties.getValue()) {
            RegexEntityConverter converter = new RegexEntityConverter();
            if (null != definition.getRegexConverter().getGroups() && !definition.getRegexConverter().getGroups().isEmpty()) {
                converter.setProperties(definition.getRegexConverter().getGroups());
            }
            converter.setMainProperty(definitionProperties.getValue());
            try {
                converter.init(definition.getRegexConverter().getRegex());
                spec.setConverter((EntityConverter)converter);
            }
            catch (PatternSyntaxException e) {
                LOG.log(Level.WARNING, "Could not parse Entity converter regex: {0}", e);
            }
        }
    }

    MaltegoEntitySpec readMaltegoSpec(EntityDefinition definition) {
        DisplayDescriptorList propertiesList = new DisplayDescriptorList();
        DisplayDescriptor valueDescriptor = null;
        EntityProperties definitionProperties = definition.getProperties();
        if (null != definitionProperties.getFields()) {
            for (EntityDefinitionProperty entityProp : definitionProperties.getFields()) {
                DisplayDescriptor fieldDescriptor = this.readPropertyField(entityProp);
                propertiesList.add(fieldDescriptor);
                if (!definitionProperties.getValue().equals(entityProp.getName())) continue;
                valueDescriptor = fieldDescriptor;
            }
        }
        MaltegoEntitySpec spec = this.readEntityDefinition(definition, propertiesList);
        if (null != valueDescriptor) {
            spec.setValueProperty(valueDescriptor);
        }
        if (!StringUtilities.isNullOrEmpty((String)definitionProperties.getDisplayValue())) {
            spec.setDisplayValueExpression(definitionProperties.getDisplayValue());
        }
        if (!StringUtilities.isNullOrEmpty((String)definitionProperties.getImageOverlay())) {
            spec.setImageExpression(definitionProperties.getImageOverlay());
        }
        this.translateRegexConverter(spec, definition);
        this.translateActions(spec, definition);
        this.translateOverlays(spec, definition);
        return spec;
    }
}

