/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.Payload;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.StartGraphMessage;
import com.paterva.maltego.collab.graph.state.ParticipantPool;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.StateGetPeerGraph;
import com.paterva.maltego.collab.graph.state.StateGotGraph;

class StateGetHistoryGraph
extends StateConnecting {
    StateGetHistoryGraph() {
    }

    @Override
    protected void run() {
        this.progress(LogMessageLevel.Info, "Attempting history graph sync", 55);
        this.debug("attempting to build graph from history");
        PayloadCollection syncPoint = null;
        try {
            syncPoint = this.getSyncPoint(PayloadCollection.create(this.historyQueue().payloads(), this.liveQueue().payloads()));
        }
        catch (CollaborationException ex) {
            this.debug("Error parsing start message: " + (Object)((Object)ex));
        }
        if (syncPoint != null) {
            this.debug("found history sync point");
            this.liveQueue().clear();
            this.historyQueue().clear();
            this.setNextState(new StateGotGraph(syncPoint));
        } else {
            this.debug("no history sync point found");
            ParticipantPool participants = this.participants();
            Participant p = participants.chooseRandom();
            this.setNextState(new StateGetPeerGraph(p, 3));
        }
    }

    private PayloadCollection getSyncPoint(PayloadCollection payloads) throws CollaborationException {
        boolean startSync = false;
        PayloadCollection.List list = new PayloadCollection.List();
        for (Payload p : payloads) {
            if (startSync) {
                list.add(p);
            }
            if (!p.isType("start")) continue;
            startSync = true;
            this.parseStart(p, list);
        }
        if (startSync) {
            return list;
        }
        return null;
    }

    private void parseStart(Payload start, PayloadCollection.List list) throws CollaborationException {
        StartGraphMessage msg = StartGraphMessage.parse(start.getBody());
        this.addPayload(start, "icons", msg.getIcons(), list);
        this.addPayload(start, "especs", msg.getEntitySpecs(), list);
        this.addPayload(start, "lspecs", msg.getLinkSpecs(), list);
        this.addPayload(start, "xaction", msg.getTransactions(), list);
        this.addPayload(start, "layouts", msg.getLayoutSettings(), list);
        this.addPayload(start, "collect", msg.getCollectionSettings(), list);
    }

    private void addPayload(Payload start, String type, String body, PayloadCollection.List list) {
        if (body != null) {
            list.add(new Payload(start.getID(), start.getFrom(), type, body, start.getTimestamp()));
        }
    }
}

