/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaTextBorder;
import com.bulenkov.iconloader.util.GraphicsConfig;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class DarculaPasswordFieldUI
extends BasicPasswordFieldUI {
    public static ComponentUI createUI(final JComponent c) {
        c.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                c.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                c.repaint();
            }
        });
        return new DarculaPasswordFieldUI();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Border border;
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        if ((border = c.getBorder()) instanceof DarculaTextBorder) {
            g.setColor(c.getBackground());
            int width = c.getWidth();
            int height = c.getHeight();
            Insets i = border.getBorderInsets(c);
            if (c.hasFocus()) {
                GraphicsConfig config = new GraphicsConfig(g);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g.fillRect(0, 0, width, height);
                config.restore();
            } else {
                g.fillRect(0, 0, width, height);
            }
        } else {
            super.paintBackground(g);
        }
    }
}

