/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class DarculaButtonUI
extends BasicButtonUI {
    public static final String USER_SET_BACKGROUND_COLOR = "userSetBackgroundColor";
    public static final String ALPHA_HOVER_COLOR = "alphaHoverColor";
    public static final String DONT_DRAW_BACKGROUND = "dontDrawBackground";
    public static final String IN_HUB_TITLE_PANEL = "inHubTitlePanel";
    public static final String IN_HUB_PANEL = "inHubPanel";
    public static final String IN_HUB_DETAILS_PANEL = "inHubDetailsPanel";
    public static final String BUTTON_BG = "buttonBg";
    private final Map<AbstractButton, ChangeListener> _listeners = new HashMap<AbstractButton, ChangeListener>();
    private final Map<AbstractButton, MouseListener> _mouseListeners = new HashMap<AbstractButton, MouseListener>();
    private final Map<AbstractButton, KeyListener> _keyListeners = new HashMap<AbstractButton, KeyListener>();
    private boolean myMouseIsOverButton = false;
    private boolean firstStateChanged = true;
    private boolean firstUpdate = true;
    private Color userSetBackgroundColor;

    public static boolean isInExitDialog(JComponent c) {
        boolean b = false;
        Container parent = c.getParent();
        if (parent != null && parent instanceof JPanel && (parent = parent.getParent()) != null && parent instanceof JPanel) {
            JPanel exitPanelParent = (JPanel)parent;
            for (Component component : exitPanelParent.getComponents()) {
                if (component == null || !component.getClass().getName().startsWith("org.netbeans.core.ExitDialog")) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setFont(UIManager.getLookAndFeelDefaults().getFont("Button.font"));
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        KeyListener keyListener;
        MouseListener mouseListener;
        super.uninstallListeners(b);
        ChangeListener listener = this._listeners.remove(b);
        if (listener != null) {
            b.getModel().removeChangeListener(listener);
        }
        if ((mouseListener = this._mouseListeners.remove(b)) != null) {
            b.removeMouseListener(mouseListener);
        }
        if ((keyListener = this._keyListeners.remove(b)) != null) {
            b.removeKeyListener(keyListener);
        }
    }

    @Override
    protected void installListeners(final AbstractButton b) {
        b.setRolloverEnabled(true);
        super.installListeners(b);
        if ("Cancel".equals(b.getText())) {
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (DarculaButtonUI.isInExitDialog(b)) {
                        System.setProperty("maltego.closeApp.setSaveInEDT", "false");
                    }
                }
            };
            b.addMouseListener(mouseListener);
            this._mouseListeners.put(b, mouseListener);
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (DarculaButtonUI.isInExitDialog(b)) {
                        System.setProperty("maltego.closeApp.setSaveInEDT", "false");
                    }
                }
            };
            b.addKeyListener(keyListener);
            this._keyListeners.put(b, keyListener);
        }
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model;
                if (DarculaButtonUI.this.firstStateChanged) {
                    DarculaButtonUI.this.userSetBackgroundColor = b.getBackground();
                    b.putClientProperty(DarculaButtonUI.USER_SET_BACKGROUND_COLOR, DarculaButtonUI.this.userSetBackgroundColor);
                    DarculaButtonUI.this.firstStateChanged = false;
                }
                if ((model = (ButtonModel)e.getSource()).isRollover() != DarculaButtonUI.this.myMouseIsOverButton) {
                    DarculaButtonUI.this.myMouseIsOverButton = model.isRollover();
                    if (DarculaButtonUI.this.myMouseIsOverButton) {
                        if (DarculaButtonUI.isInHub(b)) {
                            b.setForeground(DarculaButtonUI.getHoverButtonColorHub());
                            if (b.getIcon() != null && DarculaButtonUI.isInHubTitlePanel(b)) {
                                b.setBackground(DarculaButtonUI.getHoverButtonColorHub());
                            }
                        } else if (DarculaButtonUI.isInHubDetailsPanel(b)) {
                            b.setForeground(DarculaButtonUI.getHoverButtonColorHub());
                        } else {
                            b.setForeground(UIManager.getLookAndFeelDefaults().getColor("Button.darculaMod.hoverForeground"));
                            if (DarculaButtonUI.isDropDownButton(b) && DarculaButtonUI.isToolBarForParent(b) || Boolean.TRUE.equals(b.getClientProperty(DarculaButtonUI.ALPHA_HOVER_COLOR))) {
                                b.setBackground(DarculaButtonUI.this.getHoverButtonColor2());
                            } else {
                                b.setBackground(DarculaButtonUI.this.getHoverButtonColor1());
                            }
                        }
                    } else {
                        if (DarculaButtonUI.isInHubTitlePanel(b) || DarculaButtonUI.isInHubDetailsPanel(b)) {
                            b.setForeground(DarculaButtonUI.getButtonColorHubTitle());
                        } else if (DarculaButtonUI.isInHubPanel(b)) {
                            b.setForeground(DarculaButtonUI.getButtonColorHub());
                        } else {
                            b.setForeground(UIManager.getLookAndFeelDefaults().getColor("Button.foreground"));
                        }
                        b.setBackground(DarculaButtonUI.this.userSetBackgroundColor.equals(DarculaButtonUI.this.getButtonColor1()) ? DarculaButtonUI.this.getButtonColor1() : DarculaButtonUI.this.userSetBackgroundColor);
                    }
                }
            }
        };
        b.getModel().addChangeListener(listener);
        this._listeners.put(b, listener);
    }

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
        if (c.isEnabled()) {
            JButton b;
            Color color = c.getBackground();
            if (c instanceof JButton && (b = (JButton)c).isDefaultButton()) {
                color = !b.getModel().isRollover() ? this.getSelectedButtonColor1() : this.getHoverButtonColor1();
            }
            ((Graphics2D)g).setPaint(color);
            if (!Boolean.TRUE.equals(c.getClientProperty(DONT_DRAW_BACKGROUND))) {
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
        config.restore();
        super.paint(g, c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension temp = BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
        int reduceHeightBy = 6;
        if (DarculaButtonUI.isToolBarForParent(c)) {
            reduceHeightBy = 2;
            if ((b.getText() == null || b.getText().isEmpty()) && DarculaButtonUI.isGraphViewToolBar(b)) {
                temp.width -= 4;
            }
        }
        if (DarculaButtonUI.isInHubTitlePanel(c)) {
            reduceHeightBy = 10;
        }
        if (SystemInfo.isLinux && temp.width > 0) {
            temp.width += 8;
        }
        temp.height -= reduceHeightBy;
        return temp;
    }

    public static boolean isGraphViewToolBar(Component c) {
        boolean b = false;
        Container parent = c.getParent();
        if (parent != null && parent instanceof JComponent) {
            b = parent.getClass().getName().startsWith("com.paterva.maltego.ui.graph.impl.GraphViewElement$1") ? true : DarculaButtonUI.isGraphViewToolBar(parent);
        }
        return b;
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        Color selectedFg;
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color fg = button.getForeground();
        if (!model.isRollover() && fg instanceof UIResource && button instanceof JButton && ((JButton)button).isDefaultButton() && (selectedFg = UIManager.getLookAndFeelDefaults().getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        g.setColor(fg);
        GraphicsUtil.setupTextAntialiasing(g, c);
        FontMetrics metrics = g.getFontMetrics();
        int mnemonicIndex = button.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("Button.disabledText"));
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        if (DarculaButtonUI.isToolBarForParent(c) && !DarculaButtonUI.isCollectionNodeForParentOfParent(c) && b.getIcon() != null && (b.getText() == null || b.getText().isEmpty())) {
            this.userSetBackgroundColor = c.getParent().getBackground();
            if (this.firstUpdate) {
                b.setBackground(this.userSetBackgroundColor);
                b.putClientProperty(USER_SET_BACKGROUND_COLOR, this.userSetBackgroundColor);
                this.firstUpdate = false;
            }
            b.setBorderPainted(false);
        } else if (DarculaButtonUI.isInHubDetailsPanel(c)) {
            String buttonBg = (String)b.getClientProperty(BUTTON_BG);
            if (buttonBg != null) {
                this.userSetBackgroundColor = UIManager.getLookAndFeelDefaults().getColor(buttonBg);
            }
            if (this.firstUpdate) {
                b.setBackground(this.userSetBackgroundColor);
                b.putClientProperty(USER_SET_BACKGROUND_COLOR, this.userSetBackgroundColor);
                this.firstUpdate = false;
            }
            b.setBorderPainted(false);
        } else if (DarculaButtonUI.isInHub(c)) {
            String buttonBg = (String)b.getClientProperty(BUTTON_BG);
            this.userSetBackgroundColor = buttonBg != null ? UIManager.getLookAndFeelDefaults().getColor(buttonBg) : c.getParent().getBackground();
            if (this.firstUpdate || buttonBg != null) {
                b.setBackground(this.userSetBackgroundColor);
                b.putClientProperty(USER_SET_BACKGROUND_COLOR, this.userSetBackgroundColor);
                this.firstUpdate = false;
            }
            b.setBorderPainted(false);
        }
        super.update(g, c);
    }

    public static boolean isDropDownButton(JComponent c) {
        return c != null && c.getClass().getName().startsWith("org.openide.awt.DropDownButton");
    }

    public static boolean isToolBarForParent(JComponent c) {
        Container parent = c.getParent();
        return parent != null && parent instanceof JToolBar;
    }

    private static boolean isInHubTitlePanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HUB_TITLE_PANEL));
    }

    private static boolean isInHubPanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HUB_PANEL));
    }

    private static boolean isInHubDetailsPanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HUB_DETAILS_PANEL));
    }

    static boolean isInHub(JComponent c) {
        return DarculaButtonUI.isInHubTitlePanel(c) || DarculaButtonUI.isInHubPanel(c);
    }

    public static boolean isCollectionNodeForParentOfParent(JComponent c) {
        Container parent = c.getParent();
        if (parent != null) {
            return (parent = parent.getParent()) != null && parent.getClass().getName().startsWith("com.paterva.maltego.ui.graph.view2d.CollectionNodeComponent");
        }
        return false;
    }

    protected Color getButtonColor1() {
        return UIManager.getLookAndFeelDefaults().getColor("Button.darcula.color1");
    }

    protected Color getSelectedButtonColor1() {
        return UIManager.getLookAndFeelDefaults().getColor("Button.darcula.selection.color1");
    }

    protected Color getHoverButtonColor1() {
        return UIManager.getLookAndFeelDefaults().getColor("Button.darculaMod.hoverColor1");
    }

    protected Color getHoverButtonColor2() {
        return UIManager.getLookAndFeelDefaults().getColor("DropDownButton.hover.color");
    }

    public static Color getButtonColorHubTitle() {
        return UIManager.getLookAndFeelDefaults().getColor("hub-title-fg");
    }

    public static Color getButtonColorHub() {
        return UIManager.getLookAndFeelDefaults().getColor("hub-button-fg");
    }

    public static Color getHoverButtonColorHub() {
        return UIManager.getLookAndFeelDefaults().getColor("hub-button-hover-fg");
    }
}

