/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import javax.swing.JPasswordField;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

class PasswordPropertyEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
InplaceEditor.Factory {
    private InplaceEditor ed = null;

    PasswordPropertyEditor() {
    }

    @Override
    public String getAsText() {
        return (String)this.getValue();
    }

    @Override
    public void setAsText(String s) {
        this.setValue(s);
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        gfx.setColor(Color.black);
        String s = this.getAsText();
        if (s != null) {
            int diameter = 9;
            int x = box.x + 1;
            int y = box.y + (box.height - diameter) / 2;
            for (int i = 0; i < s.length(); ++i) {
                gfx.fillOval(x, y, diameter, diameter);
                x += diameter + 2;
            }
        }
    }

    public void attachEnv(PropertyEnv env) {
        env.registerInplaceEditorFactory((InplaceEditor.Factory)this);
    }

    public InplaceEditor getInplaceEditor() {
        if (this.ed == null) {
            this.ed = new TextBoxInplaceEditor();
        }
        return this.ed;
    }

    private static class TextBoxInplaceEditor
    extends InplacePropertyEditor<JPasswordField> {
        public TextBoxInplaceEditor() {
            super(new JPasswordField());
            ((JPasswordField)this.getEditorControl()).setSelectionColor(Color.lightGray);
        }

        public Object getValue() {
            return new String(((JPasswordField)this.getEditorControl()).getPassword());
        }

        public void setValue(Object object) {
            ((JPasswordField)this.getEditorControl()).setText((String)object);
        }

        @Override
        protected void reset(Object value) {
            if (value != null) {
                ((JPasswordField)this.getEditorControl()).setText((String)value);
            }
        }
    }
}

