/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.product;

import com.paterva.maltego.licensing.LicenseErrorDisplayer;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.ui.LicenseWizardDisplayer;
import com.paterva.maltego.licensing.ui.manager.LicenseManagerController;
import com.paterva.maltego.licensing.ui.product.ActivationTypePanel;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import java.awt.event.ActionEvent;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;

public class ProductSelectionAction
extends SystemAction {
    private static boolean showing = false;

    public static void perform() {
        ((ProductSelectionAction)SystemAction.get(ProductSelectionAction.class)).actionPerformed(null);
    }

    public static boolean isShowing() {
        return showing;
    }

    public static boolean mayShow() {
        return !showing && !LicenseWizard.isShowing() && !LicenseManagerController.isShowing() && !LicenseErrorDisplayer.getDefault().isShowing();
    }

    public String getName() {
        return "Product Selection";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ev) {
        boolean done;
        if (!ProductSelectionAction.mayShow()) {
            return;
        }
        do {
            done = true;
            try {
                showing = true;
                ProductSelectionResult result = ActivationTypePanel.showActivationDialog();
                if (result == null) {
                    if (!LicenseManager.A().A(false).D()) continue;
                    NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)"Are you sure you want to exit Maltego?");
                    descriptor.setTitle("Exit");
                    descriptor.setOptions(new Object[]{"Exit", "Cancel"});
                    if ("Exit".equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor))) {
                        LifecycleManager.getDefault().exit();
                        continue;
                    }
                    done = false;
                    continue;
                }
                LicenseWizard.setProductSelectionResult(result);
                showing = false;
                LicenseWizardDisplayer.getDefault().run();
            }
            finally {
                showing = false;
            }
        } while (!done);
    }
}

