/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.seeds.ui.hub.settings;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedProvider;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.ComponentFactory;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import com.paterva.maltego.util.ui.dialog.ValidatingPanel;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.BorderLayout;
import java.awt.Color;
import java.net.URL;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import org.openide.awt.HtmlBrowser;

public class HubSeedRequiredSettingsPanel
extends ValidatingPanel {
    private final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();

    public HubSeedRequiredSettingsPanel(ValidatingController controller, HubSeedDescriptor seed) {
        super(controller);
        this.setBackground(this.LAF.getColor("3-main-dark-color"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(10, 10));
        Color orange = this.LAF.getColor("3-maltego-orange");
        Color titleBg = this.LAF.getColor("7-heading-panel-background");
        String contactInfoStr = this.getProviderContactInfo(seed);
        JTextPane descriptionPane = new JTextPane();
        descriptionPane.setContentType("text/html");
        descriptionPane.setForeground(orange);
        descriptionPane.setBackground(titleBg);
        descriptionPane.setEditable(false);
        descriptionPane.setBorder(new EmptyBorder(5, 10, 10, 10));
        descriptionPane.setHighlighter(null);
        descriptionPane.setOpaque(true);
        descriptionPane.setText("<html><body style=\"color:" + ColorUtilities.encode((Color)orange) + "\"><h3>Required Fields</h3>The following settings are required to install the " + seed.getDisplayName() + " Hub Item.<br>If you do not have the required info please contact:<br>" + contactInfoStr + "</body></html>");
        descriptionPane.addHyperlinkListener(event -> {
            URL url;
            if (HyperlinkEvent.EventType.ACTIVATED.equals(event.getEventType()) && !FileUtilities.isRemoteFileURL((URL)(url = event.getURL()))) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
        });
        this.add(descriptionPane, "North");
        HubSeedSettings settings = HubSeedSettings.getDefault();
        DisplayDescriptorCollection props = settings.getGlobalTransformProperties(seed);
        DataSource globalTxSettings = settings.getGlobalTransformSettings(seed);
        ComponentFactory factory = ComponentFactories.form(Collections.singletonMap("useRequiredFieldColor", false), (boolean)false);
        JComponent component = (JComponent)factory.createEditingComponent(globalTxSettings, (DisplayDescriptorEnumeration)props, null);
        this.add(component);
    }

    private String getProviderContactInfo(HubSeedDescriptor seed) {
        HubSeedProvider provider = seed.getProvider();
        StringBuilder contactInfo = new StringBuilder();
        if (provider != null) {
            String name = provider.getName();
            String email = provider.getEmail();
            String phone = provider.getPhone();
            String website = provider.getWebsite();
            contactInfo.append("<table>");
            if (name != null) {
                contactInfo.append("<tr><td colspan=\"2\"><b>").append(name).append("</b></td></tr>");
            }
            if (email != null) {
                contactInfo.append("<tr><td>Email:</td><td><a href=\"mailto:").append(email).append("\">").append(email).append("</a></td></tr>");
            }
            if (website != null) {
                contactInfo.append("<tr><td>Website:</td><td><a href=\"").append(website).append("\">").append(website).append("</a></td></tr>");
            }
            if (phone != null) {
                contactInfo.append("<tr><td>Phone:</td><td>").append(phone).append("</td></tr>");
            }
            contactInfo.append("</table>");
        }
        return contactInfo.toString();
    }
}

