/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.HashSet;
import java.util.Set;

public class EventBinding<T> {
    private final InstrumentationHandler.AbstractInstrumenter instrumenter;
    private final T element;
    volatile boolean disposing;
    private volatile boolean disposed;

    EventBinding(InstrumentationHandler.AbstractInstrumenter instrumenter, T element) {
        if (element == null) {
            throw new NullPointerException();
        }
        this.instrumenter = instrumenter;
        this.element = element;
    }

    final InstrumentationHandler.AbstractInstrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public T getElement() {
        return this.element;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.disposed) {
            this.disposing = true;
            this.instrumenter.disposeBinding(this);
            this.disposed = true;
        }
    }

    synchronized void setDisposingBulk() {
        this.disposing = true;
    }

    synchronized void disposeBulk() {
        this.disposed = true;
    }

    static final class Allocation<T>
    extends EventBinding<T> {
        private final AllocationEventFilter filterAllocation;

        Allocation(InstrumentationHandler.AbstractInstrumenter instrumenter, AllocationEventFilter filter, T listener) {
            super(instrumenter, listener);
            this.filterAllocation = filter;
        }

        AllocationEventFilter getAllocationFilter() {
            return this.filterAllocation;
        }
    }

    static final class Source<T>
    extends EventBinding<T> {
        private final SourceSectionFilter filterSourceSection;
        private final SourceSectionFilter inputFilter;
        private final boolean isExecutionEvent;

        Source(InstrumentationHandler.AbstractInstrumenter instrumenter, SourceSectionFilter filterSourceSection, SourceSectionFilter inputFilter, T element, boolean isExecutionEvent) {
            super(instrumenter, element);
            this.inputFilter = inputFilter;
            this.filterSourceSection = filterSourceSection;
            this.isExecutionEvent = isExecutionEvent;
        }

        SourceSectionFilter getInputFilter() {
            return this.inputFilter;
        }

        Set<Class<?>> getLimitedTags() {
            Set<Class<?>> tags = this.filterSourceSection.getLimitedTags();
            if (this.inputFilter != null) {
                Set<Class<?>> inputTags = this.inputFilter.getLimitedTags();
                if (tags == null) {
                    return inputTags;
                }
                if (inputTags == null) {
                    return tags;
                }
                if (inputTags.equals(tags)) {
                    return tags;
                }
                HashSet compoundTags = new HashSet();
                compoundTags.addAll(tags);
                compoundTags.addAll(inputTags);
                return compoundTags;
            }
            return tags;
        }

        public SourceSectionFilter getFilter() {
            return this.filterSourceSection;
        }

        boolean isInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node node, SourceSection nodeSourceSection) {
            if (this.isInstrumentedLeaf(providedTags, node, nodeSourceSection)) {
                if (rootNode == null) {
                    return false;
                }
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        boolean isChildInstrumentedFull(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent)) {
                return false;
            }
            if (this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.isInstrumentedNodeWithInputFilter(providedTags, current, currentSourceSection)) {
                return this.isInstrumentedRoot(providedTags, rootNode, rootNode.getSourceSection(), 0);
            }
            return false;
        }

        boolean isChildInstrumentedLeaf(Set<Class<?>> providedTags, RootNode rootNode, Node parent, SourceSection parentSourceSection, Node current, SourceSection currentSourceSection) {
            if (this.inputFilter == null) {
                return false;
            }
            if (rootNode == null) {
                return false;
            }
            if (!InstrumentationHandler.isInstrumentableNode(parent)) {
                return false;
            }
            return this.isInstrumentedLeaf(providedTags, parent, parentSourceSection) && this.isInstrumentedNodeWithInputFilter(providedTags, current, currentSourceSection);
        }

        private boolean isInstrumentedNodeWithInputFilter(Set<Class<?>> providedTags, Node current, SourceSection currentSourceSection) {
            try {
                return this.inputFilter.isInstrumentedNode(providedTags, current, currentSourceSection);
            }
            catch (Throwable t) {
                if (this.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.inputFilter.toString(), t);
                return false;
            }
        }

        boolean isInstrumentedRoot(Set<Class<?>> providedTags, RootNode rootNode, SourceSection rootSourceSection, int rootNodeBits) {
            if (!this.getInstrumenter().isInstrumentableRoot(rootNode)) {
                return false;
            }
            try {
                return this.getFilter().isInstrumentedRoot(providedTags, rootSourceSection, rootNode, rootNodeBits);
            }
            catch (Throwable t) {
                if (this.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t);
                return false;
            }
        }

        boolean isInstrumentedLeaf(Set<Class<?>> providedTags, Node instrumentedNode, SourceSection section) {
            try {
                return this.getFilter().isInstrumentedNode(providedTags, instrumentedNode, section);
            }
            catch (Throwable t) {
                if (this.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t);
                return false;
            }
        }

        boolean isInstrumentedSource(com.oracle.truffle.api.source.Source source) {
            if (!this.getInstrumenter().isInstrumentableSource(source)) {
                return false;
            }
            try {
                return this.getFilter().isInstrumentedSource(source);
            }
            catch (Throwable t) {
                if (this.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this, this.getFilter().toString(), t);
                return false;
            }
        }

        boolean isExecutionEvent() {
            return this.isExecutionEvent;
        }

        boolean isLanguageBinding() {
            return this.getInstrumenter() instanceof InstrumentationHandler.LanguageClientInstrumenter;
        }
    }
}

