/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.customicons.imex.CategorizedIcons;
import com.paterva.maltego.customicons.imex.IconDiscoveryItems;
import com.paterva.maltego.customicons.imex.IconImporter;
import com.paterva.maltego.customicons.imex.IconRegistryIcon;
import com.paterva.maltego.discovery.DiscoveryContext;
import com.paterva.maltego.discovery.DiscoveryMergingRules;
import com.paterva.maltego.discovery.DiscoveryProvider;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.openide.util.Exceptions;

public class IconDiscoveryProvider
implements DiscoveryProvider<IconDiscoveryItems> {
    public IconDiscoveryItems getNewAndMerged(IconDiscoveryItems items) {
        CategorizedIcons icons = items.getIcons();
        DiscoveryMergingRules.IconRule rule = items.getContext().getMergingRules().getIconRule();
        IconRegistry registry = IconRegistry.getDefault();
        ArrayList<IconRegistryIcon> newIcons = new ArrayList<IconRegistryIcon>();
        for (Map.Entry categoryEntry : icons.entrySet()) {
            String category = (String)categoryEntry.getKey();
            Map names = (Map)categoryEntry.getValue();
            for (Map.Entry nameEntry : names.entrySet()) {
                IconSize size;
                String name = (String)nameEntry.getKey();
                Map sizes = (Map)nameEntry.getValue();
                boolean mustImport = false;
                if (!registry.existsCaseInsensitive(category, name)) {
                    mustImport = true;
                } else if (rule.equals((Object)DiscoveryMergingRules.IconRule.REPLACE)) {
                    for (Map.Entry sizeEntry : sizes.entrySet()) {
                        size = (IconSize)sizeEntry.getKey();
                        Image newImage = (Image)sizeEntry.getValue();
                        Image oldImage = registry.loadImage(category, name, size, null).orElse(null);
                        if (oldImage != null) {
                            BufferedImage oldBuffImg;
                            BufferedImage newBuffImg = ImageUtils.createBufferedImage((Image)newImage);
                            if (ImageUtils.equals((BufferedImage)newBuffImg, (BufferedImage)(oldBuffImg = ImageUtils.createBufferedImage((Image)oldImage)))) continue;
                            mustImport = true;
                            break;
                        }
                        mustImport = true;
                        break;
                    }
                }
                if (!mustImport) continue;
                for (Map.Entry sizeEntry : sizes.entrySet()) {
                    size = (IconSize)sizeEntry.getKey();
                    Image image = (Image)sizeEntry.getValue();
                    newIcons.add(new IconRegistryIcon(category, name, size, image));
                }
            }
        }
        return new IconDiscoveryItems(this, CategorizedIcons.fromList(newIcons, icons.getMetadatas()), items.getContext());
    }

    public void apply(IconDiscoveryItems icons) {
        try {
            DiscoveryContext ctx = icons.getContext();
            String seedUrl = ctx.getSeedUrl();
            HubSeedDescriptor hubSeed = HubSeedRegistry.getDefault().getHubSeed(seedUrl);
            String hubItem = hubSeed == null ? null : hubSeed.getName();
            IconImporter importer = new IconImporter();
            importer.apply(IconRegistry.getDefault(), this.getNewAndMerged(icons).getIcons(), hubItem);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

