/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.customicons.imex.IconConfig;
import com.paterva.maltego.customicons.imex.IconDescriptor;
import com.paterva.maltego.customicons.imex.IconEntryFactory;
import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconMetadataEntryFactory;
import com.paterva.maltego.customicons.imex.SelectableCategory;
import com.paterva.maltego.customicons.imex.SelectableIcon;
import com.paterva.maltego.customicons.imex.Util;
import com.paterva.maltego.imgfactory.icons.DefaultIconLayerRegistry;
import com.paterva.maltego.imgfactory.icons.IconExistInfo;
import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class IconConfigImporter
extends ConfigImporter {
    private boolean _doCleanup = true;

    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List metadatas = reader.readAll((EntryFactory)new IconMetadataEntryFactory(), "Graph1");
        List icons = reader.readAll((EntryFactory)new IconEntryFactory(metadatas), "Graph1");
        return this.createConfig(icons, metadatas);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        DefaultIconLayerRegistry oldRegistry = new DefaultIconLayerRegistry(configRoot, true);
        List<IconDescriptor> icons = Util.createDescriptors((IconLayerRegistry)oldRegistry);
        List<IconMetadata> metadatas = Util.getIconMetadatas((IconLayerRegistry)oldRegistry);
        this._doCleanup = false;
        return this.createConfig(icons, metadatas);
    }

    private Config createConfig(List<IconDescriptor> icons, List<IconMetadata> metadatas) throws IOException {
        while (icons.contains(null)) {
            icons.remove(null);
        }
        if (icons.isEmpty()) {
            return null;
        }
        List<SelectableCategory> selectableCategories = Util.createSelectables(icons, metadatas);
        this.verify(selectableCategories);
        IconExistInfo existInfo = new IconExistInfo();
        for (SelectableCategory selectableCategory : selectableCategories) {
            boolean oneSelected = false;
            for (SelectableIcon selectableIcon : selectableCategory.getIcons()) {
                String iconName = selectableIcon.getIconName();
                boolean iconSelected = !existInfo.exist(selectableCategory.getName(), iconName);
                selectableIcon.setSelected(iconSelected);
                oneSelected |= iconSelected;
            }
            selectableCategory.setSelected(oneSelected);
        }
        return new IconConfig(selectableCategories);
    }

    private void verify(List<SelectableCategory> selectableCategories) throws IOException {
        boolean svgAvailable = false;
        for (SelectableCategory selectableCategory : selectableCategories) {
            for (SelectableIcon selectableIcon : selectableCategory.getIcons()) {
                IconDescriptor descriptor;
                for (IconSize iconSize : IconSize.values()) {
                    descriptor = selectableIcon.getIcon(iconSize);
                    if (descriptor == null || !ImageUtils.isSVGFile((FileObject)descriptor.getFileObject())) continue;
                    svgAvailable = true;
                }
                for (IconSize iconSize : IconSize.values()) {
                    descriptor = selectableIcon.getIcon(iconSize);
                    if (descriptor == null && iconSize == IconSize.MASSIVE) {
                        descriptor = selectableIcon.getIcon(IconSize.LARGE);
                    }
                    if (descriptor == null) {
                        if (svgAvailable) continue;
                        int size = iconSize.getSize();
                        throw new IOException(size + "x" + size + " icon missing for " + selectableIcon.getIconName() + " with category " + selectableCategory.getName());
                    }
                    FileObject fileObject = descriptor.getFileObject();
                    if (fileObject == null) {
                        throw new IOException("Could not open icon " + descriptor.getIconName());
                    }
                    try (InputStream is = fileObject.getInputStream();){
                        BufferedImage img = ImageIO.read(is);
                        if (img == null) {
                            throw new IOException(fileObject.getNameExt() + " is not a valid image file");
                        }
                        if (ImageUtils.isSVGFile((FileObject)fileObject)) continue;
                        int width = img.getWidth();
                        int height = img.getHeight();
                        if (iconSize.getSize() == width || iconSize == IconSize.MASSIVE && (iconSize != IconSize.MASSIVE || width == height || IconSize.MASSIVE.getSize() == width || IconSize.LARGE.getSize() == width)) continue;
                        throw new IOException(fileObject.getNameExt() + " has width " + width + " instead of expected " + iconSize.getSize());
                    }
                }
            }
        }
    }

    public int applyConfig(Config config) {
        int importNum = 0;
        IconConfig iconConfig = (IconConfig)config;
        IconLayerRegistry iconRegistry = IconLayerRegistry.getDefault();
        for (SelectableCategory selectableCategory : iconConfig.getSelectedCategories()) {
            for (SelectableIcon selectableIcon : selectableCategory.getSelectedIcons()) {
                try {
                    String category = selectableCategory.getName();
                    IconSize[] iconName = selectableIcon.getIconName();
                    Optional iconOpt = iconRegistry.findRegistryIcon(new VirtualIcon(category, (String)iconName));
                    if (iconOpt.isPresent()) {
                        RegistryIcon existingIcon = (RegistryIcon)iconOpt.get();
                        category = existingIcon.getCategory();
                        iconRegistry.remove(existingIcon);
                    }
                    Map<IconSize, FileObject> iconFiles = selectableIcon.getIcons().stream().collect(Collectors.toMap(IconDescriptor::getSize, IconDescriptor::getFileObject));
                    RegistryIcon icon = iconRegistry.addFromFiles(category, (String)iconName, iconFiles);
                    Optional<IconMetadata> metadata = selectableIcon.getMetadata();
                    if (metadata.isPresent()) {
                        iconRegistry.setAliases(icon, metadata.get().getAliases());
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                ++importNum;
            }
        }
        if (this._doCleanup) {
            try {
                for (SelectableCategory selectableCategory : iconConfig.getSelectedCategories()) {
                    for (SelectableIcon selectableIcon : selectableCategory.getSelectedIcons()) {
                        FileObject parent;
                        FileObject fileObject = null;
                        for (IconSize iconSize : IconSize.values()) {
                            IconDescriptor descriptor = selectableIcon.getIcon(iconSize);
                            if (descriptor == null && iconSize == IconSize.MASSIVE) {
                                descriptor = selectableIcon.getIcon(IconSize.LARGE);
                            }
                            if (descriptor == null || (fileObject = descriptor.getFileObject()) == null || !fileObject.canWrite()) continue;
                            fileObject.delete();
                        }
                        if (fileObject == null || (parent = fileObject.getParent()) == null || parent.getChildren().length != 0) continue;
                        parent.delete();
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return importNum;
    }
}

