/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.mode;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.ActivationException;
import com.paterva.maltego.licensing.D;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.LicensingException;
import com.paterva.maltego.licensing.json.rest.JsonLicenseRestRequests;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseResponse;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.mode.C;
import com.paterva.maltego.licensing.serialize.N;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.keycloak.representations.AccessToken;

public class B {
    private static final Logger A = Logger.getLogger(B.class.getName());

    public static Optional<A> A(long time, D license, boolean checkOnline) throws Exception {
        A licenseMode = null;
        if (license != null) {
            if (!checkOnline) {
                licenseMode = com.paterva.maltego.licensing.mode.A.A(time, license, true);
                A.log(Level.FINE, "Offline license check: {0}", licenseMode.V());
            } else {
                boolean isSame = true;
                boolean serverReached = false;
                String licenseKey = license.C();
                try {
                    isSame = com.paterva.maltego.licensing.rest.A.B(licenseKey, license.G());
                    serverReached = true;
                }
                catch (Exception ex) {
                    NormalException.logStackTrace((Throwable)ex);
                }
                if (isSame) {
                    licenseMode = com.paterva.maltego.licensing.mode.A.A(time, license, serverReached);
                    A.log(Level.FINE, "License same as on server: {0}", licenseMode.V());
                } else {
                    String msg = "License NOT same as on server, reactivating...";
                    A.log(Level.FINE, msg);
                    com.paterva.maltego.licensing.serialize.C.B(msg);
                    Optional<D> licenseOpt = null;
                    try {
                        licenseOpt = C.A(licenseKey);
                    }
                    catch (LicensingException ex) {
                        A.log(Level.WARNING, "Failed to re-activate license after it changed on the server: {0}", ex.getMessage());
                    }
                    if (licenseOpt != null && licenseOpt.isPresent()) {
                        licenseMode = com.paterva.maltego.licensing.mode.A.A(time, licenseOpt.get(), serverReached);
                    }
                    SwingUtilities.invokeLater(() -> LicenseManager.A().E());
                }
            }
        }
        return Optional.ofNullable(licenseMode);
    }

    public static Optional<A> B(long time, JsonLicenseResponse license, boolean checkOnline, boolean maltegoIdOffline) throws Exception {
        A licenseMode = null;
        if (license != null) {
            if (!checkOnline || maltegoIdOffline) {
                licenseMode = com.paterva.maltego.licensing.mode.A.R(time, license, true, maltegoIdOffline);
                A.log(Level.FINE, "Offline maltego ID license check: {0}", licenseMode.V());
            } else {
                boolean isSameAccordingToServer = true;
                boolean isSameInfoAndCapabilities = true;
                boolean serverReached = false;
                if (CloudAuth.getDefault().isAuthorized()) {
                    A.fine("Checking activation is same on server");
                    String msg = "License NOT same as on server, reactivating...";
                    try {
                        String activationId = license.getActivationId();
                        JsonLicenseResponse licenseResponse = JsonLicenseRestRequests.isSameWithMaltegoID(activationId);
                        isSameAccordingToServer = licenseResponse.getActivationId().equalsIgnoreCase(activationId);
                        if (isSameAccordingToServer) {
                            A.log(Level.FINE, "Activation is the same on server: {0}", activationId);
                        } else {
                            A.log(Level.WARNING, "Activation is NOT same - on this machine : {0}, on server: {1}", new Object[]{activationId, licenseResponse.getActivationId()});
                        }
                        isSameInfoAndCapabilities = license.equalInfoAndCapabilities(licenseResponse);
                        if (!isSameInfoAndCapabilities) {
                            license = licenseResponse;
                        }
                        serverReached = true;
                    }
                    catch (ActivationException ex) {
                        if (!ex.isCommunicationError()) {
                            String message;
                            isSameAccordingToServer = false;
                            String displayMessage = ex.getDisplayMessage();
                            displayMessage = StringUtilities.isNullOrEmpty((String)displayMessage) ? (StringUtilities.isNullOrEmpty((String)(message = ex.getMessage())) ? "Error checking Maltego ID activation, reactivating..." : message + ", reactivating...") : displayMessage + " Reactivating...";
                            msg = displayMessage;
                        }
                        A.log(Level.WARNING, "Error checking Maltego ID activation: {0}", ex.getMessage());
                        NormalException.logStackTrace((Throwable)ex);
                    }
                    catch (Exception ex) {
                        NormalException.logStackTrace((Throwable)ex);
                    }
                    if (isSameAccordingToServer) {
                        licenseMode = com.paterva.maltego.licensing.mode.A.R(time, license, serverReached, maltegoIdOffline);
                        if (isSameInfoAndCapabilities) {
                            A.log(Level.FINE, "License same as on server: {0}", licenseMode.V());
                        } else {
                            A.log(Level.FINE, "License same as on server, but details changed: {0}", licenseMode.V());
                            SwingUtilities.invokeLater(() -> LicenseManager.A().E());
                        }
                    } else {
                        A.log(Level.FINE, msg);
                        N.B().C(msg);
                        Optional<JsonLicenseResponse> licenseOpt = null;
                        try {
                            licenseOpt = C.C();
                        }
                        catch (ActivationException ex) {
                            A.log(Level.WARNING, "Failed to re-activate license after it changed on the server: {0}", ex.getMessage());
                        }
                        if (licenseOpt != null && licenseOpt.isPresent()) {
                            licenseMode = com.paterva.maltego.licensing.mode.A.R(time, licenseOpt.get(), serverReached, maltegoIdOffline);
                        }
                        SwingUtilities.invokeLater(() -> {
                            LicenseManager.A().E();
                            try {
                                AccessToken accessToken = CloudAuth.getDefault().getAccessToken();
                                com.paterva.maltego.licensing.free.B.A().A(accessToken);
                            }
                            catch (Exception ex) {
                                A.log(Level.WARNING, "Failed to update display user info after re-activation: {0}", ex.getMessage());
                            }
                        });
                    }
                }
            }
        }
        return Optional.ofNullable(licenseMode);
    }
}

