/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.registry.HubSeedSettings;
import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformPropertyDescriptor;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.transform.manager.nodes.ManagedProperty;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.StringUtilities;

public class HubTransformPropertyProxy
extends TransformPropertyDescriptor
implements ManagedProperty {
    private final TransformDefinition _transform;
    private final TransformPropertyDescriptor _hubProperty;
    private final TransformPropertyDescriptor _transformProperty;
    private final HubSeedDescriptor _hubSeed;

    public HubTransformPropertyProxy(TransformPropertyDescriptor hubProperty, TransformDefinition transform, HubSeedDescriptor hubSeed) {
        super(hubProperty);
        this._hubSeed = hubSeed;
        this._hubProperty = hubProperty;
        this._transform = transform;
        this._transformProperty = (TransformPropertyDescriptor)this._transform.getProperties().get(this._hubProperty.getName());
    }

    private Object getValue() {
        Object value = HubSeedSettings.getDefault().getGlobalTransformSettings(this._hubSeed).getValue((PropertyDescriptor)this._hubProperty);
        return value != null ? value : this._hubProperty.getDefaultValue();
    }

    @Override
    public boolean isPopup() {
        Popup popup = this._transform.getPopup((PropertyDescriptor)this._transformProperty);
        return popup == Popup.Yes || !this._hubProperty.isNullable() && this.isNull(this.getValue());
    }

    @Override
    public void setPopup(boolean popup) {
        if (this.canChangePopup()) {
            if (popup) {
                this._transform.setPopup((PropertyDescriptor)this, Popup.Yes);
            } else {
                this._transform.setPopup((PropertyDescriptor)this, Popup.No);
            }
        }
    }

    public Visibility getVisibility() {
        return super.getVisibility();
    }

    public void setVisibility(Visibility visibility) {
    }

    @Override
    public void setInternal(boolean internal) {
    }

    @Override
    public boolean canChangeVisibility() {
        return false;
    }

    @Override
    public boolean canChangeReadonly() {
        return true;
    }

    @Override
    public boolean canChangePopup() {
        return true;
    }

    @Override
    public boolean isReadonly() {
        return super.isReadonly();
    }

    public boolean isHidden() {
        return this.getVisibility() == Visibility.Hidden;
    }

    public String getImage() {
        if (this.isInternal()) {
            return "com/paterva/maltego/transform/manager/resources/Internal.gif";
        }
        if (this.isPopup() && this.isAuth()) {
            return "com/paterva/maltego/transform/manager/resources/PopupKey.png";
        }
        if (this.isPopup()) {
            return "com/paterva/maltego/transform/manager/resources/Popup.gif";
        }
        if (this.isAuth()) {
            return "com/paterva/maltego/transform/manager/resources/Key.png";
        }
        return super.getImage();
    }

    public String getHtmlDisplayName() {
        if (this.isAbstract()) {
            return "[" + this.getDisplayName() + "]";
        }
        return super.getHtmlDisplayName();
    }

    private boolean isNull(Object o) {
        if (o instanceof String) {
            return StringUtilities.isNullOrEmpty((String)((String)o));
        }
        return o == null;
    }
}

