/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.table;

import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.ui.CheckList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.TableColumnSelector;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class EditableTableColumnSelector
extends TableColumnSelector {
    private ListMap<String, String> _selectableColumns;
    private ETable _table;
    private String[] _allColumns;

    public EditableTableColumnSelector(ETable table, String[] allColumns, String[] selectable) {
        this(table, allColumns, selectable, selectable);
    }

    public EditableTableColumnSelector(ETable table, String[] allColumns, String[] selectable, String[] displayNames) {
        if (selectable == null || displayNames == null || selectable.length != displayNames.length) {
            throw new IllegalArgumentException("Selectable and display name arrays must be non null and of equal length.");
        }
        this._table = table;
        this._allColumns = allColumns;
        this._selectableColumns = new ListMap();
        for (int i = 0; i < selectable.length; ++i) {
            this._selectableColumns.put((Object)selectable[i], (Object)displayNames[i]);
        }
    }

    public String[] selectVisibleColumns(TableColumnSelector.TreeNode root, String[] selected) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Not implemented"));
        return new String[0];
    }

    public String[] selectVisibleColumns(String[] available, String[] selected) {
        JPanel panel = new JPanel(new BorderLayout(5, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(12, 5, 5, 5));
        CheckList checkList = new CheckList(this.createColumnItems());
        checkList.setBackground(new JPanel().getBackground());
        Object[] selectedItems = this.createColumnItems(selected);
        checkList.setSelectedItems(selectedItems);
        panel.add((Component)checkList, "Center");
        panel.add(Box.createHorizontalStrut(20), "West");
        panel.add((Component)new JLabel("Select the columns to display in the table:"), "North");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "Select table columns");
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            Object[] items = checkList.getSelectedItems();
            selected = this.getNames(items);
        }
        LinkedList<String> result = new LinkedList<String>();
        Enumeration<TableColumn> currentlyVisible = this._table.getColumnModel().getColumns();
        while (currentlyVisible.hasMoreElements()) {
            String string = currentlyVisible.nextElement().getHeaderValue().toString();
            if (!this.contains(selected, string)) continue;
            result.add(string);
        }
        for (String s : this._allColumns) {
            if (!this._selectableColumns.containsKey((Object)s) && !result.contains(s)) {
                result.add(s);
                continue;
            }
            if (!this.contains(selected, s) || result.contains(s)) continue;
            result.add(s);
        }
        String[] stringArray = result.toArray(new String[result.size()]);
        return stringArray;
    }

    private ColumnItem[] createColumnItems() {
        ColumnItem[] items = new ColumnItem[this._selectableColumns.size()];
        int index = 0;
        for (Map.Entry entry : this._selectableColumns.entrySet()) {
            items[index++] = new ColumnItem((String)entry.getKey(), (String)entry.getValue());
        }
        return items;
    }

    private ColumnItem[] createColumnItems(String[] names) {
        ColumnItem[] items = new ColumnItem[names.length];
        for (int i = 0; i < names.length; ++i) {
            items[i] = new ColumnItem(names[i], (String)this._selectableColumns.get((Object)names[i]));
        }
        return items;
    }

    private String[] getNames(Object[] items) {
        String[] names = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            names[i] = ((ColumnItem)items[i]).getName();
        }
        return names;
    }

    private boolean contains(String[] array, String value) {
        for (String s : array) {
            if (!s.equals(value)) continue;
            return true;
        }
        return false;
    }

    private class ColumnItem {
        private String _name;
        private String _displayName;

        public ColumnItem(String name) {
            this(name, null);
        }

        public ColumnItem(String name, String displayName) {
            this._name = name;
            this._displayName = displayName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public boolean equals(ColumnItem item) {
            if (item == null) {
                return false;
            }
            return item.getName().equals(this.getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ColumnItem) {
                return this.equals((ColumnItem)obj);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this._name != null ? this._name.hashCode() : 0);
            return hash;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getDisplayName() {
            if (this._displayName == null) {
                return this._name;
            }
            return this._displayName;
        }

        public void setDisplayName(String displayName) {
            this._displayName = displayName;
        }
    }
}

