/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.laf;

import java.awt.Color;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.graphics.ColorUtilities;

public class Colors {
    public static Color getQuarkXPressShade(Color a, float shadePercentage) {
        float rShade = 255.0f - (255.0f - (float)a.getRed()) / 100.0f * shadePercentage;
        float gShade = 255.0f - (255.0f - (float)a.getGreen()) / 100.0f * shadePercentage;
        float bShade = 255.0f - (255.0f - (float)a.getBlue()) / 100.0f * shadePercentage;
        rShade = Colors.bracket(rShade / 255.0f);
        gShade = Colors.bracket(gShade / 255.0f);
        bShade = Colors.bracket(bShade / 255.0f);
        return new Color(rShade, gShade, bShade, (float)a.getAlpha() / 255.0f);
    }

    private static float bracket(float input) {
        input = Math.min(input, 1.0f);
        input = Math.max(input, 0.0f);
        return input;
    }

    public static boolean isBrighter(Color a, Color b) {
        int[] ac = new int[]{a.getRed(), a.getGreen(), a.getBlue()};
        int[] bc = new int[]{b.getRed(), b.getGreen(), b.getBlue()};
        int dif = 0;
        for (int i = 0; i < 3; ++i) {
            int currDif = ac[i] - bc[i];
            if (Math.abs(currDif) <= Math.abs(dif)) continue;
            dif = currDif;
        }
        return dif > 0;
    }

    public static int averageDifference(Color a, Color b) {
        int[] ac = new int[]{a.getRed(), a.getGreen(), a.getBlue()};
        int[] bc = new int[]{b.getRed(), b.getGreen(), b.getBlue()};
        int dif = 0;
        for (int i = 0; i < 3; ++i) {
            dif += bc[i] - ac[i];
        }
        return dif / 3;
    }

    public static Color adjustComponentsTowards(Color toAdjust, Color towards) {
        int r = toAdjust.getRed();
        int g = toAdjust.getGreen();
        int b = toAdjust.getBlue();
        int ra = towards.getRed();
        int ga = towards.getGreen();
        int ba = towards.getBlue();
        r += Colors.minMax((ra - r) / 3);
        g += Colors.minMax((ga - g) / 3);
        b += Colors.minMax((ba - b) / 3);
        return new Color(r, g, b);
    }

    public static Color adjustTowards(Color toAdjust, int amount, Color towards) {
        int r = toAdjust.getRed();
        int g = toAdjust.getGreen();
        int b = toAdjust.getBlue();
        int factor = Colors.isBrighter(towards, toAdjust) ? 1 : -1;
        r = Colors.minMax(r + factor * amount);
        g = Colors.minMax(g + factor * amount);
        b = Colors.minMax(b + factor * amount);
        return new Color(r, g, b);
    }

    public static Color adjustBy(Color toAdjust, int amount) {
        int r = Colors.minMax(toAdjust.getRed() + amount);
        int g = Colors.minMax(toAdjust.getGreen() + amount);
        int b = Colors.minMax(toAdjust.getBlue() + amount);
        return new Color(r, g, b);
    }

    public static Color adjustBy(Color toAdjust, int[] amounts) {
        int r = Colors.minMax(toAdjust.getRed() + amounts[0]);
        int g = Colors.minMax(toAdjust.getGreen() + amounts[1]);
        int b = Colors.minMax(toAdjust.getBlue() + amounts[2]);
        return new Color(r, g, b);
    }

    public static Color getMiddle(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public static Color saturate(Color c, float amount) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[1] = hsb[1] + amount;
        hsb[1] = Math.min(hsb[1], 1.0f);
        hsb[1] = Math.max(hsb[1], 0.0f);
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static Color lighten(Color c, float amount) {
        float[] hsl = ColorUtilities.RGBtoHSL((Color)c);
        hsl[2] = hsl[2] + amount;
        hsl[2] = Math.min(hsl[2], 1.0f);
        hsl[2] = Math.max(hsl[2], 0.0f);
        return ColorUtilities.HSLtoRGB((float)hsl[0], (float)hsl[1], (float)hsl[2]);
    }

    public static Color darken(Color c, float amount) {
        return Colors.lighten(c, -amount);
    }

    public static Color invert(Color c) {
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        hsb[1] = Math.min(hsb[1], 0.1f);
        hsb[2] = (double)hsb[2] < 0.6 || c.getRed() < 50 && c.getGreen() < 50 ? 0.9f : 0.1f;
        return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
    }

    public static Color setAlpha(Color c, int alpha) {
        return ColorUtil.setAlpha((Color)c, (int)alpha);
    }

    private static int minMax(int i) {
        if (i < 0) {
            return 0;
        }
        if (i > 255) {
            return 255;
        }
        return i;
    }
}

