/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.webtx.action;

import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class SendToUrlSettings {
    private static SendToUrlSettings _instance;
    protected static final String PREF_SEND_TO_URL = "maltego.sendtourl";
    protected static final String PREF_URL_COUNT = "maltego.sendtourl.count";

    protected SendToUrlSettings() {
    }

    public static synchronized SendToUrlSettings getDefault() {
        if (_instance == null && (_instance = (SendToUrlSettings)Lookup.getDefault().lookup(SendToUrlSettings.class)) == null) {
            _instance = new SendToUrlSettings();
        }
        return _instance;
    }

    public String[] getUrls() {
        String url;
        Preferences prefs = this.getPreferences();
        int count = this.getCount(prefs);
        ArrayList<String> urls = new ArrayList<String>(count);
        for (int i = 0; i < count && !StringUtilities.isNullOrEmpty((String)(url = this.getUrl(prefs, i))); ++i) {
            urls.add(url);
        }
        return urls.toArray(new String[urls.size()]);
    }

    public void addUrl(String url) {
        if (!StringUtilities.isNullOrEmpty((String)url)) {
            String[] urls;
            for (String otherUrl : urls = this.getUrls()) {
                if (!url.equals(otherUrl)) continue;
                return;
            }
            Preferences prefs = this.getPreferences();
            this.setUrl(prefs, urls.length, url);
            this.setCount(prefs, urls.length + 1);
        }
    }

    public void clearUrls() {
        this.setCount(this.getPreferences(), 0);
    }

    protected int getCount(Preferences prefs) {
        return prefs.getInt(PREF_URL_COUNT, 0);
    }

    protected void setCount(Preferences prefs, int count) {
        prefs.putInt(PREF_URL_COUNT, count);
    }

    protected String getUrl(Preferences prefs, int index) {
        return prefs.get(SendToUrlSettings.getUrlKey(index), null);
    }

    protected void setUrl(Preferences prefs, int index, String url) {
        prefs.put(SendToUrlSettings.getUrlKey(index), url);
    }

    private static String getUrlKey(int index) {
        return "maltego.sendtourl." + index;
    }

    protected Preferences getPreferences() {
        return NbPreferences.forModule(SendToUrlSettings.class);
    }
}

