/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.api.TransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformAdapterFactory;
import com.paterva.maltego.transform.runner.api.TransformHandle;
import com.paterva.maltego.transform.runner.api.TransformMessageHandler;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformResultHandler;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformRunnable;
import com.paterva.maltego.transform.runner.api.TransformRunner;
import com.paterva.maltego.transform.runner.api.TransformRunnerContext;
import com.paterva.maltego.util.Args;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class DefaultTransformRunner
extends TransformRunner {
    private static final int THROUGHPUT = 5;
    private RequestProcessor _processor = null;
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    @Override
    public TransformHandle run(TransformRunnerContext ctx, ProgressContributor progressContributor) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull((Object)progressContributor, (String)"progressContributor");
        DefaultTransformRunnable runnable = new DefaultTransformRunnable(ctx, progressContributor);
        RequestProcessor.Task task = this.getProcessor().create((Runnable)runnable);
        this.getProcessor().post((Runnable)task);
        runnable.setCancelDelegate((Cancellable)task);
        return runnable;
    }

    @Override
    public void cancelAll() {
        if (this._processor == null) {
            return;
        }
        RequestProcessor processor = this._processor;
        this._processor = null;
        processor.stop();
        List runnables = processor.shutdownNow();
        for (Runnable runnable : runnables) {
            if (!(runnable instanceof RequestProcessor.Task)) continue;
            RequestProcessor.Task task = (RequestProcessor.Task)runnable;
            task.cancel();
        }
    }

    @Override
    public boolean cancel(TransformHandle handle) {
        if (handle instanceof DefaultTransformRunnable) {
            DefaultTransformRunnable runnable = (DefaultTransformRunnable)handle;
            runnable.cancelled();
            return true;
        }
        return false;
    }

    private RequestProcessor getProcessor() {
        if (this._processor == null) {
            this._processor = new RequestProcessor("Transform Runner", 5, true);
        }
        return this._processor;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private void fireTransformStarted(TransformRunnable transformRunnable) {
        this._changeSupport.firePropertyChange("transform.started", null, transformRunnable);
    }

    private void fireTransformProgress(TransformRunnable transformRunnable) {
        this._changeSupport.firePropertyChange("transform.progress", null, transformRunnable);
    }

    private void fireTransformDone(TransformRunnable transformRunnable) {
        this._changeSupport.firePropertyChange("transform.done", null, transformRunnable);
    }

    private class DefaultTransformRunnable
    implements TransformRunnable {
        private final TransformRunContext _ctx;
        private Cancellable _cancelDelegate;
        private int _lastProgress = -1;
        private String _lastMessage;
        private TransformAdapter _adapter;
        private boolean _cancelled;
        private final ProgressContributor _progressContributor;

        public DefaultTransformRunnable(TransformRunnerContext ctx, ProgressContributor progressContributor) {
            this._ctx = new TransformRunContext(ctx, this);
            this._cancelled = false;
            this._progressContributor = progressContributor;
        }

        @Override
        public TransformRunContext getContext() {
            return this._ctx;
        }

        @Override
        public void resultReceived(TransformResult result) {
            if (this._cancelled) {
                return;
            }
            String msg = result.getLastProgressMessage();
            if (result.getLastProgress() > this._lastProgress || Utilities.compareObjects((Object)this._lastMessage, (Object)msg) && msg != null) {
                this._lastProgress = result.getLastProgress();
                this._lastMessage = msg;
                if (this._lastProgress < 0) {
                    this._progressContributor.progress(msg);
                } else {
                    this._progressContributor.progress(msg, this._lastProgress);
                }
                DefaultTransformRunner.this.fireTransformProgress(this);
            }
            if (result.getMessages() != null) {
                TransformMessageHandler.getDefault().handle(this._ctx, result.getMessages(), result.getInputEntity());
            }
            if (result.transformComplete() || result.getGraphID() != null) {
                TransformResultHandler.getDefault().updateGraph(this._ctx, result);
            }
        }

        @Override
        public synchronized void cancelled() {
            try {
                if (this._cancelDelegate != null) {
                    this._cancelDelegate.cancel();
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                TransformMessageHandler.getDefault().handle(this._ctx, new TransformMessage(TransformMessage.Severity.Warning, "Transform " + this._ctx.getTransform().getDisplayName() + " stopped"));
                this._cancelled = true;
                this._progressContributor.finish();
                DefaultTransformRunner.this.fireTransformDone(this);
                if (this._adapter != null) {
                    this._adapter.cancel();
                }
                this._ctx.getTransformsContext().onTransformComplete(this._ctx);
            }
        }

        @Override
        public void run() {
            this._progressContributor.start(100);
            DefaultTransformRunner.this.fireTransformStarted(this);
            PropertyChangeListener graphCloseListener = evt -> {
                if (evt.getNewValue().equals(this._ctx.getTargetGraphID()) && "graphClosed".equals(evt.getPropertyName()) && this._adapter != null) {
                    this._adapter.cancel();
                }
            };
            try {
                GraphLifeCycleManager.getDefault().addPropertyChangeListener(graphCloseListener);
                this._adapter = this.createTransformAdapter();
                this._adapter.run(this._ctx);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
                this.resultReceived(TransformResult.error(e));
            }
            finally {
                SwingUtilities.invokeLater(() -> this._progressContributor.finish());
                DefaultTransformRunner.this.fireTransformDone(this);
                GraphLifeCycleManager.getDefault().removePropertyChangeListener(graphCloseListener);
            }
        }

        private TransformAdapter createTransformAdapter() {
            return TransformAdapterFactory.getDefault().get(this._ctx);
        }

        public Cancellable getCancelDelegate() {
            return this._cancelDelegate;
        }

        public void setCancelDelegate(Cancellable cancelDelegate) {
            this._cancelDelegate = cancelDelegate;
        }

        @Override
        public int getProgress() {
            return this._lastProgress;
        }

        @Override
        public String getLastMessage() {
            return this._lastMessage;
        }

        @Override
        public boolean getIsCancelled() {
            return this._cancelled;
        }
    }
}

