/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerFinder;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerReference;
import com.paterva.maltego.transform.finder.wizard.FailurePanel;
import com.paterva.maltego.transform.finder.wizard.ProgressHandleAdapter;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchPanel;
import com.paterva.maltego.transform.finder.wizard.UpdateFetchText;
import com.paterva.maltego.transform.protocol.v2api.remote.RemoteTransformFindException;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

class UpdateTransformsFetchController
extends PassFailProgressController<DiscoveryResult<TransformServerListing>, UpdateFetchPanel, FailurePanel>
implements WizardNavigationSupport {
    UpdateTransformsFetchController() {
    }

    protected DiscoveryResult<TransformServerListing> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws DiscoveryException {
        TransformServerFinder serverFinder = TransformServerFinder.getDefault();
        TransformFinder transformFinder = TransformFinder.getDefault();
        ProgressHandleAdapter progress = new ProgressHandleAdapter(handle);
        HubSeedDescriptor hubSeed = (HubSeedDescriptor)descriptor.getProperty("hubItem");
        TransformSeed[] seeds = (TransformSeed[])descriptor.getProperty("transformSeeds");
        Boolean removeMissing = (Boolean)descriptor.getProperty("removeMissing");
        DiscoveryResult references = serverFinder.findServers(seeds, (ProgressCallback)progress);
        Exception[] errors = references.getErrors();
        if (errors != null && errors.length > 0) {
            boolean throwException = false;
            for (Exception error : errors) {
                if (error != null && error.getClass().toString().contains("TransformFindException")) continue;
                if (error instanceof RuntimeException) {
                    String msg = error.getMessage();
                    if (msg != null && msg.contains("Unable to process the request") && msg.contains("Code:")) continue;
                    throwException = true;
                    break;
                }
                if (error instanceof IOException) {
                    Throwable cause = error.getCause();
                    if (cause instanceof UnknownHostException || cause instanceof SocketTimeoutException || cause instanceof SocketException) continue;
                    throwException = true;
                    break;
                }
                throwException = true;
                break;
            }
            if (throwException) {
                throw new DiscoveryException((Throwable)errors[0]);
            }
        }
        if (references.getData() == null || ((TransformServerReference[])references.getData()).length == 0) {
            throw new DiscoveryException("No transforms were found");
        }
        DiscoveryResult details = serverFinder.getDetails((TransformServerReference[])references.getData(), (ProgressCallback)progress);
        if (details.getData() == null || ((TransformServerDetail[])details.getData()).length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        DiscoveryResult listings = transformFinder.listTransforms((TransformServerDetail[])details.getData(), (ProgressCallback)progress);
        TransformServerListing[] data = (TransformServerListing[])listings.getData();
        if (data == null || data.length == 0) {
            throw new DiscoveryException("No transform servers could be contacted");
        }
        descriptor.putProperty("transformListings", (Object)listings);
        descriptor.putProperty("transformReferences", (Object)references);
        return listings;
    }

    protected UpdateFetchPanel createPassComponent() {
        return new UpdateFetchPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, UpdateFetchPanel component, DiscoveryResult<TransformServerListing> result) {
        UpdateFetchText urt = new UpdateFetchText();
        component.setText(urt.get((TransformServerListing[])result.getData()));
        component.setDuplicateTransforms(UpdateTransformsFetchController.getDuplicateTransforms((TransformServerListing[])result.getData()));
    }

    protected void fail(FailurePanel component, Exception e) {
        if (e == null) {
            component.setError(null);
        } else if (e instanceof DiscoveryException) {
            component.setError(e.getMessage());
            Throwable cause = e.getCause();
            if (cause != null) {
                String msg = cause.getMessage();
                if (msg != null) {
                    component.setError(msg);
                }
                boolean knownCause = false;
                if (cause instanceof CertificateNeedValidationException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof NoTrustedCertificateChainFoundException) {
                    knownCause = this.setErrorMsg(msg, component);
                } else if (cause instanceof RemoteTransformFindException) {
                    knownCause = this.setErrorMsg(msg, component);
                }
                if (knownCause) {
                    component.setTitle("Certificate chain is not trusted.");
                    String extraInfo = "Rerun this wizard from the \"Maltego Data Hub\" item under the \"Transforms\" ribbon tab after the certificate has been trusted.";
                    component.setMessage(extraInfo);
                }
            }
        } else {
            component.setError(e.getMessage());
        }
    }

    public boolean canBack() {
        return false;
    }

    protected String getFailureMessage() {
        int index3;
        int index2;
        int index1;
        String msg = super.getFailureMessage();
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1 && (index3 = (msg = msg.substring(0, index2 + 1)).indexOf("n:")) > -1) {
            msg = msg.substring(0, index3 + 1);
        }
        return msg;
    }

    private boolean setErrorMsg(String msg, FailurePanel component) {
        int index2;
        int index1;
        boolean knownCause = false;
        if (msg != null && (index1 = msg.indexOf(" [Action:")) > -1 && (index2 = msg.indexOf("]", index1)) > -1) {
            msg = msg.substring(0, index2 + 1);
            knownCause = true;
            component.setError(msg);
        }
        return knownCause;
    }

    public static Map<HubSeedDescriptor, Set<TransformDescriptor>> getDuplicateTransforms(TransformServerListing[] data) {
        HashMap<HubSeedDescriptor, Set<TransformDescriptor>> duplicates = new HashMap<HubSeedDescriptor, Set<TransformDescriptor>>();
        for (TransformServerListing listing : data) {
            for (Map.Entry entry : listing.getDuplicateTransforms().entrySet()) {
                TransformDescriptor transform = (TransformDescriptor)entry.getKey();
                HubSeedDescriptor hubSeed = (HubSeedDescriptor)entry.getValue();
                HashSet<TransformDescriptor> transforms = (HashSet<TransformDescriptor>)duplicates.get(hubSeed);
                if (transforms == null) {
                    transforms = new HashSet<TransformDescriptor>();
                    duplicates.put(hubSeed, transforms);
                }
                transforms.add(transform);
            }
        }
        return duplicates;
    }
}

