/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.seeds.api.HubSeedUrl;
import com.paterva.maltego.seeds.api.HubSeeds;
import com.paterva.maltego.seeds.api.registry.HubSeedRegistry;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.finder.analytics.InstallHubItemEvent;
import com.paterva.maltego.transform.finder.wizard.ChooseSeedsControl;
import com.paterva.maltego.transform.finder.wizard.SeedUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class ChooseSeedsController
extends ValidatingController<ChooseSeedsControl> {
    private static final String ERROR_LOCAL_SERVER_URL = "Please enter a valid URL for the local Maltego server";

    public ChooseSeedsController() {
        this.setName("Select Data Sources");
        this.setDescription("Choose your desired use cases to install the corresponding Data Sources. Transforms can be managed later from the Maltego Data Hub.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/transform/finder/wizard/TransformSeed.png".replace(".png", "48.png")));
    }

    protected ChooseSeedsControl createComponent() {
        ChooseSeedsControl control = new ChooseSeedsControl();
        control.addChangeListener(this.changeListener());
        return control;
    }

    protected String getFirstError(ChooseSeedsControl component) {
        if (component.isLocalSeedEnabled()) {
            String url = component.getLocalSeedUrl();
            if (StringUtilities.isNullOrEmpty((String)url)) {
                return ERROR_LOCAL_SERVER_URL;
            }
            try {
                new URL(url).toString();
            }
            catch (Exception ex) {
                return ERROR_LOCAL_SERVER_URL;
            }
        }
        return null;
    }

    protected void readSettings(WizardDescriptor settings) {
        boolean freeOnline;
        boolean preventLocalSeedInstallation;
        boolean maltegoIdOffline;
        HubSeeds seeds = HubSeedRegistry.getDefault().getSeeds(false);
        List<HubSeedDescriptor> preInstallSeeds = SeedUtils.getPreInstallSeeds(seeds);
        ((ChooseSeedsControl)this.component()).setPublicSeeds(preInstallSeeds);
        A licenseMode = LicenseManager.A().A(false);
        boolean bl = maltegoIdOffline = licenseMode.U() && licenseMode.S();
        if (seeds.getSeeds().isEmpty()) {
            ((ChooseSeedsControl)this.component()).setSeedDiscoveryFailed(maltegoIdOffline);
        }
        boolean bl2 = preventLocalSeedInstallation = (freeOnline = Boolean.TRUE.equals(settings.getProperty("licensing.online"))) || licenseMode.U() && !MaltegoIdProductRestrictions.allowInternalHubItem((A)licenseMode);
        if (preventLocalSeedInstallation) {
            ((ChooseSeedsControl)this.component()).adjustViewForFreeUser(preventLocalSeedInstallation);
        } else {
            String localSeedUrl = (String)settings.getProperty("localSeedUrl");
            Boolean isLocalSeedEnabled = (Boolean)settings.getProperty("localSeedEnabled");
            if (isLocalSeedEnabled == null) {
                isLocalSeedEnabled = Boolean.FALSE;
            }
            ((ChooseSeedsControl)this.component()).setLocalSeedEnabled(isLocalSeedEnabled);
            ((ChooseSeedsControl)this.component()).setLocalSeedUrl(localSeedUrl);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
        Map<HubSeedDescriptor, Boolean> publicSeedSelection = ((ChooseSeedsControl)this.component()).getPublicSeedSelection();
        boolean isLocalSeedEnabled = ((ChooseSeedsControl)this.component()).isLocalSeedEnabled();
        String localSeedUrl = ((ChooseSeedsControl)this.component()).getLocalSeedUrl();
        HubSeedDescriptor localHubSeed = (HubSeedDescriptor)settings.getProperty("localHubSeed");
        ArrayList<TransformSeed> selectedSeedsList = new ArrayList<TransformSeed>();
        for (Map.Entry<HubSeedDescriptor, Boolean> entry : publicSeedSelection.entrySet()) {
            HubSeedDescriptor key = entry.getKey();
            Boolean value = entry.getValue();
            if (!value.booleanValue()) continue;
            InstallHubItemEvent.send(InstallHubItemEvent.Trigger.WIZARD, key);
            for (TransformSeed transformSeed : HubSeedRegistry.getDefault().getTransformSeeds(key)) {
                selectedSeedsList.add(transformSeed);
            }
        }
        if (localHubSeed != null) {
            HubSeedRegistry.getDefault().removeSeed(localHubSeed, true);
        }
        TransformSeed localSeed = null;
        if (isLocalSeedEnabled && !StringUtilities.isNullOrEmpty((String)localSeedUrl)) {
            localHubSeed = new HubSeedDescriptor();
            localHubSeed.setName("localservertransforms");
            localHubSeed.setDisplayName("Local Server Transforms");
            ArrayList<HubSeedUrl> grantedHubSeedUrls = new ArrayList<HubSeedUrl>();
            grantedHubSeedUrls.add(new HubSeedUrl(localSeedUrl));
            localHubSeed.setGrantedHubSeedUrls(grantedHubSeedUrls);
            localHubSeed.setCustom(true);
            HubSeedRegistry.getDefault().addSeed(localHubSeed);
            localSeed = HubSeedRegistry.getDefault().getTransformSeed(localHubSeed);
            selectedSeedsList.add(localSeed);
        }
        TransformSeed[] seeds = (TransformSeed[])selectedSeedsList.stream().toArray(TransformSeed[]::new);
        settings.putProperty("allTransformSeeds", (Object)seeds);
        settings.putProperty("transformSeeds", (Object)seeds);
        settings.putProperty("localSeedEnabled", (Object)isLocalSeedEnabled);
        settings.putProperty("localSeedUrl", (Object)localSeedUrl);
        settings.putProperty("localSeed", localSeed);
        settings.putProperty("localHubSeed", (Object)localHubSeed);
    }
}

