/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard.browser;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.EulaAcceptHandler;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.free.B;
import com.paterva.maltego.licensing.serialize.I;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.licensing.ui.wizard.browser.BrowserLoginSuccessPanel;
import com.paterva.maltego.util.ui.dialog.FailPanel;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.keycloak.representations.AccessToken;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;

public class BrowserLoginController
extends PassFailProgressController<Void, BrowserLoginSuccessPanel, FailPanel> {
    private final CloudAuth cloudAuth = CloudAuth.getDefault();
    private static final String KEY_USE_CREDITS = "use_credits";
    private static final String USE_CREDITS_PREFIX = "Maltego Credits";
    private static final String KEY_ORG_NAME = "organization";
    private ChangeListener clickListener;

    public BrowserLoginController() {
        this.setName("Login");
        this.setDescription("Please log in through your browser.");
        this.setImage(LicenseWizard.getDescriptionImage());
    }

    protected Void doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        Boolean useSystemBrowser = (Boolean)descriptor.getProperty("browser.login.use.system.browser");
        if (this.cloudAuth.isAuthorized()) {
            this.checkUseCredits(descriptor);
        } else {
            handle.progress("Logging in... Waiting for authentication signal from your browser.");
            try {
                boolean switchOrg = Boolean.TRUE.equals(descriptor.getProperty("licensing.switch-org.maltegoId"));
                this.cloudAuth.login(true, useSystemBrowser.booleanValue(), false, true, switchOrg);
            }
            catch (Exception ex) {
                throw new Exception("Browser authentication failed" + (ex.getMessage() != null ? ": " + ex.getMessage() : ""));
            }
            if (this.cloudAuth.isAuthorized()) {
                this.checkUseCredits(descriptor);
            } else {
                String problemMessage = this.cloudAuth.getProblemMessage(true);
                throw new Exception("Browser authentication failed - token invalid: " + problemMessage);
            }
        }
        return null;
    }

    private void checkUseCredits(WizardDescriptor descriptor) throws Exception {
        boolean useCredits;
        Object userCreditsObject;
        AccessToken accessToken;
        Map otherClaims;
        boolean freeOnline = Boolean.TRUE.equals(descriptor.getProperty("licensing.online"));
        if (!freeOnline && (otherClaims = (accessToken = this.cloudAuth.getAccessToken()).getOtherClaims()) != null && (userCreditsObject = otherClaims.get(KEY_USE_CREDITS)) != null && !(useCredits = Boolean.TRUE.equals(userCreditsObject))) {
            String orgName = "the organization";
            Object map = otherClaims.get(KEY_ORG_NAME);
            if (map instanceof Map) {
                Object org = ((Map)map).get("name");
                if (org != null) {
                    orgName = (String)org;
                }
                descriptor.putProperty("licensing.switch-org.maltegoId", (Object)true);
                throw new Exception("Maltego Credits disabled due to an old OSINT Profiler product in " + orgName + ".");
            }
        }
    }

    protected BrowserLoginSuccessPanel createPassComponent() {
        return new BrowserLoginSuccessPanel();
    }

    protected FailPanel createFailComponent() {
        FailPanel c = new FailPanel("Browser login failed");
        this.clickListener = ignored -> this.getDescriptor().doPreviousClick();
        c.addChangeListener(this.clickListener);
        return c;
    }

    protected void pass(WizardDescriptor descriptor, BrowserLoginSuccessPanel component, Void v) {
        LicenseManager licMan = LicenseManager.A();
        boolean freeOnline = Boolean.TRUE.equals(descriptor.getProperty("licensing.online"));
        if (freeOnline) {
            licMan.C(true);
            licMan.B(true);
            licMan.H(false);
            licMan.G(false);
            licMan.I(false);
            descriptor.putProperty("licensing.gateway-maltego-id", (Object)false);
            descriptor.putProperty("licensing.online", (Object)true);
            AccessToken accessToken = this.cloudAuth.getAccessToken();
            B.A().A(accessToken);
            licMan.E();
        }
        I eula = (I)descriptor.getProperty("licensing.eula");
        EulaAcceptHandler.eulaAccepted((I)eula);
    }

    protected void fail(FailPanel component, Exception e) {
        String error = e == null ? null : e.getMessage();
        component.setError(error);
        if (error != null && error.contains(USE_CREDITS_PREFIX)) {
            component.setMessage("Activate using a License Key, or retry Maltego ID login and select an organization without the product.");
            component.setOptionsButtonVisible(true);
        } else {
            component.setMessage("Please check Options > Proxy settings and try to Login again");
            component.setOptionsButtonVisible(true);
        }
    }

    protected String getFailureMessage() {
        String msg = super.getFailureMessage();
        if (msg != null && !msg.contains(" [Action:")) {
            String account = "Maltego ID";
            WizardDescriptor descriptor = this.getDescriptor();
            if (descriptor != null && Boolean.TRUE.equals(descriptor.getProperty("licensing.online"))) {
                account = "CE account";
            }
            msg = "Alternatively submit a " + account + " support request at https://docs.maltego.com/support/tickets/new";
        }
        return msg;
    }
}

